/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.refcodes.serial.AbstractPayloadSegment;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.EndOfStringByteAccessor;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.serial.TransmissionSequenceException;
import org.refcodes.textual.CaseStyleBuilder;

public class AsciizSegment
extends AbstractPayloadSegment<String>
implements EndOfStringByteAccessor {
    private static final long serialVersionUID = 1L;
    private byte _endOfStringByte;

    public AsciizSegment() {
        this(CaseStyleBuilder.asCamelCase(AsciizSegment.class.getSimpleName()), "", 0);
    }

    public AsciizSegment(TransmissionMetrics aTransmissionMetrics) {
        this(CaseStyleBuilder.asCamelCase(AsciizSegment.class.getSimpleName()), "", aTransmissionMetrics.getEndOfStringByte());
    }

    public AsciizSegment(TransmissionMetrics aTransmissionMetrics, String aValue) {
        this(CaseStyleBuilder.asCamelCase(AsciizSegment.class.getSimpleName()), aValue, aTransmissionMetrics.getEndOfStringByte());
    }

    public AsciizSegment(TransmissionMetrics aTransmissionMetrics, byte[] aValue) {
        this(CaseStyleBuilder.asCamelCase(AsciizSegment.class.getSimpleName()), aValue, aTransmissionMetrics.getEndOfStringByte());
    }

    public AsciizSegment(String aAlias, TransmissionMetrics aTransmissionMetrics, byte[] aValue) {
        this(aAlias, new String(aValue, StandardCharsets.US_ASCII), aTransmissionMetrics.getEndOfStringByte());
    }

    public AsciizSegment(String aAlias, TransmissionMetrics aTransmissionMetrics, String aValue) {
        this(aAlias, aValue, aTransmissionMetrics.getEndOfStringByte());
    }

    public AsciizSegment(String aValue) {
        this(CaseStyleBuilder.asCamelCase(AsciizSegment.class.getSimpleName()), aValue, 0);
    }

    public AsciizSegment(byte[] aValue) {
        this(CaseStyleBuilder.asCamelCase(AsciizSegment.class.getSimpleName()), aValue, 0);
    }

    public AsciizSegment(String aAlias, byte[] aValue) {
        this(aAlias, new String(aValue, StandardCharsets.US_ASCII), 0);
    }

    public AsciizSegment(String aAlias, String aValue) {
        this(aAlias, aValue, 0);
    }

    public AsciizSegment(byte aEndOfStringByte) {
        this(CaseStyleBuilder.asCamelCase(AsciizSegment.class.getSimpleName()), "", aEndOfStringByte);
    }

    public AsciizSegment(String aValue, byte aEndOfStringByte) {
        this(CaseStyleBuilder.asCamelCase(AsciizSegment.class.getSimpleName()), aValue, aEndOfStringByte);
    }

    public AsciizSegment(byte[] aValue, byte aEndOfStringByte) {
        this(CaseStyleBuilder.asCamelCase(AsciizSegment.class.getSimpleName()), aValue, aEndOfStringByte);
    }

    public AsciizSegment(String aAlias, byte[] aValue, byte aEndOfStringByte) {
        this(aAlias, new String(aValue, StandardCharsets.US_ASCII), aEndOfStringByte);
    }

    public AsciizSegment(String aAlias, String aValue, byte aEndOfStringByte) {
        super(aAlias, aValue);
        this._endOfStringByte = aEndOfStringByte;
    }

    @Override
    public Sequence toSequence() {
        if (this.getPayload() != null) {
            return new ByteArraySequence(((String)this.getPayload()).getBytes(StandardCharsets.US_ASCII)).withAppend(this._endOfStringByte);
        }
        return new ByteArraySequence(this._endOfStringByte);
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        for (int i = 0; i < aSequence.getLength() - aOffset; ++i) {
            if (aSequence.getByteAt(aOffset + i) != this._endOfStringByte) continue;
            super.setPayload(new String(aSequence.toBytes(aOffset, i), StandardCharsets.US_ASCII));
            return aOffset + i + 1;
        }
        throw new TransmissionSequenceException(aSequence, "No terminating <" + this._endOfStringByte + "> found in the given sequence starting at offset <" + aOffset + ">.");
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException {
        byte eByte;
        ByteArraySequence theSequence = new ByteArraySequence();
        while ((eByte = (byte)aInputStream.read()) != this._endOfStringByte) {
            theSequence.append(eByte);
        }
        this.setPayload(new String(theSequence.toBytes(), StandardCharsets.US_ASCII));
    }

    @Override
    public int getLength() {
        return this.getPayload() != null ? this.toSequence().getLength() : 0;
    }

    @Override
    public SerialSchema toSchema() {
        return SerialSchema.builder().withAlias(this.getAlias()).withInstance(this).withValue(this.toSequence()).withLength(this.getLength()).withVerbose((String)this.getPayload()).withDescription("A segment containing a <" + this._endOfStringByte + "> terminated string payload.").build();
    }

    @Override
    public AsciizSegment withPayload(String aValue) {
        this.setPayload(aValue);
        return this;
    }

    @Override
    public void setPayload(byte[] aValue) {
        this.setPayload(new String(aValue, StandardCharsets.US_ASCII));
    }

    @Override
    public AsciizSegment withPayload(byte[] aValue) {
        this.setPayload(aValue);
        return this;
    }

    @Override
    public byte getEndOfStringByte() {
        return this._endOfStringByte;
    }
}

