/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.util.regex.Pattern;
import org.refcodes.exception.BugException;
import org.refcodes.observer.Observable;
import org.refcodes.observer.Observers;
import org.refcodes.rest.RestEndpoint;
import org.refcodes.rest.RestEndpointBuilder;
import org.refcodes.rest.RestRequestConsumer;
import org.refcodes.web.BaseLocatorAccessor;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.RealmAccessor;

public interface RestServer
extends Observable<RestEndpoint>,
Observers<RestEndpoint, RestServer>,
MediaTypeFactoryLookup.MutableMediaTypeFactoryLookup,
RealmAccessor.RealmProperty,
RealmAccessor.RealmBuilder<RestServer>,
BaseLocatorAccessor.BaseLocatorProperty,
BaseLocatorAccessor.BaseLocatorBuilder<RestServer> {
    @Override
    default public RestServer withObserversActive(boolean isActive) {
        this.setObserversActive(isActive);
        return this;
    }

    @Override
    default public RestServer withEnableObservers() {
        this.setObserversActive(true);
        return this;
    }

    @Override
    default public RestServer withDisableObservers() {
        this.setObserversActive(false);
        return this;
    }

    default public boolean onRequest(RestEndpoint aRestEndpoint) {
        return this.subscribeObserver(aRestEndpoint);
    }

    @Override
    default public RestServer withBaseLocator(String aBaseLocator) {
        this.setBaseLocator(aBaseLocator);
        return this;
    }

    @Override
    default public RestServer withRealm(String aRealm) {
        this.setRealm(aRealm);
        return this;
    }

    default public RestEndpointBuilder onRequest(String aLocatorPathPattern, RestRequestConsumer aRequestConsumer) {
        return this.onRequest(null, aLocatorPathPattern, aRequestConsumer);
    }

    default public RestEndpointBuilder onRequest(Pattern aLocatorRegExp, RestRequestConsumer aRequestConsumer) {
        return this.onRequest(null, aLocatorRegExp, aRequestConsumer);
    }

    default public RestEndpointBuilder onRequest(HttpMethod aHttpMethod, String aLocatorPathPattern, RestRequestConsumer aRequestConsumer) {
        RestEndpointBuilder theEndpoint = new RestEndpointBuilder(aHttpMethod, aLocatorPathPattern, aRequestConsumer);
        if (!this.subscribeObserver(theEndpoint)) {
            throw new BugException("We encountered a bug! As we created the endpoint within this method, it cannot have been added already!");
        }
        return theEndpoint;
    }

    default public RestEndpointBuilder onRequest(HttpMethod aHttpMethod, Pattern aLocatorRegExp, RestRequestConsumer aRequestConsumer) {
        RestEndpointBuilder theEndpoint = new RestEndpointBuilder(aHttpMethod, aLocatorRegExp, aRequestConsumer);
        if (!this.subscribeObserver(theEndpoint)) {
            throw new BugException("We encountered a bug! As we created the endpoint within this method, it cannot have been added already!");
        }
        return theEndpoint;
    }

    default public RestEndpointBuilder onGet(String aLocatorPathPattern, RestRequestConsumer aRequestConsumer) {
        return this.onRequest(HttpMethod.GET, aLocatorPathPattern, aRequestConsumer);
    }

    default public RestEndpointBuilder onGet(Pattern aLocatorRegExp, RestRequestConsumer aRequestConsumer) {
        return this.onRequest(HttpMethod.GET, aLocatorRegExp, aRequestConsumer);
    }

    default public RestEndpointBuilder onPut(String aLocatorPathPattern, RestRequestConsumer aRequestConsumer) {
        return this.onRequest(HttpMethod.PUT, aLocatorPathPattern, aRequestConsumer);
    }

    default public RestEndpointBuilder onPut(Pattern aLocatorRegExp, RestRequestConsumer aRequestConsumer) {
        return this.onRequest(HttpMethod.PUT, aLocatorRegExp, aRequestConsumer);
    }

    default public RestEndpointBuilder onPost(String aLocatorPathPattern, RestRequestConsumer aRequestConsumer) {
        return this.onRequest(HttpMethod.POST, aLocatorPathPattern, aRequestConsumer);
    }

    default public RestEndpointBuilder onPost(Pattern aLocatorRegExp, RestRequestConsumer aRequestConsumer) {
        return this.onRequest(HttpMethod.POST, aLocatorRegExp, aRequestConsumer);
    }

    default public RestEndpointBuilder onDelete(String aLocatorPathPattern, RestRequestConsumer aRequestConsumer) {
        return this.onRequest(HttpMethod.DELETE, aLocatorPathPattern, aRequestConsumer);
    }

    default public RestEndpointBuilder onDelete(Pattern aLocatorRegExp, RestRequestConsumer aRequestConsumer) {
        return this.onRequest(HttpMethod.DELETE, aLocatorRegExp, aRequestConsumer);
    }
}

