/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Map;
import org.refcodes.data.FilenameExtension;
import org.refcodes.properties.DocumentMetrics;
import org.refcodes.properties.DocumentNotation;
import org.refcodes.properties.ImmutableProperties;
import org.refcodes.properties.Properties;
import org.refcodes.properties.ResourceProperties;
import org.refcodes.properties.ResourcePropertiesFactory;
import org.refcodes.properties.XmlProperties;
import org.refcodes.runtime.ConfigLocator;

public class XmlPropertiesFactory
implements ResourcePropertiesFactory {
    private final DocumentMetrics _documentMetrics;

    public XmlPropertiesFactory() {
        this(DocumentNotation.DEFAULT);
    }

    public XmlPropertiesFactory(DocumentMetrics aDocumentMetrics) {
        this._documentMetrics = aDocumentMetrics;
    }

    @Override
    public String[] getFilenameSuffixes() {
        return new String[]{FilenameExtension.XML.getFilenameSuffix()};
    }

    @Override
    public ResourceProperties toProperties(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        return new XmlProperties(aResourceClass, aFilePath, aConfigLocator, this._documentMetrics);
    }

    @Override
    public ResourceProperties toProperties(File aFile, ConfigLocator aConfigLocator) throws IOException, ParseException {
        return new XmlProperties(aFile, aConfigLocator, this._documentMetrics);
    }

    @Override
    public ResourceProperties toProperties(InputStream aInputStream) throws IOException, ParseException {
        return new XmlProperties(aInputStream, this._documentMetrics);
    }

    @Override
    public ResourceProperties toProperties(Map<?, ?> aProperties) {
        return new XmlProperties(aProperties, this._documentMetrics);
    }

    @Override
    public ResourceProperties toProperties(Object aObj) {
        return new XmlProperties(aObj, this._documentMetrics);
    }

    @Override
    public ResourceProperties toProperties(ImmutableProperties aProperties) {
        return new XmlProperties(aProperties, this._documentMetrics);
    }

    @Override
    public ResourceProperties toProperties(Properties aProperties) {
        return new XmlProperties(aProperties, this._documentMetrics);
    }

    @Override
    public ResourceProperties toProperties(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        return new XmlProperties(aFilePath, aConfigLocator, this._documentMetrics);
    }

    @Override
    public ResourceProperties toProperties(URL aUrl) throws IOException, ParseException {
        return new XmlProperties(aUrl, this._documentMetrics);
    }
}

