/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import org.refcodes.codec.BaseMetrics;
import org.refcodes.codec.BaseMetricsImpl;
import org.refcodes.data.CharSet;
import org.refcodes.data.PaddingChar;

public enum BaseMetricsConfig implements BaseMetrics
{
    BASE2(2, CharSet.ARABIC_BASE64.getCharSet(), PaddingChar.BASE64.getChar()),
    BINARY(2, CharSet.ARABIC_BASE64.getCharSet(), PaddingChar.BASE64.getChar()),
    BASE4(4, CharSet.ARABIC_BASE64.getCharSet(), PaddingChar.BASE64.getChar()),
    BASE8(8, CharSet.ARABIC_BASE64.getCharSet(), PaddingChar.BASE64.getChar()),
    OCTAL(8, CharSet.ARABIC_BASE64.getCharSet(), PaddingChar.BASE64.getChar()),
    ENCODED_AS_NUMBER(8, CharSet.ENCODED_AS_NUMBER.getCharSet(), '0'),
    BASE16(16, CharSet.ARABIC_BASE64.getCharSet(), PaddingChar.BASE64.getChar()),
    HEXADECIMAL(16, CharSet.ARABIC_BASE64.getCharSet(), PaddingChar.BASE64.getChar()),
    BASE32(32, CharSet.ARABIC_BASE64.getCharSet(), PaddingChar.BASE64.getChar()),
    BASE64(64, CharSet.BASE64.getCharSet(), PaddingChar.BASE64.getChar()),
    BASE64_ARABIC(64, CharSet.ARABIC_BASE64.getCharSet(), PaddingChar.BASE64.getChar()),
    BASE64_URL(64, CharSet.BASE64URL.getCharSet(), PaddingChar.BASE64.getChar());

    private BaseMetrics _baseMetrics;

    private BaseMetricsConfig(int aBase, char[] aCharSet, char aPaddingChar) {
        this._baseMetrics = new BaseMetricsImpl(aBase, aCharSet, aPaddingChar);
    }

    @Override
    public int getNumberBase() {
        return this._baseMetrics.getNumberBase();
    }

    @Override
    public char[] getCharSet() {
        return this._baseMetrics.getCharSet();
    }

    @Override
    public int getBytesPerInt() {
        return this._baseMetrics.getBytesPerInt();
    }

    @Override
    public int getDigitsPerInt() {
        return this._baseMetrics.getDigitsPerInt();
    }

    @Override
    public int getBitsPerDigit() {
        return this._baseMetrics.getBitsPerDigit();
    }

    @Override
    public int getDigitsPerByte() {
        return this._baseMetrics.getDigitsPerByte();
    }

    @Override
    public int getDigitMask() {
        return this._baseMetrics.getDigitMask();
    }

    public static BaseMetrics toBaseCodec(int aNumberBase) {
        for (BaseMetricsConfig aBaseCodec : BaseMetricsConfig.values()) {
            if (aBaseCodec.getNumberBase() != aNumberBase) continue;
            return aBaseCodec;
        }
        return null;
    }

    @Override
    public int toValue(char aChar) {
        return this._baseMetrics.toValue(aChar);
    }

    @Override
    public char toChar(int aValue) {
        return this._baseMetrics.toChar(aValue);
    }

    @Override
    public char getPaddingChar() {
        return this._baseMetrics.getPaddingChar();
    }

    @Override
    public int getBytesPerBlock() {
        return this._baseMetrics.getBytesPerBlock();
    }
}

