/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.teletype;

import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import org.refcodes.archetype.C2Helper;
import org.refcodes.archetype.CliHelper;
import org.refcodes.cli.ArgsFilter;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CleanFlag;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.ConfigOption;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Example;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.InitFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.QuietFlag;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.data.BooleanLiterals;
import org.refcodes.data.Literal;
import org.refcodes.data.Scheme;
import org.refcodes.exception.BugException;
import org.refcodes.exception.Trap;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.net.PortManagerSingleton;
import org.refcodes.properties.ImmutableProperties;
import org.refcodes.properties.MapProperties;
import org.refcodes.properties.ext.application.ApplicationProperties;
import org.refcodes.rest.JdkHttpRestClient;
import org.refcodes.rest.JdkHttpRestServer;
import org.refcodes.rest.RestRequestConsumer;
import org.refcodes.rest.RestRequestEvent;
import org.refcodes.serial.alt.tty.Parity;
import org.refcodes.serial.alt.tty.StopBits;
import org.refcodes.serial.alt.tty.TtyPort;
import org.refcodes.serial.alt.tty.TtyPortHub;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.HttpResponseException;
import org.refcodes.web.HttpServerResponse;
import org.refcodes.web.HttpStatusException;
import org.refcodes.web.MediaType;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.UrlBuilder;

public class Main {
    private static final RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final int DEFAULT_DATA_BITS = 8;
    private static final int DEFAULT_BAUD_RATE = 9600;
    private static final String TITLE = "<T.E.L.E.T.Y.P.E>";
    private static final String NAME = "teletype";
    private static final String DEFAULT_CONFIG = "teletype.ini";
    private static final String DESCRIPTION = "Teleprinter command line tool for sending data to and receiving data from TTY (serial) ports simultaneously (see [https://www.metacodes.pro/manpages/teletype_manpage]).";
    private static final String LICENSE_NOTE = "You may choose between the LGPL v3.0 or later and the Apache License v2.0 when using this software";
    private static final String COPYRIGHT = "Copyright (c) by CLUB.FUNCODES | See [https://www.metacodes.pro/manpages/teletype_manpage]";
    private static final char[] BANNER_PALETTE = AsciiColorPalette.MAX_LEVEL_GRAY.getPalette();
    private static final Font BANNER_FONT = new Font(FontFamily.DIALOG, FontStyle.BOLD);
    private static final String MESSAGE_PROPERTY = "message";
    private static final String ASCIIZ_PROPERTY = "asciiz";
    private static final String LISTEN_PROPERTY = "listen";
    private static final String SEND_PROPERTY = "send";
    private static final String STOP_BITS_PROPERTY = "stopBits";
    private static final String PARITY_PROPERTY = "parity";
    private static final String DATA_BITS_PROPERTY = "dataBits";
    private static final String BAUD_PROPERTY = "baud";
    private static final String PORT_PROPERTY = "port";
    private static final String LIST_PROPERTY = "list";
    private static final String ASCIIZ_QUERY_FIELD = "asciiz";
    private static final int MAX_OPEN_SEND_DAEMON_RETRY_COUNT = 5;
    private static final String C2_SEND_ENDPOINT = "/send";
    private static final String C2_PORT_PROPERTY = "port";
    private static C2Helper _c2Helper = null;

    public static void main(String[] args) {
        block10: {
            Flag theListPortsFlag = CliSugar.flag(Character.valueOf('l'), LIST_PROPERTY, LIST_PROPERTY, "List all detected TTY (COM) serial ports.");
            StringOption theTtyPortArg = CliSugar.stringOption(Character.valueOf('p'), "port", "port", "The COM (serial) port to operate on.");
            IntOption theBaudArg = CliSugar.intOption(Character.valueOf('b'), BAUD_PROPERTY, BAUD_PROPERTY, "The baud rate to use for the TTY (COM) serial port.");
            IntOption theDataBitsArg = CliSugar.intOption("data-bits", DATA_BITS_PROPERTY, "The data bits to use for the TTY (COM) serial port (usually a value of 7 or 8).");
            EnumOption<Parity> theParityArg = CliSugar.enumOption(PARITY_PROPERTY, Parity.class, PARITY_PROPERTY, "The parity to use for the TTY (COM) serial port: " + VerboseTextBuilder.asString((Object[])Parity.values()));
            EnumOption<StopBits> theStopBitsArg = CliSugar.enumOption("stop-bits", StopBits.class, STOP_BITS_PROPERTY, "The stop bits to use for the TTY (COM) serial port: " + VerboseTextBuilder.asString((Object[])StopBits.values()));
            Flag theSendFlag = CliSugar.flag(Character.valueOf('S'), SEND_PROPERTY, SEND_PROPERTY, "Send data to the COM (serial) port.");
            Flag theListenFlag = CliSugar.flag(Character.valueOf('L'), LISTEN_PROPERTY, LISTEN_PROPERTY, "Listen for data from the COM (serial) port.");
            Flag theAsciizFlag = CliSugar.flag(Character.valueOf('z'), "asciiz", "asciiz", "Terminate the message to be sent by the value 0 (\"zero\"), print line break upon an incoming 0 (\"zero\").");
            StringOption theMessageArg = CliSugar.stringOption(Character.valueOf('m'), MESSAGE_PROPERTY, MESSAGE_PROPERTY, "The message to be sent.");
            SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag(false);
            HelpFlag theHelpFlag = CliSugar.helpFlag();
            QuietFlag theQuietFlag = CliSugar.quietFlag(true);
            DebugFlag theDebugFlag = CliSugar.debugFlag();
            InitFlag theInitFlag = CliSugar.initFlag(false);
            CleanFlag theCleanFlag = CliSugar.cleanFlag(false);
            ConfigOption theConfigArg = CliSugar.configOption();
            CasesCondition theArgsSyntax = CliSugar.cases(CliSugar.and(theListPortsFlag, CliSugar.any(theQuietFlag, theDebugFlag)), CliSugar.and(theTtyPortArg, CliSugar.xor(theListenFlag, CliSugar.and(theSendFlag, theMessageArg)), CliSugar.any(theBaudArg, theDataBitsArg, theStopBitsArg, theParityArg, theAsciizFlag, theConfigArg, theQuietFlag, theDebugFlag)), CliSugar.and(theConfigArg, CliSugar.xor(theListenFlag, CliSugar.and(theSendFlag, theMessageArg)), CliSugar.any(theTtyPortArg, theBaudArg, theDataBitsArg, theStopBitsArg, theParityArg, theAsciizFlag, theQuietFlag, theDebugFlag)), CliSugar.and(theInitFlag, CliSugar.optional(theConfigArg, theQuietFlag)), CliSugar.and(theTtyPortArg, theCleanFlag, CliSugar.any(theQuietFlag, theDebugFlag)), CliSugar.xor(theHelpFlag, CliSugar.and(theSysInfoFlag, CliSugar.any(theQuietFlag))));
            Example[] theExamples = CliSugar.examples(CliSugar.example("List all available TTY (COM) ports", theListPortsFlag), CliSugar.example("Receive data from specific port", theTtyPortArg, theListenFlag), CliSugar.example("Send data to specific port", theTtyPortArg, theSendFlag, theMessageArg), CliSugar.example("Receive data from specific port using given config", theListenFlag, theConfigArg), CliSugar.example("Send data to specific port using given config", theSendFlag, theMessageArg, theConfigArg), CliSugar.example("Initialize default config file", theInitFlag), CliSugar.example("Initialize specific config file", theInitFlag, theConfigArg), CliSugar.example("Clean the port's lock file", theCleanFlag, theTtyPortArg), CliSugar.example("To show the help text", theHelpFlag), CliSugar.example("To print the system info", theSysInfoFlag));
            CliHelper theCliHelper = ((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)CliHelper.builder().withArgs(args, ArgsFilter.D_XX)).withArgsSyntax(theArgsSyntax)).withExamples(theExamples)).withFilePath(DEFAULT_CONFIG)).withResourceClass((Class)Main.class)).withName(NAME)).withTitle(TITLE)).withDescription(DESCRIPTION)).withLicense(LICENSE_NOTE)).withCopyright(COPYRIGHT)).withBannerFont(BANNER_FONT)).withBannerFontPalette(BANNER_PALETTE)).withLogger(LOGGER)).build();
            ApplicationProperties theArgsProperties = theCliHelper.getApplicationProperties();
            boolean isDebug = theArgsProperties.getBoolean((Object)theDebugFlag);
            boolean isAsciiz = theArgsProperties.getBoolean((Object)theAsciizFlag);
            boolean isVerbose = theCliHelper.isVerbose();
            try {
                if (theListPortsFlag.isEnabled()) {
                    Main.listSerialPorts(isVerbose);
                    break block10;
                }
                if (theTtyPortArg.hasValue()) {
                    int theBaudRate = theArgsProperties.getIntOr(theBaudArg, (Integer)9600);
                    int theDataBits = theArgsProperties.getIntOr(theDataBitsArg, (Integer)8);
                    String thePortName = (String)theArgsProperties.get((Object)theTtyPortArg);
                    Parity theParity = theArgsProperties.getEnumOr(theParityArg, Parity.NONE);
                    StopBits theStopBits = theArgsProperties.getEnumOr(theStopBitsArg, StopBits.AUTO);
                    TtyPort theTtyPort = (TtyPort)new TtyPortHub().toPort(thePortName);
                    if (theTtyPort == null) {
                        throw new IllegalArgumentException("No port <" + (String)theTtyPortArg.getValue() + "> has been found.");
                    }
                    _c2Helper = C2Helper.builder().withInstanceAlias(theTtyPort.getAlias().toLowerCase()).withResourceClass(Main.class).withLogger(LOGGER).withVerbose(isVerbose).build();
                    if (theCleanFlag.isEnabled()) {
                        _c2Helper.deleteLockFile(isVerbose);
                    } else if (theListenFlag.isEnabled()) {
                        Main.listen(theTtyPort, theBaudRate, theDataBits, theStopBits, theParity, isAsciiz, isVerbose, isDebug);
                    } else if (theSendFlag.isEnabled()) {
                        Main.sendDispatch(theTtyPort, (String)theMessageArg.getValue(), theBaudRate, theDataBits, theStopBits, theParity, isAsciiz, isVerbose);
                    }
                    break block10;
                }
                throw new BugException("We should never end up here, please check your command line args!");
            }
            catch (Exception e) {
                theCliHelper.exitOnException(e);
            }
        }
    }

    private static void sendDispatch(TtyPort aTtyPort, String aMessage, int aBaud, int aDataBits, StopBits aStopBits, Parity aParity, boolean isAsciiz, boolean isVerbose) throws IOException, HttpResponseException, ParseException {
        try (TtyPort ttyPort = aTtyPort.withOpen(aBaud, aDataBits, aStopBits, aParity);){
            if (isVerbose) {
                LOGGER.printSeparator();
                LOGGER.info("Sending \"" + aMessage + "\" to port <" + aTtyPort.getAlias().toUpperCase() + ">" + (isAsciiz ? ", 0 (\"zero\") terminated " : " ") + "...");
            }
            Main.sendMessage(aTtyPort, aMessage, isAsciiz);
        }
        catch (IOException ttyExc) {
            ImmutableProperties theLockProperties = _c2Helper.readLockFile(isVerbose);
            if (theLockProperties != null) {
                int thePort = theLockProperties.getInt("port");
                if (PortManagerSingleton.getInstance().isPortBound(thePort)) {
                    if (isVerbose) {
                        LOGGER.printSeparator();
                        LOGGER.info("Sending \"" + aMessage + "\" to port <" + aTtyPort.getAlias().toUpperCase() + ">" + (isAsciiz ? ", 0 (\"zero\") terminated " : " ") + "...");
                    }
                    JdkHttpRestClient theClient = new JdkHttpRestClient().withBaseUrl(Scheme.HTTP, Literal.LOCALHOST.getValue(), thePort);
                    UrlBuilder theUrl = new UrlBuilder(Main.toSendEndpoint());
                    theUrl.getQueryFields().put("asciiz", Boolean.toString(isAsciiz));
                    RequestHeaderFields theHeadeFields = new RequestHeaderFields();
                    theHeadeFields.putContentType(MediaType.TEXT_PLAIN);
                    theClient.doPost(theUrl, theHeadeFields, (Object)aMessage);
                }
            }
            throw new IllegalStateException("The port <" + aTtyPort.getAlias() + "> seems to be in use by another (unknwon) application!");
        }
    }

    private static void sendDaemon(TtyPort aTtyPort, boolean isVerbose, boolean isDebug) throws IOException, ParseException {
        int thePort;
        Integer thePort2;
        ImmutableProperties theImmutableProperties = _c2Helper.readLockFile(isVerbose);
        if (theImmutableProperties != null && (thePort2 = theImmutableProperties.getInt("port")) != null && !PortManagerSingleton.getInstance().isPortAvaialble(thePort2)) {
            throw new IllegalStateException("Cannot start daemon as the port <" + thePort2 + "> reserved by the lockfile is already in use!");
        }
        JdkHttpRestServer theRestServer = null;
        int count = 1;
        do {
            block4: {
                thePort = PortManagerSingleton.getInstance().bindAnyPort();
                try {
                    theRestServer = new JdkHttpRestServer().withOpen(thePort);
                }
                catch (IOException e) {
                    if (count <= 5) break block4;
                    throw e;
                }
            }
            ++count;
        } while (theRestServer == null);
        _c2Helper.writeLockFile((ImmutableProperties)((Object)new MapProperties().withPutInt("port", (Integer)thePort)), isVerbose);
        theRestServer.onPost(Main.toSendEndpoint(), (RestRequestConsumer)new SendRequestConsumer(aTtyPort, isVerbose, isDebug)).open();
    }

    private static void sendMessage(TtyPort aTtyPort, String aMessage, boolean isAsciiz) throws IOException {
        OutputStream theOutputStream = aTtyPort.getOutputStream();
        theOutputStream.write(aMessage.getBytes());
        if (isAsciiz) {
            theOutputStream.write(0);
        }
        theOutputStream.flush();
    }

    private static void listen(TtyPort aTtyPort, int aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity, boolean isAsciiz, boolean isVerbose, boolean isDebug) throws IOException, ParseException {
        TtyPort ttyPort = aTtyPort.withOpen(aBaudRate, aDataBits, aStopBits, aParity);
        try {
            Main.sendDaemon(aTtyPort, isVerbose, isDebug);
            if (isVerbose) {
                LOGGER.printSeparator();
                LOGGER.info("Listening on TTY port <" + aTtyPort.getAlias().toUpperCase() + "> with <" + aBaudRate + "> baud, <" + aDataBits + ">, data bits, <" + String.valueOf((Object)aStopBits) + "> stop bits and a parity of <" + String.valueOf((Object)aParity) + ">" + (isAsciiz ? ", 0 (\"zero\") terminated " : " ") + "...");
                LOGGER.printTail();
            }
            while (true) {
                byte eReceiveByte;
                if ((eReceiveByte = aTtyPort.receiveByte()) == 0 && isAsciiz) {
                    System.out.println();
                    continue;
                }
                System.out.print(new String(new byte[]{eReceiveByte}));
            }
        }
        catch (Throwable throwable) {
            if (ttyPort != null) {
                try {
                    ttyPort.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    private static void listSerialPorts(boolean isVerbose) throws IOException {
        TtyPortHub theTtyPortHub = new TtyPortHub();
        TtyPort[] thePorts = theTtyPortHub.ports();
        if (isVerbose) {
            if (thePorts.length != 0) {
                int theMaxWidth = 0;
                for (TtyPort ePort : thePorts) {
                    int eWidth = ePort.getAlias().length();
                    if (theMaxWidth >= eWidth) continue;
                    theMaxWidth = eWidth;
                }
                HorizAlignTextBuilder theBuilder = new HorizAlignTextBuilder().withColumnWidth(theMaxWidth);
                for (TtyPort ePort : thePorts) {
                    LOGGER.info("[" + theBuilder.toString(new String[]{ePort.getAlias()}) + "] " + ePort.getName() + ": \"" + ePort.getDescription() + "\" (" + ePort.getPortMetrics().getBaudRate() + " baud)");
                }
            } else {
                LOGGER.info("No serial (COM) ports found.");
            }
        } else {
            for (TtyPort ePort : thePorts) {
                System.out.println(ePort.getAlias() + "\t" + ePort.getPortMetrics().getBaudRate() + " baud\t" + ePort.getDescription() + "\t" + ePort.getName());
            }
        }
    }

    private static String toSendEndpoint() {
        return C2_SEND_ENDPOINT + _c2Helper.getInstanceAlias() != null ? "/" + _c2Helper.getInstanceAlias().toLowerCase() : "";
    }

    private static class SendRequestConsumer
    implements RestRequestConsumer {
        private final TtyPort _ttyPort;
        boolean _isVerbose;
        boolean _isDebug;

        public SendRequestConsumer(TtyPort aTtyPort, boolean isVerbose, boolean isDebug) {
            this._ttyPort = aTtyPort;
            this._isVerbose = isVerbose;
            this._isDebug = isDebug;
        }

        @Override
        public void onRequest(RestRequestEvent aRequest, HttpServerResponse aResponse) throws HttpStatusException {
            String aMessage = aRequest.getHttpBody();
            String theAsciiz = aRequest.getUrl().getQueryFields().getFirst("asciiz");
            boolean isAsciiz = BooleanLiterals.isTrue(theAsciiz);
            try {
                Main.sendMessage(this._ttyPort, aMessage, isAsciiz);
            }
            catch (IOException e) {
                if (this._isVerbose) {
                    if (this._isDebug) {
                        System.err.println("Cannot send the message \"" + aMessage + "\" to port <" + this._ttyPort.getAlias().toUpperCase() + "> as of: " + Trap.asMessage(e));
                        e.printStackTrace();
                    } else {
                        System.err.println("Cannot send the message \"" + aMessage + "\" to port <" + this._ttyPort.getAlias().toUpperCase() + "> as of: " + Trap.asMessage(e));
                    }
                }
                if (this._isDebug) {
                    LOGGER.error("Cannot send the message \"" + aMessage + "\" to port <" + this._ttyPort.getAlias().toUpperCase() + "> as of: " + Trap.asMessage(e), e);
                }
                LOGGER.error("Cannot send the message \"" + aMessage + "\" to port <" + this._ttyPort.getAlias().toUpperCase() + "> as of: " + Trap.asMessage(e));
            }
        }
    }
}

