/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.util.HashMap;
import java.util.Objects;
import org.refcodes.data.Delimiter;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.web.HttpMediaType;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeAccessor;
import org.refcodes.web.MediaTypeParameter;
import org.refcodes.web.TopLevelType;
import org.refcodes.web.TopLevelTypeAccessor;

public class ContentType
extends HashMap<String, String>
implements TopLevelTypeAccessor,
MediaTypeAccessor,
HttpMediaType {
    private static final long serialVersionUID = 1L;
    private final MediaType _mediaType;

    public ContentType(MediaType aMediaType) {
        Objects.requireNonNull(aMediaType, "The media-type argument must not be null!");
        this._mediaType = aMediaType;
    }

    public ContentType(String aHttpMediaType) {
        String theHttpContentType;
        if (aHttpMediaType == null || aHttpMediaType.isEmpty()) {
            throw new IllegalArgumentException("You must set a HTTP content type and not <null> (or an empty <String>) as a <ContentType> without <MediaType> does not make sense.");
        }
        int indexOf = aHttpMediaType.indexOf(Delimiter.MEDIA_TYPE_PARAMETERS.getChar());
        if (indexOf != -1) {
            theHttpContentType = aHttpMediaType.substring(0, indexOf);
            if (aHttpMediaType.length() > indexOf) {
                String[] theParameters;
                for (String eTupel : theParameters = aHttpMediaType.substring(indexOf + 1).split("" + Delimiter.MEDIA_TYPE_PARAMETERS.getChar())) {
                    if (eTupel == null) continue;
                    PropertyImpl eProperty = new PropertyImpl(eTupel);
                    this.put(((String)eProperty.getKey()).trim(), eProperty.getValue() != null ? ((String)eProperty.getValue()).trim() : null);
                }
            }
        } else {
            theHttpContentType = aHttpMediaType;
        }
        theHttpContentType = theHttpContentType.trim();
        this._mediaType = MediaType.fromHttpMediaSubtype(theHttpContentType);
        if (this._mediaType == null) {
            throw new IllegalArgumentException("Unable to detect valid known Media-Type from argument <" + aHttpMediaType + ">.");
        }
    }

    public ContentType(MediaType aMediaType, ContentType aProperties) {
        Objects.requireNonNull(aMediaType, "The media-type argument must not be null!");
        this._mediaType = aMediaType;
        this.putAll(aProperties);
    }

    @Override
    public TopLevelType getTopLevelType() {
        return this.getMediaType().getTopLevelType();
    }

    @Override
    public String put(MediaTypeParameter aParameter, String aValue) {
        return this.put(aParameter.getName(), aValue);
    }

    public ContentType withPut(MediaTypeParameter aParameter, String aValue) {
        this.put(aParameter.getName(), aValue);
        return this;
    }

    public String getCharsetParametrer() {
        return (String)this.get(MediaTypeParameter.CHARSET.getName());
    }

    public String putCharsetParametrer(String aCharsetCode) {
        return this.put(MediaTypeParameter.CHARSET.getName(), aCharsetCode);
    }

    public ContentType withCharsetParametrer(String aValue) {
        this.put(MediaTypeParameter.CHARSET.getName(), aValue);
        return this;
    }

    @Override
    public String toHttpMediaType() {
        String theResult = null;
        MediaType theMediaType = this.getMediaType();
        if (theMediaType != null) {
            theResult = theMediaType.toHttpMediaType(this);
        }
        return theResult;
    }

    @Override
    public MediaType getMediaType() {
        return this._mediaType;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._mediaType == null ? 0 : this._mediaType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentType other = (ContentType)obj;
        return this._mediaType == other._mediaType;
    }

    @Override
    public String toString() {
        return this._mediaType.toHttpMediaType();
    }
}

