/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import org.refcodes.struct.ImmutablePathTable;
import org.refcodes.struct.PathTable;
import org.refcodes.struct.TypeUtility;

public class StructureUtility {
    public static final String SYSTEM_PROPERTY_STRUCT_KEEP_MAPS = "struct.keepMaps";
    public static final String ENVIRONMENT_VARIABLE_STRUCT_KEEP_MAPS = "STRUCT_KEEPMAPS";
    private static Boolean _isKeepMaps = null;

    private StructureUtility() {
    }

    public static <T> void retrieveFrom(ImmutablePathTable<T> aFromPathTable, String aFromPath, PathTable<T> aToPathTable) {
        String theFromPath = StructureUtility.toGenericPath(aFromPathTable, aFromPath);
        for (String ePath : aFromPathTable.paths()) {
            String eToPath;
            if (!ePath.startsWith(theFromPath) || !(eToPath = ePath.substring(theFromPath.length())).startsWith(aFromPathTable.getRootPath()) && !eToPath.isEmpty()) continue;
            aToPathTable.put(eToPath, aFromPathTable.get((Object)ePath));
        }
    }

    public static <T> void retrieveTo(ImmutablePathTable<T> aFromPathTable, String aToPath, PathTable<T> aToPathTable) {
        String thetoPath = StructureUtility.toGenericPath(aFromPathTable, aToPath);
        for (String ePath : aFromPathTable.paths()) {
            aToPathTable.put(thetoPath + ePath, aFromPathTable.get((Object)ePath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Object toDataStructure(ImmutablePathTable<?> aPathTable, String aFromPath) {
        if (_isKeepMaps == null) {
            Class<StructureUtility> clazz = StructureUtility.class;
            // MONITORENTER : org.refcodes.struct.StructureUtility.class
            if (_isKeepMaps == null) {
                _isKeepMaps = System.getProperty(SYSTEM_PROPERTY_STRUCT_KEEP_MAPS) != null ? Boolean.valueOf(Boolean.parseBoolean(System.getProperty(SYSTEM_PROPERTY_STRUCT_KEEP_MAPS))) : (System.getenv(ENVIRONMENT_VARIABLE_STRUCT_KEEP_MAPS) != null ? Boolean.valueOf(Boolean.parseBoolean(System.getenv(ENVIRONMENT_VARIABLE_STRUCT_KEEP_MAPS))) : Boolean.valueOf(false));
            }
            // MONITOREXIT : clazz
        }
        if (_isKeepMaps == false) return TypeUtility.toUnwrappedMap(aPathTable.toMap(aFromPath));
        return aPathTable.toMap(aFromPath);
    }

    public static String toGenericPath(ImmutablePathTable<?> aPathTable, String aPath) {
        aPath = aPathTable.toNormalizedPath(aPath);
        while (aPath.endsWith("" + aPathTable.getDelimiter())) {
            aPath = aPath.substring(0, aPath.length() - 1);
        }
        return aPath;
    }
}

