/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial.ext.handshake;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.data.IoRetryCount;
import org.refcodes.data.IoSleepLoopTime;
import org.refcodes.exception.TimeoutIOException;
import org.refcodes.exception.Trap;
import org.refcodes.io.TimeoutInputStream;
import org.refcodes.numerical.ChecksumValidationMode;
import org.refcodes.numerical.ChecksumValidationModeAccessor;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcAlgorithmAccessor;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.EndianessAccessor;
import org.refcodes.serial.AbstractPortDecorator;
import org.refcodes.serial.AcknowledgeMagicBytesAccessor;
import org.refcodes.serial.AcknowledgeRetryNumberAccessor;
import org.refcodes.serial.AcknowledgeTimeoutMillisAccessor;
import org.refcodes.serial.AllocSectionDecoratorSegment;
import org.refcodes.serial.ByteArraySection;
import org.refcodes.serial.ByteSegment;
import org.refcodes.serial.MagicBytesSegmentMultiplexer;
import org.refcodes.serial.Port;
import org.refcodes.serial.PortMetrics;
import org.refcodes.serial.ReceiveSegmentConsumerDaemon;
import org.refcodes.serial.ReceiveSegmentResultDaemon;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentConsumer;
import org.refcodes.serial.SegmentResult;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SequenceNumberAccessor;
import org.refcodes.serial.SequenceNumberInitValueAccessor;
import org.refcodes.serial.SequenceNumberWidthAccessor;
import org.refcodes.serial.SerialUtility;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.serial.TransmitSegmentConsumerDaemon;
import org.refcodes.serial.TransmitSegmentResultDaemon;
import org.refcodes.serial.ext.handshake.AcknowledgeMessage;
import org.refcodes.serial.ext.handshake.AcknowledgeType;
import org.refcodes.serial.ext.handshake.HandshakeTransmissionMetrics;
import org.refcodes.serial.ext.handshake.Message;
import org.refcodes.serial.ext.handshake.ReplyRetryNumberAccessor;
import org.refcodes.serial.ext.handshake.ReplyTimeoutMillisAccessor;
import org.refcodes.serial.ext.handshake.RequestHandler;
import org.refcodes.serial.ext.handshake.TransmissionMessage;
import org.refcodes.serial.ext.handshake.TransmissionType;

public class HandshakePortController<PM extends PortMetrics>
extends AbstractPortDecorator<PM>
implements AcknowledgeMagicBytesAccessor,
AcknowledgeTimeoutMillisAccessor,
AcknowledgeRetryNumberAccessor,
ReplyTimeoutMillisAccessor,
ReplyRetryNumberAccessor,
SequenceNumberAccessor,
SequenceNumberInitValueAccessor,
SequenceNumberWidthAccessor,
CrcAlgorithmAccessor,
ChecksumValidationModeAccessor,
EndianessAccessor {
    private static final Logger LOGGER = Logger.getLogger(HandshakePortController.class.getName());
    private static final int MAX_SEQUENCE_NUMBER_COUNT = 1024;
    private final Set<Integer> _sequenceNumbers = new HashSet<Integer>();
    private LinkedBlockingQueue<TransmissionMessage> _inboundQueue;
    private final LinkedBlockingQueue<TransmissionMessage> _consumerQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<TransmissionMessage> _requestQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<Message> _outboundQueue = new LinkedBlockingQueue();
    private final AtomicInteger _sequenceNumber = new AtomicInteger(0);
    private final Map<Integer, TransmissionMessage> _sequenceNumToAcknowledge = new HashMap<Integer, TransmissionMessage>();
    private final Map<Integer, TransmissionMessage> _sequenceNumToRequest = new HashMap<Integer, TransmissionMessage>();
    private HandshakeTransmissionMetrics _transmissionMetrics;
    private final List<SegmentConsumerTupel<?>> _segmentConsumerTupels = new ArrayList();
    private final List<RequestHandlerTupel<?>> _requestHandlerTupels = new ArrayList();
    private Runnable _pingHandler = null;
    private ExecutorService _executorService;

    private HandshakePortController(Builder<PM> aBuilder) {
        this(aBuilder.port, aBuilder.endianess, aBuilder.acknowledgeRetryNumber, aBuilder.acknowledgeTimeoutInMs, aBuilder.replyRetryNumber, aBuilder.replyTimeoutInMs, aBuilder.sequenceNumberInitValue, aBuilder.sequenceNumberWidth, aBuilder.crcAlgorithm, aBuilder.checksumValidationMode, aBuilder.inboundQueueCapacity, aBuilder.executorService);
    }

    public HandshakePortController(Port<PM> aPort, HandshakeTransmissionMetrics aTransmissionMetrics) {
        this(aPort, aTransmissionMetrics, -1, null);
    }

    public HandshakePortController(Port<PM> aPort, HandshakeTransmissionMetrics aTransmissionMetrics, ExecutorService aExecutorService) {
        this(aPort, aTransmissionMetrics, -1, aExecutorService);
    }

    public HandshakePortController(Port<PM> aPort) {
        this(aPort, null, -1, null);
    }

    public HandshakePortController(Port<PM> aPort, Endianess aEndianess, int aAcknowledgeRetryNumber, long aAcknowledgeTimeoutInMs, int aReplyRetryNumber, long aReplyTimeoutInMs, int aSequenceNumberWidth, CrcAlgorithm aCrcAlgorithm, ChecksumValidationMode aChecksumValidationMode) {
        this(aPort, aEndianess, aAcknowledgeRetryNumber, aAcknowledgeTimeoutInMs, aReplyRetryNumber, aReplyTimeoutInMs, -1, aSequenceNumberWidth, aCrcAlgorithm, aChecksumValidationMode, -1, null);
    }

    public HandshakePortController(Port<PM> aPort, Endianess aEndianess, int aAcknowledgeRetryNumber, long aAcknowledgeTimeoutInMs, int aReplyRetryNumber, long aReplyTimeoutInMs, int aSequenceNumberWidth, CrcAlgorithm aCrcAlgorithm, ChecksumValidationMode aChecksumValidationMode, ExecutorService aExecutorService) {
        this(aPort, aEndianess, aAcknowledgeRetryNumber, aAcknowledgeTimeoutInMs, aReplyRetryNumber, aReplyTimeoutInMs, -1, aSequenceNumberWidth, aCrcAlgorithm, aChecksumValidationMode, -1, aExecutorService);
    }

    public HandshakePortController(Port<PM> aPort, Endianess aEndianess, int aAcknowledgeRetryNumber, long aAcknowledgeTimeoutInMs, int aReplyRetryNumber, long aReplyTimeoutInMs, int aSequenceNumberInitValue, int aSequenceNumberWidth, CrcAlgorithm aCrcAlgorithm, ChecksumValidationMode aChecksumValidationMode) {
        this(aPort, aEndianess, aAcknowledgeRetryNumber, aAcknowledgeTimeoutInMs, aReplyRetryNumber, aReplyTimeoutInMs, aSequenceNumberInitValue, aSequenceNumberWidth, aCrcAlgorithm, aChecksumValidationMode, -1, null);
    }

    public HandshakePortController(Port<PM> aPort, Endianess aEndianess, CrcAlgorithm aCrcAlgorithm) {
        this(aPort, aEndianess, HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER, HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS, HandshakeTransmissionMetrics.DEFAULT_REPLY_RETRY_NUMBER, HandshakeTransmissionMetrics.DEFAULT_REPLY_TIMEOUT_IN_MS, -1, 4, aCrcAlgorithm, HandshakeTransmissionMetrics.DEFAULT_CHECKSUM_VALIDATION_MODE, -1, null);
    }

    public HandshakePortController(Port<PM> aPort, Endianess aEndianess, CrcAlgorithm aCrcAlgorithm, ChecksumValidationMode aChecksumValidationMode) {
        this(aPort, aEndianess, HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER, HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS, HandshakeTransmissionMetrics.DEFAULT_REPLY_RETRY_NUMBER, HandshakeTransmissionMetrics.DEFAULT_REPLY_TIMEOUT_IN_MS, -1, 4, aCrcAlgorithm, aChecksumValidationMode, -1, null);
    }

    public HandshakePortController(Port<PM> aPort, Endianess aEndianess, CrcAlgorithm aCrcAlgorithm, ChecksumValidationMode aChecksumValidationMode, ExecutorService aExecutorService) {
        this(aPort, aEndianess, HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER, HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS, HandshakeTransmissionMetrics.DEFAULT_REPLY_RETRY_NUMBER, HandshakeTransmissionMetrics.DEFAULT_REPLY_TIMEOUT_IN_MS, -1, 4, aCrcAlgorithm, aChecksumValidationMode, -1, aExecutorService);
    }

    public HandshakePortController(Port<PM> aPort, Endianess aEndianess, CrcAlgorithm aCrcAlgorithm, ExecutorService aExecutorService) {
        this(aPort, aEndianess, HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER, HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS, HandshakeTransmissionMetrics.DEFAULT_REPLY_RETRY_NUMBER, HandshakeTransmissionMetrics.DEFAULT_REPLY_TIMEOUT_IN_MS, -1, 4, aCrcAlgorithm, HandshakeTransmissionMetrics.DEFAULT_CHECKSUM_VALIDATION_MODE, -1, aExecutorService);
    }

    public HandshakePortController(Port<PM> aPort, ExecutorService aExecutorService) {
        this(aPort, HandshakeTransmissionMetrics.DEFAULT_ENDIANESS, HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER, HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS, HandshakeTransmissionMetrics.DEFAULT_REPLY_RETRY_NUMBER, HandshakeTransmissionMetrics.DEFAULT_REPLY_TIMEOUT_IN_MS, -1, 4, HandshakeTransmissionMetrics.DEFAULT_CRC_ALGORITHM, HandshakeTransmissionMetrics.DEFAULT_CHECKSUM_VALIDATION_MODE, -1, aExecutorService);
    }

    public HandshakePortController(Port<PM> aPort, HandshakeTransmissionMetrics aTransmissionMetrics, int aInboundQueueCapacity) {
        this(aPort, aTransmissionMetrics, aInboundQueueCapacity, null);
    }

    public HandshakePortController(Port<PM> aPort, int aInboundQueueCapacity) {
        this(aPort, null, aInboundQueueCapacity, null);
    }

    public HandshakePortController(Port<PM> aPort, Endianess aEndianess, int aAcknowledgeRetryNumber, long aAcknowledgeTimeoutInMs, int aReplyRetryNumber, long aReplyTimeoutInMs, int aSequenceNumberWidth, CrcAlgorithm aCrcAlgorithm, ChecksumValidationMode aChecksumValidationMode, int aInboundQueueCapacity) {
        this(aPort, aEndianess, aAcknowledgeRetryNumber, aAcknowledgeTimeoutInMs, aReplyRetryNumber, aReplyTimeoutInMs, -1, aSequenceNumberWidth, aCrcAlgorithm, aChecksumValidationMode, aInboundQueueCapacity, null);
    }

    public HandshakePortController(Port<PM> aPort, Endianess aEndianess, int aAcknowledgeRetryNumber, long aAcknowledgeTimeoutInMs, int aReplyRetryNumber, long aReplyTimeoutInMs, int aSequenceNumberWidth, CrcAlgorithm aCrcAlgorithm, ChecksumValidationMode aChecksumValidationMode, int aInboundQueueCapacity, ExecutorService aExecutorService) {
        this(aPort, aEndianess, aAcknowledgeRetryNumber, aAcknowledgeTimeoutInMs, aReplyRetryNumber, aReplyTimeoutInMs, -1, aSequenceNumberWidth, aCrcAlgorithm, aChecksumValidationMode, aInboundQueueCapacity, aExecutorService);
    }

    public HandshakePortController(Port<PM> aPort, Endianess aEndianess, int aAcknowledgeRetryNumber, long aAcknowledgeTimeoutInMs, int aReplyRetryNumber, long aReplyTimeoutInMs, int aSequenceNumberInitValue, int aSequenceNumberWidth, CrcAlgorithm aCrcAlgorithm, ChecksumValidationMode aChecksumValidationMode, int aInboundQueueCapacity) {
        this(aPort, aEndianess, aAcknowledgeRetryNumber, aAcknowledgeTimeoutInMs, aReplyRetryNumber, aReplyTimeoutInMs, aSequenceNumberInitValue, aSequenceNumberWidth, aCrcAlgorithm, aChecksumValidationMode, aInboundQueueCapacity, null);
    }

    public HandshakePortController(Port<PM> aPort, Endianess aEndianess, CrcAlgorithm aCrcAlgorithm, int aInboundQueueCapacity) {
        this(aPort, aEndianess, HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER, HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS, HandshakeTransmissionMetrics.DEFAULT_REPLY_RETRY_NUMBER, HandshakeTransmissionMetrics.DEFAULT_REPLY_TIMEOUT_IN_MS, -1, 4, aCrcAlgorithm, HandshakeTransmissionMetrics.DEFAULT_CHECKSUM_VALIDATION_MODE, aInboundQueueCapacity, null);
    }

    public HandshakePortController(Port<PM> aPort, Endianess aEndianess, CrcAlgorithm aCrcAlgorithm, ChecksumValidationMode aChecksumValidationMode, int aInboundQueueCapacity) {
        this(aPort, aEndianess, HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER, HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS, HandshakeTransmissionMetrics.DEFAULT_REPLY_RETRY_NUMBER, HandshakeTransmissionMetrics.DEFAULT_REPLY_TIMEOUT_IN_MS, -1, 4, aCrcAlgorithm, aChecksumValidationMode, aInboundQueueCapacity, null);
    }

    public HandshakePortController(Port<PM> aPort, Endianess aEndianess, CrcAlgorithm aCrcAlgorithm, ChecksumValidationMode aChecksumValidationMode, int aInboundQueueCapacity, ExecutorService aExecutorService) {
        this(aPort, aEndianess, HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER, HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS, HandshakeTransmissionMetrics.DEFAULT_REPLY_RETRY_NUMBER, HandshakeTransmissionMetrics.DEFAULT_REPLY_TIMEOUT_IN_MS, -1, 4, aCrcAlgorithm, aChecksumValidationMode, aInboundQueueCapacity, aExecutorService);
    }

    public HandshakePortController(Port<PM> aPort, Endianess aEndianess, CrcAlgorithm aCrcAlgorithm, int aInboundQueueCapacity, ExecutorService aExecutorService) {
        this(aPort, aEndianess, HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER, HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS, HandshakeTransmissionMetrics.DEFAULT_REPLY_RETRY_NUMBER, HandshakeTransmissionMetrics.DEFAULT_REPLY_TIMEOUT_IN_MS, -1, 4, aCrcAlgorithm, HandshakeTransmissionMetrics.DEFAULT_CHECKSUM_VALIDATION_MODE, aInboundQueueCapacity, aExecutorService);
    }

    public HandshakePortController(Port<PM> aPort, int aInboundQueueCapacity, ExecutorService aExecutorService) {
        this(aPort, null, aInboundQueueCapacity, aExecutorService);
    }

    public HandshakePortController(Port<PM> aPort, Endianess aEndianess, int aAcknowledgeRetryNumber, long aAcknowledgeTimeoutInMs, int aReplyRetryNumber, long aReplyTimeoutInMs, int aSequenceNumberInitValue, int aSequenceNumberWidth, CrcAlgorithm aCrcAlgorithm, ChecksumValidationMode aChecksumValidationMode, ExecutorService aExecutorService) {
        this(aPort, aEndianess, aAcknowledgeRetryNumber, aAcknowledgeTimeoutInMs, aReplyRetryNumber, aReplyTimeoutInMs, aSequenceNumberInitValue, aSequenceNumberWidth, aCrcAlgorithm, aChecksumValidationMode, -1, aExecutorService);
    }

    public HandshakePortController(Port<PM> aPort, Endianess aEndianess, int aAcknowledgeRetryNumber, long aAcknowledgeTimeoutInMs, int aReplyRetryNumber, long aReplyTimeoutInMs, int aSequenceNumberInitValue, int aSequenceNumberWidth, CrcAlgorithm aCrcAlgorithm, ChecksumValidationMode aChecksumValidationMode, int aInboundQueueCapacity, ExecutorService aExecutorService) {
        this(aPort, HandshakeTransmissionMetrics.builder().withEndianess(aEndianess).withAcknowledgeRetryNumber(aAcknowledgeRetryNumber).withAcknowledgeTimeoutMillis(aAcknowledgeTimeoutInMs).withSequenceNumberInitValue(aSequenceNumberInitValue).withSequenceNumberWidth(aSequenceNumberWidth).withCrcAlgorithm(aCrcAlgorithm).withChecksumValidationMode(aChecksumValidationMode).build(), aInboundQueueCapacity, aExecutorService);
    }

    public HandshakePortController(Port<PM> aPort, HandshakeTransmissionMetrics aTransmissionMetrics, int aInboundQueueCapacity, ExecutorService aExecutorService) {
        super(aPort);
        this._inboundQueue = new LinkedBlockingQueue(aInboundQueueCapacity != -1 ? aInboundQueueCapacity : Integer.MAX_VALUE);
        this._transmissionMetrics = aTransmissionMetrics != null ? aTransmissionMetrics : new HandshakeTransmissionMetrics();
        this._sequenceNumber.set(this._transmissionMetrics.getSequenceNumberInitValue() != -1 ? this._transmissionMetrics.getSequenceNumberInitValue() : (int)System.currentTimeMillis());
        ExecutorService executorService = this._executorService = aExecutorService != null ? aExecutorService : ControlFlowUtility.createCachedExecutorService(true);
        if (aPort.isOpened()) {
            this.start();
        }
    }

    public void ping() throws IOException {
        this.pingWithin(this._transmissionMetrics.getPingTimeoutMillis(), this._transmissionMetrics.getPingRetryNumber());
    }

    public <SEGMENT extends Segment> void pingWithin(long aTimeoutMillis, int aRetryNumber) throws IOException {
        this.transmitSegmentWithin(aTimeoutMillis, aRetryNumber, new TransmissionMessage(this._sequenceNumber.getAndIncrement(), TransmissionType.PING, this._transmissionMetrics));
    }

    public void onPing(Runnable aPingHandler) {
        this._pingHandler = aPingHandler;
    }

    public <SEGMENT extends Segment> boolean onSegment(SEGMENT aSegment, SegmentConsumer<SEGMENT> aSegmentConsumer) {
        for (SegmentConsumerTupel<?> eTupel : this._segmentConsumerTupels) {
            if (eTupel.segment != aSegment && !eTupel.segment.equals(aSegment)) continue;
            return false;
        }
        this._segmentConsumerTupels.add(new SegmentConsumerTupel<SEGMENT>(aSegment, aSegmentConsumer));
        return true;
    }

    public <REQUEST extends Segment> boolean onRequest(REQUEST aRequest, RequestHandler<REQUEST> aRequestHandler) {
        for (RequestHandlerTupel<?> eTupel : this._requestHandlerTupels) {
            if (eTupel.request != aRequest && !eTupel.request.equals(aRequest)) continue;
            return false;
        }
        this._requestHandlerTupels.add(new RequestHandlerTupel<REQUEST>(aRequest, aRequestHandler));
        return true;
    }

    @Override
    public int available() throws IOException {
        ArrayList<TransmissionMessage> theSegments = new ArrayList<TransmissionMessage>(this._inboundQueue);
        int theLength = 0;
        for (Segment segment : theSegments) {
            theLength += segment.getLength();
        }
        return theLength;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this._port != null) {
            this._port.close();
        }
        super.close();
        this._executorService.shutdownNow();
    }

    @Override
    public <SEGMENT extends Segment> SegmentResult<SEGMENT> doTransmitSegment(SEGMENT aSegment) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot receive a segment as the connection is in status <" + String.valueOf((Object)this.getConnectionStatus()) + ">!");
        }
        TransmitSegmentResultDaemon<SEGMENT> theDaemon = new TransmitSegmentResultDaemon<SEGMENT>(aSegment, this);
        this._executorService.execute(theDaemon);
        return theDaemon.getSegmentResult();
    }

    @Override
    public <SEGMENT extends Segment> void doTransmitSegment(SEGMENT aSegment, SegmentConsumer<SEGMENT> aSegmentConsumer) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot transmit a segment as the connection is in status <" + String.valueOf((Object)this.getConnectionStatus()) + ">!");
        }
        this._executorService.execute(new TransmitSegmentConsumerDaemon<SEGMENT>(aSegmentConsumer, aSegment, this));
    }

    @Override
    public byte[] getAcknowledgeMagicBytes() {
        return this._transmissionMetrics.getAcknowledgeMagicBytes();
    }

    @Override
    public int getAcknowledgeRetryNumber() {
        return this._transmissionMetrics.getAcknowledgeRetryNumber();
    }

    @Override
    public long getAcknowledgeTimeoutMillis() {
        return this._transmissionMetrics.getAcknowledgeTimeoutMillis();
    }

    @Override
    public int getReplyRetryNumber() {
        return this._transmissionMetrics.getReplyRetryNumber();
    }

    @Override
    public long getReplyTimeoutMillis() {
        return this._transmissionMetrics.getReplyTimeoutMillis();
    }

    @Override
    public CrcAlgorithm getCrcAlgorithm() {
        return this._transmissionMetrics.getCrcAlgorithm();
    }

    @Override
    public ChecksumValidationMode getChecksumValidationMode() {
        return this._transmissionMetrics.getChecksumValidationMode();
    }

    @Override
    public Endianess getEndianess() {
        return this._transmissionMetrics.getEndianess();
    }

    @Override
    public InputStream getInputStream() {
        InputStream thePayloadStream;
        try {
            TransmissionMessage theTransmissionMessage = this._inboundQueue.take();
            thePayloadStream = theTransmissionMessage.getPayload().toSequence().getInputStream();
        }
        catch (InterruptedException e) {
            thePayloadStream = new ByteArrayInputStream(new byte[0]);
        }
        return thePayloadStream;
    }

    @Override
    public TimeoutInputStream getInputStream(long aTimeoutMillis) {
        return SerialUtility.createTimeoutInputStream(this.getInputStream(), aTimeoutMillis);
    }

    @Override
    public int getSequenceNumber() {
        return this._sequenceNumber.get();
    }

    @Override
    public int getSequenceNumberInitValue() {
        return this._transmissionMetrics.getSequenceNumberInitValue();
    }

    @Override
    public int getSequenceNumberWidth() {
        return this._transmissionMetrics.getSequenceNumberWidth();
    }

    @Override
    public <SEGMENT extends Segment> SegmentResult<SEGMENT> onReceiveSegment(SEGMENT aSegment) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot receive a segment as the connection is in status <" + String.valueOf((Object)this.getConnectionStatus()) + ">!");
        }
        ReceiveSegmentResultDaemon<SEGMENT> theDaemon = new ReceiveSegmentResultDaemon<SEGMENT>(aSegment, this);
        this._executorService.execute(theDaemon);
        return theDaemon.getSegmentResult();
    }

    @Override
    public <SEGMENT extends Segment> void onReceiveSegment(SEGMENT aSegment, SegmentConsumer<SEGMENT> aSegmentConsumer) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot receive a segment as the connection is in status <" + String.valueOf((Object)this.getConnectionStatus()) + ">!");
        }
        this._executorService.execute(new ReceiveSegmentConsumerDaemon<SEGMENT>(aSegmentConsumer, aSegment, this));
    }

    @Override
    public synchronized void open() throws IOException {
        super.open();
        this.start();
    }

    @Override
    public synchronized void open(PM aPortMetrics) throws IOException {
        super.open(aPortMetrics);
        this.start();
    }

    @Override
    public byte receiveByte() throws IOException {
        return this.receiveByteWithin(-1L);
    }

    @Override
    public byte receiveByteWithin(long aTimeoutMillis) throws IOException {
        ByteSegment theSegment = new ByteSegment();
        this.receiveSegmentWithin(aTimeoutMillis, theSegment);
        return (Byte)theSegment.getPayload();
    }

    @Override
    public byte[] receiveAllBytes() throws IOException {
        ByteArraySection theSection = new ByteArraySection(new byte[this.available()]);
        AllocSectionDecoratorSegment<ByteArraySection> theSegment = new AllocSectionDecoratorSegment<ByteArraySection>(theSection, (TransmissionMetrics)this._transmissionMetrics);
        this.receiveSegmentWithin(-1L, theSegment);
        return (byte[])theSection.getPayload();
    }

    @Override
    public byte[] receiveBytes(int aLength) throws IOException {
        return this.receiveBytesWithin(-1L, aLength);
    }

    @Override
    public byte[] receiveBytesWithin(long aTimeoutMillis, int aLength) throws IOException {
        ByteArraySection theSection = new ByteArraySection(new byte[aLength]);
        AllocSectionDecoratorSegment<ByteArraySection> theSegment = new AllocSectionDecoratorSegment<ByteArraySection>(theSection, (TransmissionMetrics)this._transmissionMetrics);
        this.receiveSegmentWithin(-1L, theSegment);
        return (byte[])theSection.getPayload();
    }

    @Override
    public void receiveBytes(byte[] aBuffer, int aOffset, int aLength) throws IOException {
        this.receiveBytesWithin(-1L, aBuffer, aOffset, aLength);
    }

    @Override
    public void receiveBytesWithin(long aTimeoutMillis, byte[] aBuffer, int aOffset, int aLength) throws IOException {
        ByteArraySection theSection = new ByteArraySection(new byte[this.available()]);
        AllocSectionDecoratorSegment<ByteArraySection> theSegment = new AllocSectionDecoratorSegment<ByteArraySection>(theSection, (TransmissionMetrics)this._transmissionMetrics);
        this.receiveSegmentWithin(aTimeoutMillis, theSegment);
        byte[] theBuffer = (byte[])theSection.getPayload();
        System.arraycopy(theBuffer, 0, aBuffer, aOffset, aLength);
    }

    @Override
    public Sequence receiveSequence(int aLength) throws IOException {
        return this.receiveSequenceWithin(-1L, aLength);
    }

    @Override
    public Sequence receiveSequenceWithin(long aTimeoutMillis, int aLength) throws IOException {
        ByteArraySection theSection = new ByteArraySection(new byte[aLength]);
        AllocSectionDecoratorSegment<ByteArraySection> theSegment = new AllocSectionDecoratorSegment<ByteArraySection>(theSection, (TransmissionMetrics)this._transmissionMetrics);
        this.receiveSegmentWithin(aTimeoutMillis, theSegment);
        return theSection.toSequence();
    }

    @Override
    public <SEGMENT extends Segment> void receiveSegment(SEGMENT aSegment) throws IOException {
        this.receiveSegmentWithin(-1L, aSegment);
    }

    @Override
    public <SEGMENT extends Segment> void receiveSegmentWithin(long aTimeoutMillis, SEGMENT aSegment) throws IOException {
        try {
            TransmissionMessage theHandshakeMsg;
            TransmissionMessage transmissionMessage = theHandshakeMsg = aTimeoutMillis > 0L ? this._inboundQueue.poll(aTimeoutMillis, TimeUnit.MILLISECONDS) : this._inboundQueue.take();
            if (theHandshakeMsg == null) {
                throw new TimeoutIOException(aTimeoutMillis, "Unable to retrieve a transmission within <" + aTimeoutMillis + "> milliseconds!");
            }
            theHandshakeMsg.toPayloadSegment(aSegment);
        }
        catch (InterruptedException e) {
            throw new IOException("I/O operation has unexpectedly been interrupted upon receiving a segment!", e);
        }
    }

    public <REQUEST extends Segment, RESPONSE extends Segment> void requestSegment(REQUEST aRequest, RESPONSE aResponse) throws IOException {
        this.requestSegmentWithin(-1L, aRequest, aResponse);
    }

    public <REQUEST extends Segment, RESPONSE extends Segment> void requestSegmentWithin(long aTimeoutMillis, REQUEST aRequest, RESPONSE aResponse) throws IOException {
        this.requestSegmentWithin(aTimeoutMillis, new TransmissionMessage(this._sequenceNumber.getAndIncrement(), TransmissionType.ACKNOWLEDGEABLE_REQUEST, aRequest, aResponse, this._transmissionMetrics));
    }

    public <REQUEST extends Segment, RESPONSE extends Segment> void requestSegment(REQUEST aRequest, RESPONSE aResponse, boolean isAcknowledgeable) throws IOException {
        this.requestSegmentWithin(-1L, aRequest, aResponse, isAcknowledgeable);
    }

    public <REQUEST extends Segment, RESPONSE extends Segment> void requestSegmentWithin(long aTimeoutMillis, REQUEST aRequest, RESPONSE aResponse, boolean isAcknowledgeable) throws IOException {
        this.requestSegmentWithin(aTimeoutMillis, new TransmissionMessage(this._sequenceNumber.getAndIncrement(), isAcknowledgeable ? TransmissionType.ACKNOWLEDGEABLE_REQUEST : TransmissionType.REQUEST, aRequest, aResponse, this._transmissionMetrics));
    }

    @Override
    public <SEGMENT extends Segment> void transmitSegment(SEGMENT aSegment) throws IOException {
        this.transmitSegmentWithin(this._transmissionMetrics.getAcknowledgeTimeoutMillis(), this._transmissionMetrics.getAcknowledgeRetryNumber(), new TransmissionMessage(this._sequenceNumber.getAndIncrement(), TransmissionType.ACKNOWLEDGEABLE_TRANSMISSION, aSegment, this._transmissionMetrics));
    }

    @Override
    public void transmitSequence(Sequence aSequence) throws IOException {
        this.transmitSegmentWithin(this._transmissionMetrics.getAcknowledgeTimeoutMillis(), this._transmissionMetrics.getAcknowledgeRetryNumber(), new TransmissionMessage(this._sequenceNumber.getAndIncrement(), TransmissionType.ACKNOWLEDGEABLE_TRANSMISSION, aSequence, this._transmissionMetrics));
    }

    public <SEGMENT extends Segment> void transmitSegmentWithin(long aTimeoutMillis, int aRetryNumber, SEGMENT aSegment) throws IOException {
        this.transmitSegmentWithin(aTimeoutMillis, aRetryNumber, new TransmissionMessage(this._sequenceNumber.getAndIncrement(), TransmissionType.ACKNOWLEDGEABLE_TRANSMISSION, aSegment, this._transmissionMetrics));
    }

    public <SEGMENT extends Segment> void transmitSegmentWithin(long aTimeoutMillis, SEGMENT aSegment) throws IOException {
        this.transmitSegmentWithin(aTimeoutMillis, 1, new TransmissionMessage(this._sequenceNumber.getAndIncrement(), TransmissionType.ACKNOWLEDGEABLE_TRANSMISSION, aSegment, this._transmissionMetrics));
    }

    public void transmitSequenceWithin(long aTimeoutMillis, int aRetryNumber, Sequence aSequence) throws IOException {
        this.transmitSegmentWithin(aTimeoutMillis, aRetryNumber, new TransmissionMessage(this._sequenceNumber.getAndIncrement(), TransmissionType.ACKNOWLEDGEABLE_TRANSMISSION, aSequence, this._transmissionMetrics));
    }

    public void transmitSequenceWithin(long aTimeoutMillis, Sequence aSequence) throws IOException {
        this.transmitSegmentWithin(aTimeoutMillis, 1, new TransmissionMessage(this._sequenceNumber.getAndIncrement(), TransmissionType.ACKNOWLEDGEABLE_TRANSMISSION, aSequence, this._transmissionMetrics));
    }

    public <SEGMENT extends Segment> void transmitSegment(SEGMENT aSegment, boolean isAcknowledgeable) throws IOException {
        this.transmitSegmentWithin(this._transmissionMetrics.getAcknowledgeTimeoutMillis(), this._transmissionMetrics.getAcknowledgeRetryNumber(), new TransmissionMessage(this._sequenceNumber.getAndIncrement(), isAcknowledgeable ? TransmissionType.ACKNOWLEDGEABLE_TRANSMISSION : TransmissionType.TRANSMISSION, aSegment, this._transmissionMetrics));
    }

    public void transmitSequence(Sequence aSequence, boolean isAcknowledgeable) throws IOException {
        this.transmitSegmentWithin(this._transmissionMetrics.getAcknowledgeTimeoutMillis(), this._transmissionMetrics.getAcknowledgeRetryNumber(), new TransmissionMessage(this._sequenceNumber.getAndIncrement(), isAcknowledgeable ? TransmissionType.ACKNOWLEDGEABLE_TRANSMISSION : TransmissionType.TRANSMISSION, aSequence, this._transmissionMetrics));
    }

    @Override
    public void transmitByte(byte aByte) throws IOException {
        ByteSegment theSegment = new ByteSegment(aByte);
        this.transmitSegment(theSegment);
    }

    @Override
    public void transmitBytes(byte[] aBytes) throws IOException {
        ByteArraySection theSection = new ByteArraySection(aBytes);
        AllocSectionDecoratorSegment<ByteArraySection> theSegment = new AllocSectionDecoratorSegment<ByteArraySection>(theSection, (TransmissionMetrics)this._transmissionMetrics);
        this.transmitSegment(theSegment);
    }

    @Override
    public void transmitBytes(byte[] aBytes, int aOffset, int aLength) throws IOException {
        byte[] theBuffer = new byte[aLength];
        System.arraycopy(aBytes, aOffset, theBuffer, 0, aLength);
        ByteArraySection theSection = new ByteArraySection(theBuffer);
        AllocSectionDecoratorSegment<ByteArraySection> theSegment = new AllocSectionDecoratorSegment<ByteArraySection>(theSection, (TransmissionMetrics)this._transmissionMetrics);
        this.transmitSegment(theSegment);
    }

    @Override
    public HandshakePortController<PM> withOpen() throws IOException {
        this.open();
        return this;
    }

    @Override
    public HandshakePortController<PM> withOpen(PM aPortMetrics) throws IOException {
        this.open(aPortMetrics);
        return this;
    }

    @Override
    public HandshakePortController<PM> withOpenUnchecked(PM aPortMetrics) {
        this.openUnchecked(aPortMetrics);
        return this;
    }

    @Override
    public HandshakePortController<PM> withOpenUnchecked() {
        this.openUnchecked();
        return this;
    }

    public static <PM extends PortMetrics> Builder<PM> builder() {
        return new Builder();
    }

    private void start() {
        this._executorService.execute(new OutboundQueueDaemon());
        this._executorService.execute(new InboundQueueDaemon());
        this._executorService.execute(new RequestQueueDaemon());
        this._executorService.execute(new ConsumerQueueDaemon());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transmitSegmentWithin(long aTimeoutMillis, int aRetryNumber, TransmissionMessage aTransmissionMessage) throws IOException {
        aRetryNumber = aRetryNumber != -1 ? aRetryNumber : this._transmissionMetrics.getAcknowledgeRetryNumber();
        long l = aTimeoutMillis = aTimeoutMillis != -1L ? aTimeoutMillis : this._transmissionMetrics.getAcknowledgeTimeoutMillis();
        if (aTransmissionMessage.getTransmissionType().isAcknowledgeable()) {
            int theSequenceNumber = aTransmissionMessage.getSequenceNumber();
            for (int i = 0; i < aRetryNumber; ++i) {
                if (!this._outboundQueue.contains(aTransmissionMessage)) {
                    this._outboundQueue.offer(aTransmissionMessage);
                }
                try {
                    TransmissionMessage transmissionMessage = aTransmissionMessage;
                    synchronized (transmissionMessage) {
                        aTransmissionMessage.wait(aTimeoutMillis);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (aTransmissionMessage.getException() != null) {
                    this._outboundQueue.remove(aTransmissionMessage);
                    this._sequenceNumToAcknowledge.remove(theSequenceNumber);
                    throw aTransmissionMessage.getException();
                }
                if (!aTransmissionMessage.hasAcknowledge()) continue;
                this._sequenceNumToAcknowledge.remove(theSequenceNumber);
                this._outboundQueue.remove(aTransmissionMessage);
                return;
            }
            this._outboundQueue.remove(aTransmissionMessage);
            this._sequenceNumToAcknowledge.remove(theSequenceNumber);
            throw new TimeoutIOException(this._transmissionMetrics.getAcknowledgeTimeoutMillis(), "Aborting transmission after <" + aRetryNumber + "> retries without an acknowledge with timeouts each of <" + this._transmissionMetrics.getAcknowledgeTimeoutMillis() + "> milliseconds duration! Failed transmission: " + (String)(aTransmissionMessage != null && aTransmissionMessage.getPayload() != null ? " Failed transmission: " + aTransmissionMessage.getPayload().toString() : ""));
        }
        for (int i = 0; i < aRetryNumber; ++i) {
            if (!this._outboundQueue.contains(aTransmissionMessage)) {
                this._outboundQueue.offer(aTransmissionMessage);
            }
            try {
                TransmissionMessage transmissionMessage = aTransmissionMessage;
                synchronized (transmissionMessage) {
                    aTransmissionMessage.wait(aTimeoutMillis);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (aTransmissionMessage.getException() == null) continue;
            this._outboundQueue.remove(aTransmissionMessage);
            throw aTransmissionMessage.getException();
        }
        this._outboundQueue.remove(aTransmissionMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <RESPONSE extends Segment> void requestSegmentWithin(long aTimeoutMillis, TransmissionMessage aRequestMsg) throws IOException {
        int theSequenceNumber = aRequestMsg.getSequenceNumber();
        for (int i = 0; i < this._transmissionMetrics.getReplyRetryNumber(); ++i) {
            if (!this._outboundQueue.contains(aRequestMsg)) {
                this._outboundQueue.offer(aRequestMsg);
            }
            try {
                TransmissionMessage transmissionMessage = aRequestMsg;
                synchronized (transmissionMessage) {
                    aRequestMsg.wait(aTimeoutMillis != -1L ? aTimeoutMillis : this._transmissionMetrics.getReplyTimeoutMillis());
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (aRequestMsg.getException() != null) {
                this._sequenceNumToRequest.remove(theSequenceNumber);
                this._outboundQueue.remove(aRequestMsg);
                throw aRequestMsg.getException();
            }
            if (!aRequestMsg.hasResponse()) continue;
            this._sequenceNumToRequest.remove(theSequenceNumber);
            this._outboundQueue.remove(aRequestMsg);
            return;
        }
        this._sequenceNumToRequest.remove(theSequenceNumber);
        this._outboundQueue.remove(aRequestMsg);
        throw new TimeoutIOException(this._transmissionMetrics.getReplyTimeoutMillis(), "Aborting transmission after <" + this._transmissionMetrics.getReplyRetryNumber() + "> retries without an acknowledge with timeouts each of <" + this._transmissionMetrics.getReplyTimeoutMillis() + "> milliseconds duration! Failed transmission: " + aRequestMsg.getPayload().toString());
    }

    private void offerInbound(TransmissionMessage aTransmissionMsg) {
        if (!this._inboundQueue.offer(aTransmissionMsg)) {
            if (aTransmissionMsg.getTransmissionType().isAcknowledgeable()) {
                this._outboundQueue.offer(new AcknowledgeMessage(AcknowledgeType.TRANSMISSION_DISMISSED, aTransmissionMsg.getSequenceNumber(), this._transmissionMetrics));
            }
            LOGGER.log(Level.WARNING, "Skipping inbound transmission for session ID <" + aTransmissionMsg.getSequenceNumber() + "> as the queue capacity has been exceeded.");
        } else if (aTransmissionMsg.getTransmissionType().isAcknowledgeable()) {
            this._outboundQueue.offer(new AcknowledgeMessage(AcknowledgeType.ACKNOWLEDGE, aTransmissionMsg.getSequenceNumber(), this._transmissionMetrics));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addSequenceNumber(TransmissionMessage eTransmissionMsg) {
        if (!this._sequenceNumbers.contains(eTransmissionMsg.getSequenceNumber())) {
            Set<Integer> set = this._sequenceNumbers;
            synchronized (set) {
                if (!this._sequenceNumbers.contains(eTransmissionMsg.getSequenceNumber())) {
                    this._sequenceNumbers.add(eTransmissionMsg.getSequenceNumber());
                    if (this._sequenceNumbers.size() > 1024) {
                        this._sequenceNumbers.remove(0);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static final class Builder<PM extends PortMetrics>
    implements AcknowledgeTimeoutMillisAccessor.AcknowledgeTimeoutMillisBuilder<Builder<PM>>,
    AcknowledgeRetryNumberAccessor.AcknowledgeRetryNumberBuilder<Builder<PM>>,
    ReplyTimeoutMillisAccessor.ReplyTimeoutMillisBuilder<Builder<PM>>,
    ReplyRetryNumberAccessor.ReplyRetryNumberBuilder<Builder<PM>>,
    CrcAlgorithmAccessor.CrcAlgorithmBuilder<Builder<PM>>,
    ChecksumValidationModeAccessor.ChecksumValidationModeBuilder<Builder<PM>>,
    EndianessAccessor.EndianessBuilder<Builder<PM>>,
    SequenceNumberInitValueAccessor.SequenceNumberInitValueBuilder<Builder<PM>>,
    SequenceNumberWidthAccessor.SequenceNumberWidthBuilder<Builder<PM>> {
        private int acknowledgeRetryNumber;
        private long acknowledgeTimeoutInMs;
        private int replyRetryNumber;
        private long replyTimeoutInMs;
        private CrcAlgorithm crcAlgorithm;
        private ChecksumValidationMode checksumValidationMode;
        private Endianess endianess;
        private ExecutorService executorService;
        private Port<PM> port;
        private int sequenceNumberInitValue;
        private int sequenceNumberWidth;
        private int inboundQueueCapacity;

        private Builder() {
        }

        @Override
        public Builder<PM> withReplyRetryNumber(int aReplyRetryNumber) {
            this.replyRetryNumber = aReplyRetryNumber;
            return this;
        }

        @Override
        public Builder<PM> withReplyTimeoutMillis(long aReplyTimeoutInMs) {
            this.replyTimeoutInMs = aReplyTimeoutInMs;
            return this;
        }

        @Override
        public Builder<PM> withAcknowledgeRetryNumber(int aAcknowledgeRetryNumber) {
            this.acknowledgeRetryNumber = aAcknowledgeRetryNumber;
            return this;
        }

        @Override
        public Builder<PM> withAcknowledgeTimeoutMillis(long aAcknowledgeTimeoutInMs) {
            this.acknowledgeTimeoutInMs = aAcknowledgeTimeoutInMs;
            return this;
        }

        @Override
        public Builder<PM> withCrcAlgorithm(CrcAlgorithm aCrcAlgorithm) {
            this.crcAlgorithm = aCrcAlgorithm;
            return this;
        }

        @Override
        public Builder<PM> withChecksumValidationMode(ChecksumValidationMode aChecksumValidationMode) {
            this.checksumValidationMode = aChecksumValidationMode;
            return this;
        }

        @Override
        public Builder<PM> withEndianess(Endianess aEndianess) {
            this.endianess = aEndianess;
            return this;
        }

        @Override
        public Builder<PM> withSequenceNumberInitValue(int aSequenceNumberInitValue) {
            this.sequenceNumberInitValue = aSequenceNumberInitValue;
            return this;
        }

        @Override
        public Builder<PM> withSequenceNumberWidth(int aSequenceNumberWidth) {
            this.sequenceNumberWidth = aSequenceNumberWidth;
            return this;
        }

        public Builder<PM> withInboundQueueCapacity(int aInboundQueueCapacity) {
            this.inboundQueueCapacity = aInboundQueueCapacity;
            return this;
        }

        public Builder<PM> withExecutorService(ExecutorService aExecutorService) {
            this.executorService = aExecutorService;
            return this;
        }

        public Builder<PM> withPort(Port<PM> aPort) {
            this.port = aPort;
            return this;
        }

        public HandshakePortController<PM> build() {
            return new HandshakePortController(this);
        }
    }

    private static class SegmentConsumerTupel<SEGMENT extends Segment> {
        SEGMENT segment;
        SegmentConsumer<SEGMENT> consumer;

        SegmentConsumerTupel(SEGMENT aSegment, SegmentConsumer<SEGMENT> aConsumer) {
            this.segment = aSegment;
            this.consumer = aConsumer;
        }

        void onSegment() {
            this.consumer.onSegment(this.segment);
        }
    }

    private static class RequestHandlerTupel<REQUEST extends Segment> {
        REQUEST request;
        RequestHandler<REQUEST> handler;

        RequestHandlerTupel(REQUEST aRequest, RequestHandler<REQUEST> aHandler) {
            this.request = aRequest;
            this.handler = aHandler;
        }

        public Segment onRequest() {
            return this.handler.onRequest(this.request);
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [request=" + String.valueOf(this.request) + ", handler=" + String.valueOf(this.handler) + "]";
        }
    }

    private class OutboundQueueDaemon
    implements Runnable {
        private OutboundQueueDaemon() {
        }

        @Override
        public void run() {
            while (!HandshakePortController.this.isClosed()) {
                try {
                    Message eOut = HandshakePortController.this._outboundQueue.take();
                    if (eOut instanceof TransmissionMessage && ((TransmissionMessage)eOut).getTransmissionType() == TransmissionType.PING) {
                        this.onPingMsg((TransmissionMessage)eOut);
                        continue;
                    }
                    if (eOut instanceof TransmissionMessage && ((TransmissionMessage)eOut).getTransmissionType() == TransmissionType.TRANSMISSION) {
                        this.onTransmissionMsg((TransmissionMessage)eOut);
                        continue;
                    }
                    if (eOut instanceof TransmissionMessage && ((TransmissionMessage)eOut).getTransmissionType() == TransmissionType.REQUEST) {
                        this.onRequestMsg((TransmissionMessage)eOut);
                        continue;
                    }
                    if (eOut instanceof TransmissionMessage && ((TransmissionMessage)eOut).getTransmissionType() == TransmissionType.RESPONSE) {
                        this.onResponseMsg((TransmissionMessage)eOut);
                        continue;
                    }
                    if (eOut instanceof TransmissionMessage && ((TransmissionMessage)eOut).getTransmissionType() == TransmissionType.ACKNOWLEDGEABLE_TRANSMISSION) {
                        this.onAcknowledgeableTransmissionMsg((TransmissionMessage)eOut);
                        continue;
                    }
                    if (eOut instanceof TransmissionMessage && ((TransmissionMessage)eOut).getTransmissionType() == TransmissionType.ACKNOWLEDGEABLE_REQUEST) {
                        this.onAcknowledgeableRequestMsg((TransmissionMessage)eOut);
                        continue;
                    }
                    if (eOut instanceof TransmissionMessage && ((TransmissionMessage)eOut).getTransmissionType() == TransmissionType.ACKNOWLEDGEABLE_RESPONSE) {
                        this.onAcknowledgeableResponseMsg((TransmissionMessage)eOut);
                        continue;
                    }
                    this.onAcknowledge(eOut);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private void onAcknowledge(Message aAcknowledge) {
            try {
                HandshakePortController.this._port.transmitSegment(aAcknowledge);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, Trap.asMessage(e), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onAcknowledgeableResponseMsg(TransmissionMessage aAcknowledgeableResponseMsg) {
            HandshakePortController.this._sequenceNumToAcknowledge.put(aAcknowledgeableResponseMsg.getSequenceNumber(), aAcknowledgeableResponseMsg);
            try {
                HandshakePortController.this._port.transmitSegment(aAcknowledgeableResponseMsg);
            }
            catch (IOException e) {
                HandshakePortController.this._sequenceNumToAcknowledge.remove(aAcknowledgeableResponseMsg.getSequenceNumber());
                aAcknowledgeableResponseMsg.setException(e);
                TransmissionMessage transmissionMessage = aAcknowledgeableResponseMsg;
                synchronized (transmissionMessage) {
                    aAcknowledgeableResponseMsg.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onAcknowledgeableRequestMsg(TransmissionMessage aAcknowledgeableRequestMsg) {
            HandshakePortController.this._sequenceNumToRequest.put(aAcknowledgeableRequestMsg.getSequenceNumber(), aAcknowledgeableRequestMsg);
            try {
                HandshakePortController.this._port.transmitSegment(aAcknowledgeableRequestMsg);
            }
            catch (IOException e) {
                HandshakePortController.this._sequenceNumToRequest.remove(aAcknowledgeableRequestMsg.getSequenceNumber());
                aAcknowledgeableRequestMsg.setException(e);
                TransmissionMessage transmissionMessage = aAcknowledgeableRequestMsg;
                synchronized (transmissionMessage) {
                    aAcknowledgeableRequestMsg.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onAcknowledgeableTransmissionMsg(TransmissionMessage aAcknowledgeableTransmissionMsg) {
            HandshakePortController.this._sequenceNumToAcknowledge.put(aAcknowledgeableTransmissionMsg.getSequenceNumber(), aAcknowledgeableTransmissionMsg);
            try {
                HandshakePortController.this._port.transmitSegment(aAcknowledgeableTransmissionMsg);
            }
            catch (IOException e) {
                HandshakePortController.this._sequenceNumToAcknowledge.remove(aAcknowledgeableTransmissionMsg.getSequenceNumber());
                aAcknowledgeableTransmissionMsg.setException(e);
                TransmissionMessage transmissionMessage = aAcknowledgeableTransmissionMsg;
                synchronized (transmissionMessage) {
                    aAcknowledgeableTransmissionMsg.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onTransmissionMsg(TransmissionMessage aTransmissionMsg) {
            try {
                HandshakePortController.this._port.transmitSegment(aTransmissionMsg);
            }
            catch (IOException e) {
                aTransmissionMsg.setException(e);
            }
            TransmissionMessage transmissionMessage = aTransmissionMsg;
            synchronized (transmissionMessage) {
                aTransmissionMsg.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onRequestMsg(TransmissionMessage aRequestMsg) {
            HandshakePortController.this._sequenceNumToRequest.put(aRequestMsg.getSequenceNumber(), aRequestMsg);
            try {
                HandshakePortController.this._port.transmitSegment(aRequestMsg);
            }
            catch (IOException e) {
                HandshakePortController.this._sequenceNumToRequest.remove(aRequestMsg.getSequenceNumber());
                aRequestMsg.setException(e);
                TransmissionMessage transmissionMessage = aRequestMsg;
                synchronized (transmissionMessage) {
                    aRequestMsg.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onResponseMsg(TransmissionMessage aResponseMsg) {
            try {
                HandshakePortController.this._port.transmitSegment(aResponseMsg);
            }
            catch (IOException e) {
                aResponseMsg.setException(e);
            }
            TransmissionMessage transmissionMessage = aResponseMsg;
            synchronized (transmissionMessage) {
                aResponseMsg.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPingMsg(TransmissionMessage aPingMsg) {
            HandshakePortController.this._sequenceNumToAcknowledge.put(aPingMsg.getSequenceNumber(), aPingMsg);
            try {
                HandshakePortController.this._port.transmitSegment(aPingMsg);
            }
            catch (IOException e) {
                HandshakePortController.this._sequenceNumToAcknowledge.remove(aPingMsg.getSequenceNumber());
                aPingMsg.setException(e);
                TransmissionMessage transmissionMessage = aPingMsg;
                synchronized (transmissionMessage) {
                    aPingMsg.notifyAll();
                }
            }
        }
    }

    private class InboundQueueDaemon
    implements Runnable {
        private InboundQueueDaemon() {
        }

        @Override
        public void run() {
            TransmissionMessage eResponseMsg = null;
            while (!HandshakePortController.this.isClosed()) {
                try {
                    Segment[] segmentArray = new Segment[12];
                    TransmissionMessage ePingMsg = new TransmissionMessage(TransmissionType.PING, HandshakePortController.this._transmissionMetrics);
                    segmentArray[0] = ePingMsg;
                    TransmissionMessage eTransmissionMsg = new TransmissionMessage(TransmissionType.TRANSMISSION, HandshakePortController.this._transmissionMetrics);
                    segmentArray[1] = eTransmissionMsg;
                    TransmissionMessage eAcknowledgeableTransmissionMsg = new TransmissionMessage(TransmissionType.ACKNOWLEDGEABLE_TRANSMISSION, HandshakePortController.this._transmissionMetrics);
                    segmentArray[2] = eAcknowledgeableTransmissionMsg;
                    TransmissionMessage eRequestMsg = new TransmissionMessage(TransmissionType.REQUEST, HandshakePortController.this._transmissionMetrics);
                    segmentArray[3] = eRequestMsg;
                    eResponseMsg = new TransmissionMessage(TransmissionType.RESPONSE, HandshakePortController.this._transmissionMetrics);
                    segmentArray[4] = eResponseMsg;
                    TransmissionMessage eAcknowledgeableRequestMsg = new TransmissionMessage(TransmissionType.ACKNOWLEDGEABLE_REQUEST, HandshakePortController.this._transmissionMetrics);
                    segmentArray[5] = eAcknowledgeableRequestMsg;
                    TransmissionMessage eAcknowledgeableResponseMsg = new TransmissionMessage(TransmissionType.ACKNOWLEDGEABLE_RESPONSE, HandshakePortController.this._transmissionMetrics);
                    segmentArray[6] = eAcknowledgeableResponseMsg;
                    AcknowledgeMessage ePongAck = new AcknowledgeMessage(AcknowledgeType.PONG, HandshakePortController.this._transmissionMetrics);
                    segmentArray[7] = ePongAck;
                    AcknowledgeMessage eAcknowledgeableTransmissionAck = new AcknowledgeMessage(AcknowledgeType.ACKNOWLEDGE, HandshakePortController.this._transmissionMetrics);
                    segmentArray[8] = eAcknowledgeableTransmissionAck;
                    AcknowledgeMessage eAcknowledgeableTransmissionDismissedAck = new AcknowledgeMessage(AcknowledgeType.TRANSMISSION_DISMISSED, HandshakePortController.this._transmissionMetrics);
                    segmentArray[9] = eAcknowledgeableTransmissionDismissedAck;
                    AcknowledgeMessage eAcknowledgeableResponseAck = new AcknowledgeMessage(AcknowledgeType.RESPONSE, HandshakePortController.this._transmissionMetrics);
                    segmentArray[10] = eAcknowledgeableResponseAck;
                    AcknowledgeMessage eAcknowledgeableRequestDismissedAck = new AcknowledgeMessage(AcknowledgeType.REQUEST_DISMISSED, HandshakePortController.this._transmissionMetrics);
                    segmentArray[11] = eAcknowledgeableRequestDismissedAck;
                    MagicBytesSegmentMultiplexer eMultiplexer = new MagicBytesSegmentMultiplexer(segmentArray);
                    HandshakePortController.this._port.receiveSegment(eMultiplexer);
                    if (eMultiplexer.getCallee() == ePingMsg) {
                        this.onPingMsg(ePingMsg);
                        continue;
                    }
                    if (eMultiplexer.getCallee() == ePongAck) {
                        this.onPongAck(ePongAck);
                        continue;
                    }
                    if (eMultiplexer.getCallee() == eTransmissionMsg) {
                        this.onTransmissionMsg(eTransmissionMsg);
                        continue;
                    }
                    if (eMultiplexer.getCallee() == eAcknowledgeableTransmissionMsg) {
                        this.onAcknowledgeableTransmissionMsg(eAcknowledgeableTransmissionMsg);
                        continue;
                    }
                    if (eMultiplexer.getCallee() == eAcknowledgeableTransmissionAck) {
                        this.onAcknowledgeTransmissionAck(eAcknowledgeableTransmissionAck);
                        continue;
                    }
                    if (eMultiplexer.getCallee() == eAcknowledgeableTransmissionDismissedAck) {
                        this.onAcknowledgeableTransmissionDismissedAck(eAcknowledgeableTransmissionDismissedAck);
                        continue;
                    }
                    if (eMultiplexer.getCallee() == eAcknowledgeableRequestMsg) {
                        this.onAcknowledgeableRequestMsg(eAcknowledgeableRequestMsg);
                        continue;
                    }
                    if (eMultiplexer.getCallee() == eAcknowledgeableResponseMsg) {
                        this.onAcknowledgeableResponseMsg(eAcknowledgeableResponseMsg);
                        continue;
                    }
                    if (eMultiplexer.getCallee() == eAcknowledgeableRequestDismissedAck) {
                        this.onAcknowledgeableRequestDismissedAck(eAcknowledgeableRequestDismissedAck);
                        continue;
                    }
                    if (eMultiplexer.getCallee() == eAcknowledgeableResponseAck) {
                        this.onAcknowledgeableResponseAck(eAcknowledgeableResponseAck);
                        continue;
                    }
                    if (eMultiplexer.getCallee() == eRequestMsg) {
                        this.onRequestMsg(eRequestMsg);
                        continue;
                    }
                    if (eMultiplexer.getCallee() != eResponseMsg) continue;
                    this.onResponseMsg(eResponseMsg);
                }
                catch (IOException e) {
                    if (HandshakePortController.this.isClosed()) continue;
                    try {
                        if (HandshakePortController.this._port.available() <= 0) continue;
                        LOGGER.log(Level.WARNING, Trap.asMessage(e), e);
                        HandshakePortController.this._port.skipAvailableWithin(IoRetryCount.MIN.getValue(), IoSleepLoopTime.MIN.getTimeMillis());
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private void onTransmissionMsg(TransmissionMessage eTransmissionMsg) {
            if (!HandshakePortController.this._segmentConsumerTupels.isEmpty()) {
                HandshakePortController.this._consumerQueue.offer(eTransmissionMsg);
            } else {
                HandshakePortController.this.offerInbound(eTransmissionMsg);
            }
        }

        private void onRequestMsg(TransmissionMessage aRequestMsg) {
            if (HandshakePortController.this.addSequenceNumber(aRequestMsg)) {
                HandshakePortController.this._requestQueue.offer(aRequestMsg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onResponseMsg(TransmissionMessage aResponseMsg) throws TransmissionException {
            TransmissionMessage theRequestMsg = HandshakePortController.this._sequenceNumToRequest.remove(aResponseMsg.getSequenceNumber());
            if (theRequestMsg != null) {
                theRequestMsg.setResponse(aResponseMsg.getPayload().toSequence());
                TransmissionMessage transmissionMessage = theRequestMsg;
                synchronized (transmissionMessage) {
                    theRequestMsg.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onAcknowledgeableResponseAck(AcknowledgeMessage aAcknowledgeableResponseAck) {
            TransmissionMessage theAcknowledgeableResponseMsg = HandshakePortController.this._sequenceNumToAcknowledge.remove(aAcknowledgeableResponseAck.getSequenceNumber());
            if (aAcknowledgeableResponseAck != null) {
                theAcknowledgeableResponseMsg.acknowledge();
                TransmissionMessage transmissionMessage = theAcknowledgeableResponseMsg;
                synchronized (transmissionMessage) {
                    theAcknowledgeableResponseMsg.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onAcknowledgeableRequestDismissedAck(AcknowledgeMessage aAcknowledgeableRequestDismissedAck) {
            TransmissionMessage theRequestMsg = HandshakePortController.this._sequenceNumToRequest.remove(aAcknowledgeableRequestDismissedAck.getSequenceNumber());
            if (theRequestMsg != null) {
                theRequestMsg.setException(new IOException(new IllegalArgumentException("Bad request, no remote <" + RequestHandler.class.getSimpleName() + "> has been found for given request <" + String.valueOf(theRequestMsg.getPayload()) + ">!")));
                TransmissionMessage transmissionMessage = theRequestMsg;
                synchronized (transmissionMessage) {
                    theRequestMsg.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onAcknowledgeableResponseMsg(TransmissionMessage aAcknowledgeableResponseMsg) throws TransmissionException {
            TransmissionMessage theRequestMsg = HandshakePortController.this._sequenceNumToRequest.remove(aAcknowledgeableResponseMsg.getSequenceNumber());
            if (theRequestMsg != null) {
                theRequestMsg.setResponse(aAcknowledgeableResponseMsg.getPayload().toSequence());
                TransmissionMessage transmissionMessage = theRequestMsg;
                synchronized (transmissionMessage) {
                    theRequestMsg.notifyAll();
                }
                HandshakePortController.this._outboundQueue.offer(new AcknowledgeMessage(AcknowledgeType.RESPONSE, aAcknowledgeableResponseMsg.getSequenceNumber(), HandshakePortController.this._transmissionMetrics));
            }
        }

        private void onAcknowledgeableRequestMsg(TransmissionMessage aAcknowledgeableRequestMsg) {
            if (HandshakePortController.this.addSequenceNumber(aAcknowledgeableRequestMsg)) {
                HandshakePortController.this._requestQueue.offer(aAcknowledgeableRequestMsg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onAcknowledgeableTransmissionDismissedAck(AcknowledgeMessage aAcknowledgeableTransmissionDismissedAck) {
            TransmissionMessage theAcknowledgeableTransmissionMsg = HandshakePortController.this._sequenceNumToAcknowledge.remove(aAcknowledgeableTransmissionDismissedAck.getSequenceNumber());
            if (theAcknowledgeableTransmissionMsg != null) {
                theAcknowledgeableTransmissionMsg.setException(new IOException("Receiver dismissed transmission with sequence number <" + aAcknowledgeableTransmissionDismissedAck.getSequenceNumber() + ">!"));
                TransmissionMessage transmissionMessage = theAcknowledgeableTransmissionMsg;
                synchronized (transmissionMessage) {
                    theAcknowledgeableTransmissionMsg.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onAcknowledgeTransmissionAck(AcknowledgeMessage aAcknowledgeTransmissionAck) {
            TransmissionMessage theAcknowledgeableTransmissionMsg = HandshakePortController.this._sequenceNumToAcknowledge.remove(aAcknowledgeTransmissionAck.getSequenceNumber());
            if (theAcknowledgeableTransmissionMsg != null) {
                theAcknowledgeableTransmissionMsg.acknowledge();
                TransmissionMessage transmissionMessage = theAcknowledgeableTransmissionMsg;
                synchronized (transmissionMessage) {
                    theAcknowledgeableTransmissionMsg.notifyAll();
                }
            }
        }

        private void onAcknowledgeableTransmissionMsg(TransmissionMessage aAcknowledgeableTransmissionMsg) {
            if (HandshakePortController.this.addSequenceNumber(aAcknowledgeableTransmissionMsg)) {
                this.onTransmissionMsg(aAcknowledgeableTransmissionMsg);
                HandshakePortController.this._outboundQueue.offer(new AcknowledgeMessage(AcknowledgeType.ACKNOWLEDGE, aAcknowledgeableTransmissionMsg.getSequenceNumber(), HandshakePortController.this._transmissionMetrics));
            }
        }

        private void onPingMsg(TransmissionMessage aPingMsg) {
            if (HandshakePortController.this.addSequenceNumber(aPingMsg)) {
                HandshakePortController.this._outboundQueue.offer(new AcknowledgeMessage(AcknowledgeType.PONG, aPingMsg.getSequenceNumber(), HandshakePortController.this._transmissionMetrics));
                if (HandshakePortController.this._pingHandler != null) {
                    HandshakePortController.this._pingHandler.run();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPongAck(AcknowledgeMessage aPongAck) {
            TransmissionMessage thePingMsg = HandshakePortController.this._sequenceNumToAcknowledge.remove(aPongAck.getSequenceNumber());
            if (thePingMsg != null) {
                thePingMsg.acknowledge();
                TransmissionMessage transmissionMessage = thePingMsg;
                synchronized (transmissionMessage) {
                    thePingMsg.notifyAll();
                }
            }
        }
    }

    private class RequestQueueDaemon
    implements Runnable {
        private RequestQueueDaemon() {
        }

        @Override
        public void run() {
            while (!HandshakePortController.this.isClosed()) {
                try {
                    TransmissionMessage eRequestMsg = HandshakePortController.this._requestQueue.take();
                    try {
                        TransmissionMessage eResponseMsg = new TransmissionMessage(eRequestMsg.getSequenceNumber(), eRequestMsg.getTransmissionType().isAcknowledgeable() ? TransmissionType.ACKNOWLEDGEABLE_RESPONSE : TransmissionType.RESPONSE, this.onRequest(eRequestMsg), HandshakePortController.this._transmissionMetrics);
                        HandshakePortController.this.transmitSegmentWithin(HandshakePortController.this._transmissionMetrics.getAcknowledgeTimeoutMillis(), HandshakePortController.this._transmissionMetrics.getAcknowledgeRetryNumber(), eResponseMsg);
                    }
                    catch (IOException | IllegalArgumentException e) {
                        LOGGER.log(Level.WARNING, Trap.asMessage(e), e);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private Segment onRequest(TransmissionMessage aRequestMsg) throws IOException {
            Sequence theSequence = aRequestMsg.getPayload().toSequence();
            IOException theCause = null;
            for (RequestHandlerTupel<?> eRequestHandlerTupel : HandshakePortController.this._requestHandlerTupels) {
                try {
                    eRequestHandlerTupel.request.fromTransmission(theSequence);
                    return eRequestHandlerTupel.onRequest();
                }
                catch (IOException e) {
                    theCause = theCause == null ? e : theCause;
                }
            }
            HandshakePortController.this._outboundQueue.offer(new AcknowledgeMessage(AcknowledgeType.REQUEST_DISMISSED, aRequestMsg.getSequenceNumber()));
            throw new IllegalArgumentException("Bad request, no <" + RequestHandler.class.getSimpleName() + "> has been found!" + (String)(theCause != null ? " Cause: " + theCause.getMessage() : ""), theCause);
        }
    }

    private class ConsumerQueueDaemon
    implements Runnable {
        private ConsumerQueueDaemon() {
        }

        @Override
        public void run() {
            while (!HandshakePortController.this.isClosed()) {
                try {
                    TransmissionMessage eConsumerMsg = HandshakePortController.this._consumerQueue.take();
                    try {
                        this.onSegment(eConsumerMsg);
                        if (!eConsumerMsg.getTransmissionType().isAcknowledgeable()) continue;
                        HandshakePortController.this._outboundQueue.offer(new AcknowledgeMessage(AcknowledgeType.ACKNOWLEDGE, eConsumerMsg.getSequenceNumber(), HandshakePortController.this._transmissionMetrics));
                    }
                    catch (IOException | IllegalArgumentException e) {
                        HandshakePortController.this.offerInbound(eConsumerMsg);
                        LOGGER.log(Level.WARNING, Trap.asMessage(e), e);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private void onSegment(TransmissionMessage aConsumerMsg) throws IOException {
            Sequence theSequence = aConsumerMsg.getPayload().toSequence();
            Throwable theCause = null;
            for (SegmentConsumerTupel<?> eSegmentConsumerTupel : HandshakePortController.this._segmentConsumerTupels) {
                try {
                    eSegmentConsumerTupel.segment.fromTransmission(theSequence);
                    eSegmentConsumerTupel.onSegment();
                    return;
                }
                catch (IOException e) {
                    theCause = theCause == null ? e : theCause;
                }
            }
            throw new IllegalArgumentException("Bad transmission, no <" + SegmentConsumer.class.getSimpleName() + "> has been found!" + (String)(theCause != null ? " Cause: " + theCause.getMessage() : ""), theCause);
        }
    }
}

