/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial.ext.handshake;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.serial.AssertMagicBytesSegment;
import org.refcodes.serial.CrcSegmentDecorator;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SequenceNumberSegment;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.serial.ext.handshake.AcknowledgeType;
import org.refcodes.serial.ext.handshake.AcknowledgeTypeAccessor;
import org.refcodes.serial.ext.handshake.HandshakeMessage;
import org.refcodes.serial.ext.handshake.HandshakeTransmissionMetrics;
import org.refcodes.struct.MapSimpleTypeTable;
import org.refcodes.struct.SimpleTypeTable;

class AcknowledgeMessage
implements HandshakeMessage,
AcknowledgeTypeAccessor {
    private static final long serialVersionUID = 1L;
    protected Segment _delegatee = null;
    private SequenceNumberSegment _sequenceNumberSegment;
    private AssertMagicBytesSegment _assertMagicBytesSegment;
    private HandshakeTransmissionMetrics _transmissionMetrics;

    public AcknowledgeMessage(AcknowledgeType aAcknowledgeType, int aSequenceNumber) {
        this(aAcknowledgeType, aSequenceNumber, new HandshakeTransmissionMetrics());
    }

    public AcknowledgeMessage(AcknowledgeType aAcknowledgeType, int aSequenceNumber, HandshakeTransmissionMetrics aTransmissionMetrics) {
        aTransmissionMetrics = aTransmissionMetrics != null ? aTransmissionMetrics : new HandshakeTransmissionMetrics();
        Segment[] segmentArray = new CrcSegmentDecorator[1];
        Segment[] segmentArray2 = new Segment.SegmentMixin[2];
        this._assertMagicBytesSegment = SerialSugar.assertMagicBytesSegment(aTransmissionMetrics.toMagicBytes(aAcknowledgeType), (TransmissionMetrics)aTransmissionMetrics);
        segmentArray2[0] = this._assertMagicBytesSegment;
        this._sequenceNumberSegment = SerialSugar.sequenceNumberSegment((long)aSequenceNumber, (TransmissionMetrics)aTransmissionMetrics);
        segmentArray2[1] = this._sequenceNumberSegment;
        segmentArray[0] = SerialSugar.crcSegment(SerialSugar.segmentComposite((Segment[])segmentArray2), aTransmissionMetrics);
        this._delegatee = SerialSugar.segmentComposite((Segment[])segmentArray);
        this._transmissionMetrics = aTransmissionMetrics;
    }

    public AcknowledgeMessage(AcknowledgeType aAcknowledgeType) {
        this(aAcknowledgeType, -1, new HandshakeTransmissionMetrics());
    }

    public AcknowledgeMessage(AcknowledgeType aAcknowledgeType, HandshakeTransmissionMetrics aTransmissionMetrics) {
        this(aAcknowledgeType, -1, aTransmissionMetrics);
    }

    @Override
    public int getLength() {
        return this._delegatee.getLength();
    }

    @Override
    public void reset() {
        this._assertMagicBytesSegment.reset();
        this._delegatee.reset();
        this._sequenceNumberSegment.reset();
    }

    @Override
    public Sequence toSequence() {
        return this._delegatee.toSequence();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [segment=" + String.valueOf(this._delegatee) + "]";
    }

    @Override
    public SimpleTypeTable toSimpleTypeTable() {
        return this._delegatee != null ? this._delegatee.toSimpleTypeTable() : new MapSimpleTypeTable();
    }

    @Override
    public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
        this._delegatee.transmitTo(aOutputStream, aReturnStream);
    }

    @Override
    public SerialSchema toSchema() {
        return this._delegatee.toSchema();
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        return this._delegatee.fromTransmission(aSequence, aOffset);
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException {
        this._delegatee.receiveFrom(aInputStream, aReturnStream);
    }

    @Override
    public int getSequenceNumber() {
        return this._sequenceNumberSegment != null ? (this._sequenceNumberSegment.getValue() != null ? this._sequenceNumberSegment.getValue().intValue() : -1) : -1;
    }

    @Override
    public byte[] getMagicBytes() {
        return this._assertMagicBytesSegment.getMagicBytes();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._delegatee == null ? 0 : this._delegatee.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AcknowledgeMessage other = (AcknowledgeMessage)obj;
        return !(this._delegatee == null ? other._delegatee != null : !this._delegatee.equals(other._delegatee));
    }

    @Override
    public AcknowledgeType getAcknowledgeType() {
        return this._transmissionMetrics.toAcknowledgeType(this._assertMagicBytesSegment.getMagicBytes());
    }
}

