/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial.alt.tty;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.exception.BugException;
import org.refcodes.io.TimeoutInputStream;
import org.refcodes.mixin.DescriptionAccessor;
import org.refcodes.mixin.NameAccessor;
import org.refcodes.serial.AbstractPort;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialUtility;
import org.refcodes.serial.alt.tty.BaudRate;
import org.refcodes.serial.alt.tty.Handshake;
import org.refcodes.serial.alt.tty.Parity;
import org.refcodes.serial.alt.tty.StopBits;
import org.refcodes.serial.alt.tty.TtyPortMetrics;

public class TtyPort
extends AbstractPort<TtyPortMetrics>
implements NameAccessor,
DescriptionAccessor,
AutoCloseable {
    public static final Parity DEFAULT_PARITY = Parity.EVEN;
    public static final StopBits DEFAULT_STOP_BITS = StopBits.ONE_POINT_FIVE;
    private String _name;
    private String _description;
    private SerialPort _serialPort;

    protected TtyPort(String aAlias, TtyPortMetrics aPortMetrics, String aName, String aDescription, SerialPort aSerialPort) {
        this(aAlias, aPortMetrics, aName, aDescription, aSerialPort, ControlFlowUtility.createCachedExecutorService(true));
    }

    protected TtyPort(String aAlias, TtyPortMetrics aPortMetrics, String aName, String aDescription, SerialPort aSerialPort, ExecutorService aExecutorService) {
        super(aAlias, aPortMetrics, aExecutorService);
        this._name = aName;
        this._description = aDescription;
        this._serialPort = aSerialPort;
        this._serialPort.flushIOBuffers();
        this._serialPort.addDataListener(new SerialPortDataListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void serialEvent(SerialPortEvent event) {
                TtyPort ttyPort = TtyPort.this;
                synchronized (ttyPort) {
                    this.notifyAll();
                }
            }

            @Override
            public int getListeningEvents() {
                return 1;
            }
        });
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public int getReadBufferSize() {
        return this._serialPort.getDeviceReadBufferSize();
    }

    public int getWriteBufferSize() {
        return this._serialPort.getDeviceWriteBufferSize();
    }

    @Override
    public boolean isOpenable() {
        return !this.isOpened();
    }

    @Override
    public void open() throws IOException {
        this.open((TtyPortMetrics)this._portMetrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(TtyPortMetrics aConnection) throws IOException {
        if (aConnection != null) {
            this._portMetrics = aConnection;
        }
        super.open((TtyPortMetrics)this._portMetrics);
        Object object = this;
        synchronized (object) {
            this.notifyAll();
        }
        object = this._serialPort;
        synchronized (object) {
            this._serialPort.notifyAll();
        }
        if (!this._serialPort.openPort() && !this._serialPort.isOpen()) {
            throw new IOException("Cannot open port  <" + this._serialPort.getSystemPortName() + ">.");
        }
        Parity theParity = ((TtyPortMetrics)this._portMetrics).getParity();
        if (theParity == Parity.AUTO) {
            theParity = DEFAULT_PARITY;
        }
        int theSerialPartiy = switch (theParity) {
            case Parity.EVEN -> 2;
            case Parity.MARK -> 3;
            case Parity.NONE -> 0;
            case Parity.ODD -> 1;
            case Parity.SPACE -> 4;
            case Parity.AUTO -> throw new BugException("We should not end up in enumeration <" + String.valueOf((Object)theParity) + ">.");
            default -> throw new BugException("The enumeration <" + String.valueOf((Object)theParity) + "> has been forgotten to get implemented.");
        };
        StopBits theStopBits = ((TtyPortMetrics)this._portMetrics).getStopBits();
        if (theStopBits == StopBits.AUTO) {
            theStopBits = DEFAULT_STOP_BITS;
        }
        int theSerialStopBits = switch (theStopBits) {
            case StopBits.ONE -> 1;
            case StopBits.ONE_POINT_FIVE -> 2;
            case StopBits.TWO -> 3;
            case StopBits.AUTO -> throw new BugException("We should not end up in enumeration <" + String.valueOf((Object)theStopBits) + ">.");
            default -> throw new BugException("The enumeration <" + String.valueOf((Object)theStopBits) + "> has been forgotten to get implemented.");
        };
        this._serialPort.setComPortTimeouts(16, ((TtyPortMetrics)this._portMetrics).getReadTimeoutMillis() > 0L ? (int)((TtyPortMetrics)this._portMetrics).getReadTimeoutMillis() : this._serialPort.getReadTimeout(), ((TtyPortMetrics)this._portMetrics).getWriteTimeoutMillis() > 0L ? (int)((TtyPortMetrics)this._portMetrics).getWriteTimeoutMillis() : this._serialPort.getWriteTimeout());
        this._serialPort.setComPortParameters(((TtyPortMetrics)this._portMetrics).getBaudRate(), ((TtyPortMetrics)this._portMetrics).getDataBits(), theSerialStopBits, theSerialPartiy);
    }

    public void open(int aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity, Handshake aHandshake, int aReadTimeout, int aWriteTimeout) throws IOException {
        this.open(new TtyPortMetrics(aBaudRate, aDataBits, aStopBits, aParity, aHandshake, (long)aReadTimeout, (long)aWriteTimeout));
    }

    public void open(BaudRate aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity, Handshake aHandshake, int aReadTimeout, int aWriteTimeout) throws IOException {
        this.open(new TtyPortMetrics(aBaudRate, aDataBits, aStopBits, aParity, aHandshake, (long)aReadTimeout, (long)aWriteTimeout));
    }

    public void open(int aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity, Handshake aHandshake) throws IOException {
        this.open(new TtyPortMetrics(aBaudRate, aDataBits, aStopBits, aParity, aHandshake, ((TtyPortMetrics)this._portMetrics).getReadTimeoutMillis(), ((TtyPortMetrics)this._portMetrics).getWriteTimeoutMillis()));
    }

    public void open(BaudRate aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity, Handshake aHandshake) throws IOException {
        this.open(new TtyPortMetrics(aBaudRate, aDataBits, aStopBits, aParity, aHandshake, ((TtyPortMetrics)this._portMetrics).getReadTimeoutMillis(), ((TtyPortMetrics)this._portMetrics).getWriteTimeoutMillis()));
    }

    public void open(int aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity) throws IOException {
        this.open(new TtyPortMetrics(aBaudRate, aDataBits, aStopBits, aParity, ((TtyPortMetrics)this._portMetrics).getHandshake(), ((TtyPortMetrics)this._portMetrics).getReadTimeoutMillis(), ((TtyPortMetrics)this._portMetrics).getWriteTimeoutMillis()));
    }

    public void open(BaudRate aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity) throws IOException {
        this.open(new TtyPortMetrics(aBaudRate, aDataBits, aStopBits, aParity, ((TtyPortMetrics)this._portMetrics).getHandshake(), ((TtyPortMetrics)this._portMetrics).getReadTimeoutMillis(), ((TtyPortMetrics)this._portMetrics).getWriteTimeoutMillis()));
    }

    @Override
    public void open(int aBaudRate) throws IOException {
        this.open(new TtyPortMetrics(aBaudRate, ((TtyPortMetrics)this._portMetrics).getDataBits(), ((TtyPortMetrics)this._portMetrics).getStopBits(), ((TtyPortMetrics)this._portMetrics).getParity(), ((TtyPortMetrics)this._portMetrics).getHandshake(), ((TtyPortMetrics)this._portMetrics).getReadTimeoutMillis(), ((TtyPortMetrics)this._portMetrics).getWriteTimeoutMillis()));
    }

    @Override
    public void open(BaudRate aBaudRate) throws IOException {
        this.open(new TtyPortMetrics(aBaudRate, ((TtyPortMetrics)this._portMetrics).getDataBits(), ((TtyPortMetrics)this._portMetrics).getStopBits(), ((TtyPortMetrics)this._portMetrics).getParity(), ((TtyPortMetrics)this._portMetrics).getHandshake(), ((TtyPortMetrics)this._portMetrics).getReadTimeoutMillis(), ((TtyPortMetrics)this._portMetrics).getWriteTimeoutMillis()));
    }

    public void open(BaudRate aBaudRate, int aReadTimeout, int aWriteTimeout) throws IOException {
        this.open(new TtyPortMetrics(aBaudRate, ((TtyPortMetrics)this._portMetrics).getDataBits(), ((TtyPortMetrics)this._portMetrics).getStopBits(), ((TtyPortMetrics)this._portMetrics).getParity(), ((TtyPortMetrics)this._portMetrics).getHandshake(), (long)aReadTimeout, (long)aWriteTimeout));
    }

    public void open(int aBaudRate, int aReadTimeout, int aWriteTimeout) throws IOException {
        this.open(new TtyPortMetrics(aBaudRate, ((TtyPortMetrics)this._portMetrics).getDataBits(), ((TtyPortMetrics)this._portMetrics).getStopBits(), ((TtyPortMetrics)this._portMetrics).getParity(), ((TtyPortMetrics)this._portMetrics).getHandshake(), (long)aReadTimeout, (long)aWriteTimeout));
    }

    public void open(int aReadTimeout, int aWriteTimeout) throws IOException {
        this.open(new TtyPortMetrics(((TtyPortMetrics)this._portMetrics).getBaudRate(), ((TtyPortMetrics)this._portMetrics).getDataBits(), ((TtyPortMetrics)this._portMetrics).getStopBits(), ((TtyPortMetrics)this._portMetrics).getParity(), ((TtyPortMetrics)this._portMetrics).getHandshake(), (long)aReadTimeout, (long)aWriteTimeout));
    }

    @Override
    public void transmitSequence(Sequence aSequence) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot receive a segment from port <" + this._alias + "> (" + this._name + ") as the connection is in status <" + String.valueOf((Object)this.getConnectionStatus()) + ">!");
        }
        this._serialPort.writeBytes(aSequence.toBytes(), aSequence.getLength());
    }

    @Override
    public void receiveBytes(byte[] aBuffer, int aOffset, int aLength) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot receive a segment as the connection is in status <" + String.valueOf((Object)this.getConnectionStatus()) + ">!");
        }
        int theLength = this._serialPort.readBytes(aBuffer, aLength, aOffset);
        if (theLength != aLength) {
            throw new IOException("Cannot only read as many as <" + theLength + "> bytes instead of the expected <" + aLength + "> bytes from port <" + this._alias + "> (" + this._name + ")" + (String)(!this.isOpened() ? ", the port status is <" + String.valueOf((Object)this.getConnectionStatus()) + ">, maybe it was not opened or closed too eraly" : "") + "!");
        }
    }

    @Override
    public int available() {
        return this._serialPort.bytesAvailable();
    }

    @Override
    public void flush() throws IOException {
        this._serialPort.flushIOBuffers();
    }

    @Override
    public TtyPort withOpen(TtyPortMetrics aConnection) throws IOException {
        this.open(aConnection);
        return this;
    }

    @Override
    public TtyPort withOpen() throws IOException {
        this.open();
        return this;
    }

    public TtyPort withOpen(int aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity, Handshake aHandshake, int aReadTimeout, int aWriteTimeout) throws IOException {
        this.open(aBaudRate, aDataBits, aStopBits, aParity, aHandshake, aReadTimeout, aWriteTimeout);
        return this;
    }

    public TtyPort withOpen(BaudRate aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity, Handshake aHandshake, int aReadTimeout, int aWriteTimeout) throws IOException {
        this.open(aBaudRate, aDataBits, aStopBits, aParity, aHandshake, aReadTimeout, aWriteTimeout);
        return this;
    }

    public TtyPort withOpen(int aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity, Handshake aHandshake) throws IOException {
        this.open(aBaudRate, aDataBits, aStopBits, aParity, aHandshake);
        return this;
    }

    public TtyPort withOpen(BaudRate aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity, Handshake aHandshake) throws IOException {
        this.open(aBaudRate, aDataBits, aStopBits, aParity, aHandshake);
        return this;
    }

    public TtyPort withOpen(int aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity) throws IOException {
        this.open(aBaudRate, aDataBits, aStopBits, aParity);
        return this;
    }

    public TtyPort withOpen(BaudRate aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity) throws IOException {
        this.open(aBaudRate, aDataBits, aStopBits, aParity);
        return this;
    }

    @Override
    public TtyPort withOpen(int aBaudRate) throws IOException {
        this.open(aBaudRate);
        return this;
    }

    @Override
    public TtyPort withOpen(BaudRate aBaudRate) throws IOException {
        this.open(aBaudRate);
        return this;
    }

    public TtyPort withOpen(BaudRate aBaudRate, int aReadTimeout, int aWriteTimeout) throws IOException {
        this.open(aBaudRate, aReadTimeout, aWriteTimeout);
        return this;
    }

    public TtyPort withOpen(int aBaudRate, int aReadTimeout, int aWriteTimeout) throws IOException {
        this.open(aBaudRate, aReadTimeout, aWriteTimeout);
        return this;
    }

    public TtyPort withOpen(int aReadTimeout, int aWriteTimeout) throws IOException {
        this.open(aReadTimeout, aWriteTimeout);
        return this;
    }

    @Override
    public TtyPort withOpenUnchecked() {
        this.openUnchecked();
        return this;
    }

    @Override
    public TtyPort withOpenUnchecked(TtyPortMetrics aPortMetrics) {
        this.openUnchecked(aPortMetrics);
        return this;
    }

    @Override
    public TtyPortMetrics getPortMetrics() {
        return (TtyPortMetrics)this._portMetrics;
    }

    @Override
    public boolean isOpened() {
        if (!this._serialPort.isOpen() && super.isOpened()) {
            super.closeQuietly();
        }
        return super.isOpened();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        super.close();
        Object object = this;
        synchronized (object) {
            this.notifyAll();
        }
        object = this._serialPort;
        synchronized (object) {
            try {
                this._serialPort.flushIOBuffers();
            }
            finally {
                this._serialPort.removeDataListener();
                this._serialPort.notifyAll();
                this._serialPort.closePort();
            }
        }
    }

    @Override
    public InputStream getInputStream() {
        return this._serialPort.getInputStream();
    }

    @Override
    public TimeoutInputStream getInputStream(long aTimeoutMillis) {
        return SerialUtility.createTimeoutInputStream(this._serialPort.getInputStream(), aTimeoutMillis);
    }

    @Override
    public OutputStream getOutputStream() {
        return this._serialPort.getOutputStream();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this._alias + ", portMetrics=" + String.valueOf(this._portMetrics) + ", name=" + this._name + ", description=" + this._description + "]";
    }
}

