/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.mixin.EncodingAccessor;
import org.refcodes.mixin.ValueAccessor;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.EndianessAccessor;
import org.refcodes.schema.Schema;
import org.refcodes.serial.AllocSectionDecoratorSegment;
import org.refcodes.serial.LengthWidthAccessor;
import org.refcodes.serial.PayloadSegment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.StringSection;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.struct.SimpleTypeTable;
import org.refcodes.textual.CaseStyleBuilder;

public class StringSegment
implements PayloadSegment<String>,
EncodingAccessor<Charset> {
    private static final long serialVersionUID = 1L;
    private AllocSectionDecoratorSegment<StringSection> _allocSectionDecoratorSegment;

    private StringSegment(Builder aBuilder) {
        this(aBuilder.alias, aBuilder.value, aBuilder.encoding, aBuilder.lengthWidth, aBuilder.endianess);
    }

    public StringSegment() {
        this(CaseStyleBuilder.asCamelCase(StringSegment.class.getSimpleName()), null, TransmissionMetrics.DEFAULT_ENCODING, 4, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public StringSegment(TransmissionMetrics aTransmissionMetrics) {
        this(CaseStyleBuilder.asCamelCase(StringSegment.class.getSimpleName()), null, aTransmissionMetrics.getEncoding(), aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess());
    }

    public StringSegment(String aValue, TransmissionMetrics aTransmissionMetrics) {
        this(CaseStyleBuilder.asCamelCase(StringSegment.class.getSimpleName()), aValue, aTransmissionMetrics.getEncoding(), aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess());
    }

    public StringSegment(String aAlias, String aValue, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aValue, aTransmissionMetrics.getEncoding(), aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess());
    }

    public StringSegment(String aValue) {
        this(CaseStyleBuilder.asCamelCase(StringSegment.class.getSimpleName()), aValue, TransmissionMetrics.DEFAULT_ENCODING, 4, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public StringSegment(Charset aEncoding) {
        this(CaseStyleBuilder.asCamelCase(StringSegment.class.getSimpleName()), null, aEncoding, 4, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public StringSegment(String aValue, Charset aEncoding) {
        this(CaseStyleBuilder.asCamelCase(StringSegment.class.getSimpleName()), aValue, aEncoding, 4, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public StringSegment(String aAlias, String aValue) {
        this(aAlias, aValue, TransmissionMetrics.DEFAULT_ENCODING, 4, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public StringSegment(String aAlias, String aValue, Charset aEncoding) {
        this(aAlias, aValue, aEncoding, 4, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public StringSegment(Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase(StringSegment.class.getSimpleName()), null, TransmissionMetrics.DEFAULT_ENCODING, 4, aEndianess);
    }

    public StringSegment(int aLengthWidth) {
        this(CaseStyleBuilder.asCamelCase(StringSegment.class.getSimpleName()), null, TransmissionMetrics.DEFAULT_ENCODING, aLengthWidth, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public StringSegment(int aLengthWidth, Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase(StringSegment.class.getSimpleName()), null, TransmissionMetrics.DEFAULT_ENCODING, aLengthWidth, aEndianess);
    }

    public StringSegment(String aValue, Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase(StringSegment.class.getSimpleName()), aValue, TransmissionMetrics.DEFAULT_ENCODING, 4, aEndianess);
    }

    public StringSegment(Charset aEncoding, Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase(StringSegment.class.getSimpleName()), null, aEncoding, 4, aEndianess);
    }

    public StringSegment(String aValue, Charset aEncoding, Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase(StringSegment.class.getSimpleName()), aValue, aEncoding, 4, aEndianess);
    }

    public StringSegment(String aAlias, String aValue, Endianess aEndianess) {
        this(aAlias, aValue, TransmissionMetrics.DEFAULT_ENCODING, 4, aEndianess);
    }

    public StringSegment(String aAlias, String aValue, Charset aEncoding, Endianess aEndianess) {
        this(aAlias, aValue, aEncoding, 4, aEndianess);
    }

    public StringSegment(String aValue, int aLengthWidth) {
        this(CaseStyleBuilder.asCamelCase(StringSegment.class.getSimpleName()), aValue, TransmissionMetrics.DEFAULT_ENCODING, aLengthWidth, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public StringSegment(Charset aEncoding, int aLengthWidth) {
        this(CaseStyleBuilder.asCamelCase(StringSegment.class.getSimpleName()), null, aEncoding, aLengthWidth, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public StringSegment(String aValue, Charset aEncoding, int aLengthWidth) {
        this(CaseStyleBuilder.asCamelCase(StringSegment.class.getSimpleName()), aValue, aEncoding, aLengthWidth, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public StringSegment(String aAlias, String aValue, int aLengthWidth) {
        this(aAlias, aValue, TransmissionMetrics.DEFAULT_ENCODING, aLengthWidth, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public StringSegment(String aAlias, String aValue, Charset aEncoding, int aLengthWidth) {
        this(aAlias, aValue, aEncoding, aLengthWidth, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public StringSegment(String aValue, int aLengthWidth, Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase(StringSegment.class.getSimpleName()), aValue, TransmissionMetrics.DEFAULT_ENCODING, aLengthWidth, aEndianess);
    }

    public StringSegment(Charset aEncoding, int aLengthWidth, Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase(StringSegment.class.getSimpleName()), null, aEncoding, aLengthWidth, aEndianess);
    }

    public StringSegment(String aValue, Charset aEncoding, int aLengthWidth, Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase(StringSegment.class.getSimpleName()), aValue, aEncoding, aLengthWidth, aEndianess);
    }

    public StringSegment(String aAlias, String aValue, int aLengthWidth, Endianess aEndianess) {
        this(aAlias, aValue, TransmissionMetrics.DEFAULT_ENCODING, aLengthWidth, aEndianess);
    }

    public StringSegment(String aAlias, String aValue, Charset aEncoding, int aLengthWidth, Endianess aEndianess) {
        this._allocSectionDecoratorSegment = new AllocSectionDecoratorSegment<StringSection>(new StringSection(aAlias, aValue, aEncoding), aLengthWidth, aEndianess);
    }

    @Override
    public Sequence toSequence() {
        return this._allocSectionDecoratorSegment.toSequence();
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        return this._allocSectionDecoratorSegment.fromTransmission(aSequence, aOffset);
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException {
        this._allocSectionDecoratorSegment.receiveFrom(aInputStream, aReturnStream);
    }

    @Override
    public int getLength() {
        return this._allocSectionDecoratorSegment.getLength();
    }

    @Override
    public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
        this._allocSectionDecoratorSegment.transmitTo(aOutputStream, aReturnStream);
    }

    @Override
    public void reset() {
        this._allocSectionDecoratorSegment.reset();
    }

    @Override
    public SerialSchema toSchema() {
        return SerialSchema.builder().withAlias(this.getAlias()).withInstance(this).withValue(this.toSequence()).withLength(this.getLength()).withVerbose(this.getPayload()).withDescription("Wrapper segment for an allocation segment containing a string section payload.").withChildren(new Schema[]{this._allocSectionDecoratorSegment.toSchema()}).build();
    }

    @Override
    public StringSegment withPayload(String aValue) {
        this.setPayload(aValue);
        return this;
    }

    @Override
    public Charset getEncoding() {
        return ((StringSection)this._allocSectionDecoratorSegment.getDecoratee()).getEncoding();
    }

    @Override
    public SimpleTypeTable toSimpleTypeTable() {
        return this._allocSectionDecoratorSegment.toSimpleTypeTable();
    }

    @Override
    public String getAlias() {
        return ((StringSection)this._allocSectionDecoratorSegment.getDecoratee()).getAlias();
    }

    @Override
    public String getPayload() {
        return (String)((StringSection)this._allocSectionDecoratorSegment.getDecoratee()).getPayload();
    }

    @Override
    public void setPayload(String aPayload) {
        ((StringSection)this._allocSectionDecoratorSegment.getDecoratee()).setPayload(aPayload);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this.getAlias() + ", value=" + (this.getPayload() == null ? null : this.getPayload()) + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements AliasAccessor.AliasBuilder<Builder>,
    ValueAccessor.ValueBuilder<String, Builder>,
    EncodingAccessor.EncodingBuilder<Charset, Builder>,
    LengthWidthAccessor.LengthWidthBuilder<Builder>,
    EndianessAccessor.EndianessBuilder<Builder> {
        private String alias;
        private String value;
        private Charset encoding;
        private int lengthWidth;
        private Endianess endianess;

        private Builder() {
        }

        @Override
        public Builder withAlias(String aAlias) {
            this.alias = aAlias;
            return this;
        }

        @Override
        public Builder withValue(String aValue) {
            this.value = aValue;
            return this;
        }

        @Override
        public Builder withEncoding(Charset aEncoding) {
            this.encoding = aEncoding;
            return this;
        }

        @Override
        public Builder withLengthWidth(int aLengthWidth) {
            this.lengthWidth = aLengthWidth;
            return this;
        }

        @Override
        public Builder withEndianess(Endianess aEndianess) {
            this.endianess = aEndianess;
            return this;
        }

        public StringSegment build() {
            return new StringSegment(this);
        }
    }
}

