/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.controlflow.RetryCounter;
import org.refcodes.data.IoTimeout;
import org.refcodes.exception.UnhandledEnumBugException;
import org.refcodes.io.SkipAvailableInputStream;
import org.refcodes.mixin.ConcatenateMode;
import org.refcodes.mixin.ConcatenateModeAccessor;
import org.refcodes.mixin.DecorateeAccessor;
import org.refcodes.numerical.ChecksumValidationMode;
import org.refcodes.numerical.ChecksumValidationModeAccessor;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcAlgorithmAccessor;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.EndianessAccessor;
import org.refcodes.serial.AbstractStopAndWaitTransmissionDecorator;
import org.refcodes.serial.AcknowledgeMagicBytesAccessor;
import org.refcodes.serial.AcknowledgeRetryNumberAccessor;
import org.refcodes.serial.AcknowledgeSegmentPackagerAccessor;
import org.refcodes.serial.AcknowledgeTimeoutMillisAccessor;
import org.refcodes.serial.CrcSegmentPackager;
import org.refcodes.serial.DecoratorSegment;
import org.refcodes.serial.FlowControlRetryException;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentPackager;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SequenceNumberInitValueAccessor;
import org.refcodes.serial.SequenceNumberWidthAccessor;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;

public class StopAndWaitSegmentDecorator<DECORATEE extends Segment>
extends AbstractStopAndWaitTransmissionDecorator<DECORATEE>
implements Segment,
DecoratorSegment<DECORATEE> {
    private static final long serialVersionUID = 1L;

    private StopAndWaitSegmentDecorator(Builder<DECORATEE> aBuilder) {
        this(aBuilder.decoratee, aBuilder.sequenceNumberInitValue, aBuilder.sequenceNumberWidth, aBuilder.sequenceNumberConcatenateMode, aBuilder.acknowledgeMagicBytes, aBuilder.ackRetryNumber, aBuilder.ackTimeoutInMs, aBuilder.toAckSegmentPackager(), aBuilder.endianess);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, ConcatenateMode aCrcChecksumConcatenateMode, Endianess aEndianess) {
        super(aDecoratee, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aCrcChecksumConcatenateMode, aEndianess);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, ChecksumValidationMode aChecksumValidationMode, Endianess aEndianess) {
        super(aDecoratee, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aCrcAlgorithm, aCrcChecksumConcatenateMode, aChecksumValidationMode, aEndianess);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, Endianess aEndianess) {
        super(aDecoratee, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aCrcAlgorithm, aCrcChecksumConcatenateMode, aEndianess);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, CrcAlgorithm aCrcAlgorithm, Endianess aEndianess) {
        super(aDecoratee, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aCrcAlgorithm, aEndianess);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, Endianess aEndianess) {
        super(aDecoratee, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aEndianess);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, SegmentPackager aAckSegmentPackager, Endianess aEndianess) {
        super(aDecoratee, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aAckSegmentPackager, aEndianess);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, ConcatenateMode aCrcChecksumConcatenateMode, Endianess aEndianess) {
        super(aDecoratee, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aCrcChecksumConcatenateMode, aEndianess);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, ChecksumValidationMode aChecksumValidationMode, Endianess aEndianess) {
        super(aDecoratee, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aCrcAlgorithm, aCrcChecksumConcatenateMode, aChecksumValidationMode, aEndianess);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, Endianess aEndianess) {
        super(aDecoratee, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aCrcAlgorithm, aCrcChecksumConcatenateMode, aEndianess);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, CrcAlgorithm aCrcAlgorithm, Endianess aEndianess) {
        super(aDecoratee, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aCrcAlgorithm, aEndianess);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, Endianess aEndianess) {
        super(aDecoratee, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aEndianess);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, SegmentPackager aAckSegmentPackager, Endianess aEndianess) {
        super(aDecoratee, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aAckSegmentPackager, aEndianess);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, ConcatenateMode aCrcChecksumConcatenateMode) {
        super(aDecoratee, aCrcChecksumConcatenateMode);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, ChecksumValidationMode aChecksumValidationMode) {
        super(aDecoratee, aCrcAlgorithm, aCrcChecksumConcatenateMode, aChecksumValidationMode);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode) {
        super(aDecoratee, aCrcAlgorithm, aCrcChecksumConcatenateMode);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm) {
        super(aDecoratee, aCrcAlgorithm);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, int aSequenceNumberInitValue, int aSequenceNumberWidth, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, ConcatenateMode aCrcChecksumConcatenateMode, Endianess aEndianess) {
        super(aDecoratee, aSequenceNumberInitValue, aSequenceNumberWidth, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aCrcChecksumConcatenateMode, aEndianess);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, int aSequenceNumberInitValue, int aSequenceNumberWidth, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, ChecksumValidationMode aChecksumValidationMode, Endianess aEndianess) {
        super(aDecoratee, aSequenceNumberInitValue, aSequenceNumberWidth, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aCrcAlgorithm, aCrcChecksumConcatenateMode, aChecksumValidationMode, aEndianess);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, int aSequenceNumberInitValue, int aSequenceNumberWidth, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, Endianess aEndianess) {
        super(aDecoratee, aSequenceNumberInitValue, aSequenceNumberWidth, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aCrcAlgorithm, aCrcChecksumConcatenateMode, aEndianess);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, int aSequenceNumberInitValue, int aSequenceNumberWidth, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, CrcAlgorithm aCrcAlgorithm, Endianess aEndianess) {
        super(aDecoratee, aSequenceNumberInitValue, aSequenceNumberWidth, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aCrcAlgorithm, aEndianess);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, int aSequenceNumberInitValue, int aSequenceNumberWidth, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, Endianess aEndianess) {
        super(aDecoratee, aSequenceNumberInitValue, aSequenceNumberWidth, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aEndianess);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, int aSequenceNumberInitValue, int aSequenceNumberWidth, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, SegmentPackager aAckSegmentPackager, Endianess aEndianess) {
        super(aDecoratee, aSequenceNumberInitValue, aSequenceNumberWidth, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aAckSegmentPackager, aEndianess);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, SegmentPackager aAckSegmentPackager) {
        super(aDecoratee, aAckSegmentPackager);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee, TransmissionMetrics aTransmissionMetrics) {
        super(aDecoratee, aTransmissionMetrics);
    }

    public StopAndWaitSegmentDecorator(DECORATEE aDecoratee) {
        super(aDecoratee);
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        return ((Segment)this._decoratee).fromTransmission(aSequence, aOffset);
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException {
        if (aReturnStream == null) {
            ((Segment)this._decoratee).receiveFrom(aInputStream, aReturnStream);
            return;
        }
        RetryCounter theRetries = new RetryCounter(this._acknowledgeRetryNumber, this._acknowledgeTimeoutInMs);
        Exception eException = null;
        SkipAvailableInputStream theSkipInputStream = new SkipAvailableInputStream(aInputStream, this._acknowledgeTimeoutInMs);
        while (theRetries.nextRetry()) {
            eException = null;
            try {
                long eSequenceNumber;
                switch (this._sequenceNumberConcatenateMode) {
                    case APPEND: {
                        ((Segment)this._decoratee).receiveFrom(aInputStream, aReturnStream);
                        eSequenceNumber = this.readSequenceNumber(aInputStream);
                        break;
                    }
                    case PREPEND: {
                        eSequenceNumber = this.readSequenceNumber(aInputStream);
                        ((Segment)this._decoratee).receiveFrom(aInputStream, aReturnStream);
                        break;
                    }
                    default: {
                        throw new UnhandledEnumBugException(this._sequenceNumberConcatenateMode);
                    }
                }
                if (this._sequenceNumberInitValue == -1 && this._sequenceNumber == 0 || eSequenceNumber == (long)this._sequenceNumber) {
                    this._acknowledgeSequenceNumberSegment.setPayload(eSequenceNumber);
                    this._acknowledgeSegment.transmitTo(aReturnStream);
                    ++this._sequenceNumber;
                    return;
                }
            }
            catch (Exception e) {
                eException = e;
            }
            if (!theRetries.hasNextRetry()) continue;
            try {
                theSkipInputStream.skipAvailableTillSilenceFor(IoTimeout.toSenseTimeoutTimeframeInMs(this._acknowledgeTimeoutInMs));
            }
            catch (IOException iOException) {}
        }
        if (eException != null) {
            throw new FlowControlRetryException(this._acknowledgeRetryNumber, this._acknowledgeTimeoutInMs, "Aborting after <" + this.getAcknowledgeRetryNumber() + "> retries with a timeout for each retry of <" + this.getAcknowledgeTimeoutMillis() + "> milliseconds: " + eException.getMessage(), eException);
        }
        throw new FlowControlRetryException(this._acknowledgeRetryNumber, this._acknowledgeTimeoutInMs, "Aborting after <" + this.getAcknowledgeRetryNumber() + "> retries with a timeout for each retry of <" + this.getAcknowledgeTimeoutMillis() + "> milliseconds.");
    }

    public static <DECORATEE extends Segment> Builder<DECORATEE> builder() {
        return new Builder();
    }

    public static final class Builder<DECORATEE extends Segment>
    implements AcknowledgeRetryNumberAccessor.AcknowledgeRetryNumberBuilder<Builder<DECORATEE>>,
    AcknowledgeTimeoutMillisAccessor.AcknowledgeTimeoutMillisBuilder<Builder<DECORATEE>>,
    DecorateeAccessor.DecorateeBuilder<DECORATEE, Builder<DECORATEE>>,
    AcknowledgeMagicBytesAccessor.AcknowledgeMagicBytesBuilder<Builder<DECORATEE>>,
    SequenceNumberWidthAccessor.SequenceNumberWidthBuilder<Builder<DECORATEE>>,
    SequenceNumberInitValueAccessor.SequenceNumberInitValueBuilder<Builder<DECORATEE>>,
    ConcatenateModeAccessor.ConcatenateModeBuilder<Builder<DECORATEE>>,
    ChecksumValidationModeAccessor.ChecksumValidationModeBuilder<Builder<DECORATEE>>,
    CrcAlgorithmAccessor.CrcAlgorithmBuilder<Builder<DECORATEE>>,
    EndianessAccessor.EndianessBuilder<Builder<DECORATEE>>,
    AcknowledgeSegmentPackagerAccessor.AcknowledgeSegmentPackagerBuilder<Builder<DECORATEE>> {
        private DECORATEE decoratee = null;
        private int ackRetryNumber = TransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER;
        private long ackTimeoutInMs = TransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS;
        private byte[] acknowledgeMagicBytes = TransmissionMetrics.DEFAULT_ACKNOWLEDGE_MAGIC_BYTES;
        private int sequenceNumberWidth = 4;
        private int sequenceNumberInitValue = -1;
        private ConcatenateMode sequenceNumberConcatenateMode = TransmissionMetrics.DEFAULT_SEQUENCE_NUMBER_CONCATENATE_MODE;
        private Endianess endianess = TransmissionMetrics.DEFAULT_ENDIANESS;
        private CrcAlgorithm crcAlgorithm = null;
        private final ConcatenateMode crcChecksumConcatenateMode = null;
        private ChecksumValidationMode crcChecksumValidationMode = null;
        private SegmentPackager ackSegmentPackager = null;

        private Builder() {
        }

        @Override
        public Builder<DECORATEE> withAcknowledgeRetryNumber(int aAcknowledgeRetryNumber) {
            this.ackRetryNumber = aAcknowledgeRetryNumber;
            return this;
        }

        @Override
        public Builder<DECORATEE> withAcknowledgeTimeoutMillis(long aAckTimeoutInMs) {
            this.ackTimeoutInMs = aAckTimeoutInMs;
            return this;
        }

        @Override
        public Builder<DECORATEE> withDecoratee(DECORATEE aDecoratee) {
            this.decoratee = aDecoratee;
            return this;
        }

        @Override
        public Builder<DECORATEE> withAcknowledgeMagicBytes(byte[] aAcknowledgeMagicBytes) {
            this.acknowledgeMagicBytes = aAcknowledgeMagicBytes;
            return this;
        }

        @Override
        public Builder<DECORATEE> withSequenceNumberWidth(int aSequenceNumberWidth) {
            this.sequenceNumberWidth = aSequenceNumberWidth;
            return this;
        }

        @Override
        public Builder<DECORATEE> withSequenceNumberInitValue(int aSequenceNumberInitValue) {
            this.sequenceNumberInitValue = aSequenceNumberInitValue;
            return this;
        }

        @Override
        public Builder<DECORATEE> withConcatenateMode(ConcatenateMode aConcatenateMode) {
            this.sequenceNumberConcatenateMode = aConcatenateMode;
            return this;
        }

        @Override
        public Builder<DECORATEE> withCrcAlgorithm(CrcAlgorithm aCrcAlgorithm) {
            this.crcAlgorithm = aCrcAlgorithm;
            return this;
        }

        @Override
        public Builder<DECORATEE> withChecksumValidationMode(ChecksumValidationMode aChecksumValidationMode) {
            this.crcChecksumValidationMode = aChecksumValidationMode;
            return this;
        }

        @Override
        public Builder<DECORATEE> withEndianess(Endianess aEndianess) {
            this.endianess = aEndianess;
            return this;
        }

        @Override
        public Builder<DECORATEE> withAcknowledgeSegmentPackager(SegmentPackager aAcknowledgeSegmentPackager) {
            this.ackSegmentPackager = aAcknowledgeSegmentPackager;
            return this;
        }

        SegmentPackager toAckSegmentPackager() {
            if (this.ackSegmentPackager != null) {
                return this.ackSegmentPackager;
            }
            if (this.crcAlgorithm != null || this.crcChecksumValidationMode != null) {
                CrcAlgorithm theCrcAlgorithm = this.crcAlgorithm != null ? this.crcAlgorithm : TransmissionMetrics.DEFAULT_CRC_ALGORITHM;
                ChecksumValidationMode theCrcChecksumValidationMode = this.crcChecksumValidationMode != null ? this.crcChecksumValidationMode : TransmissionMetrics.DEFAULT_CHECKSUM_VALIDATION_MODE;
                ConcatenateMode theCrcChecksumConcatenateMode = this.crcChecksumConcatenateMode != null ? this.crcChecksumConcatenateMode : TransmissionMetrics.DEFAULT_CRC_CHECKSUM_CONCATENATE_MODE;
                Endianess theEndianess = this.endianess != null ? this.endianess : TransmissionMetrics.DEFAULT_ENDIANESS;
                return new CrcSegmentPackager(theCrcAlgorithm, theCrcChecksumConcatenateMode, theCrcChecksumValidationMode, theEndianess);
            }
            return new SegmentPackager.DummySegmentPackager();
        }

        public StopAndWaitSegmentDecorator<DECORATEE> build() {
            return new StopAndWaitSegmentDecorator<Builder>(this);
        }
    }
}

