/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.logging.Logger;
import org.refcodes.controlflow.RetryCounter;
import org.refcodes.data.IoTimeout;
import org.refcodes.io.SkipAvailableInputStream;
import org.refcodes.io.TimeoutInputStream;
import org.refcodes.mixin.ConcatenateMode;
import org.refcodes.numerical.ChecksumValidationMode;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.AcknowledgeMagicBytesAccessor;
import org.refcodes.serial.AcknowledgeRetryNumberAccessor;
import org.refcodes.serial.AcknowledgeSegmentPackagerAccessor;
import org.refcodes.serial.AcknowledgeTimeoutMillisAccessor;
import org.refcodes.serial.CrcSegmentPackager;
import org.refcodes.serial.FlowControlRetryException;
import org.refcodes.serial.InputReturnStreamAccessor;
import org.refcodes.serial.MagicBytesSegment;
import org.refcodes.serial.NumberSegment;
import org.refcodes.serial.PacketOutputStream;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentComposite;
import org.refcodes.serial.SegmentPackager;
import org.refcodes.serial.SerialUtility;
import org.refcodes.serial.StopAndWaitPacketInputStream;
import org.refcodes.serial.TransmissionMetrics;

public class StopAndWaitPacketOutputStream
extends PacketOutputStream
implements AcknowledgeRetryNumberAccessor,
AcknowledgeTimeoutMillisAccessor,
AcknowledgeMagicBytesAccessor,
AcknowledgeSegmentPackagerAccessor {
    private static final Logger LOGGER = Logger.getLogger(StopAndWaitPacketInputStream.class.getName());
    private static final boolean IS_DEBUG = false;
    private byte[] _acknowledgeMagicBytes;
    private MagicBytesSegment _acknowledgeMagicBytesSegment;
    private int _acknowledgeRetryNumber;
    private Segment _acknowledgeSegment;
    private SegmentPackager _acknowledgeSegmentPackager;
    private NumberSegment _acknowledgeSequenceNumberSegment;
    private long _acknowledgeTimeoutInMs;
    private InputStream _returnStream;

    public static Builder builder() {
        return new Builder();
    }

    private StopAndWaitPacketOutputStream(Builder aBuilder) {
        this(aBuilder.outputStream, aBuilder.blockSize, aBuilder.truncateLengthWidth, aBuilder.packetMagicBytes, aBuilder.sequenceNumberInitValue, aBuilder.sequenceNumberWidth, aBuilder.sequenceNumberConcatenateMode, aBuilder.toPacketSegmentPackager(), aBuilder.returnStream, aBuilder.acknowledgeMagicBytes, aBuilder.acknowledgeRetryNumber, aBuilder.acknowledgeTimeoutInMs, aBuilder.toAckSegmentPackager(), aBuilder.endianess);
    }

    public StopAndWaitPacketOutputStream(OutputStream aOutputStream, InputStream aReturnStream, TransmissionMetrics aTransmissionMetrics) {
        this(aOutputStream, aTransmissionMetrics.getBlockSize(), aTransmissionMetrics.getPacketLengthWidth(), aTransmissionMetrics.getPacketMagicBytes(), aTransmissionMetrics.getSequenceNumberInitValue(), aTransmissionMetrics.getSequenceNumberWidth(), aTransmissionMetrics.getSequenceNumberConcatenateMode(), aTransmissionMetrics.toPacketSegmentPackager(), aReturnStream, aTransmissionMetrics.getAcknowledgeMagicBytes(), aTransmissionMetrics.getAcknowledgeRetryNumber(), aTransmissionMetrics.getAcknowledgeTimeoutMillis(), aTransmissionMetrics.toAckSegmentPackager(), aTransmissionMetrics.getEndianess());
    }

    public StopAndWaitPacketOutputStream(OutputStream aOutputStream, int aBlockSize, int aPacketLengthWidth, byte[] aPacketMagicBytes, int aSequenceNumberInitValue, int aSequenceNumberWidth, ConcatenateMode aSequenceNumberConcatenateMode, SegmentPackager aPacketSegmentPackager, InputStream aReturnStream, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, SegmentPackager aAckSegmentPackager, Endianess aEndianess) {
        super(aOutputStream, aBlockSize, aPacketLengthWidth, aPacketMagicBytes, aSequenceNumberInitValue, aSequenceNumberWidth, aSequenceNumberConcatenateMode, aPacketSegmentPackager, aEndianess);
        this._returnStream = aReturnStream;
        this._acknowledgeMagicBytes = aAcknowledgeMagicBytes;
        this._acknowledgeRetryNumber = aAckRetryNumber;
        this._acknowledgeTimeoutInMs = aAckTimeoutInMs;
        this._acknowledgeSegmentPackager = aAckSegmentPackager != null ? aAckSegmentPackager : new SegmentPackager.DummySegmentPackager();
        Segment[] segmentArray = new Segment.SegmentMixin[2];
        this._acknowledgeMagicBytesSegment = new MagicBytesSegment(this._acknowledgeMagicBytes.length);
        segmentArray[0] = this._acknowledgeMagicBytesSegment;
        this._acknowledgeSequenceNumberSegment = new NumberSegment(this._sequenceNumberWidth, this._endianess);
        segmentArray[1] = this._acknowledgeSequenceNumberSegment;
        this._acknowledgeSegment = this._acknowledgeSegmentPackager.toPackaged(new SegmentComposite(segmentArray));
    }

    @Override
    public byte[] getAcknowledgeMagicBytes() {
        return this._acknowledgeMagicBytes;
    }

    @Override
    public int getAcknowledgeRetryNumber() {
        return this._acknowledgeRetryNumber;
    }

    @Override
    public SegmentPackager getAcknowledgeSegmentPackager() {
        return this._acknowledgeSegmentPackager;
    }

    @Override
    public long getAcknowledgeTimeoutMillis() {
        return this._acknowledgeTimeoutInMs;
    }

    @Override
    protected void doTransmitPacket() throws IOException {
        if (this._returnStream == null) {
            super.doTransmitPacket();
        } else if (this._blockOffset != 0) {
            this._sequenceNumberSegment.setPayload(Long.valueOf(this._sequenceNumber));
            SkipAvailableInputStream theSkipReturnStream = new SkipAvailableInputStream(this._returnStream, this._acknowledgeTimeoutInMs);
            Exception eException = null;
            RetryCounter theRetries = new RetryCounter(this._acknowledgeRetryNumber, this._acknowledgeTimeoutInMs);
            TimeoutInputStream theTimeoutReturnStream = SerialUtility.createTimeoutInputStream(this._returnStream, this._acknowledgeTimeoutInMs);
            while (theRetries.nextRetry()) {
                eException = null;
                try {
                    this._packetSegment.transmitTo(this._outputStream);
                    this._acknowledgeSegment.receiveFrom(theTimeoutReturnStream);
                    byte[] eAck = this._acknowledgeMagicBytesSegment.getPayload();
                    int eSequenceNumber = ((Long)this._acknowledgeSequenceNumberSegment.getPayload()).intValue();
                    if (Arrays.equals(eAck, this._acknowledgeMagicBytes) && eSequenceNumber == this._sequenceNumber) {
                        ++this._sequenceNumber;
                        this._blockSequence.clear();
                        this._blockOffset = 0;
                        return;
                    }
                }
                catch (Exception e) {
                    eException = e;
                }
                if (!theRetries.hasNextRetry()) continue;
                try {
                    theSkipReturnStream.skipAvailableWithin(IoTimeout.toTimeoutSleepLoopTimeInMs(this._acknowledgeTimeoutInMs));
                }
                catch (IOException iOException) {}
            }
            if (eException != null) {
                throw new FlowControlRetryException(this._acknowledgeRetryNumber, this._acknowledgeTimeoutInMs, "Aborting after <" + this._acknowledgeRetryNumber + "> retries with a timeout for each retry of <" + this._acknowledgeTimeoutInMs + "> milliseconds: " + eException.getMessage(), eException);
            }
            throw new FlowControlRetryException(this._acknowledgeRetryNumber, this._acknowledgeTimeoutInMs, "Aborting after <" + this._acknowledgeRetryNumber + "> retries with a timeout for each retry of <" + this._acknowledgeTimeoutInMs + "> milliseconds.");
        }
    }

    public static final class Builder
    extends PacketOutputStream.Builder
    implements AcknowledgeMagicBytesAccessor.AcknowledgeMagicBytesBuilder<Builder>,
    AcknowledgeTimeoutMillisAccessor.AcknowledgeTimeoutMillisBuilder<Builder>,
    AcknowledgeRetryNumberAccessor.AcknowledgeRetryNumberBuilder<Builder>,
    InputReturnStreamAccessor.InputReturnStreamBuilder<Builder>,
    AcknowledgeSegmentPackagerAccessor.AcknowledgeSegmentPackagerBuilder<Builder> {
        byte[] acknowledgeMagicBytes = TransmissionMetrics.DEFAULT_ACKNOWLEDGE_MAGIC_BYTES;
        int acknowledgeRetryNumber = TransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER;
        SegmentPackager acknowledgeSegmentPackager = null;
        long acknowledgeTimeoutInMs = TransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS;
        InputStream returnStream = null;

        private Builder() {
        }

        @Override
        public StopAndWaitPacketOutputStream build() {
            return new StopAndWaitPacketOutputStream(this);
        }

        @Override
        public Builder withAcknowledgeMagicBytes(byte[] aAcknowledgeMagicBytes) {
            this.acknowledgeMagicBytes = aAcknowledgeMagicBytes;
            return this;
        }

        @Override
        public Builder withAcknowledgeRetryNumber(int aAcknowledgeRetryNumber) {
            this.acknowledgeRetryNumber = aAcknowledgeRetryNumber;
            return this;
        }

        @Override
        public Builder withAcknowledgeSegmentPackager(SegmentPackager aAcknowledgeSegmentPackager) {
            this.acknowledgeSegmentPackager = aAcknowledgeSegmentPackager;
            return this;
        }

        @Override
        public Builder withAcknowledgeTimeoutMillis(long aAckTimeoutInMs) {
            this.acknowledgeTimeoutInMs = aAckTimeoutInMs;
            return this;
        }

        @Override
        public Builder withReturnStream(InputStream aReturnStream) {
            this.returnStream = aReturnStream;
            return this;
        }

        SegmentPackager toAckSegmentPackager() {
            if (this.acknowledgeSegmentPackager != null) {
                return this.acknowledgeSegmentPackager;
            }
            if (this.crcAlgorithm != null || this.crcChecksumValidationMode != null) {
                CrcAlgorithm theCrcAlgorithm = this.crcAlgorithm != null ? this.crcAlgorithm : TransmissionMetrics.DEFAULT_CRC_ALGORITHM;
                ChecksumValidationMode theCrcChecksumValidationMode = this.crcChecksumValidationMode != null ? this.crcChecksumValidationMode : TransmissionMetrics.DEFAULT_CHECKSUM_VALIDATION_MODE;
                ConcatenateMode theCrcChecksumConcatenateMode = this.crcChecksumConcatenateMode != null ? this.crcChecksumConcatenateMode : TransmissionMetrics.DEFAULT_CRC_CHECKSUM_CONCATENATE_MODE;
                Endianess theEndianess = this.endianess != null ? this.endianess : TransmissionMetrics.DEFAULT_ENDIANESS;
                return new CrcSegmentPackager(theCrcAlgorithm, theCrcChecksumConcatenateMode, theCrcChecksumValidationMode, theEndianess);
            }
            return new SegmentPackager.DummySegmentPackager();
        }
    }
}

