/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import org.refcodes.component.LinkComponent;
import org.refcodes.io.BytesReceiver;
import org.refcodes.io.Skippable;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentReceiver;
import org.refcodes.serial.Sequence;

public interface SerialReceiver
extends BytesReceiver,
SegmentReceiver,
LinkComponent.LinkAutomaton,
Skippable {
    @Override
    public int available() throws IOException;

    @Override
    default public byte receiveByte() throws IOException {
        return this.receiveBytes(1)[0];
    }

    @Override
    default public byte[] receiveBytes(int aLength) throws IOException {
        byte[] theChunk = new byte[aLength];
        this.receiveBytes(theChunk, 0, aLength);
        return theChunk;
    }

    default public Sequence receiveSequenceWithin(long aTimeoutMillis, int aLength) throws IOException {
        return new ByteArraySequence(this.receiveBytesWithin(aTimeoutMillis, aLength));
    }

    default public Sequence receiveSequence(int aLength) throws IOException {
        return new ByteArraySequence(this.receiveBytes(aLength));
    }

    @Override
    default public <SEGMENT extends Segment> void receiveSegmentWithin(long aTimeoutMillis, SEGMENT aSegment) throws IOException {
        aSegment.receiveFrom(this.getInputStream(aTimeoutMillis), null);
    }

    @Override
    default public <SEGMENT extends Segment> void receiveSegment(SEGMENT aSegment) throws IOException {
        aSegment.receiveFrom(this.getInputStream(), null);
    }

    @Override
    public void open() throws IOException;

    @Override
    public void close() throws IOException;
}

