/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.PayloadSection;
import org.refcodes.serial.PayloadTransmission;
import org.refcodes.serial.Section;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.struct.MapSimpleTypeTable;
import org.refcodes.struct.SimpleTypeTable;
import org.refcodes.textual.CaseStyleBuilder;

public class SequenceSection
implements PayloadSection<Sequence>,
Section.SectionMixin {
    private static final long serialVersionUID = 1L;
    protected Sequence _sequence;
    protected String _alias;

    public SequenceSection() {
        this(CaseStyleBuilder.asCamelCase(SequenceSection.class.getSimpleName()), new ByteArraySequence());
    }

    public SequenceSection(String aAlias) {
        this(aAlias, new ByteArraySequence());
    }

    public SequenceSection(int aSequenceSize) {
        this(CaseStyleBuilder.asCamelCase(SequenceSection.class.getSimpleName()), aSequenceSize);
    }

    public SequenceSection(String aAlias, int aSequenceSize) {
        this(aAlias, new ByteArraySequence(aSequenceSize));
    }

    public SequenceSection(Sequence aSequence) {
        this(CaseStyleBuilder.asCamelCase(SequenceSection.class.getSimpleName()), aSequence);
    }

    public SequenceSection(String aAlias, Sequence aSequence) {
        this._alias = aAlias;
        this._sequence = aSequence;
    }

    @Override
    public int getLength() {
        return this._sequence.getLength();
    }

    @Override
    public Sequence toSequence() {
        return this._sequence;
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        this._sequence.replace(aSequence.toSequence(aOffset, aLength));
    }

    @Override
    public void reset() {
        this._sequence.clear();
    }

    @Override
    public SerialSchema toSchema() {
        return SerialSchema.builder().withAlias(this.getAlias()).withInstance(this).withValue(this.toSequence()).withLength(this.getLength()).withDescription("A section consisting of a sequence.").build();
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    @Override
    public PayloadTransmission<Sequence> withPayload(Sequence aValue) {
        this.setPayload(aValue);
        return this;
    }

    @Override
    public Sequence getPayload() {
        return this._sequence;
    }

    @Override
    public void setPayload(Sequence aValue) {
        this._sequence = aValue;
    }

    @Override
    public SimpleTypeTable toSimpleTypeTable() {
        return new MapSimpleTypeTable().withPut(this._alias, (Object)(this._sequence != null ? this._sequence.toBytes() : null));
    }
}

