/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import org.refcodes.mixin.OffsetAccessor;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SequenceAccessor;

public class SequenceInputStream
extends InputStream
implements OffsetAccessor,
SequenceAccessor {
    private final Sequence _sequence;
    boolean _isClosed = false;
    private int _offset = 0;

    public SequenceInputStream(Sequence aSequence) {
        this._sequence = aSequence;
    }

    public SequenceInputStream(Sequence aSequence, int aOffset) {
        this._sequence = aSequence;
        this._offset = aOffset;
    }

    @Override
    public int available() throws IOException {
        if (this._isClosed) {
            throw new IOException("The stream has already been closed!");
        }
        return this._sequence.getLength();
    }

    @Override
    public void close() throws IOException {
        this._isClosed = true;
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        if (this._isClosed) {
            throw new IOException("The stream has already been closed!");
        }
        if (this._sequence.getLength() == this._offset && !this._isClosed) {
            return -1;
        }
        Sequence sequence = this._sequence;
        synchronized (sequence) {
            if (this._sequence.getLength() == this._offset) {
                if (this._isClosed) {
                    throw new IOException("Connection is closed and only <" + this._sequence.getLength() + "> bytes out of requested <1> bytes are available!");
                }
                throw new IndexOutOfBoundsException("Only <" + this._sequence.getLength() + "> bytes out of requested <1> bytes are available!");
            }
            byte theValue = this._sequence.getByteAt(this._offset);
            ++this._offset;
            return theValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] aChunk, int aOffset, int aLength) throws IOException {
        if (this._isClosed) {
            throw new IOException("The stream has already been closed!");
        }
        Sequence sequence = this._sequence;
        synchronized (sequence) {
            if (this._sequence.getLength() < this._offset + aLength) {
                aLength = this._sequence.getLength();
            }
            this._sequence.toBytes(this._offset, aLength, aChunk, aOffset);
            this._offset += aLength;
            return aLength;
        }
    }

    @Override
    public int getOffset() {
        return this._offset;
    }

    @Override
    public Sequence getSequence() {
        return this._sequence;
    }
}

