/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.nio.charset.Charset;
import java.text.ParseException;
import org.refcodes.data.Literal;
import org.refcodes.mixin.EncodingAccessor;
import org.refcodes.properties.ImmutableProperties;
import org.refcodes.properties.MapImmutableProperties;
import org.refcodes.properties.MapProperties;
import org.refcodes.serial.AbstractPayloadSection;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Section;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.serial.TransmissionSequenceException;
import org.refcodes.struct.MapSimpleTypeTable;
import org.refcodes.struct.SimpleTypeTable;
import org.refcodes.textual.CaseStyleBuilder;
import org.refcodes.textual.EscapeTextBuilder;

public class PropertiesSection
extends AbstractPayloadSection<ImmutableProperties>
implements Section,
EncodingAccessor<Charset> {
    private static final long serialVersionUID = 1L;
    private String _charset;

    public PropertiesSection(ImmutableProperties aPayload, TransmissionMetrics aTransmissionMetrics) {
        this(CaseStyleBuilder.asCamelCase(PropertiesSection.class.getSimpleName()), (ImmutableProperties)new MapImmutableProperties(aPayload), aTransmissionMetrics.getEncoding());
    }

    public PropertiesSection(String aAlias, ImmutableProperties aPayload, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, (ImmutableProperties)new MapImmutableProperties(aPayload), aTransmissionMetrics.getEncoding());
    }

    public PropertiesSection() {
        this(CaseStyleBuilder.asCamelCase(PropertiesSection.class.getSimpleName()), new MapImmutableProperties());
    }

    public PropertiesSection(ImmutableProperties aPayload) {
        this(CaseStyleBuilder.asCamelCase(PropertiesSection.class.getSimpleName()), aPayload);
    }

    public PropertiesSection(Charset aCharset) {
        this(CaseStyleBuilder.asCamelCase(PropertiesSection.class.getSimpleName()), (ImmutableProperties)new MapImmutableProperties(), aCharset);
    }

    public PropertiesSection(ImmutableProperties aPayload, Charset aCharset) {
        this(CaseStyleBuilder.asCamelCase(PropertiesSection.class.getSimpleName()), (ImmutableProperties)new MapImmutableProperties(aPayload), aCharset);
    }

    public PropertiesSection(String aAlias) {
        this(aAlias, (ImmutableProperties)new MapImmutableProperties(), TransmissionMetrics.DEFAULT_ENCODING);
    }

    public PropertiesSection(String aAlias, ImmutableProperties aPayload) {
        this(aAlias, aPayload, TransmissionMetrics.DEFAULT_ENCODING);
    }

    public PropertiesSection(String aAlias, Charset aCharset) {
        this(aAlias, (ImmutableProperties)new MapImmutableProperties(), aCharset);
    }

    public PropertiesSection(String aAlias, ImmutableProperties aPayload, Charset aCharset) {
        super(aAlias, new MapImmutableProperties(aPayload));
        this._charset = aCharset != null ? aCharset.name() : TransmissionMetrics.DEFAULT_ENCODING.name();
    }

    @Override
    public Sequence toSequence() {
        String serialized = this.toSerialized();
        return new ByteArraySequence(serialized.getBytes(this.getEncoding()));
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        byte[] theRecord = aSequence.toBytes(aOffset, aLength);
        try {
            this.parseFrom(new String(theRecord, this.getEncoding()));
        }
        catch (ParseException e) {
            throw new TransmissionSequenceException(aSequence, "Cannot parse the sequence <" + aSequence.toHexString() + "> at offset <" + aOffset + ">!", (Throwable)e);
        }
    }

    @Override
    public int getLength() {
        return this.getPayload() != null ? this.toSerialized().length() : 0;
    }

    @Override
    public SerialSchema toSchema() {
        String theSerialized = this.toSerialized();
        return SerialSchema.builder().withAlias(this.getAlias()).withInstance(this).withValue(this.toSequence()).withLength(theSerialized.length()).withVerbose(theSerialized.replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r")).withDescription("A body containing a string payload.").build();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this._charset == null ? 0 : this._charset.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertiesSection other = (PropertiesSection)obj;
        return !(this._charset == null ? other._charset != null : !this._charset.equals(other._charset));
    }

    @Override
    public PropertiesSection withPayload(ImmutableProperties aValue) {
        this.setPayload(aValue);
        return this;
    }

    @Override
    public SimpleTypeTable toSimpleTypeTable() {
        return new MapSimpleTypeTable(this._payload);
    }

    private String toSerialized() {
        StringBuilder theBuilder = new StringBuilder();
        for (String eKey : ((ImmutableProperties)this.getPayload()).sortedKeys()) {
            String eValue = (String)((ImmutableProperties)this.getPayload()).get((Object)eKey);
            eValue = EscapeTextBuilder.asEscaped(eValue);
            theBuilder.append(eKey);
            theBuilder.append(Literal.EQUALS.getValue());
            theBuilder.append(eValue);
            theBuilder.append('\n');
        }
        return theBuilder.toString();
    }

    private void parseFrom(String aString) throws ParseException {
        if (aString != null && aString.length() != 0) {
            String[] thePairs;
            MapProperties theProperties = new MapProperties();
            for (String eValue : thePairs = aString.split("\n")) {
                String[] eTupel = eValue.split("=", 2);
                theProperties.put(eTupel[0], EscapeTextBuilder.asUnEscaped(eTupel[1]));
            }
            this.setPayload(new MapImmutableProperties((Object)theProperties));
        } else {
            this.setPayload(new MapImmutableProperties());
        }
    }

    @Override
    public Charset getEncoding() {
        return this._charset != null ? Charset.forName(this._charset) : TransmissionMetrics.DEFAULT_ENCODING;
    }
}

