/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.OutputStream;
import org.refcodes.exception.UnhandledEnumBugException;
import org.refcodes.mixin.BlockSizeAccessor;
import org.refcodes.mixin.ConcatenateMode;
import org.refcodes.mixin.OutputStreamAccessor;
import org.refcodes.mixin.PacketSizeAccessor;
import org.refcodes.numerical.ChecksumValidationMode;
import org.refcodes.numerical.ChecksumValidationModeAccessor;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcAlgorithmAccessor;
import org.refcodes.numerical.CrcChecksumConcatenateModeAccessor;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.EndianessAccessor;
import org.refcodes.serial.AllocSectionDecoratorSegment;
import org.refcodes.serial.BoundedSequenceDecorator;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.CrcSegmentPackager;
import org.refcodes.serial.MagicBytesSegment;
import org.refcodes.serial.NumberSegment;
import org.refcodes.serial.PacketLengthWidthAccessor;
import org.refcodes.serial.PacketMagicBytesAccessor;
import org.refcodes.serial.PacketSegmentPackagerAccessor;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentComposite;
import org.refcodes.serial.SegmentPackager;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SequenceNumberAccessor;
import org.refcodes.serial.SequenceNumberConcatenateModeAccessor;
import org.refcodes.serial.SequenceNumberInitValueAccessor;
import org.refcodes.serial.SequenceNumberWidthAccessor;
import org.refcodes.serial.SequenceSection;
import org.refcodes.serial.TransmissionMetrics;

public class PacketOutputStream
extends OutputStream
implements PacketLengthWidthAccessor,
PacketSizeAccessor,
EndianessAccessor,
BlockSizeAccessor,
SequenceNumberInitValueAccessor,
SequenceNumberConcatenateModeAccessor,
SequenceNumberAccessor,
SequenceNumberWidthAccessor,
PacketSegmentPackagerAccessor,
PacketMagicBytesAccessor {
    private int _blockSize;
    private boolean _isClosed;
    private int _packetLength;
    private byte[] _packetMagicBytes;
    private SegmentPackager _packetSegmentPackager;
    private ConcatenateMode _sequenceNumberConcatenateMode;
    private int _sequenceNumberInitValue;
    private int _packetLengthWidth;
    protected int _blockOffset = 0;
    protected Sequence _blockSequence;
    protected Endianess _endianess;
    protected OutputStream _outputStream;
    protected Segment _packetSegment;
    protected int _sequenceNumber;
    protected NumberSegment _sequenceNumberSegment;
    protected int _sequenceNumberWidth;
    protected AllocSectionDecoratorSegment<SequenceSection> _allocSegment;
    protected BoundedSequenceDecorator _boundedSequence;

    public static Builder builder() {
        return new Builder();
    }

    private PacketOutputStream(Builder aBuilder) {
        this(aBuilder.outputStream, aBuilder.blockSize, aBuilder.truncateLengthWidth, aBuilder.packetMagicBytes, aBuilder.sequenceNumberInitValue, aBuilder.sequenceNumberWidth, aBuilder.sequenceNumberConcatenateMode, aBuilder.toPacketSegmentPackager(), aBuilder.endianess);
    }

    public PacketOutputStream(OutputStream aOutputStream, TransmissionMetrics aTransmissionMetrics) {
        this(aOutputStream, aTransmissionMetrics.getBlockSize(), aTransmissionMetrics.getPacketLengthWidth(), aTransmissionMetrics.getPacketMagicBytes(), aTransmissionMetrics.getSequenceNumberInitValue(), aTransmissionMetrics.getSequenceNumberWidth(), aTransmissionMetrics.getSequenceNumberConcatenateMode(), aTransmissionMetrics.toPacketSegmentPackager(), aTransmissionMetrics.getEndianess());
    }

    public PacketOutputStream(OutputStream aOutputStream, int aBlockSize, int aPacketLengthWidth, byte[] aPacketMagicBytes, int aSequenceNumberInitValue, int aSequenceNumberWidth, ConcatenateMode aSequenceNumberConcatenateMode, SegmentPackager aPacketSegmentPackager, Endianess aEndianess) {
        this._outputStream = aOutputStream;
        this._sequenceNumberConcatenateMode = aSequenceNumberConcatenateMode;
        this._sequenceNumberInitValue = aSequenceNumberInitValue;
        this._sequenceNumberWidth = aSequenceNumberWidth;
        this._sequenceNumber = aSequenceNumberInitValue != -1 ? aSequenceNumberInitValue : 0;
        this._blockSize = aBlockSize;
        this._packetLengthWidth = aPacketLengthWidth;
        this._endianess = aEndianess;
        this._packetSegmentPackager = aPacketSegmentPackager != null ? aPacketSegmentPackager : new SegmentPackager.DummySegmentPackager();
        this._blockSequence = new ByteArraySequence(aBlockSize);
        this._boundedSequence = new BoundedSequenceDecorator(this._blockSequence, aBlockSize);
        this._sequenceNumberSegment = new NumberSegment(aSequenceNumberWidth, Long.valueOf(aSequenceNumberInitValue), aEndianess);
        MagicBytesSegment theMagicBytes = new MagicBytesSegment(aPacketMagicBytes);
        this._allocSegment = new AllocSectionDecoratorSegment<SequenceSection>(new SequenceSection(this._boundedSequence), aPacketLengthWidth, aEndianess);
        this._packetSegment = this._packetSegmentPackager.toPackaged(switch (this._sequenceNumberConcatenateMode) {
            case ConcatenateMode.APPEND -> new SegmentComposite(new Segment[]{theMagicBytes, this._allocSegment, this._sequenceNumberSegment});
            case ConcatenateMode.PREPEND -> new SegmentComposite(new Segment[]{theMagicBytes, this._sequenceNumberSegment, this._allocSegment});
            default -> throw new UnhandledEnumBugException(this._sequenceNumberConcatenateMode);
        });
        this._packetLength = this._packetSegment.getLength();
    }

    @Override
    public void close() throws IOException {
        this._isClosed = true;
        this._outputStream.close();
        super.close();
    }

    @Override
    public void flush() throws IOException {
        this.doTransmitPacket();
        super.flush();
    }

    @Override
    public int getBlockSize() {
        return this._blockSize;
    }

    @Override
    public Endianess getEndianess() {
        return this._endianess;
    }

    @Override
    public byte[] getPacketMagicBytes() {
        return this._packetMagicBytes;
    }

    @Override
    public SegmentPackager getPacketSegmentPackager() {
        return this._packetSegmentPackager;
    }

    @Override
    public int getPacketSize() {
        return this._packetLength;
    }

    @Override
    public int getSequenceNumber() {
        return this._sequenceNumber;
    }

    @Override
    public ConcatenateMode getSequenceNumberConcatenateMode() {
        return this._sequenceNumberConcatenateMode;
    }

    @Override
    public int getSequenceNumberInitValue() {
        return this._sequenceNumberInitValue;
    }

    @Override
    public int getSequenceNumberWidth() {
        return this._sequenceNumberWidth;
    }

    @Override
    public int getPacketLengthWidth() {
        return this._packetLengthWidth;
    }

    @Override
    public void write(int b) throws IOException {
        if (this._isClosed) {
            throw new IOException("The stream has already been closed!");
        }
        if (this._blockOffset < this._blockSize) {
            this._blockSequence.setByteAt(this._blockOffset, (byte)b);
            ++this._blockOffset;
        }
        if (this._blockOffset == this._blockSize) {
            this.doTransmitPacket();
        }
    }

    protected void doTransmitPacket() throws IOException {
        if (this._blockOffset != 0) {
            this._sequenceNumberSegment.setPayload(Long.valueOf(this._sequenceNumber));
            this._boundedSequence.setLength(this._blockOffset);
            this._packetSegment.transmitTo(this._outputStream);
            ++this._sequenceNumber;
            this._blockSequence.clear();
            this._blockOffset = 0;
        }
    }

    static SegmentPackager toPacketSegmentPackager(CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, ChecksumValidationMode aChecksumValidationMode, Endianess aEndianess) {
        if (aCrcAlgorithm != null || aChecksumValidationMode != null || aCrcChecksumConcatenateMode != null) {
            CrcAlgorithm theCrcAlgorithm = aCrcAlgorithm != null ? aCrcAlgorithm : TransmissionMetrics.DEFAULT_CRC_ALGORITHM;
            ChecksumValidationMode theCrcChecksumValidationMode = aChecksumValidationMode != null ? aChecksumValidationMode : TransmissionMetrics.DEFAULT_CHECKSUM_VALIDATION_MODE;
            ConcatenateMode theCrcChecksumConcatenateMode = aCrcChecksumConcatenateMode != null ? aCrcChecksumConcatenateMode : TransmissionMetrics.DEFAULT_CRC_CHECKSUM_CONCATENATE_MODE;
            Endianess theEndianess = aEndianess != null ? aEndianess : TransmissionMetrics.DEFAULT_ENDIANESS;
            return new CrcSegmentPackager(theCrcAlgorithm, theCrcChecksumConcatenateMode, theCrcChecksumValidationMode, theEndianess);
        }
        return new SegmentPackager.DummySegmentPackager();
    }

    public static class Builder
    implements PacketLengthWidthAccessor.PacketLengthWidthBuilder<Builder>,
    SequenceNumberInitValueAccessor.SequenceNumberInitValueBuilder<Builder>,
    SequenceNumberWidthAccessor.SequenceNumberWidthBuilder<Builder>,
    BlockSizeAccessor.BlockSizeBuilder<Builder>,
    OutputStreamAccessor.OutputStreamBuilder<Builder>,
    EndianessAccessor.EndianessBuilder<Builder>,
    SequenceNumberConcatenateModeAccessor.SequenceNumberConcatenateModeBuilder<Builder>,
    PacketSegmentPackagerAccessor.PacketSegmentPackagerBuilder<Builder>,
    CrcAlgorithmAccessor.CrcAlgorithmBuilder<Builder>,
    ChecksumValidationModeAccessor.ChecksumValidationModeBuilder<Builder>,
    CrcChecksumConcatenateModeAccessor.CrcChecksumConcatenateModeBuilder<Builder>,
    PacketMagicBytesAccessor.PacketMagicBytesBuilder<Builder> {
        int blockSize = 1024;
        CrcAlgorithm crcAlgorithm = null;
        ConcatenateMode crcChecksumConcatenateMode = null;
        ChecksumValidationMode crcChecksumValidationMode = null;
        Endianess endianess = TransmissionMetrics.DEFAULT_ENDIANESS;
        byte[] lastPacketMagicBytes = TransmissionMetrics.DEFAULT_LAST_PACKET_MAGIC_BYTES;
        OutputStream outputStream = null;
        byte[] packetMagicBytes = TransmissionMetrics.DEFAULT_PACKET_MAGIC_BYTES;
        SegmentPackager packetSegmentPackager = null;
        ConcatenateMode sequenceNumberConcatenateMode = TransmissionMetrics.DEFAULT_SEQUENCE_NUMBER_CONCATENATE_MODE;
        int sequenceNumberInitValue = -1;
        int sequenceNumberWidth = 4;
        int truncateLengthWidth = 4;

        Builder() {
        }

        public PacketOutputStream build() {
            return new PacketOutputStream(this);
        }

        @Override
        public Builder withBlockSize(int aBlockSize) {
            this.blockSize = aBlockSize;
            return this;
        }

        @Override
        public Builder withCrcAlgorithm(CrcAlgorithm aCrcAlgorithm) {
            this.crcAlgorithm = aCrcAlgorithm;
            return this;
        }

        @Override
        public Builder withCrcChecksumConcatenateMode(ConcatenateMode aCrcChecksumConcatenateMode) {
            this.crcChecksumConcatenateMode = aCrcChecksumConcatenateMode;
            return this;
        }

        @Override
        public Builder withChecksumValidationMode(ChecksumValidationMode aChecksumValidationMode) {
            this.crcChecksumValidationMode = aChecksumValidationMode;
            return this;
        }

        @Override
        public Builder withEndianess(Endianess aEndianess) {
            this.endianess = aEndianess;
            return this;
        }

        @Override
        public Builder withOutputStream(OutputStream aOutputStream) {
            this.outputStream = aOutputStream;
            return this;
        }

        @Override
        public Builder withPacketMagicBytes(byte[] aPacketMagicBytes) {
            this.packetMagicBytes = aPacketMagicBytes;
            return this;
        }

        @Override
        public Builder withPacketSegmentPackager(SegmentPackager aPacketSegmentPackager) {
            this.packetSegmentPackager = aPacketSegmentPackager;
            return this;
        }

        @Override
        public Builder withSequenceNumberConcatenateMode(ConcatenateMode aSequenceNumberConcatenateMode) {
            this.sequenceNumberConcatenateMode = aSequenceNumberConcatenateMode;
            return this;
        }

        @Override
        public Builder withSequenceNumberInitValue(int aSequenceNumberInitValue) {
            this.sequenceNumberInitValue = aSequenceNumberInitValue;
            return this;
        }

        @Override
        public Builder withSequenceNumberWidth(int aSequenceNumberWidth) {
            this.sequenceNumberWidth = aSequenceNumberWidth;
            return this;
        }

        @Override
        public Builder withPacketLengthWidth(int aPacketLengthWidth) {
            this.truncateLengthWidth = aPacketLengthWidth;
            return this;
        }

        SegmentPackager toPacketSegmentPackager() {
            if (this.packetSegmentPackager != null) {
                return this.packetSegmentPackager;
            }
            return PacketOutputStream.toPacketSegmentPackager(this.crcAlgorithm, this.crcChecksumConcatenateMode, this.crcChecksumValidationMode, this.endianess);
        }
    }
}

