/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.refcodes.io.ReplayInputStream;
import org.refcodes.serial.AbstractMagicBytesTransmissionMultiplexer;
import org.refcodes.serial.BadCrcChecksumException;
import org.refcodes.serial.BadMagicBytesException;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialTransceiver;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionSequenceException;

public class MagicBytesSegmentMultiplexer
extends AbstractMagicBytesTransmissionMultiplexer<Segment>
implements Segment {
    private static final long serialVersionUID = 1L;

    public MagicBytesSegmentMultiplexer() {
    }

    public MagicBytesSegmentMultiplexer(Collection<Segment> aSegments, int aReadLimit) {
        super(aSegments, aReadLimit);
    }

    public MagicBytesSegmentMultiplexer(Collection<Segment> aSegments) {
        super(aSegments);
    }

    public MagicBytesSegmentMultiplexer(int aReadLimit, Segment ... aSegments) {
        super(aReadLimit, (Transmission[])aSegments);
    }

    public MagicBytesSegmentMultiplexer(Segment ... aSegments) {
        super((Transmission[])aSegments);
    }

    @Override
    public int fromTransmission(byte[] aChunk) throws TransmissionException {
        return this.fromTransmission(new ByteArraySequence(aChunk), 0);
    }

    @Override
    public int fromTransmission(Sequence aSequence) throws TransmissionException {
        return this.fromTransmission(aSequence, 0);
    }

    @Override
    public int fromTransmission(byte[] aChunk, int aOffset) throws TransmissionException {
        return this.fromTransmission(new ByteArraySequence(aChunk), aOffset);
    }

    @Override
    public void receiveFrom(InputStream aInputStream) throws IOException {
        this.receiveFrom(aInputStream, null);
    }

    @Override
    public void receiveFrom(SerialTransceiver aSerialTransceiver) throws IOException {
        this.receiveFrom(aSerialTransceiver.getInputStream(), aSerialTransceiver.getOutputStream());
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        if (this._children != null) {
            for (Segment a_children : (Segment[])this._children) {
                try {
                    int eReturn = a_children.fromTransmission(aSequence, aOffset);
                    this._responsibility = a_children;
                    return eReturn;
                }
                catch (BadCrcChecksumException | BadMagicBytesException transmissionException) {
                }
            }
        }
        throw new TransmissionSequenceException(aSequence, aOffset, "There are no segments to which to transmit the given sequence!");
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException {
        if (this._children != null) {
            InputStream theInputStream = aInputStream.markSupported() ? aInputStream : new ReplayInputStream(aInputStream);
            theInputStream.mark(this._readLimit);
            for (Segment a_children : (Segment[])this._children) {
                try {
                    a_children.receiveFrom(theInputStream, aReturnStream);
                    this._responsibility = a_children;
                    return;
                }
                catch (BadMagicBytesException ignore) {
                    theInputStream.reset();
                }
                catch (BadCrcChecksumException ignore) {
                    theInputStream.reset();
                    ignore.printStackTrace();
                }
            }
        }
        throw new TransmissionException("There are no segments to which to transmit the given transmission to!");
    }
}

