/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.util.UUID;
import org.refcodes.serial.CrossoverLoopbackPort;
import org.refcodes.serial.LoopbackPort;
import org.refcodes.serial.PortTestBench;

public class LoopbackPortTestBench
implements PortTestBench {
    private final LoopbackPort _port1 = new LoopbackPort("/dev/ttyLoopback" + UUID.randomUUID().toString());
    private final LoopbackPort _port2 = new CrossoverLoopbackPort(this._port1);

    @Override
    public boolean hasPorts() {
        return true;
    }

    public LoopbackPort getReceiverPort() throws IOException {
        return this._port1;
    }

    public LoopbackPort getTransmitterPort() throws IOException {
        return this._port2;
    }

    @Override
    public void open() throws IOException {
        this._port1.open();
        this._port2.open();
    }

    @Override
    public void close() throws IOException {
        try {
            this._port1.close();
        }
        finally {
            this._port2.close();
        }
    }

    @Override
    public void waitShortestForPortCatchUp() {
    }

    @Override
    public void waitShortForPortCatchUp() {
    }

    @Override
    public void waitForPortCatchUp() {
    }

    @Override
    public void waitLongForPortCatchUp() {
    }

    @Override
    public void waitLongestForPortCatchUp() {
    }

    @Override
    public void waitForPortCatchUp(long aSleepTimeMillis) {
        try {
            Thread.sleep(aSleepTimeMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

