/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.function.Supplier;
import org.refcodes.serial.AbstractPayloadSection;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.PayloadTransmission;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.textual.CaseStyleBuilder;

public class FileSection
extends AbstractPayloadSection<File> {
    private static final long serialVersionUID = 1L;
    private static final int WRITE_BLOCK_FILE_SIZE = 4096;
    public static final String FILE_PATH = "FILE_PATH";
    public static final String FILE_SIZE = "FILE_SIZE";
    public static final String FILE_EXISTS = "FILE_EXISTS";
    public static final String FILE = "FILE";
    private Supplier<String> _filePathSupplier = null;

    public FileSection(String aAlias, File aFile) {
        super(aAlias, aFile);
    }

    public FileSection(File aFile) {
        super(CaseStyleBuilder.asKebabCase(FileSection.class.getSimpleName()), aFile);
    }

    public FileSection(String aAlias, String aFilePath) {
        super(aAlias, new File(aFilePath));
    }

    public FileSection(String aFilePath) {
        super(CaseStyleBuilder.asKebabCase(FileSection.class.getSimpleName()), new File(aFilePath));
    }

    public FileSection(Supplier<String> aFilePathSupplier) {
        super(CaseStyleBuilder.asKebabCase(FileSection.class.getSimpleName()), null);
        this._filePathSupplier = aFilePathSupplier;
    }

    public FileSection(String aAlias, String aBasePath, Supplier<String> aFilePathSupplier) {
        super(aAlias, new File(aBasePath));
        this._filePathSupplier = aFilePathSupplier;
    }

    public FileSection(String aBasePath, Supplier<String> aFilePathSupplier) {
        super(CaseStyleBuilder.asKebabCase(FileSection.class.getSimpleName()), new File(aBasePath));
        this._filePathSupplier = aFilePathSupplier;
    }

    public FileSection(String aAlias, File aBasePath, Supplier<String> aFilePathSupplier) {
        super(aAlias, aBasePath);
        this._filePathSupplier = aFilePathSupplier;
    }

    public FileSection(File aBasePath, Supplier<String> aFilePathSupplier) {
        super(CaseStyleBuilder.asKebabCase(FileSection.class.getSimpleName()), aBasePath);
        this._filePathSupplier = aFilePathSupplier;
    }

    @Override
    public SerialSchema toSchema() {
        File theFile = this.toPayloadFile();
        SerialSchema theSchema = SerialSchema.builder().withAlias(this.getAlias()).withInstance(this).withLength(this.getLength()).withDescription("A file segment containing a payload referenced by a file.").build();
        theSchema.put(FILE_PATH, theFile.getAbsolutePath());
        theSchema.put(FILE_SIZE, theFile.length());
        theSchema.put(FILE_EXISTS, theFile.exists());
        theSchema.put(FILE, theFile.isFile());
        return theSchema;
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        File theFile = this.toPayloadFile();
        byte[] theByte = new byte[1];
        try (FileOutputStream theOut = new FileOutputStream(theFile);){
            for (int i = 0; i < aLength; ++i) {
                theByte[0] = aSequence.getByteAt(i + aOffset);
                theOut.write(theByte);
            }
        }
        catch (IOException | ArrayIndexOutOfBoundsException e) {
            throw new TransmissionException("Cannot send transmission for sequence <" + aSequence.toHexString() + "> at offset <" + aOffset + "> with length <" + aLength + ">!", e);
        }
    }

    @Override
    public void receiveFrom(InputStream aInputStream, int aLength, OutputStream aReturnStream) throws IOException {
        File theFile = this.toPayloadFile();
        try (BufferedOutputStream theOut = new BufferedOutputStream(new FileOutputStream(theFile));){
            int size;
            int count = 0;
            byte[] theBuffer = new byte[4096];
            while (aLength - count >= theBuffer.length) {
                size = aInputStream.read(theBuffer);
                count += size;
                ((OutputStream)theOut).write(theBuffer, 0, size);
                ((OutputStream)theOut).flush();
            }
            while (aLength > count) {
                size = aInputStream.read(theBuffer, 0, aLength - count);
                count += size;
                ((OutputStream)theOut).write(theBuffer, 0, size);
                ((OutputStream)theOut).flush();
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new TransmissionException("Cannot receive transmission from input stream <" + String.valueOf(aInputStream) + "> and return stream <" + String.valueOf(aReturnStream) + "> with length <" + aLength + ">!", e);
        }
    }

    @Override
    public int getLength() {
        return (int)this.toPayloadFile().length();
    }

    @Override
    public Sequence toSequence() {
        ByteArraySequence theSequence;
        File theFile = this.toPayloadFile();
        try (FileInputStream theIn = new FileInputStream(theFile);){
            byte[] theFileBytes = new byte[(int)theFile.length()];
            theIn.read(theFileBytes);
            theSequence = new ByteArraySequence(theFileBytes);
        }
        catch (IOException ignoree) {
            theSequence = new ByteArraySequence();
        }
        return theSequence;
    }

    @Override
    public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
        File theFile = this.toPayloadFile();
        Files.copy(theFile.toPath(), aOutputStream);
    }

    @Override
    public PayloadTransmission<File> withPayload(File aPayload) {
        this.setPayload(aPayload);
        return this;
    }

    public File toPayloadFile() {
        if (this._filePathSupplier != null) {
            if (this._payload != null) {
                return new File((File)this._payload, this._filePathSupplier.get());
            }
            return new File(this._filePathSupplier.get());
        }
        return (File)this._payload;
    }
}

