/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.exception.UnhandledEnumBugException;
import org.refcodes.mixin.ConcatenateMode;
import org.refcodes.numerical.ChecksumValidationMode;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.AbstractCrcTransmissionDecorator;
import org.refcodes.serial.BadCrcChecksumException;
import org.refcodes.serial.BadCrcChecksumSequenceException;
import org.refcodes.serial.DecoratorSegment;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;

public class CrcSegmentDecorator<DECORATEE extends Segment>
extends AbstractCrcTransmissionDecorator<DECORATEE>
implements DecoratorSegment<DECORATEE> {
    private static final long serialVersionUID = 1L;

    public CrcSegmentDecorator(DECORATEE aDecoratee, TransmissionMetrics aTransmissionMetrics) {
        super(aDecoratee, aTransmissionMetrics);
    }

    public CrcSegmentDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm) {
        super(aDecoratee, aCrcAlgorithm);
    }

    public CrcSegmentDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ChecksumValidationMode aChecksumValidationMode) {
        super(aDecoratee, aCrcAlgorithm, aChecksumValidationMode);
    }

    public CrcSegmentDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, Endianess aEndianess) {
        super(aDecoratee, aCrcAlgorithm);
    }

    public CrcSegmentDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ChecksumValidationMode aChecksumValidationMode, Endianess aEndianess) {
        super(aDecoratee, aCrcAlgorithm, aChecksumValidationMode, aEndianess);
    }

    public CrcSegmentDecorator(DECORATEE aDecoratee, ConcatenateMode aCrcChecksumConcatenateMode) {
        super(aDecoratee, aCrcChecksumConcatenateMode);
    }

    public CrcSegmentDecorator(DECORATEE aDecoratee, ConcatenateMode aCrcChecksumConcatenateMode, Endianess aEndianess) {
        super(aDecoratee, aCrcChecksumConcatenateMode, aEndianess);
    }

    public CrcSegmentDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode) {
        super(aDecoratee, aCrcAlgorithm, aCrcChecksumConcatenateMode);
    }

    public CrcSegmentDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, ChecksumValidationMode aChecksumValidationMode) {
        super(aDecoratee, aCrcAlgorithm, aCrcChecksumConcatenateMode, aChecksumValidationMode);
    }

    public CrcSegmentDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, Endianess aEndianess) {
        super(aDecoratee, aCrcAlgorithm, aCrcChecksumConcatenateMode, aEndianess);
    }

    public CrcSegmentDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, ChecksumValidationMode aChecksumValidationMode, Endianess aEndianess) {
        super(aDecoratee, aCrcAlgorithm, aCrcChecksumConcatenateMode, aChecksumValidationMode, aEndianess);
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        long theCrcChecksum;
        int theOffset = aOffset;
        switch (this._crcChecksumConcatenateMode) {
            case PREPEND: {
                byte[] theBytes = aSequence.toBytes(aOffset, this._crcAlgorithm.getCrcWidth());
                aOffset += this._crcAlgorithm.getCrcWidth();
                this._crcChecksum = this.getEndianess().toUnsignedLong(theBytes);
                aOffset = ((Segment)this._decoratee).fromTransmission(aSequence, aOffset);
                break;
            }
            case APPEND: {
                theOffset = aOffset = ((Segment)this._decoratee).fromTransmission(aSequence, aOffset);
                byte[] theBytes = aSequence.toBytes(aOffset, this._crcAlgorithm.getCrcWidth());
                this._crcChecksum = this.getEndianess().toUnsignedLong(theBytes);
                aOffset += this._crcAlgorithm.getCrcWidth();
                break;
            }
            default: {
                throw new UnhandledEnumBugException(this._crcChecksumConcatenateMode);
            }
        }
        if (this._checksumValidationMode == ChecksumValidationMode.ENFORCE_VALID_CHECKSUM && (theCrcChecksum = ((Segment)this._decoratee).toSequence().toCrcChecksum(this._crcAlgorithm)) != this._crcChecksum) {
            throw new BadCrcChecksumSequenceException(this._crcChecksum, theCrcChecksum, aSequence, "The CRC checksum <" + this._crcChecksum + "> at offset <" + theOffset + "> does not match the calculated CRC checksum <" + theCrcChecksum + ">.");
        }
        return aOffset;
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException {
        long theCrcChecksum;
        byte[] theBytes = new byte[this._crcAlgorithm.getCrcWidth()];
        switch (this._crcChecksumConcatenateMode) {
            case PREPEND: {
                aInputStream.read(theBytes, 0, this._crcAlgorithm.getCrcWidth());
                this._crcChecksum = this.getEndianess().toUnsignedLong(theBytes);
                ((Segment)this._decoratee).receiveFrom(aInputStream, aReturnStream);
                break;
            }
            case APPEND: {
                ((Segment)this._decoratee).receiveFrom(aInputStream, aReturnStream);
                aInputStream.read(theBytes, 0, this._crcAlgorithm.getCrcWidth());
                this._crcChecksum = this.getEndianess().toUnsignedLong(theBytes);
                break;
            }
            default: {
                throw new UnhandledEnumBugException(this._crcChecksumConcatenateMode);
            }
        }
        if (this._checksumValidationMode == ChecksumValidationMode.ENFORCE_VALID_CHECKSUM && (theCrcChecksum = ((Segment)this._decoratee).toSequence().toCrcChecksum(this._crcAlgorithm)) != this._crcChecksum) {
            throw new BadCrcChecksumException(this._crcChecksum, theCrcChecksum, "The CRC checksum <" + this._crcChecksum + "> at offset <0> does not match the calculated CRC checksum <" + theCrcChecksum + ">.");
        }
    }
}

