/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import org.refcodes.factory.PrototypeFactory;
import org.refcodes.factory.TypeFactory;
import org.refcodes.mixin.EncodingAccessor;
import org.refcodes.mixin.TypeAccessor;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.EndianessAccessor;
import org.refcodes.serial.AllocSectionDecoratorSegment;
import org.refcodes.serial.BooleanArraySection;
import org.refcodes.serial.BooleanSegment;
import org.refcodes.serial.ByteArraySection;
import org.refcodes.serial.ByteSegment;
import org.refcodes.serial.CharArraySection;
import org.refcodes.serial.CharSection;
import org.refcodes.serial.DoubleArraySection;
import org.refcodes.serial.DoubleSegment;
import org.refcodes.serial.EnumSegment;
import org.refcodes.serial.FloatArraySection;
import org.refcodes.serial.FloatSegment;
import org.refcodes.serial.IntArraySection;
import org.refcodes.serial.IntSegment;
import org.refcodes.serial.LengthWidthAccessor;
import org.refcodes.serial.LongArraySection;
import org.refcodes.serial.LongSegment;
import org.refcodes.serial.PayloadSegment;
import org.refcodes.serial.PayloadTransmission;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentArraySection;
import org.refcodes.serial.SegmentComposite;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.ShortArraySection;
import org.refcodes.serial.ShortSegment;
import org.refcodes.serial.StringArraySection;
import org.refcodes.serial.StringSection;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.struct.ImmutableClassStructTable;
import org.refcodes.struct.ImmutableSimpleTypeTable;
import org.refcodes.struct.MapClassStructTable;
import org.refcodes.struct.MapSimpleTypeTable;
import org.refcodes.struct.SimpleType;
import org.refcodes.struct.SimpleTypeTable;
import org.refcodes.struct.TypeUtility;
import org.refcodes.textual.CaseStyleBuilder;

public class ComplexTypeSegment<T>
extends SegmentComposite<Segment>
implements PayloadSegment<T>,
TypeAccessor<T>,
LengthWidthAccessor,
EndianessAccessor,
EncodingAccessor<Charset> {
    private static final long serialVersionUID = 1L;
    private String _alias;
    private Class<T> _type;
    private T _value = null;
    private String[] _attributes = null;
    private int _lengthWidth;
    private Endianess _endianess;
    private String _charset;

    public ComplexTypeSegment(Class<T> aType, TransmissionMetrics aTransmissionMetrics) {
        this(CaseStyleBuilder.asCamelCase(ComplexTypeSegment.class.getSimpleName()), aType, null, aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess(), aTransmissionMetrics.getEncoding(), null);
    }

    public ComplexTypeSegment(Class<T> aType, TransmissionMetrics aTransmissionMetrics, String ... aAttributes) {
        this(CaseStyleBuilder.asCamelCase(ComplexTypeSegment.class.getSimpleName()), aType, null, aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess(), aTransmissionMetrics.getEncoding(), aAttributes);
    }

    public ComplexTypeSegment(T aValue, TransmissionMetrics aTransmissionMetrics) {
        this(CaseStyleBuilder.asCamelCase(ComplexTypeSegment.class.getSimpleName()), null, aValue, aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess(), aTransmissionMetrics.getEncoding(), null);
    }

    public ComplexTypeSegment(T aValue, TransmissionMetrics aTransmissionMetrics, String ... aAttributes) {
        this(CaseStyleBuilder.asCamelCase(ComplexTypeSegment.class.getSimpleName()), null, aValue, aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess(), aTransmissionMetrics.getEncoding(), aAttributes);
    }

    public ComplexTypeSegment(Class<T> aType) {
        this(CaseStyleBuilder.asCamelCase(ComplexTypeSegment.class.getSimpleName()), aType, null, 4, TransmissionMetrics.DEFAULT_ENDIANESS, TransmissionMetrics.DEFAULT_ENCODING, null);
    }

    public ComplexTypeSegment(Class<T> aType, String ... aAttributes) {
        this(CaseStyleBuilder.asCamelCase(ComplexTypeSegment.class.getSimpleName()), aType, null, 4, TransmissionMetrics.DEFAULT_ENDIANESS, TransmissionMetrics.DEFAULT_ENCODING, aAttributes);
    }

    public ComplexTypeSegment(T aValue) {
        this(CaseStyleBuilder.asCamelCase(ComplexTypeSegment.class.getSimpleName()), null, aValue, 4, TransmissionMetrics.DEFAULT_ENDIANESS, TransmissionMetrics.DEFAULT_ENCODING, null);
    }

    public ComplexTypeSegment(T aValue, String ... aAttributes) {
        this(CaseStyleBuilder.asCamelCase(ComplexTypeSegment.class.getSimpleName()), null, aValue, 4, TransmissionMetrics.DEFAULT_ENDIANESS, TransmissionMetrics.DEFAULT_ENCODING, aAttributes);
    }

    public ComplexTypeSegment(Class<T> aType, int aLengthWidth, Endianess aEndianess, Charset aCharset) {
        this(CaseStyleBuilder.asCamelCase(ComplexTypeSegment.class.getSimpleName()), aType, null, aLengthWidth, aEndianess, aCharset, null);
    }

    public ComplexTypeSegment(Class<T> aType, int aLengthWidth, Endianess aEndianess, Charset aCharset, String ... aAttributes) {
        this(CaseStyleBuilder.asCamelCase(ComplexTypeSegment.class.getSimpleName()), aType, null, aLengthWidth, aEndianess, aCharset, aAttributes);
    }

    public ComplexTypeSegment(T aValue, int aLengthWidth, Endianess aEndianess, Charset aCharset) {
        this(CaseStyleBuilder.asCamelCase(ComplexTypeSegment.class.getSimpleName()), null, aValue, aLengthWidth, aEndianess, aCharset, null);
    }

    public ComplexTypeSegment(T aValue, int aLengthWidth, Endianess aEndianess, Charset aCharset, String ... aAttributes) {
        this(CaseStyleBuilder.asCamelCase(ComplexTypeSegment.class.getSimpleName()), null, aValue, aLengthWidth, aEndianess, aCharset, aAttributes);
    }

    public ComplexTypeSegment(String aAlias, Class<T> aType) {
        this(aAlias, aType, null, 4, TransmissionMetrics.DEFAULT_ENDIANESS, TransmissionMetrics.DEFAULT_ENCODING, null);
    }

    public ComplexTypeSegment(String aAlias, Class<T> aType, String ... aAttributes) {
        this(aAlias, aType, null, 4, TransmissionMetrics.DEFAULT_ENDIANESS, TransmissionMetrics.DEFAULT_ENCODING, aAttributes);
    }

    public ComplexTypeSegment(String aAlias, T aValue) {
        this(aAlias, null, aValue, 4, TransmissionMetrics.DEFAULT_ENDIANESS, TransmissionMetrics.DEFAULT_ENCODING, null);
    }

    public ComplexTypeSegment(String aAlias, T aValue, String ... aAttributes) {
        this(aAlias, null, aValue, 4, TransmissionMetrics.DEFAULT_ENDIANESS, TransmissionMetrics.DEFAULT_ENCODING, aAttributes);
    }

    public ComplexTypeSegment(String aAlias, Class<T> aType, int aLengthWidth, Endianess aEndianess, Charset aCharset) {
        this(aAlias, aType, null, aLengthWidth, aEndianess, aCharset, null);
    }

    public ComplexTypeSegment(String aAlias, Class<T> aType, int aLengthWidth, Endianess aEndianess, Charset aCharset, String ... aAttributes) {
        this(aAlias, aType, null, aLengthWidth, aEndianess, aCharset, aAttributes);
    }

    public ComplexTypeSegment(String aAlias, T aValue, int aLengthWidth, Endianess aEndianess, Charset aCharset) {
        this(aAlias, null, aValue, aLengthWidth, aEndianess, aCharset, null);
    }

    public ComplexTypeSegment(String aAlias, T aValue, int aLengthWidth, Endianess aEndianess, Charset aCharset, String ... aAttributes) {
        this(aAlias, null, aValue, aLengthWidth, aEndianess, aCharset, aAttributes);
    }

    private ComplexTypeSegment(String aAlias, Class<T> aType, T aValue, int aLengthWidth, Endianess aEndianess, Charset aCharset, String[] aAttributes) {
        super(new Segment[0]);
        this._alias = aAlias;
        this._lengthWidth = aLengthWidth;
        this._charset = aCharset != null ? aCharset.name() : TransmissionMetrics.DEFAULT_ENCODING.name();
        this._endianess = aEndianess;
        this._type = aType != null ? aType : aValue.getClass();
        this._value = aValue;
        this._attributes = aAttributes;
        this.initComplexType();
    }

    @Override
    public Class<T> getType() {
        return this._type;
    }

    public String[] getAttributes() {
        return this._attributes;
    }

    @Override
    public int getLengthWidth() {
        return this._lengthWidth;
    }

    @Override
    public Endianess getEndianess() {
        return this._endianess;
    }

    @Override
    public Charset getEncoding() {
        return this._charset != null ? Charset.forName(this._charset) : TransmissionMetrics.DEFAULT_ENCODING;
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        int theOffset = super.fromTransmission(aSequence, aOffset);
        this._value = this.toValue();
        return theOffset;
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException {
        super.receiveFrom(aInputStream, aReturnStream);
        this._value = this.toValue();
    }

    @Override
    public T getPayload() {
        return this._value;
    }

    @Override
    public PayloadTransmission<T> withPayload(T aValue) {
        this.setPayload(aValue);
        return this;
    }

    @Override
    public void setPayload(T aValue) {
        this._value = aValue;
        this.initComplexType();
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this._alias + ", type=" + String.valueOf(this._type) + ", value=" + String.valueOf(this._value) + ", lengthWidth=" + this._lengthWidth + ", endianess=" + String.valueOf((Object)this._endianess) + ", charset=" + this._charset + "]";
    }

    private void initComplexType() {
        Segment theSegment;
        MapClassStructTable theStructMap = new MapClassStructTable(this._type, SimpleType.WRAPPER_TYPES);
        MapSimpleTypeTable theValueMap = new MapSimpleTypeTable(this._value);
        if (this._attributes != null && this._attributes.length != 0) {
            MapClassStructTable theStructMapBuilder = new MapClassStructTable();
            MapSimpleTypeTable theValueMapBuilder = new MapSimpleTypeTable();
            for (String eAttribute : this._attributes) {
                theStructMapBuilder.put(eAttribute, (Class)theStructMap.get((Object)eAttribute));
                theValueMapBuilder.insert(theValueMap.query(eAttribute));
            }
            theValueMap = theValueMapBuilder;
            theStructMap = theStructMapBuilder;
        }
        if ((theSegment = this.toSegment(theStructMap, theValueMap)) != null) {
            if (theSegment instanceof SegmentComposite) {
                SegmentComposite theSegmentComposite = (SegmentComposite)theSegment;
                this._children = theSegmentComposite.getChildren();
            } else {
                this._children = new Segment[]{theSegment};
            }
        }
    }

    private Segment toSegment(ImmutableClassStructTable aStructTable, ImmutableSimpleTypeTable aValueTable) {
        return this.toSegment(aStructTable, aValueTable, aStructTable.getRootPath());
    }

    private Segment toSegment(ImmutableClassStructTable aStructTable, ImmutableSimpleTypeTable aValueTable, String aPath) {
        ArrayList<AllocSectionDecoratorSegment<Object>> theChildren = new ArrayList<AllocSectionDecoratorSegment<Object>>();
        for (String eKey : aStructTable.children()) {
            Transmission.TransmissionMixin eChild = null;
            String ePath = aStructTable.toPath(aPath, eKey);
            if (aStructTable.isCompositeDir(eKey)) {
                theStructMap = aStructTable.getCompositeDir(eKey);
                SimpleTypeTable theValueMap = aValueTable != null ? aValueTable.getDir(eKey) : null;
                eChild = this.toSegment(theStructMap, theValueMap, ePath);
            } else if (aStructTable.isCompositeArrayDir(eKey)) {
                int[] theIndexes;
                theStructMap = aStructTable.getCompositeArrayDir(eKey);
                Segment thePrototype = this.toSegment(theStructMap, null, "");
                SegmentArraySection<Segment> theArraySegment = null;
                if (aValueTable != null && aValueTable.isIndexDir() && (theIndexes = aValueTable.getDirIndexes()) != null && theIndexes.length != 0) {
                    ArrayList<Segment> theList = new ArrayList<Segment>();
                    for (int i : theIndexes) {
                        SimpleTypeTable eValueMap = aValueTable.getDirAt(i);
                        Segment eSegment = this.toSegment(theStructMap, eValueMap, "");
                        theList.add(eSegment);
                    }
                    theArraySegment = new SegmentArraySection<Segment>(aPath, (TypeFactory<Segment>)new PrototypeFactory<Segment>(thePrototype), (Collection<Segment>)theList);
                }
                if (theArraySegment == null) {
                    theArraySegment = new SegmentArraySection<Segment>(aPath, (TypeFactory<Segment>)new PrototypeFactory<Segment>(thePrototype));
                }
                eChild = new AllocSectionDecoratorSegment<Object>(theArraySegment, this._lengthWidth, this._endianess);
            } else if (aStructTable.isSimpleArrayType(eKey)) {
                theType = aStructTable.getSimpleArrayType(eKey);
                String string = eKey = eKey.endsWith(aStructTable.getArraySelector()) ? aStructTable.toParentPath(eKey) : eKey;
                T[] TArray = aValueTable != null ? (aValueTable.isArray(eKey) ? aValueTable.getArray(eKey) : null) : (theValue = null);
                if (Boolean.class.isAssignableFrom(theType)) {
                    eChild = new AllocSectionDecoratorSegment<BooleanArraySection>(theValue != null ? new BooleanArraySection(aPath, TypeUtility.toArray(theValue, Boolean[].class)) : new BooleanArraySection(aPath), this._lengthWidth, this._endianess);
                } else if (Byte.class.isAssignableFrom(theType)) {
                    eChild = new AllocSectionDecoratorSegment<ByteArraySection>(theValue != null ? new ByteArraySection(aPath, TypeUtility.toArray(theValue, Byte[].class)) : new ByteArraySection(aPath), this._lengthWidth, this._endianess);
                } else if (Short.class.isAssignableFrom(theType)) {
                    eChild = new AllocSectionDecoratorSegment<ShortArraySection>(theValue != null ? new ShortArraySection(aPath, this._endianess, TypeUtility.toArray(theValue, Short[].class)) : new ShortArraySection(aPath, this._endianess), this._lengthWidth, this._endianess);
                } else if (Integer.class.isAssignableFrom(theType)) {
                    eChild = new AllocSectionDecoratorSegment<IntArraySection>(theValue != null ? new IntArraySection(aPath, this._endianess, TypeUtility.toArray(theValue, Integer[].class)) : new IntArraySection(aPath, this._endianess), this._lengthWidth, this._endianess);
                } else if (Long.class.isAssignableFrom(theType)) {
                    eChild = new AllocSectionDecoratorSegment<LongArraySection>(theValue != null ? new LongArraySection(aPath, this._endianess, TypeUtility.toArray(theValue, Long[].class)) : new LongArraySection(aPath, this._endianess), this._lengthWidth, this._endianess);
                } else if (Float.class.isAssignableFrom(theType)) {
                    eChild = new AllocSectionDecoratorSegment<FloatArraySection>(theValue != null ? new FloatArraySection(aPath, this._endianess, TypeUtility.toArray(theValue, Float[].class)) : new FloatArraySection(aPath, this._endianess), this._lengthWidth, this._endianess);
                } else if (Double.class.isAssignableFrom(theType)) {
                    eChild = new AllocSectionDecoratorSegment<DoubleArraySection>(theValue != null ? new DoubleArraySection(aPath, this._endianess, TypeUtility.toArray(theValue, Double[].class)) : new DoubleArraySection(aPath, this._endianess), this._lengthWidth, this._endianess);
                } else if (Character.class.isAssignableFrom(theType)) {
                    eChild = new AllocSectionDecoratorSegment<CharArraySection>(theValue != null ? new CharArraySection(aPath, this.getEncoding(), TypeUtility.toArray(theValue, Character[].class)) : new CharArraySection(aPath, this.getEncoding()), this._lengthWidth, this._endianess);
                } else if (String.class.isAssignableFrom(theType)) {
                    eChild = new AllocSectionDecoratorSegment<StringArraySection>(theValue != null ? new StringArraySection(aPath, this._lengthWidth, this._endianess, this.getEncoding(), TypeUtility.toArray(theValue, String[].class)) : new StringArraySection(aPath, this._lengthWidth, this._endianess, this.getEncoding(), new String[0]), this._lengthWidth, this._endianess);
                }
            } else if (aStructTable.isSimpleType(eKey)) {
                theType = aStructTable.getSimpleType(eKey);
                T[] TArray = theValue = aValueTable != null ? (T[])aValueTable.get((Object)eKey) : null;
                if (Boolean.class.isAssignableFrom(theType)) {
                    eChild = theValue != null ? new BooleanSegment(ePath, (Boolean)theValue) : new BooleanSegment(ePath);
                } else if (Byte.class.isAssignableFrom(theType)) {
                    eChild = theValue != null ? new ByteSegment(ePath, (Byte)theValue) : new ByteSegment(ePath);
                } else if (Short.class.isAssignableFrom(theType)) {
                    eChild = theValue != null ? new ShortSegment(ePath, (Short)theValue, this._endianess) : new ShortSegment(ePath, this._endianess);
                } else if (Integer.class.isAssignableFrom(theType)) {
                    eChild = theValue != null ? new IntSegment(ePath, (Integer)theValue, this._endianess) : new IntSegment(ePath, this._endianess);
                } else if (Long.class.isAssignableFrom(theType)) {
                    eChild = theValue != null ? new LongSegment(ePath, (Long)theValue, this._endianess) : new LongSegment(ePath, this._endianess);
                } else if (Float.class.isAssignableFrom(theType)) {
                    eChild = theValue != null ? new FloatSegment(ePath, (Float)theValue, this._endianess) : new FloatSegment(ePath, this._endianess);
                } else if (Double.class.isAssignableFrom(theType)) {
                    eChild = theValue != null ? new DoubleSegment(ePath, (Double)theValue, this._endianess) : new DoubleSegment(ePath, this._endianess);
                } else if (Character.class.isAssignableFrom(theType)) {
                    eChild = new AllocSectionDecoratorSegment<CharSection>(theValue != null ? new CharSection(ePath, (Character)theValue, this.getEncoding()) : new CharSection(ePath, this.getEncoding()), this._lengthWidth, this._endianess);
                } else if (String.class.isAssignableFrom(theType)) {
                    eChild = new AllocSectionDecoratorSegment<StringSection>(theValue != null ? new StringSection(ePath, (String)theValue, this.getEncoding()) : new StringSection(ePath, null, this.getEncoding()), this._lengthWidth, this._endianess);
                } else if (theType.isEnum()) {
                    Enum[] theEnums = (Enum[])theType.getEnumConstants();
                    Enum theEnum = null;
                    for (Enum eEnum : theEnums) {
                        if (eEnum != theValue && !eEnum.name().equals(theValue)) continue;
                        theEnum = eEnum;
                        break;
                    }
                    eChild = new EnumSegment(ePath, theType, theEnum, this._endianess);
                }
            }
            if (eChild == null) continue;
            theChildren.add((AllocSectionDecoratorSegment<Object>)eChild);
        }
        if (theChildren.size() == 1) {
            return (Segment)theChildren.get(0);
        }
        if (theChildren.size() > 1) {
            return new SegmentComposite(theChildren);
        }
        return null;
    }

    private T toValue() {
        SimpleTypeTable theImmutableSimpleTypeTable = this.toSimpleTypeTable();
        return theImmutableSimpleTypeTable.toType(this._type);
    }
}

