/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.refcodes.mixin.EncodingAccessor;
import org.refcodes.serial.AbstractPayloadSection;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.textual.CaseStyleBuilder;

public class CharArraySection
extends AbstractPayloadSection<char[]>
implements EncodingAccessor<Charset> {
    private static final long serialVersionUID = 1L;
    private String _charset;

    public CharArraySection(TransmissionMetrics aTransmissionMetrics) {
        this(aTransmissionMetrics.getEncoding());
    }

    public CharArraySection(TransmissionMetrics aTransmissionMetrics, char ... aValue) {
        this(aTransmissionMetrics.getEncoding(), aValue);
    }

    public CharArraySection(TransmissionMetrics aTransmissionMetrics, Character ... aValue) {
        this(aTransmissionMetrics.getEncoding(), aValue);
    }

    public CharArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aTransmissionMetrics.getEncoding());
    }

    public CharArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics, char ... aValue) {
        this(aAlias, aTransmissionMetrics.getEncoding(), aValue);
    }

    public CharArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics, Character ... aValue) {
        this(aAlias, aTransmissionMetrics.getEncoding(), aValue);
    }

    public CharArraySection() {
        this(CaseStyleBuilder.asCamelCase(CharArraySection.class.getSimpleName()));
    }

    public CharArraySection(Charset aCharset) {
        this(CaseStyleBuilder.asCamelCase(CharArraySection.class.getSimpleName()), aCharset);
    }

    public CharArraySection(char[] aPayload) {
        this(CaseStyleBuilder.asCamelCase(CharArraySection.class.getSimpleName()), aPayload);
    }

    public CharArraySection(Character[] aPayload) {
        this(CaseStyleBuilder.asCamelCase(CharArraySection.class.getSimpleName()), aPayload);
    }

    public CharArraySection(Charset aCharset, char ... aPayload) {
        this(CaseStyleBuilder.asCamelCase(CharArraySection.class.getSimpleName()), aCharset, aPayload);
    }

    public CharArraySection(Charset aCharset, Character ... aPayload) {
        this(CaseStyleBuilder.asCamelCase(CharArraySection.class.getSimpleName()), aCharset, CharArraySection.toPrimitiveArray(aPayload));
    }

    public CharArraySection(String aAlias) {
        this(aAlias, TransmissionMetrics.DEFAULT_ENCODING, new char[0]);
    }

    public CharArraySection(String aAlias, Charset aCharset) {
        this(aAlias, aCharset, new char[0]);
    }

    public CharArraySection(String aAlias, char[] aPayload) {
        this(aAlias, TransmissionMetrics.DEFAULT_ENCODING, aPayload);
    }

    public CharArraySection(String aAlias, Character[] aPayload) {
        this(aAlias, TransmissionMetrics.DEFAULT_ENCODING, aPayload);
    }

    public CharArraySection(String aAlias, Charset aCharset, char ... aPayload) {
        super(aAlias, aPayload);
        this._charset = aCharset != null ? aCharset.name() : TransmissionMetrics.DEFAULT_ENCODING.name();
    }

    public CharArraySection(String aAlias, Charset aCharset, Character ... aPayload) {
        super(aAlias, CharArraySection.toPrimitiveArray(aPayload));
        this._charset = aCharset != null ? aCharset.name() : TransmissionMetrics.DEFAULT_ENCODING.name();
    }

    @Override
    public CharArraySection withPayload(char[] aValue) {
        this.setPayload(aValue);
        return this;
    }

    @Override
    public Sequence toSequence() {
        return new ByteArraySequence(new String((char[])this.getPayload()).getBytes(this.getEncoding()));
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        char[] theRecord = new String(aSequence.toBytes(aOffset, aLength), this.getEncoding()).toCharArray();
        this.setPayload(theRecord);
    }

    @Override
    public int getLength() {
        return this.toSequence().getLength();
    }

    @Override
    public SerialSchema toSchema() {
        return SerialSchema.builder().withAlias(this.getAlias()).withInstance(this).withValue(this.toSequence()).withLength(this.getLength()).withVerbose(new String((char[])this.getPayload())).withDescription("A body containing a char array payload.").build();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this._alias + ", value=" + Arrays.toString((char[])this.getPayload()) + "]";
    }

    @Override
    public Charset getEncoding() {
        return this._charset != null ? Charset.forName(this._charset) : TransmissionMetrics.DEFAULT_ENCODING;
    }

    @Override
    public void setPayload(Character[] aPayload) {
        this.setPayload(CharArraySection.toPrimitiveArray(aPayload));
    }

    @Override
    public CharArraySection withPayload(Character[] aPayload) {
        this.setPayload(CharArraySection.toPrimitiveArray(aPayload));
        return this;
    }

    private static char[] toPrimitiveArray(Character[] aPayload) {
        char[] theResult = new char[aPayload.length];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = aPayload[i].charValue();
        }
        return theResult;
    }
}

