/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import org.refcodes.serial.AbstractPayloadSegment;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.textual.CaseStyleBuilder;

public class ByteSegment
extends AbstractPayloadSegment<Byte>
implements Segment {
    private static final long serialVersionUID = 1L;
    public static final int BYTES = 1;

    public ByteSegment() {
        this(CaseStyleBuilder.asCamelCase(ByteSegment.class.getSimpleName()));
    }

    public ByteSegment(Byte aValue) {
        this(CaseStyleBuilder.asCamelCase(ByteSegment.class.getSimpleName()), aValue);
    }

    public ByteSegment(String aAlias) {
        this(aAlias, (byte)0);
    }

    public ByteSegment(String aAlias, Byte aValue) {
        super(aAlias, aValue);
    }

    @Override
    public Sequence toSequence() {
        return new ByteArraySequence(new byte[]{(Byte)this.getPayload()});
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        byte theByte = aSequence.getByteAt(aOffset);
        this.setPayload(theByte);
        return aOffset + 1;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public void reset() {
        this._payload = 0;
    }

    @Override
    public SerialSchema toSchema() {
        return SerialSchema.builder().withAlias(this.getAlias()).withInstance(this).withValue(this.toSequence()).withLength(this.getLength()).withVerbose(String.valueOf(this.getPayload())).withDescription("A segment containing an byte payload.").build();
    }

    @Override
    public ByteSegment withPayload(Byte aValue) {
        this.setPayload(aValue);
        return this;
    }
}

