/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.refcodes.serial.BadMagicBytesSequenceException;
import org.refcodes.serial.MagicBytesSegment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.textual.CaseStyleBuilder;
import org.refcodes.textual.VerboseTextBuilder;

public class AssertMagicBytesSegment
extends MagicBytesSegment {
    private static final long serialVersionUID = 1L;

    public AssertMagicBytesSegment(String aAlias, String aMagicBytes, TransmissionMetrics aTransmissionMetrics) {
        super(aAlias, aMagicBytes, aTransmissionMetrics);
    }

    public AssertMagicBytesSegment(String aAlias, byte[] aMagicBytes, TransmissionMetrics aTransmissionMetrics) {
        super(aAlias, aMagicBytes, aTransmissionMetrics);
    }

    public AssertMagicBytesSegment(TransmissionMetrics aTransmissionMetrics) {
        super(CaseStyleBuilder.asCamelCase(MagicBytesSegment.class.getSimpleName()), (String)null, aTransmissionMetrics);
    }

    public AssertMagicBytesSegment(String aMagicBytes, TransmissionMetrics aTransmissionMetrics) {
        super(CaseStyleBuilder.asCamelCase(MagicBytesSegment.class.getSimpleName()), aMagicBytes, aTransmissionMetrics);
    }

    public AssertMagicBytesSegment(byte[] aMagicBytes, TransmissionMetrics aTransmissionMetrics) {
        super(CaseStyleBuilder.asCamelCase(MagicBytesSegment.class.getSimpleName()), aMagicBytes, aTransmissionMetrics);
    }

    public AssertMagicBytesSegment(byte ... aMagicBytes) {
        super(aMagicBytes);
    }

    public AssertMagicBytesSegment(String aAlias, byte ... aMagicBytes) {
        super(aAlias, aMagicBytes);
    }

    public AssertMagicBytesSegment(String aMagicBytes, Charset aCharset) {
        super(aMagicBytes, aCharset);
    }

    public AssertMagicBytesSegment(String aAlias, String aMagicBytes, Charset aCharset) {
        super(aAlias, aMagicBytes, aCharset);
    }

    public AssertMagicBytesSegment(String aAlias, String aMagicBytes) {
        super(aAlias, aMagicBytes);
    }

    public AssertMagicBytesSegment(String aMagicBytes) {
        super(aMagicBytes);
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        byte[] theMagicBytes = aSequence.toBytes(aOffset, this._magicBytesLength);
        if (!Arrays.equals(this._magicBytes, theMagicBytes)) {
            throw new BadMagicBytesSequenceException(theMagicBytes, aSequence, "The received magic bytes " + VerboseTextBuilder.asString(theMagicBytes) + " do not match the expected magic bytes " + VerboseTextBuilder.asString(this._magicBytes) + "!");
        }
        return aOffset + this._magicBytesLength;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = SerialSchema.builder().withAlias(this.getAlias()).withInstance(this).withValue(this.toSequence()).withLength(this.getLength()).withDescription("A segment asserting the configured magic bytes.").build();
        theSchema.put("MAGIC_BYTES", this.getMagicBytes());
        theSchema.put("MAGIC_BYTES_TEXT", this.toMagicBytesString());
        return theSchema;
    }
}

