/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.refcodes.exception.TimeoutIOException;
import org.refcodes.io.SkipAvailableInputStream;
import org.refcodes.io.TimeoutInputStream;
import org.refcodes.mixin.DecorateeAccessor;
import org.refcodes.schema.Schema;
import org.refcodes.serial.FlowControlTimeoutException;
import org.refcodes.serial.MagicBytesSegment;
import org.refcodes.serial.ReadyToReceiveTransmission;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentPackager;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.SerialUtility;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.struct.MapSimpleTypeTable;
import org.refcodes.struct.SimpleTypeTable;

public abstract class AbstractReadyToReceiveTransmissionDecorator<DECORATEE extends Transmission>
implements ReadyToReceiveTransmission,
Transmission.TransmissionMixin,
DecorateeAccessor<DECORATEE> {
    private static final long serialVersionUID = 1L;
    public static final String RTR_MAGIC_BYTES = "RTR_MAGIC_BYTES";
    public static final String RTR_TIMEOUT_IN_MS = "RTR_TIMEOUT_IN_MS";
    public static final String RTR_RETRY_NUMBER = "RTR_RETRY_NUMBER";
    protected DECORATEE _decoratee = null;
    protected long _enquiryStandbyTimeInMs;
    protected long _readyToReceiveTimeoutInMs;
    protected byte[] _readyToReceiveMagicBytes;
    protected SegmentPackager _readyToReceiveSegmentPackager;
    protected int _readyToReceiveRetryNumber;
    protected MagicBytesSegment _readyToReceiveMagicByteSegment;
    protected Segment _readyToReceiveSegment;

    protected AbstractReadyToReceiveTransmissionDecorator() {
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, TransmissionMetrics aTransmissionMetrics) {
        this(aDecoratee, aTransmissionMetrics.getEnquiryStandbyTimeMillis(), aTransmissionMetrics.getReadyToReceiveMagicBytes(), aTransmissionMetrics.getReadyToReceiveRetryNumber(), aTransmissionMetrics.getReadyToReceiveTimeoutMillis(), aTransmissionMetrics.getReadyToReceiveSegmentPackager());
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee) {
        this(aDecoratee, -1L, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, null);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, byte[] aReadyToReceiveMagicBytes) {
        this(aDecoratee, -1L, aReadyToReceiveMagicBytes, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, null);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, null);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, byte[] aReadyToReceiveMagicBytes, SegmentPackager aReadyToReceiveSegmentPackager) {
        this(aDecoratee, -1L, aReadyToReceiveMagicBytes, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, aReadyToReceiveSegmentPackager);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        this(aDecoratee, -1L, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, byte[] aReadyToReceiveMagicBytes, int aReadyToReceiveRetryNumber) {
        this(aDecoratee, -1L, aReadyToReceiveMagicBytes, aReadyToReceiveRetryNumber, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, null);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, int aReadyToReceiveRetryNumber, long aReadyToReceiveTimeoutInMs) {
        this(aDecoratee, -1L, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES, aReadyToReceiveRetryNumber, aReadyToReceiveTimeoutInMs, null);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, byte[] aReadyToReceiveMagicBytes, int aReadyToReceiveRetryNumber, SegmentPackager aReadyToReceiveSegmentPackager) {
        this(aDecoratee, -1L, aReadyToReceiveMagicBytes, aReadyToReceiveRetryNumber, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, aReadyToReceiveSegmentPackager);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, int aReadyToReceiveRetryNumber, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        this(aDecoratee, -1L, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES, aReadyToReceiveRetryNumber, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, byte[] aReadyToReceiveMagicBytes, long aReadyToReceiveTimeoutInMs) {
        this(aDecoratee, -1L, aReadyToReceiveMagicBytes, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, aReadyToReceiveTimeoutInMs, null);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, byte[] aReadyToReceiveMagicBytes, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        this(aDecoratee, -1L, aReadyToReceiveMagicBytes, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToReceiveMagicBytes) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveMagicBytes, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, null);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, long aReadyToReceiveTimeoutInMs) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, aReadyToReceiveTimeoutInMs, null);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToReceiveMagicBytes, SegmentPackager aReadyToReceiveSegmentPackager) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveMagicBytes, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, aReadyToReceiveSegmentPackager);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToReceiveMagicBytes, int aReadyToReceiveRetryNumber) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveMagicBytes, aReadyToReceiveRetryNumber, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, null);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, int aReadyToReceiveRetryNumber, long aReadyToReceiveTimeoutInMs) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES, aReadyToReceiveRetryNumber, aReadyToReceiveTimeoutInMs, null);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToReceiveMagicBytes, int aReadyToReceiveRetryNumber, SegmentPackager aReadyToReceiveSegmentPackager) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveMagicBytes, aReadyToReceiveRetryNumber, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, aReadyToReceiveSegmentPackager);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, int aReadyToReceiveRetryNumber, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES, aReadyToReceiveRetryNumber, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToReceiveMagicBytes, long aReadyToReceiveTimeoutInMs) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveMagicBytes, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, aReadyToReceiveTimeoutInMs, null);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToReceiveMagicBytes, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveMagicBytes, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, byte[] aReadyToReceiveMagicBytes, int aReadyToReceiveRetryNumber, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        this(aDecoratee, -1L, aReadyToReceiveMagicBytes, aReadyToReceiveRetryNumber, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public AbstractReadyToReceiveTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToReceiveMagicBytes, int aReadyToReceiveRetryNumber, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        this._decoratee = aDecoratee;
        this._enquiryStandbyTimeInMs = aEnquiryStandbyTimeInMs;
        this._readyToReceiveMagicBytes = aReadyToReceiveMagicBytes;
        this._readyToReceiveRetryNumber = aReadyToReceiveRetryNumber;
        this._readyToReceiveTimeoutInMs = aReadyToReceiveTimeoutInMs;
        this._readyToReceiveSegmentPackager = aReadyToReceiveSegmentPackager != null ? aReadyToReceiveSegmentPackager : new SegmentPackager.DummySegmentPackager();
        this._readyToReceiveMagicByteSegment = new MagicBytesSegment(this._readyToReceiveMagicBytes);
        this._readyToReceiveSegment = this._readyToReceiveSegmentPackager.toPackaged(this._readyToReceiveMagicByteSegment);
    }

    @Override
    public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
        if (aReturnStream != null) {
            long theEnquiryStandbyTimeInMs = this._enquiryStandbyTimeInMs;
            long theBeginTimeInMs = System.currentTimeMillis();
            TimeoutInputStream theTimeoutReturnStream = SerialUtility.createTimeoutInputStream(aReturnStream, theEnquiryStandbyTimeInMs);
            SkipAvailableInputStream theSkipReturnStream = new SkipAvailableInputStream(aReturnStream, this._readyToReceiveTimeoutInMs);
            while (theEnquiryStandbyTimeInMs == -1L || theEnquiryStandbyTimeInMs > 0L) {
                theSkipReturnStream.skipAvailableExcept(this._readyToReceiveSegment.getLength());
                try {
                    this._readyToReceiveSegment.receiveFrom(theTimeoutReturnStream);
                }
                catch (TimeoutIOException e) {
                    throw new FlowControlTimeoutException(e.getTimeoutInMs(), "Encountered a timeout of <" + e.getTimeoutInMs() + "> ms while receiving from return stream <" + String.valueOf(aReturnStream) + ">!", e);
                }
                if (Arrays.equals(this._readyToReceiveMagicByteSegment.getPayload(), this._readyToReceiveMagicBytes)) {
                    this._decoratee.transmitTo(aOutputStream, aReturnStream);
                    return;
                }
                if (theEnquiryStandbyTimeInMs == -1L) continue;
                long eCurrentTimeInMs = System.currentTimeMillis();
                long ePassedTimeInMs = eCurrentTimeInMs - theBeginTimeInMs;
                theBeginTimeInMs = eCurrentTimeInMs;
                if (ePassedTimeInMs < theEnquiryStandbyTimeInMs) {
                    theEnquiryStandbyTimeInMs -= ePassedTimeInMs;
                    continue;
                }
                throw new FlowControlTimeoutException(this._readyToReceiveTimeoutInMs, "Failed after a timeout of <" + this._readyToReceiveTimeoutInMs + "> as the current (received) RTR byte <" + String.valueOf(this._readyToReceiveMagicByteSegment.getPayload()) + "> does not match the expected RTR byte <" + String.valueOf(this._readyToReceiveMagicBytes) + ">.");
            }
            throw new FlowControlTimeoutException(this._readyToReceiveTimeoutInMs, "Failed after a timeout of <" + this._readyToReceiveTimeoutInMs + "> as the current (received) RTR byte <" + String.valueOf(this._readyToReceiveMagicByteSegment.getPayload()) + "> does not match the expected RTR byte <" + String.valueOf(this._readyToReceiveMagicBytes) + ">.");
        }
        this._decoratee.transmitTo(aOutputStream, aReturnStream);
    }

    @Override
    public void reset() {
        this._decoratee.reset();
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = SerialSchema.builder().withInstance(this).withValue(this.toSequence()).withLength(this.getLength()).withDescription("A transmission decorator enriching the encapsulated transmission with \"Ready-to-receive RTR\".").withChildren(new Schema[]{this.getDecoratee().toSchema()}).build();
        theSchema.put(RTR_MAGIC_BYTES, this.getReadyToReceiveMagicBytes());
        theSchema.put(RTR_TIMEOUT_IN_MS, this.getReadyToReceiveTimeoutMillis());
        theSchema.put(RTR_RETRY_NUMBER, this.getReadyToReceiveRetryNumber());
        return theSchema;
    }

    @Override
    public long getEnquiryStandbyTimeMillis() {
        return this._enquiryStandbyTimeInMs;
    }

    @Override
    public long getReadyToReceiveTimeoutMillis() {
        return this._readyToReceiveTimeoutInMs;
    }

    @Override
    public byte[] getReadyToReceiveMagicBytes() {
        return this._readyToReceiveMagicBytes;
    }

    @Override
    public int getReadyToReceiveRetryNumber() {
        return this._readyToReceiveRetryNumber;
    }

    @Override
    public SegmentPackager getReadyToReceiveSegmentPackager() {
        return this._readyToReceiveSegmentPackager;
    }

    @Override
    public int getLength() {
        return this._decoratee.getLength();
    }

    @Override
    public Sequence toSequence() {
        return this._decoratee.toSequence();
    }

    @Override
    public DECORATEE getDecoratee() {
        return this._decoratee;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [segment=" + String.valueOf(this._decoratee) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._decoratee == null ? 0 : this._decoratee.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractReadyToReceiveTransmissionDecorator other = (AbstractReadyToReceiveTransmissionDecorator)obj;
        return !(this._decoratee == null ? other._decoratee != null : !this._decoratee.equals(other._decoratee));
    }

    @Override
    public SimpleTypeTable toSimpleTypeTable() {
        return this._decoratee != null ? this._decoratee.toSimpleTypeTable() : new MapSimpleTypeTable();
    }
}

