/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.nio.charset.Charset;
import org.refcodes.mixin.DecorateeAccessor;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.schema.Schema;
import org.refcodes.serial.AbstractMagicBytesTransmission;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionMetrics;

public abstract class AbstractMagicBytesTransmissionDecorator<DECORATEE extends Transmission>
extends AbstractMagicBytesTransmission
implements Transmission,
DecorateeAccessor<DECORATEE> {
    private static final long serialVersionUID = 1L;
    protected DECORATEE _decoratee;
    protected String _alias;

    public AbstractMagicBytesTransmissionDecorator(String aAlias, DECORATEE aDecoratee, TransmissionMetrics aTransmissionMetrics) {
        super(aAlias, aTransmissionMetrics);
        this._alias = aAlias;
        this._decoratee = aDecoratee;
    }

    public AbstractMagicBytesTransmissionDecorator(String aAlias, DECORATEE aDecoratee, int aMagicBytesLength) {
        super(aAlias, aMagicBytesLength);
        this._decoratee = aDecoratee;
    }

    public AbstractMagicBytesTransmissionDecorator(String aAlias, DECORATEE aDecoratee, String aMagicBytes) {
        super(aAlias, aMagicBytes);
        this._decoratee = aDecoratee;
    }

    public AbstractMagicBytesTransmissionDecorator(String aAlias, DECORATEE aDecoratee, String aMagicBytes, Charset aCharset) {
        super(aAlias, aMagicBytes, aCharset);
        this._decoratee = aDecoratee;
    }

    public AbstractMagicBytesTransmissionDecorator(String aAlias, DECORATEE aDecoratee, byte[] aMagicBytes) {
        super(aAlias, aMagicBytes);
        this._decoratee = aDecoratee;
    }

    @Override
    public Sequence toSequence() {
        return new ByteArraySequence(this._magicBytes).withAppend(this._decoratee.toSequence());
    }

    @Override
    public int getLength() {
        return this._magicBytesLength + this._decoratee.getLength();
    }

    @Override
    public DECORATEE getDecoratee() {
        return this._decoratee;
    }

    @Override
    public void setPayload(byte[] aValue) {
        this._magicBytes = aValue;
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    @Override
    public void reset() {
        this._decoratee.reset();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this._alias + ", segment=" + String.valueOf(this._decoratee) + ", magicBytes=" + NumericalUtility.toHexString(", ", this._magicBytes) + ", magicBytesLength=" + this._magicBytesLength + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this._decoratee == null ? 0 : this._decoratee.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractMagicBytesTransmissionDecorator other = (AbstractMagicBytesTransmissionDecorator)obj;
        return !(this._decoratee == null ? other._decoratee != null : !this._decoratee.equals(other._decoratee));
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = SerialSchema.builder().withAlias(this.getAlias()).withInstance(this).withValue(this.toSequence()).withLength(this.getLength()).withDescription("A transmission decorator prefixing the encapsulated transmission with magic bytes.").withChildren(new Schema[]{this._decoratee.toSchema()}).build();
        theSchema.put("MAGIC_BYTES", this.getMagicBytes());
        theSchema.put("MAGIC_BYTES", this.toMagicBytesString());
        return theSchema;
    }
}

