/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security.alt.chaos;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import org.refcodes.codec.BaseEncoderOutputStream;
import org.refcodes.codec.BaseMetrics;
import org.refcodes.codec.BaseMetricsConfig;
import org.refcodes.data.SafeInteger;
import org.refcodes.exception.BugException;
import org.refcodes.io.LineBreakOutputStream;
import org.refcodes.mixin.ChildAccessor;
import org.refcodes.mixin.Disposable;
import org.refcodes.mixin.EncodedAccessor;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.security.alt.chaos.ChaosEncryptionOutputStream;
import org.refcodes.security.alt.chaos.ChaosMode;
import org.refcodes.security.alt.chaos.ChaosOptions;
import org.refcodes.security.alt.chaos.ChaosOptionsImpl;

public class ChaosKey
implements SecretKey,
EncodedAccessor,
ChildAccessor<ChaosKey>,
Disposable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ChaosKey.class.getName());
    public static final String PROVIDER_NAME = "CHAOS";
    public static final int A_BYTES = 8;
    public static final double A_MAX = 4.0;
    public static final double A_MIN = 3.57;
    public static final int S_BYTES = SafeInteger.SAFE_INTEGER__BYTES;
    public static final long S_MAX = SafeInteger.MAX_SAFE_INTEGER.getValue();
    public static final long S_MIN = SafeInteger.MIN_SAFE_INTEGER.getValue();
    public static final long S_NEGATIVE_MAX = -16L;
    public static final long S_POSITIVE_MIN = 16L;
    public static final int X_BYTES = 8;
    public static final double X_MAX = 1.0;
    public static final double X_MIN = 0.0;
    public static final int ENCODED_LENGTH = 16 + S_BYTES + 2;
    private static final long S_MAX_RANGE = S_MAX - 16L;
    private static final long S_MIN_RANGE = S_MIN - -16L;
    private static final int CERTIFICATE_LINE_WIDTH = 80;
    private static final String CERTIFICATE_BEGIN_TAG_PREFIX = "-----BEGIN";
    private static final String CERTIFICATE_BEGIN_TAG_SUFFIX = "CHAOS-KEY-CHAIN-----";
    private static final String CERTIFICATE_ENCRYPTED = "ENCRYPTED";
    private static final String CERTIFICATE_SALTED = "SALTED";
    private static final String CERTIFICATE_MUTATE = "MUTATE";
    private static final String CERTIFICATE_XOR = "XOR";
    private static final String CERTIFICATE_END_TAG_PREFIX = "-----END";
    private static final String CERTIFICATE_END_TAG_SUFFIX = "CHAOS-KEY-CHAIN-----";
    private static final String PLAIN_CERTIFICATE_BEGIN = "-----BEGIN CHAOS-KEY-CHAIN-----";
    private static final String PLAIN_CERTIFICATE_END = "-----END CHAOS-KEY-CHAIN-----";
    private double _x0;
    private double _a;
    private long _s;
    private ChaosOptions _chaosOptions;
    private ChaosKey _childKey = null;

    public ChaosKey(byte[] aEncoded) {
        this(aEncoded, null);
    }

    public ChaosKey(double x0, double a, long s) {
        this(x0, a, s, (ChaosOptions)ChaosMode.NONE, null);
    }

    public ChaosKey(double x0, double a, long s, ChaosOptions aChaosOptions) {
        this(x0, a, s, aChaosOptions, null);
    }

    public ChaosKey(int x0, int a, int s) {
        this(x0, a, s, (ChaosOptions)ChaosMode.NONE, (ChaosKey)null);
    }

    public ChaosKey(int x0, int a, int s, ChaosOptions aChaosOptions) {
        this(x0, a, s, aChaosOptions, (ChaosKey)null);
    }

    public ChaosKey(char[] aSecret) {
        this(aSecret, (ChaosOptions)ChaosMode.NONE, null);
    }

    public ChaosKey(String aSecret) {
        this(aSecret, (ChaosOptions)ChaosMode.NONE, null);
    }

    public ChaosKey(char[] aSecret, ChaosOptions aChaosOptions) {
        this(aSecret, aChaosOptions, null);
    }

    public ChaosKey(String aSecret, ChaosOptions aChaosOptions) {
        this(aSecret, aChaosOptions, null);
    }

    public ChaosKey(double x0, double a, long s, ChaosKey aChildKey) {
        this(x0, a, s, (ChaosOptions)ChaosMode.NONE, aChildKey);
    }

    public ChaosKey(int x0, int a, int s, ChaosKey aChildKey) {
        this(x0, a, s, (ChaosOptions)ChaosMode.NONE, aChildKey);
    }

    public ChaosKey(int x0, int a, int s, ChaosOptions aChaosOptions, ChaosKey aChildKey) {
        this(ChaosKey.toX0(x0), ChaosKey.toA(a), ChaosKey.toS(s), aChaosOptions, aChildKey);
    }

    public ChaosKey(char[] aSecret, ChaosKey aChildKey) {
        this(aSecret, (ChaosOptions)ChaosMode.NONE, aChildKey);
    }

    public ChaosKey(String aSecret, ChaosKey aChildKey) {
        this(aSecret, (ChaosOptions)ChaosMode.NONE, aChildKey);
    }

    public ChaosKey(byte[] aEncoded, ChaosKey aChildKey) {
        byte[] theX0 = new byte[8];
        byte[] theA = new byte[8];
        byte[] theS = new byte[S_BYTES];
        byte[] theOptions = new byte[ChaosOptions.getEncodedLength()];
        System.arraycopy(aEncoded, 0, theX0, 0, 8);
        System.arraycopy(aEncoded, 8, theA, 0, 8);
        System.arraycopy(aEncoded, 16, theS, 0, S_BYTES);
        System.arraycopy(aEncoded, 16 + S_BYTES, theOptions, 0, ChaosOptions.getEncodedLength());
        ChaosOptionsImpl theChaosOptions = new ChaosOptionsImpl(theOptions);
        this.init(Endianess.BIG.toDouble(theX0), Endianess.BIG.toDouble(theA), Endianess.BIG.toLong(theS), theChaosOptions, aChildKey);
    }

    public ChaosKey(double x0, double a, long s, ChaosOptions aChaosOptions, ChaosKey aChildKey) {
        this.init(x0, a, s, aChaosOptions, aChildKey);
    }

    public ChaosKey(char[] aSecret, ChaosOptions aChaosOptions, ChaosKey aChildKey) {
        int[] theIds = NumericalUtility.toHashCodes(aSecret, 3);
        this.init(ChaosKey.toX0(theIds[0]), ChaosKey.toA(theIds[1]), ChaosKey.toS(theIds[2]), aChaosOptions, aChildKey);
    }

    public ChaosKey(String aSecret, ChaosOptions aChaosOptions, ChaosKey aChildKey) {
        int[] theIds = NumericalUtility.toHashCodes(aSecret, 3);
        this.init(ChaosKey.toX0(theIds[0]), ChaosKey.toA(theIds[1]), ChaosKey.toS(theIds[2]), aChaosOptions, aChildKey);
    }

    private void init(double x0, double a, long s, ChaosOptions aChaosOptions, ChaosKey aChildKey) {
        ChaosKey.validate(x0, a, s);
        this._x0 = x0;
        this._a = a;
        this._s = s;
        this._chaosOptions = aChaosOptions;
        this._childKey = aChildKey;
        if (x0 == 0.0) {
            LOGGER.log(Level.WARNING, "The provided <x0> value <0.0> causes degenerated security (<input> = <output>)!");
        }
    }

    @Override
    public void destroy() throws DestroyFailedException {
        this.dispose();
    }

    @Override
    public void dispose() {
        this._a = -1.0;
        this._x0 = -1.0;
        this._s = -1L;
        this._chaosOptions = null;
        if (this._childKey != null) {
            this._childKey.dispose();
            this._childKey = null;
        }
    }

    public double getA() {
        return this._a;
    }

    @Override
    public String getAlgorithm() {
        return PROVIDER_NAME;
    }

    public ChaosOptions getOptions() {
        return this._chaosOptions;
    }

    @Override
    public byte[] getEncoded() {
        byte[] theX0 = Endianess.BIG.toBytes(this._x0);
        byte[] theA = Endianess.BIG.toBytes(this._a);
        byte[] theS = Endianess.BIG.toBytes(this._s, S_BYTES);
        byte[] theOptions = this._chaosOptions.getEncoded();
        byte[] theBytes = new byte[ChaosKey.getEncodedLength()];
        System.arraycopy(theX0, 0, theBytes, 0, 8);
        System.arraycopy(theA, 0, theBytes, 8, 8);
        System.arraycopy(theS, 0, theBytes, 16, S_BYTES);
        System.arraycopy(theOptions, 0, theBytes, 16 + S_BYTES, ChaosOptions.getEncodedLength());
        return theBytes;
    }

    public byte[] toEncodedChain() {
        if (this._childKey != null) {
            byte[] theChildrenChain = this._childKey.toEncodedChain();
            byte[] theChain = new byte[theChildrenChain.length + ChaosKey.getEncodedLength()];
            System.arraycopy(this.getEncoded(), 0, theChain, 0, ChaosKey.getEncodedLength());
            System.arraycopy(theChildrenChain, 0, theChain, ChaosKey.getEncodedLength(), theChildrenChain.length);
            return theChain;
        }
        return this.getEncoded();
    }

    @Override
    public String getFormat() {
        return this.getAlgorithm() + " format";
    }

    @Override
    public ChaosKey getChild() {
        return this._childKey;
    }

    public long getS() {
        return this._s;
    }

    public double getX0() {
        return this._x0;
    }

    public String toCertificate() {
        return this.toCertificate(80);
    }

    public String toCertificate(int aLineWidth) {
        StringBuilder theBuffer = new StringBuilder(ChaosKey.toCertificateHead());
        try (ByteArrayOutputStream theBytesOut = new ByteArrayOutputStream();){
            try (LineBreakOutputStream theLineOut = new LineBreakOutputStream(theBytesOut, aLineWidth);
                 BaseEncoderOutputStream theBaseOut = new BaseEncoderOutputStream(theLineOut, (BaseMetrics)BaseMetricsConfig.BASE64);){
                theBaseOut.write(this.toEncodedChain());
                theBaseOut.flush();
            }
            theBuffer.append(theBytesOut.toString(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new BugException("Encountered an I/O related bug which cannot occur as we merely use streams in memory!", e);
        }
        theBuffer.append(ChaosKey.toCertificateTail());
        return theBuffer.toString();
    }

    public String toCertificate(String aPassword) {
        return this.toCertificate(aPassword, ChaosMode.NONE, 80);
    }

    public String toCertificate(String aPassword, int aLineWidth) {
        return this.toCertificate(aPassword, ChaosMode.NONE, aLineWidth);
    }

    public String toCertificate(String aPassword, ChaosOptions aChaosOptions) {
        return this.toCertificate(aPassword, aChaosOptions, 80);
    }

    public String toCertificate(String aPassword, ChaosOptions aChaosOptions, int aLineWidth) {
        if (aPassword == null || aPassword.isEmpty()) {
            throw new IllegalArgumentException("The password must not be null or empty!");
        }
        StringBuilder theBuffer = new StringBuilder(ChaosKey.toCertificateHead(aChaosOptions));
        try (ByteArrayOutputStream theBytesOut = new ByteArrayOutputStream();){
            try (LineBreakOutputStream theLineOut = new LineBreakOutputStream(theBytesOut, 80);
                 BaseEncoderOutputStream theBaseOut = new BaseEncoderOutputStream(theLineOut, (BaseMetrics)BaseMetricsConfig.BASE64);
                 ChaosEncryptionOutputStream theChaosOut = new ChaosEncryptionOutputStream((OutputStream)theBaseOut, new ChaosKey(aPassword, aChaosOptions));){
                theChaosOut.write(this.toEncodedChain());
                theChaosOut.flush();
            }
            theBuffer.append(theBytesOut.toString(StandardCharsets.UTF_8.name()));
        }
        catch (IOException e) {
            throw new BugException("Encountered an I/O related bug which cannot occur as we merely use streams in memory!", e);
        }
        theBuffer.append(ChaosKey.toCertificateTail(aChaosOptions));
        return theBuffer.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this._a);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this._chaosOptions == null ? 0 : this._chaosOptions.hashCode());
        result = 31 * result + (this._childKey == null ? 0 : this._childKey.hashCode());
        result = 31 * result + (int)(this._s ^ this._s >>> 32);
        temp = Double.doubleToLongBits(this._x0);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChaosKey other = (ChaosKey)obj;
        if (Double.doubleToLongBits(this._a) != Double.doubleToLongBits(other._a)) {
            return false;
        }
        if (this._chaosOptions == null ? other._chaosOptions != null : !this._chaosOptions.equals(other._chaosOptions)) {
            return false;
        }
        if (this._childKey == null ? other._childKey != null : !this._childKey.equals(other._childKey)) {
            return false;
        }
        if (this._s != other._s) {
            return false;
        }
        return Double.doubleToLongBits(this._x0) == Double.doubleToLongBits(other._x0);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [x0=" + this._x0 + ", a=" + this._a + ", s=" + this._s + ", chaosMetrics=" + String.valueOf(this._chaosOptions) + ", childKey=" + (this._childKey != null ? this._childKey.toString() : null) + "]";
    }

    public static ChaosKey createFromCertificate(File aCertFile, String aPassword) throws IOException {
        return ChaosKey.createFromCertificate(new BufferedInputStream(new FileInputStream(aCertFile)), aPassword);
    }

    public static ChaosKey createFromCertificate(InputStream aInputStream, String aPassword) throws IOException {
        ByteArrayOutputStream theByteOut = new ByteArrayOutputStream();
        aInputStream.transferTo(theByteOut);
        return ChaosKey.createFromCertificate(theByteOut.toString(StandardCharsets.UTF_8.name()), aPassword);
    }

    /*
     * Exception decompiling
     */
    public static ChaosKey createFromCertificate(String aCertificate, String aPassword) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ChaosKey createFromCertificate(File aCertFile) throws IOException {
        return ChaosKey.createFromCertificate(new BufferedInputStream(new FileInputStream(aCertFile)));
    }

    public static ChaosKey createFromCertificate(InputStream aInputStream) throws IOException {
        ByteArrayOutputStream theByteOut = new ByteArrayOutputStream();
        aInputStream.transferTo(theByteOut);
        return ChaosKey.createFromCertificate(theByteOut.toString(StandardCharsets.UTF_8.name()));
    }

    /*
     * Exception decompiling
     */
    public static ChaosKey createFromCertificate(String aCertificate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ChaosKey createKeyChain(byte[] aEncodedChain) {
        if (aEncodedChain.length == 0 || aEncodedChain.length % ChaosKey.getEncodedLength() != 0) {
            throw new IllegalArgumentException("The provided encoded chain size <" + aEncodedChain.length + "> must be a multiple of <" + ChaosKey.getEncodedLength() + ">!");
        }
        ChaosKey eKey = null;
        byte[] eEncoded = new byte[ChaosKey.getEncodedLength()];
        int theKeyCount = aEncodedChain.length / ChaosKey.getEncodedLength();
        for (int i = theKeyCount - 1; i >= 0; --i) {
            System.arraycopy(aEncodedChain, i * ChaosKey.getEncodedLength(), eEncoded, 0, ChaosKey.getEncodedLength());
            eKey = new ChaosKey(eEncoded, eKey);
        }
        return eKey;
    }

    public static ChaosKey createRndKeyChain(int aChainLength) {
        return ChaosKey.createRndKeyChain(aChainLength, ChaosMode.NONE);
    }

    public static ChaosKey createRndKeyChain(int aChainLength, ChaosOptions ... aChaosOptions) {
        ChaosOptions[] chaosOptionsArray;
        if (aChainLength < 1) {
            throw new IllegalArgumentException("The key chain length <" + aChainLength + "> must be > 0 !");
        }
        if (aChaosOptions != null && aChaosOptions.length != 0) {
            chaosOptionsArray = aChaosOptions;
        } else {
            ChaosOptions[] chaosOptionsArray2 = new ChaosOptions[1];
            chaosOptionsArray = chaosOptionsArray2;
            chaosOptionsArray2[0] = ChaosMode.NONE;
        }
        aChaosOptions = chaosOptionsArray;
        ChaosKey eKey = null;
        ChaosKey eChildKey = null;
        for (int i = aChainLength - 1; i >= 0; --i) {
            eChildKey = eKey = ChaosKey.createRndKey(i > aChaosOptions.length - 1 ? aChaosOptions[aChaosOptions.length - 1] : aChaosOptions[i], eChildKey);
        }
        return eKey;
    }

    public static ChaosKey createRndKey() {
        return ChaosKey.createRndKey(ChaosMode.NONE, null);
    }

    public static ChaosKey createRndKey(ChaosOptions aChaosOptions) {
        return ChaosKey.createRndKey(aChaosOptions, null);
    }

    public static ChaosKey createRndKey(ChaosKey aChildKey) {
        return ChaosKey.createRndKey(ChaosMode.NONE, aChildKey);
    }

    public static ChaosKey createRndKey(ChaosOptions aChaosOptions, ChaosKey aChildKey) {
        SecureRandom rnd;
        try {
            rnd = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException ignore) {
            rnd = new SecureRandom();
        }
        RuntimeException theFirstException = null;
        for (int i = 0; i < 10; ++i) {
            try {
                return new ChaosKey(ChaosKey.toX0(rnd.nextLong()), ChaosKey.toA(rnd.nextLong()), ChaosKey.toS(rnd.nextLong()), aChaosOptions, aChildKey);
            }
            catch (RuntimeException e) {
                if (theFirstException != null) continue;
                theFirstException = e;
                continue;
            }
        }
        throw theFirstException;
    }

    public static ChaosOptions asCertificateOptions(File aCertFile) throws IOException {
        return ChaosKey.asCertificateOptions(new BufferedInputStream(new FileInputStream(aCertFile)));
    }

    public static ChaosOptions asCertificateOptions(InputStream aInputStream) throws IOException {
        ByteArrayOutputStream theByteOut = new ByteArrayOutputStream();
        aInputStream.transferTo(theByteOut);
        return ChaosKey.asCertificateOptions(theByteOut.toString(StandardCharsets.UTF_8.name()));
    }

    public static ChaosOptions asCertificateOptions(String aCertificate) {
        ChaosOptions theOptions;
        block4: {
            theOptions = null;
            String[] theLines = aCertificate.split("\n");
            try {
                if (!theLines[0].equals(PLAIN_CERTIFICATE_BEGIN)) {
                    throw new IllegalArgumentException("The head (\"" + theLines[0] + "\") contains superflous declarations contrasting an expected plain (unsecured) certificate (expexting \"-----BEGIN CHAOS-KEY-CHAIN-----\") !");
                }
                if (!theLines[theLines.length - 1].equals(PLAIN_CERTIFICATE_END)) {
                    throw new IllegalArgumentException("The tail (\"" + theLines[theLines.length - 1] + "\") contains superflous declarations contrasting an expected plain (unsecured) certificate (expexting \"-----END CHAOS-KEY-CHAIN-----\") !");
                }
            }
            catch (IllegalArgumentException e) {
                theOptions = ChaosKey.fromCertificateHead(theLines[0]);
                ChaosOptions theTailOptions = ChaosKey.fromCertificateTail(theLines[theLines.length - 1]);
                if (theOptions.equals(theTailOptions)) break block4;
                throw new IllegalArgumentException("The head options <" + theOptions.toString() + "> do not match the tail options <" + theTailOptions.toString() + "> !");
            }
        }
        return theOptions;
    }

    public static int getEncodedLength() {
        return ENCODED_LENGTH;
    }

    protected int fixedLengthChildDepth() {
        int depth = 0;
        ChaosKey eKey = this.getChild();
        while (eKey != null) {
            if (!eKey.getOptions().isFixedLength()) {
                return depth;
            }
            eKey = eKey.getChild();
            ++depth;
        }
        return depth;
    }

    protected ChaosKey nextVariableLengthChild() {
        for (ChaosKey eKey = this.getChild(); eKey != null; eKey = eKey.getChild()) {
            if (eKey.getOptions().isFixedLength()) continue;
            return eKey;
        }
        return null;
    }

    protected static long addToS(long s, long aAddend) {
        if (aAddend == 0L) {
            return s;
        }
        long theS = s + aAddend;
        if (theS > S_MAX) {
            theS = S_MIN + (theS - S_MAX);
        } else if (theS < S_MIN) {
            theS = S_MAX + (theS - S_MIN);
        }
        if (theS > -16L && theS < 16L) {
            theS = s > 0L ? -16L - (16L - theS) : 16L - (-16L - theS);
        }
        return theS;
    }

    protected static double toA(int a) {
        return NumericalUtility.toDouble(a, 3.57, 4.0);
    }

    protected static double toA(long a) {
        return NumericalUtility.toDouble(a, 3.57, 4.0);
    }

    protected static long toS(int s) {
        long theS = s;
        theS = theS > 0L ? theS * (S_MAX_RANGE / Integer.MAX_VALUE) + 16L : theS * (S_MIN_RANGE / Integer.MIN_VALUE) + -16L;
        if (theS > -16L && theS < 16L) {
            throw new IllegalArgumentException("The value S was <" + theS + ">, though must not be between (excluding) <-16> and  <16>!");
        }
        if (theS > S_MAX) {
            throw new IllegalArgumentException("The value S was <" + theS + ">, though must not be greater than <" + S_MAX + ">!");
        }
        if (theS < S_MIN) {
            throw new IllegalArgumentException("The value S was <" + theS + ">, though must not be less than <" + S_MIN + ">!");
        }
        return theS;
    }

    protected static long toS(long s) {
        if (s > -16L && s < 16L) {
            s += s > 0L ? 16L : -16L;
        }
        if (s > S_MAX) {
            s = s % S_MAX_RANGE + 16L;
        }
        if (s < S_MIN) {
            s = s % S_MIN_RANGE + -16L;
        }
        if (s > -16L && s < 16L) {
            throw new IllegalArgumentException("The value S was <" + s + ">, though must not be between (excluding) <-16> and  <16>!");
        }
        if (s > S_MAX) {
            throw new IllegalArgumentException("The value S was <" + s + ">, though must not be greater than <" + S_MAX + ">!");
        }
        if (s < S_MIN) {
            throw new IllegalArgumentException("The value S was <" + s + ">, though must not be less than <" + S_MIN + ">!");
        }
        return s;
    }

    protected static double toX0(int x0) {
        return NumericalUtility.toDouble(x0, 0.0, 1.0);
    }

    protected static double toX0(long x0) {
        return NumericalUtility.toDouble(x0, 0.0, 1.0);
    }

    protected static void validate(double x0, double a, double s) {
        if (x0 < 0.0 || x0 > 1.0) {
            throw new IllegalArgumentException("The value x(0) of the chaos key was to be <" + x0 + ">, though must be between <0.0> and <1.0> (0.0 <= x0 <= 1.0)");
        }
        if (a < 3.57 || a > 4.0) {
            throw new IllegalArgumentException("The value A of the chaos key was to be <" + a + ">, though must be between <3.57> and <4.0> (3.57 <= A <= 4.0)");
        }
        if (s < (double)S_MIN || s > (double)S_MAX) {
            throw new IllegalArgumentException("The value S of the chaos key was to be <" + s + ">, though must be between <" + S_MIN + "> and  <" + S_MAX + ">");
        }
        if (s > -16.0 && s < 16.0) {
            throw new IllegalArgumentException("The value S of the chaos key was to be <" + s + ">, though must not be between (excluding) <-16> and  <16>");
        }
    }

    protected static ChaosOptions fromCertificateHead(String aCertificateHead) {
        boolean isSalted;
        boolean isXorNext;
        String theCertificateHead = aCertificateHead;
        if (!(theCertificateHead = theCertificateHead.trim()).startsWith(CERTIFICATE_BEGIN_TAG_PREFIX)) {
            throw new IllegalArgumentException("The provided certificate head (\"" + theCertificateHead + "\") does not(!) start with \"-----BEGIN\" !");
        }
        theCertificateHead = theCertificateHead.substring(CERTIFICATE_BEGIN_TAG_PREFIX.length());
        if (!(theCertificateHead = ChaosKey.trim(theCertificateHead)).endsWith("CHAOS-KEY-CHAIN-----")) {
            throw new IllegalArgumentException("The provided certificate head (\"" + theCertificateHead + "\") does not(!) end with \"CHAOS-KEY-CHAIN-----\" !");
        }
        boolean isEncrypted = (theCertificateHead = theCertificateHead.substring(0, theCertificateHead.length() - "CHAOS-KEY-CHAIN-----".length())).contains(CERTIFICATE_ENCRYPTED);
        if (!isEncrypted) {
            throw new IllegalArgumentException("The provided certificate head (\"" + aCertificateHead + "\") is expected to declare an encrypted certificate but does not declared to be \"ENCRYPTED\" !");
        }
        theCertificateHead = theCertificateHead.replaceFirst(CERTIFICATE_ENCRYPTED, "");
        boolean isMutateS = theCertificateHead.contains(CERTIFICATE_MUTATE);
        if (isMutateS) {
            theCertificateHead = theCertificateHead.replaceFirst(CERTIFICATE_MUTATE, "");
        }
        if (isXorNext = theCertificateHead.contains(CERTIFICATE_XOR)) {
            theCertificateHead = theCertificateHead.replaceFirst(CERTIFICATE_XOR, "");
        }
        if (isSalted = theCertificateHead.contains(CERTIFICATE_SALTED)) {
            theCertificateHead = theCertificateHead.replaceFirst(CERTIFICATE_SALTED, "");
        }
        if (ChaosKey.trim(theCertificateHead).length() != 0) {
            throw new IllegalArgumentException("The provided certificate head (\"" + aCertificateHead + "\") has superflous elements \"" + theCertificateHead + "\" !");
        }
        return new ChaosOptionsImpl(isMutateS, isXorNext, isSalted);
    }

    protected static ChaosOptions fromCertificateTail(String aCertificateTail) {
        boolean isSalted;
        boolean isXorNext;
        String theCertificateTail = aCertificateTail;
        if (!(theCertificateTail = theCertificateTail.trim()).startsWith(CERTIFICATE_END_TAG_PREFIX)) {
            throw new IllegalArgumentException("The provided certificate tail (\"" + theCertificateTail + "\") does not(!) start with \"-----END\" !");
        }
        theCertificateTail = theCertificateTail.substring(CERTIFICATE_END_TAG_PREFIX.length());
        if (!(theCertificateTail = ChaosKey.trim(theCertificateTail)).endsWith("CHAOS-KEY-CHAIN-----")) {
            throw new IllegalArgumentException("The provided certificate tail (\"" + theCertificateTail + "\") does not(!) end with \"CHAOS-KEY-CHAIN-----\" !");
        }
        boolean isEncrypted = (theCertificateTail = theCertificateTail.substring(0, theCertificateTail.length() - "CHAOS-KEY-CHAIN-----".length())).contains(CERTIFICATE_ENCRYPTED);
        if (!isEncrypted) {
            throw new IllegalArgumentException("The provided certificate tail (\"" + aCertificateTail + "\") is expected to declare an encrypted certificate but does not declared to be \"ENCRYPTED\" !");
        }
        theCertificateTail = theCertificateTail.replaceFirst(CERTIFICATE_ENCRYPTED, "");
        boolean isMutateS = theCertificateTail.contains(CERTIFICATE_MUTATE);
        if (isMutateS) {
            theCertificateTail = theCertificateTail.replaceFirst(CERTIFICATE_MUTATE, "");
        }
        if (isXorNext = theCertificateTail.contains(CERTIFICATE_XOR)) {
            theCertificateTail = theCertificateTail.replaceFirst(CERTIFICATE_XOR, "");
        }
        if (isSalted = theCertificateTail.contains(CERTIFICATE_SALTED)) {
            theCertificateTail = theCertificateTail.replaceFirst(CERTIFICATE_SALTED, "");
        }
        if (ChaosKey.trim(theCertificateTail).length() != 0) {
            throw new IllegalArgumentException("The provided certificate tail (\"" + aCertificateTail + "\") has superflous elements \"" + theCertificateTail + "\" !");
        }
        return new ChaosOptionsImpl(isMutateS, isXorNext, isSalted);
    }

    protected static String toCertificateHead() {
        return ChaosKey.toCertificateHead(null);
    }

    protected static String toCertificateHead(ChaosOptions aChaosOptions) {
        StringBuilder theBuffer = new StringBuilder();
        theBuffer.append(CERTIFICATE_BEGIN_TAG_PREFIX).append(' ');
        if (aChaosOptions != null) {
            theBuffer.append(CERTIFICATE_ENCRYPTED).append(' ');
            if (aChaosOptions.isSalted()) {
                theBuffer.append(CERTIFICATE_SALTED).append(' ');
            }
            if (aChaosOptions.isMutateS()) {
                theBuffer.append(CERTIFICATE_MUTATE).append(' ');
            }
            if (aChaosOptions.isXorNext()) {
                theBuffer.append(CERTIFICATE_XOR).append(' ');
            }
        }
        theBuffer.append("CHAOS-KEY-CHAIN-----").append('\n');
        return theBuffer.toString();
    }

    protected static String toCertificateTail() {
        return ChaosKey.toCertificateTail(null);
    }

    protected static String toCertificateTail(ChaosOptions aChaosOptions) {
        StringBuilder theBuffer = new StringBuilder();
        theBuffer.append(CERTIFICATE_END_TAG_PREFIX).append(' ');
        if (aChaosOptions != null) {
            theBuffer.append(CERTIFICATE_ENCRYPTED).append(' ');
            if (aChaosOptions.isSalted()) {
                theBuffer.append(CERTIFICATE_SALTED).append(' ');
            }
            if (aChaosOptions.isMutateS()) {
                theBuffer.append(CERTIFICATE_MUTATE).append(' ');
            }
            if (aChaosOptions.isXorNext()) {
                theBuffer.append(CERTIFICATE_XOR).append(' ');
            }
        }
        theBuffer.append("CHAOS-KEY-CHAIN-----");
        return theBuffer.toString();
    }

    private static String trim(String aString) {
        while (aString.startsWith(" ")) {
            aString = aString.substring(1);
        }
        while (aString.endsWith(" ")) {
            aString = aString.substring(0, aString.length() - 1);
        }
        return aString;
    }
}

