/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security;

import java.io.File;
import java.util.Arrays;
import org.refcodes.mixin.Disposable;
import org.refcodes.security.StoreType;

public class TrustStoreDescriptor
implements Disposable {
    private File _storeFile;
    private StoreType _storeType;
    private char[] _storePassword;

    public TrustStoreDescriptor(File aStoreFile) {
        this(aStoreFile, StoreType.JKS);
    }

    public TrustStoreDescriptor(File aStoreFile, StoreType aStoreType) {
        this(aStoreFile, aStoreType, null);
    }

    public TrustStoreDescriptor(File aStoreFile, char[] aStorePassword) {
        this(aStoreFile, StoreType.JKS, aStorePassword);
    }

    public TrustStoreDescriptor(File aStoreFile, StoreType aStoreType, char[] aStorePassword) {
        this._storeFile = aStoreFile;
        this._storeType = aStoreType;
        this._storePassword = aStorePassword;
    }

    public File getStoreFile() {
        return this._storeFile;
    }

    public StoreType getStoreType() {
        return this._storeType;
    }

    public char[] getStorePassword() {
        return this._storePassword;
    }

    @Override
    public void dispose() {
        if (this._storePassword != null) {
            Arrays.fill(this._storePassword, '\u0000');
        }
        this._storePassword = null;
        this._storeFile = null;
        this._storeType = null;
    }
}

