/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.ConnectionStatusAccessor;
import org.refcodes.component.LinkComponent;
import org.refcodes.rest.RestEndpoint;
import org.refcodes.rest.RestRequestConsumer;
import org.refcodes.rest.RestRequestEvent;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpMethodAccessor;
import org.refcodes.web.HttpServerResponse;
import org.refcodes.web.HttpStatusException;

public class RestEndpointBuilder
implements RestEndpoint,
HttpMethodAccessor.HttpMethodProperty,
HttpMethodAccessor.HttpMethodBuilder<RestEndpointBuilder>,
LinkComponent.LinkComponentBuilder<RestEndpointBuilder>,
ConnectionStatusAccessor {
    private static final Logger LOGGER = Logger.getLogger(RestEndpointBuilder.class.getName());
    protected RestRequestConsumer _requestObserver = null;
    protected HttpMethod _httpMethod = HttpMethod.GET;
    protected String _locatorPathPattern = null;
    protected Pattern _locatorRegExp = null;
    protected ConnectionStatus _connectionStatus = ConnectionStatus.NONE;

    public RestEndpointBuilder() {
    }

    public RestEndpointBuilder(HttpMethod aHttpMethod, String aLocatorPathPattern, RestRequestConsumer aRequestConsumer) {
        this._httpMethod = aHttpMethod;
        this._locatorPathPattern = aLocatorPathPattern;
        this._requestObserver = aRequestConsumer;
    }

    public RestEndpointBuilder(HttpMethod aHttpMethod, Pattern aLocatorRegExp, RestRequestConsumer aRequestConsumer) {
        this._httpMethod = aHttpMethod;
        this._locatorRegExp = aLocatorRegExp;
        this._requestObserver = aRequestConsumer;
    }

    @Override
    public RestEndpointBuilder withHttpMethod(HttpMethod aHttpMethod) {
        this.setHttpMethod(aHttpMethod);
        return this;
    }

    public RestEndpointBuilder withLocatorPathPattern(String aLocatorPathPattern) {
        this.setLocatorPathPattern(aLocatorPathPattern);
        return this;
    }

    public RestEndpointBuilder withLocatorRegExp(Pattern aLocatorRegExp) {
        this.setLocatorRegExp(aLocatorRegExp);
        return this;
    }

    public RestEndpointBuilder withRequestObserver(RestRequestConsumer aLambda) {
        this.setRequestObserver(aLambda);
        return this;
    }

    @Override
    public RestEndpointBuilder withOpen() throws IOException {
        this.open();
        return this;
    }

    @Override
    public RestEndpointBuilder withClose() throws IOException {
        this.close();
        return this;
    }

    @Override
    public RestEndpointBuilder withCloseQuietly() {
        this.closeQuietly();
        return this;
    }

    @Override
    public RestEndpointBuilder withCloseIn(int aCloseMillis) {
        this.closeIn(aCloseMillis);
        return this;
    }

    public void setLocatorPathPattern(String aLocatorPathPattern) {
        this._locatorPathPattern = aLocatorPathPattern;
        this._locatorRegExp = null;
    }

    public void setLocatorRegExp(Pattern aLocatorRegExp) {
        this._locatorRegExp = aLocatorRegExp;
        this._locatorPathPattern = null;
    }

    @Override
    public void setHttpMethod(HttpMethod aHttpMethod) {
        this._httpMethod = aHttpMethod;
    }

    public void setRequestObserver(RestRequestConsumer aLambda) {
        this._requestObserver = aLambda;
    }

    public RestRequestConsumer getRequestObserver() {
        return this._requestObserver;
    }

    @Override
    public void onRequest(RestRequestEvent aRequest, HttpServerResponse aResponse) throws HttpStatusException {
        if (this._connectionStatus == ConnectionStatus.OPENED) {
            this._requestObserver.onRequest(aRequest, aResponse);
        } else {
            LOGGER.log(Level.WARNING, "Ignoring request <" + String.valueOf(aRequest) + "> as this rest endpoint is in status <" + String.valueOf((Object)this._connectionStatus) + ">, you may not have opened it?");
        }
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this._httpMethod;
    }

    @Override
    public String getLocatorPathPattern() {
        return this._locatorPathPattern;
    }

    @Override
    public Pattern getLocatorRegExp() {
        return this._locatorRegExp;
    }

    @Override
    public void open() throws IOException {
        this._connectionStatus = ConnectionStatus.OPENED;
    }

    @Override
    public void close() throws IOException {
        this._connectionStatus = ConnectionStatus.CLOSED;
    }

    @Override
    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }
}

