/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.ParseException;
import org.refcodes.component.Flushable;
import org.refcodes.data.Text;
import org.refcodes.exception.BugException;
import org.refcodes.properties.ImmutableProperties;
import org.refcodes.properties.Properties;
import org.refcodes.properties.ReloadMode;
import org.refcodes.runtime.ConfigLocator;

public interface ImmutableResourceProperties
extends ImmutableProperties {
    public Properties reload() throws IOException, ParseException;

    public Properties reload(ReloadMode var1) throws IOException, ParseException;

    default public String toSerialized() {
        return this.toSerialized(this.getDelimiter());
    }

    default public String toSerialized(char aDelimiter) {
        return this.toSerialized(DEFAULT_COMMENT, aDelimiter);
    }

    default public String toSerialized(String aComment) {
        return this.toSerialized(aComment);
    }

    public String toSerialized(String var1, char var2);

    public static interface MutableResoureProperties
    extends ImmutableResourceProperties,
    ImmutableProperties.MutableProperties,
    Flushable {
        public static final String DEFAULT_COMMENT = "Generated by <" + String.valueOf(Text.REFCODES_ORG) + "> (http://www.refcodes.org)";

        default public File fileTo(File aFile) throws IOException {
            return this.fileTo(aFile, DEFAULT_COMMENT);
        }

        default public File fileTo(File aFile, char aDelimiter) throws IOException {
            return this.fileTo(aFile, DEFAULT_COMMENT, aDelimiter);
        }

        default public File fileTo(File aFile, String aComment) throws IOException {
            return this.fileTo(aFile, aComment, this.getDelimiter());
        }

        default public File fileTo(File aFile, String aComment, char aDelimiter) throws IOException {
            File[] theBaseDirs = ConfigLocator.ALL.getFolders(aFile);
            if (theBaseDirs == null || theBaseDirs.length == 0) {
                throw new IOException("Unable to file the properties to <" + aFile.toString() + "> as no approbriate folder could be detected!");
            }
            File theFile = new File(theBaseDirs[0], aFile.getName());
            return this.saveTo(theFile, aComment, aDelimiter);
        }

        default public File fileTo(String aFilePath) throws IOException {
            return this.fileTo(new File(aFilePath));
        }

        default public File fileTo(String aFilePath, char aDelimiter) throws IOException {
            return this.fileTo(new File(aFilePath), aDelimiter);
        }

        default public File fileTo(String aFilePath, String aComment) throws IOException {
            return this.fileTo(new File(aFilePath), aComment);
        }

        default public File fileTo(String aFilePath, String aComment, char aDelimiter) throws IOException {
            return this.fileTo(new File(aFilePath), aComment, aDelimiter);
        }

        @Override
        public void flush() throws IOException;

        default public Properties loadFrom(Class<?> aResourceClass, String aFilePath) throws IOException, ParseException {
            return this.loadFrom(aResourceClass.getResourceAsStream(aFilePath));
        }

        public Properties loadFrom(File var1) throws IOException, ParseException;

        public Properties loadFrom(InputStream var1) throws IOException, ParseException;

        default public Properties loadFrom(String aFilePath) throws IOException, ParseException {
            return this.loadFrom(new File(aFilePath));
        }

        default public Properties loadFrom(URL aUrl) throws IOException, ParseException {
            return this.loadFrom(aUrl.openStream());
        }

        default public void parseFrom(String aSerialized) throws ParseException {
            ByteArrayInputStream theInputStream = new ByteArrayInputStream(aSerialized.getBytes());
            try {
                this.loadFrom(theInputStream);
            }
            catch (IOException e) {
                throw new BugException("Encountered bug while creating a stream without any I/O merely in memory!", e);
            }
        }

        default public File saveTo(File aFile) throws IOException {
            return this.saveTo(aFile, null);
        }

        default public File saveTo(File aFile, char aDelimiter) throws IOException {
            return this.saveTo(aFile, null, aDelimiter);
        }

        default public File saveTo(File aFile, String aComment) throws IOException {
            return this.saveTo(aFile, aComment, this.getDelimiter());
        }

        public File saveTo(File var1, String var2, char var3) throws IOException;

        default public void saveTo(OutputStream aOutputStream) throws IOException {
            this.saveTo(aOutputStream, DEFAULT_COMMENT);
        }

        default public void saveTo(OutputStream aOutputStream, char aDelimiter) throws IOException {
            this.saveTo(aOutputStream, DEFAULT_COMMENT, aDelimiter);
        }

        default public void saveTo(OutputStream aOutputStream, String aComment) throws IOException {
            this.saveTo(aOutputStream, aComment, this.getDelimiter());
        }

        public void saveTo(OutputStream var1, String var2, char var3) throws IOException;

        default public File saveTo(String aFilePath) throws IOException {
            return this.saveTo(new File(aFilePath));
        }

        default public File saveTo(String aFilePath, char aDelimiter) throws IOException {
            return this.saveTo(new File(aFilePath), aDelimiter);
        }

        default public File saveTo(String aFilePath, String aComment) throws IOException {
            return this.saveTo(new File(aFilePath), aComment);
        }

        default public File saveTo(String aFilePath, String aComment, char aDelimiter) throws IOException {
            return this.saveTo(new File(aFilePath), aComment, aDelimiter);
        }

        default public Properties seekFrom(Class<?> aResourceClass, String aFilePath) throws IOException, ParseException {
            return this.seekFrom(aResourceClass, aFilePath, ConfigLocator.ALL);
        }

        public Properties seekFrom(Class<?> var1, String var2, ConfigLocator var3) throws IOException, ParseException;

        default public Properties seekFrom(File aFile) throws IOException, ParseException {
            return this.seekFrom(aFile.getPath());
        }

        default public Properties seekFrom(File aFile, ConfigLocator aConfigLocator) throws IOException, ParseException {
            return this.seekFrom(aFile.getPath(), aConfigLocator);
        }

        default public Properties seekFrom(String aFilePath) throws IOException, ParseException {
            return this.seekFrom(null, aFilePath);
        }

        default public Properties seekFrom(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
            return this.seekFrom(null, aFilePath, aConfigLocator);
        }

        @Override
        default public String toSerialized(String aComment, char aDelimiter) {
            ByteArrayOutputStream theOutputStream = new ByteArrayOutputStream();
            try {
                this.saveTo(theOutputStream, aComment, aDelimiter);
                theOutputStream.flush();
            }
            catch (IOException e) {
                throw new BugException("Encountered bug while creating a stream without any I/O merely in memory!", e);
            }
            return theOutputStream.toString();
        }
    }
}

