/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.p2p.alt.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.data.IoRetryCount;
import org.refcodes.data.IoSleepLoopTime;
import org.refcodes.exception.TimeoutIOException;
import org.refcodes.exception.Trap;
import org.refcodes.mixin.LocatorAccessor;
import org.refcodes.mixin.StatusAccessor;
import org.refcodes.p2p.HopCountAccessor;
import org.refcodes.p2p.HopsAccessor;
import org.refcodes.p2p.NoSuchDestinationException;
import org.refcodes.p2p.PeerProxy;
import org.refcodes.p2p.alt.serial.SerialP2PHeader;
import org.refcodes.p2p.alt.serial.SerialP2PMessage;
import org.refcodes.p2p.alt.serial.SerialP2PTail;
import org.refcodes.p2p.alt.serial.SerialP2PTransmissionMetrics;
import org.refcodes.p2p.alt.serial.SerialPeer;
import org.refcodes.p2p.alt.serial.SerialPeerRouter;
import org.refcodes.serial.CrcSegmentDecorator;
import org.refcodes.serial.IntArraySection;
import org.refcodes.serial.IntSegment;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.serial.ext.handshake.HandshakePortController;
import org.refcodes.struct.MapSimpleTypeTable;
import org.refcodes.struct.SimpleTypeTable;

public class SerialPeerProxy
implements PeerProxy<Integer, SerialP2PHeader, SerialP2PTail, SerialP2PMessage>,
SerialPeerRouter {
    private static final Logger LOGGER = Logger.getLogger(SerialPeerProxy.class.getName());
    private static final SerialP2PTransmissionMetrics DEFAULT_TRANSMISSION_METRICS = new SerialP2PTransmissionMetrics();
    protected HandshakePortController<?> _port;
    private SerialP2PTransmissionMetrics _transmissionMetrics;
    private final Map<Integer, HopCountHeuristic> _locatorToHopCountHeuristics = new WeakHashMap<Integer, HopCountHeuristic>();
    private boolean _hasPingHeurisitc = true;

    SerialPeerProxy(HandshakePortController<?> aPort, SerialPeer aPeer) {
        this(aPort, aPeer, DEFAULT_TRANSMISSION_METRICS);
    }

    SerialPeerProxy(HandshakePortController<?> aPort, SerialPeer aPeer, SerialP2PTransmissionMetrics aTransmissionMetrics) {
        this._transmissionMetrics = aTransmissionMetrics != null ? aTransmissionMetrics : DEFAULT_TRANSMISSION_METRICS;
        aPort.onRequest(new SerialP2PMessage(this._transmissionMetrics), msg -> {
            try {
                aPeer.sendMessage(msg);
                return new SerialP2PMessageResponse(ResponseStatus.OK, this._transmissionMetrics);
            }
            catch (NoSuchDestinationException e) {
                this.clearHeuristics();
                LOGGER.log(Level.WARNING, "Unable to send message to <" + String.valueOf(((SerialP2PHeader)msg.getHeader()).getDestination()) + "> and visited hops <" + Arrays.toString(((SerialP2PTail)msg.getTail()).getHops()) + "> as of: " + Trap.asMessage(e), e);
                return new SerialP2PMessageResponse(ResponseStatus.NO_SUCH_DESTINATION, this._transmissionMetrics);
            }
            catch (IOException e) {
                this.clearHeuristics();
                LOGGER.log(Level.WARNING, "Unable to send message to <" + String.valueOf(((SerialP2PHeader)msg.getHeader()).getDestination()) + "> and visaed hops <" + Arrays.toString(((SerialP2PTail)msg.getTail()).getHops()) + "> as of: " + Trap.asMessage(e), e);
                if (e instanceof TimeoutIOException) {
                    return new SerialP2PMessageResponse(ResponseStatus.NO_SUCH_DESTINATION, this._transmissionMetrics);
                }
                return new SerialP2PMessageResponse(ResponseStatus.IO_EXCEPTION, this._transmissionMetrics);
            }
        });
        aPort.onRequest(new HopCountRequest(this._transmissionMetrics), request -> {
            try {
                return new HopCountResponse(aPeer.getHopCount(request.getLocator(), request.getHops()), this._transmissionMetrics);
            }
            catch (IOException e) {
                this.clearHeuristics();
                LOGGER.log(Level.WARNING, "Unable to determine hop count for locator <" + request.getLocator() + "> and visited hops <" + Arrays.toString((Object[])request.getHops()) + "> as of: " + Trap.asMessage(e), e);
                return new HopCountResponse(-1, this._transmissionMetrics);
            }
        });
        aPort.onPing(this::refreshPing);
        this._port = aPort;
        try {
            this._port.skipAvailableWithin(IoRetryCount.MIN.getValue(), IoSleepLoopTime.MIN.getTimeMillis());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getHopCount(Integer aLocator, Integer[] aHops) throws IOException {
        if (!this._port.isOpened()) {
            return -1;
        }
        try {
            this.probePingHeuristic();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Cannot determine hop count for locator <" + aLocator + "> (port <" + this._port.getAlias() + "> seems not to be connected with a remote peer) as of: " + Trap.asMessage(e), e);
            return -1;
        }
        Integer theHopCountHeurisitc = this.getHopCountHeurisitc(aLocator);
        if (theHopCountHeurisitc != null) {
            return theHopCountHeurisitc;
        }
        try {
            HopCountRequest theRequest = new HopCountRequest((int)aLocator, aHops, this._transmissionMetrics);
            HopCountResponse theResponse = new HopCountResponse(this._transmissionMetrics);
            this._port.requestSegment(theRequest, theResponse, this._transmissionMetrics.getAcknowledgeMode().isEnabled());
            int theHopCount = theResponse.getHopCount();
            this.putHopCountHeurisitc(aLocator, theHopCount);
            return theHopCount;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Cannot determine hop count for locator <" + aLocator + "> (port <" + this._port.getAlias() + "> seems not to be connected with a remote peer) as of: " + Trap.asMessage(e), e);
            this.clearHeuristics();
            return -1;
        }
    }

    @Override
    public void sendMessage(SerialP2PMessage aMessage) throws NoSuchDestinationException, IOException {
        if (!this._port.isOpened()) {
            throw new IOException("Unable to send message to <" + String.valueOf(((SerialP2PHeader)aMessage.getHeader()).getDestination()) + "> and visited hops <" + Arrays.toString(((SerialP2PTail)aMessage.getTail()).getHops()) + "> as port <" + this._port.getAlias() + "> is in status (<" + String.valueOf((Object)this._port.getConnectionStatus()) + ">) and not(!) in status opened!");
        }
        this.probePingHeuristic();
        try {
            SerialP2PMessageResponse theResponse = new SerialP2PMessageResponse(this._transmissionMetrics);
            this._port.requestSegment(aMessage, theResponse, this._transmissionMetrics.getAcknowledgeMode().isEnabled());
            this.refreshHopCountHeurisitc((Integer)((SerialP2PHeader)aMessage.getHeader()).getDestination());
            switch (theResponse.getStatus().ordinal()) {
                case 2: {
                    throw new IOException("Unable to send message to <" + String.valueOf(((SerialP2PHeader)aMessage.getHeader()).getDestination()) + "> and visited hops <" + Arrays.toString(((SerialP2PTail)aMessage.getTail()).getHops()) + "> over port <" + this._port.getAlias() + ">!");
                }
                case 3: {
                    LOGGER.log(Level.WARNING, "Unknown status <" + String.valueOf((Object)ResponseStatus.NONE) + "> response when sending message to <" + String.valueOf(((SerialP2PHeader)aMessage.getHeader()).getDestination()) + "> and visited hops <" + Arrays.toString(((SerialP2PTail)aMessage.getTail()).getHops()) + "> over port <" + this._port.getAlias() + ">!");
                    break;
                }
                case 1: {
                    throw new NoSuchDestinationException("Unable to send message to <" + String.valueOf(((SerialP2PHeader)aMessage.getHeader()).getDestination()) + "> and visited hops <" + Arrays.toString(((SerialP2PTail)aMessage.getTail()).getHops()) + "> over port <" + this._port.getAlias() + ">!", ((SerialP2PHeader)aMessage.getHeader()).getDestination());
                }
                case 0: {
                    break;
                }
            }
        }
        catch (NoSuchDestinationException e) {
            this.clearHeuristics();
            throw e;
        }
        catch (IOException e) {
            this.clearHeuristics();
            if (e instanceof TimeoutIOException) {
                throw new NoSuchDestinationException("Port <" + this._port.getAlias() + "> seems not to be connected with a remote peer! Unable to send message to <" + String.valueOf(((SerialP2PHeader)aMessage.getHeader()).getDestination()) + "> and visited hops <" + Arrays.toString(((SerialP2PTail)aMessage.getTail()).getHops()) + ">!", ((SerialP2PHeader)aMessage.getHeader()).getDestination(), e);
            }
            throw e;
        }
    }

    private void clearHeuristics() {
        this.clearPingHeurisitc();
        this.clearHopCountHeuristics();
    }

    private void clearPingHeurisitc() {
        this._hasPingHeurisitc = false;
    }

    private boolean refreshPing() {
        this._hasPingHeurisitc = true;
        return true;
    }

    private void probePingHeuristic() throws IOException {
        try {
            if (!this._hasPingHeurisitc) {
                this._port.ping();
                this.refreshPing();
            }
        }
        catch (IOException e) {
            this.clearHopCountHeuristics();
            throw e;
        }
    }

    private void putHopCountHeurisitc(Integer aLocator, int aHopCount) {
        if (aHopCount == -1) {
            this._locatorToHopCountHeuristics.remove(aLocator);
        } else {
            HopCountHeuristic theHopCountHeuristic = this._locatorToHopCountHeuristics.get(aLocator);
            if (theHopCountHeuristic == null) {
                theHopCountHeuristic = new HopCountHeuristic(aHopCount);
                this._locatorToHopCountHeuristics.put(aLocator, theHopCountHeuristic);
            } else {
                theHopCountHeuristic.update(aHopCount);
            }
        }
    }

    private Integer getHopCountHeurisitc(Integer aLocator) {
        HopCountHeuristic theHopCountHeurisitcs = this._locatorToHopCountHeuristics.get(aLocator);
        if (theHopCountHeurisitcs != null && theHopCountHeurisitcs.isValid()) {
            return theHopCountHeurisitcs.hopCount;
        }
        this._locatorToHopCountHeuristics.remove(aLocator);
        return null;
    }

    private void refreshHopCountHeurisitc(Integer aLocator) {
        HopCountHeuristic theHopCountHeurisitcs = this._locatorToHopCountHeuristics.get(aLocator);
        if (theHopCountHeurisitcs != null) {
            theHopCountHeurisitcs.refresh();
        }
    }

    private void clearHopCountHeuristics() {
        this._locatorToHopCountHeuristics.clear();
    }

    static class HopCountRequest
    implements Segment,
    Transmission.TransmissionMixin,
    LocatorAccessor<Integer>,
    HopsAccessor<Integer> {
        private static final long serialVersionUID = 1L;
        private static final SerialP2PTransmissionMetrics DEFAULT_TRANSMISSION_METRICS = new SerialP2PTransmissionMetrics();
        private Segment _delegatee = null;
        private IntSegment _locatorSegment;
        private IntArraySection _hopsSection;

        public HopCountRequest() {
            this(-1, (int[])null, DEFAULT_TRANSMISSION_METRICS);
        }

        public HopCountRequest(SerialP2PTransmissionMetrics aTransmissionMetrics) {
            this(-1, (int[])null, aTransmissionMetrics);
        }

        public HopCountRequest(int aLocator, Integer[] aHops) {
            this(aLocator, HopCountRequest.toUnboxedArray(aHops), DEFAULT_TRANSMISSION_METRICS);
        }

        public HopCountRequest(int aLocator, int[] aHops) {
            this(aLocator, aHops, DEFAULT_TRANSMISSION_METRICS);
        }

        public HopCountRequest(int aLocator, Integer[] aHops, SerialP2PTransmissionMetrics aTransmissionMetrics) {
            this(aLocator, HopCountRequest.toUnboxedArray(aHops), aTransmissionMetrics);
        }

        public HopCountRequest(int aLocator, int[] aHops, SerialP2PTransmissionMetrics aTransmissionMetrics) {
            aTransmissionMetrics = aTransmissionMetrics != null ? aTransmissionMetrics : DEFAULT_TRANSMISSION_METRICS;
            Segment[] segmentArray = new CrcSegmentDecorator[1];
            Segment[] segmentArray2 = new Segment[3];
            segmentArray2[0] = SerialSugar.assertMagicBytesSegment(aTransmissionMetrics.getHopCountRequestMagicBytes(), (TransmissionMetrics)aTransmissionMetrics);
            this._locatorSegment = SerialSugar.intSegment((Integer)aLocator, (TransmissionMetrics)aTransmissionMetrics);
            segmentArray2[1] = this._locatorSegment;
            this._hopsSection = aHops != null ? SerialSugar.intArraySection((TransmissionMetrics)aTransmissionMetrics, aHops) : SerialSugar.intArraySection(aTransmissionMetrics);
            segmentArray2[2] = SerialSugar.allocSegment(this._hopsSection, aTransmissionMetrics);
            segmentArray[0] = SerialSugar.crcSegment(SerialSugar.segmentComposite((Segment[])segmentArray2), aTransmissionMetrics);
            this._delegatee = SerialSugar.segmentComposite((Segment[])segmentArray);
        }

        @Override
        public Integer getLocator() {
            return (Integer)this._locatorSegment.getPayload();
        }

        public Integer[] getHops() {
            return HopCountRequest.toBoxedArray((int[])this._hopsSection.getPayload());
        }

        @Override
        public int getLength() {
            return this._delegatee.getLength();
        }

        @Override
        public Sequence toSequence() {
            return this._delegatee.toSequence();
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [segment=" + String.valueOf(this._delegatee) + "]";
        }

        @Override
        public SimpleTypeTable toSimpleTypeTable() {
            return this._delegatee != null ? this._delegatee.toSimpleTypeTable() : new MapSimpleTypeTable();
        }

        @Override
        public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
            this._delegatee.transmitTo(aOutputStream, aReturnStream);
        }

        @Override
        public void reset() {
            this._delegatee.reset();
            this._hopsSection.reset();
        }

        @Override
        public SerialSchema toSchema() {
            return this._delegatee.toSchema();
        }

        @Override
        public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
            return this._delegatee.fromTransmission(aSequence, aOffset);
        }

        @Override
        public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException {
            this._delegatee.receiveFrom(aInputStream, aReturnStream);
        }

        private static Integer[] toBoxedArray(int[] aValues) {
            Integer[] theValues = new Integer[aValues.length];
            for (int i = 0; i < theValues.length; ++i) {
                theValues[i] = aValues[i];
            }
            return theValues;
        }

        private static int[] toUnboxedArray(Integer[] aValues) {
            int[] theValues = new int[aValues.length];
            for (int i = 0; i < theValues.length; ++i) {
                theValues[i] = aValues[i];
            }
            return theValues;
        }
    }

    static class HopCountResponse
    implements Segment,
    Transmission.TransmissionMixin,
    HopCountAccessor {
        private static final long serialVersionUID = 1L;
        private static final SerialP2PTransmissionMetrics DEFAULT_TRANSMISSION_METRICS = new SerialP2PTransmissionMetrics();
        private Segment _delegatee = null;
        private IntSegment _hopCountSegment;

        public HopCountResponse() {
            this(-1, DEFAULT_TRANSMISSION_METRICS);
        }

        public HopCountResponse(SerialP2PTransmissionMetrics aTransmissionMetrics) {
            this(-1, aTransmissionMetrics);
        }

        public HopCountResponse(int aHopCount) {
            this(aHopCount, DEFAULT_TRANSMISSION_METRICS);
        }

        public HopCountResponse(int aHopCount, SerialP2PTransmissionMetrics aTransmissionMetrics) {
            Segment[] segmentArray = new CrcSegmentDecorator[1];
            Segment[] segmentArray2 = new Segment.SegmentMixin[2];
            segmentArray2[0] = SerialSugar.assertMagicBytesSegment(aTransmissionMetrics.getHopCountResponseMagicBytes(), (TransmissionMetrics)aTransmissionMetrics);
            this._hopCountSegment = SerialSugar.intSegment((Integer)aHopCount, (TransmissionMetrics)aTransmissionMetrics);
            segmentArray2[1] = this._hopCountSegment;
            segmentArray[0] = SerialSugar.crcSegment(SerialSugar.segmentComposite((Segment[])segmentArray2), aTransmissionMetrics);
            this._delegatee = SerialSugar.segmentComposite((Segment[])segmentArray);
        }

        @Override
        public int getHopCount() {
            return (Integer)this._hopCountSegment.getPayload();
        }

        @Override
        public int getLength() {
            return this._delegatee.getLength();
        }

        @Override
        public void reset() {
            this._delegatee.reset();
            this._hopCountSegment.reset();
        }

        @Override
        public Sequence toSequence() {
            return this._delegatee.toSequence();
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [segment=" + String.valueOf(this._delegatee) + "]";
        }

        @Override
        public SimpleTypeTable toSimpleTypeTable() {
            return this._delegatee != null ? this._delegatee.toSimpleTypeTable() : new MapSimpleTypeTable();
        }

        @Override
        public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
            this._delegatee.transmitTo(aOutputStream, aReturnStream);
        }

        @Override
        public SerialSchema toSchema() {
            return this._delegatee.toSchema();
        }

        @Override
        public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
            return this._delegatee.fromTransmission(aSequence, aOffset);
        }

        @Override
        public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException {
            this._delegatee.receiveFrom(aInputStream, aReturnStream);
        }
    }

    static class SerialP2PMessageResponse
    implements Segment,
    Transmission.TransmissionMixin,
    StatusAccessor<ResponseStatus> {
        private static final long serialVersionUID = 1L;
        private Segment _delegatee = null;
        private IntSegment _statusSegment;

        public SerialP2PMessageResponse() {
            this(null, null);
        }

        public SerialP2PMessageResponse(ResponseStatus aStatus) {
            this(aStatus, null);
        }

        public SerialP2PMessageResponse(SerialP2PTransmissionMetrics aTransmissionMetrics) {
            this(null, aTransmissionMetrics);
        }

        public SerialP2PMessageResponse(ResponseStatus aStatus, SerialP2PTransmissionMetrics aTransmissionMetrics) {
            aTransmissionMetrics = aTransmissionMetrics != null ? aTransmissionMetrics : new SerialP2PTransmissionMetrics();
            Segment[] segmentArray = new CrcSegmentDecorator[1];
            Segment[] segmentArray2 = new Segment.SegmentMixin[2];
            segmentArray2[0] = SerialSugar.assertMagicBytesSegment(aTransmissionMetrics.getP2PMessageResponseMagicBytes(), (TransmissionMetrics)aTransmissionMetrics);
            this._statusSegment = SerialSugar.intSegment((Integer)(aStatus != null ? aStatus.getStatusValue() : ResponseStatus.NONE.getStatusValue()), (TransmissionMetrics)aTransmissionMetrics);
            segmentArray2[1] = this._statusSegment;
            segmentArray[0] = SerialSugar.crcSegment(SerialSugar.segmentComposite((Segment[])segmentArray2), aTransmissionMetrics);
            this._delegatee = SerialSugar.segmentComposite((Segment[])segmentArray);
        }

        @Override
        public ResponseStatus getStatus() {
            return ResponseStatus.toStatus((Integer)this._statusSegment.getPayload());
        }

        @Override
        public int getLength() {
            return this._delegatee.getLength();
        }

        @Override
        public Sequence toSequence() {
            return this._delegatee.toSequence();
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [segment=" + String.valueOf(this._delegatee) + "]";
        }

        @Override
        public SimpleTypeTable toSimpleTypeTable() {
            return this._delegatee != null ? this._delegatee.toSimpleTypeTable() : new MapSimpleTypeTable();
        }

        @Override
        public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
            this._delegatee.transmitTo(aOutputStream, aReturnStream);
        }

        @Override
        public void reset() {
            this._delegatee.reset();
            this._statusSegment.reset();
        }

        @Override
        public SerialSchema toSchema() {
            return this._delegatee.toSchema();
        }

        @Override
        public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
            return this._delegatee.fromTransmission(aSequence, aOffset);
        }

        @Override
        public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException {
            this._delegatee.receiveFrom(aInputStream, aReturnStream);
        }
    }

    static enum ResponseStatus {
        OK(0),
        NO_SUCH_DESTINATION(1),
        IO_EXCEPTION(2),
        NONE(-1);

        private int _status;

        private ResponseStatus(int aStatus) {
            this._status = aStatus;
        }

        public int getStatusValue() {
            return this._status;
        }

        public static ResponseStatus toStatus(int aStatusValue) {
            for (ResponseStatus eStatus : ResponseStatus.values()) {
                if (eStatus.getStatusValue() != aStatusValue) continue;
                return eStatus;
            }
            return NONE;
        }
    }

    class HopCountHeuristic {
        int hopCount;
        long timeStamp;

        HopCountHeuristic(int aHopCount) {
            this.hopCount = aHopCount;
            this.timeStamp = System.currentTimeMillis();
        }

        public void refresh() {
            this.timeStamp = System.currentTimeMillis();
        }

        public void update(int aHopCount) {
            this.hopCount = aHopCount;
            this.timeStamp = System.currentTimeMillis();
        }

        boolean isValid() {
            return this.timeStamp != -1L && System.currentTimeMillis() < this.timeStamp + SerialPeerProxy.this._transmissionMetrics.getIoHeuristicsTimeToLiveMillis();
        }
    }
}

