/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.p2p.alt.serial;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.p2p.AbstractPeer;
import org.refcodes.p2p.NoSuchDestinationException;
import org.refcodes.p2p.P2PMessageConsumer;
import org.refcodes.p2p.alt.serial.SerialP2PHeader;
import org.refcodes.p2p.alt.serial.SerialP2PMessage;
import org.refcodes.p2p.alt.serial.SerialP2PMessageConsumer;
import org.refcodes.p2p.alt.serial.SerialP2PTail;
import org.refcodes.p2p.alt.serial.SerialP2PTransmissionMetrics;
import org.refcodes.p2p.alt.serial.SerialPeerProxy;
import org.refcodes.p2p.alt.serial.SerialPeerRouter;
import org.refcodes.serial.Port;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.ext.handshake.HandshakePortController;
import org.refcodes.serial.ext.handshake.HandshakeTransmissionMetrics;

public class SerialPeer
extends AbstractPeer<Integer, SerialP2PHeader, SerialP2PTail, SerialP2PMessage, P2PMessageConsumer<SerialP2PMessage, SerialPeer>, SerialPeer, SerialPeerRouter>
implements SerialPeerRouter {
    private SerialP2PTransmissionMetrics _transmissionMetrics;

    public SerialPeer(Integer aLocator, SerialP2PMessageConsumer aMessageConsumer, Port<?> ... aPorts) {
        this(aLocator, aMessageConsumer, (SerialP2PTransmissionMetrics)null, (ExecutorService)null, aPorts);
    }

    public SerialPeer(Integer aLocator, SerialP2PMessageConsumer aMessageConsumer, SerialP2PTransmissionMetrics aTransmissionMetrics, Port<?> ... aPorts) {
        this(aLocator, aMessageConsumer, aTransmissionMetrics, (ExecutorService)null, aPorts);
    }

    public SerialPeer(Integer aLocator, SerialP2PMessageConsumer aMessageConsumer, SerialP2PTransmissionMetrics aTransmissionMetrics, ExecutorService aExecutorService, Port<?> ... aPorts) {
        super(aLocator, aMessageConsumer);
        this._transmissionMetrics = aTransmissionMetrics != null ? aTransmissionMetrics : new SerialP2PTransmissionMetrics();
        ExecutorService theExecutorService = aExecutorService != null ? aExecutorService : ControlFlowUtility.createCachedExecutorService(true);
        for (Port<?> ePort : aPorts) {
            this.addPeerRouter(new SerialPeerProxy(new HandshakePortController(ePort, (HandshakeTransmissionMetrics)this._transmissionMetrics, theExecutorService), this, this._transmissionMetrics));
        }
    }

    @Override
    public <P> void sendMessage(Integer aDestination, P aPayload) throws IOException, NoSuchDestinationException {
        this.sendMessage(new SerialP2PMessage((int)aDestination, aPayload, this._transmissionMetrics));
    }

    @Override
    public void sendMessage(int aDestination, Segment aPayload) throws IOException, NoSuchDestinationException {
        this.sendMessage(new SerialP2PMessage(aDestination, aPayload, this._transmissionMetrics));
    }

    @Override
    public void sendMessage(int aDestination, Sequence aPayload) throws IOException, NoSuchDestinationException {
        this.sendMessage(new SerialP2PMessage(aDestination, aPayload, this._transmissionMetrics));
    }

    public <P> void sendMessage(int aMagicNumber, int aDestination, P aPayload) throws IOException, NoSuchDestinationException {
        this.sendMessage(new SerialP2PMessage(aMagicNumber, aDestination, aPayload, this._transmissionMetrics));
    }

    public void sendMessage(int aMagicNumber, int aDestination, Segment aPayload) throws IOException, NoSuchDestinationException {
        this.sendMessage(new SerialP2PMessage(aMagicNumber, aDestination, aPayload, this._transmissionMetrics));
    }

    public void sendMessage(int aMagicNumber, int aDestination, Sequence aPayload) throws IOException, NoSuchDestinationException {
        this.sendMessage(new SerialP2PMessage(aDestination, aPayload, this._transmissionMetrics));
    }
}

