/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.p2p.alt.serial;

import java.nio.charset.Charset;
import org.refcodes.data.Ascii;
import org.refcodes.data.IoReconnectLoopTime;
import org.refcodes.mixin.ConcatenateMode;
import org.refcodes.numerical.ChecksumValidationMode;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.Endianess;
import org.refcodes.p2p.alt.serial.AcknowledgeMode;
import org.refcodes.serial.SegmentPackager;
import org.refcodes.serial.ext.handshake.HandshakeTransmissionMetrics;

public class SerialP2PTransmissionMetrics
extends HandshakeTransmissionMetrics {
    private static final byte[] DEFAULT_HOP_COUNT_REQUEST_MAGIC_BYTES = new byte[]{Ascii.ENQ.getCode()};
    private static final byte[] DEFAULT_HOP_COUNT_RESPONSE_MAGIC_BYTES = new byte[]{Ascii.ACK.getCode()};
    private static final byte[] DEFAULT_P2P_MESSAGE_MAGIC_BYTES = new byte[]{Ascii.SOH.getCode()};
    private static final byte[] DEFAULT_P2P_MESSAGE_RESPONSE_MAGIC_BYTES = new byte[]{Ascii.EOT.getCode()};
    private static final AcknowledgeMode DEFAULT_ACKNOWLEDGE_MODE = AcknowledgeMode.ON;
    private static final int DEFAULT_IO_RECONNETCT_LOOP_TIME_IN_MS = IoReconnectLoopTime.MIN.getTimeMillis();
    private byte[] _hopCountRequestMagicBytes = DEFAULT_HOP_COUNT_REQUEST_MAGIC_BYTES;
    private byte[] _hopCountResponseMagicBytes = DEFAULT_HOP_COUNT_RESPONSE_MAGIC_BYTES;
    private byte[] _p2pMessageMagicBytes = DEFAULT_P2P_MESSAGE_MAGIC_BYTES;
    private byte[] _p2pMessageResponseMagicBytes = DEFAULT_P2P_MESSAGE_RESPONSE_MAGIC_BYTES;
    private AcknowledgeMode _acknowledgeMode = DEFAULT_ACKNOWLEDGE_MODE;
    private int _ioReconnetctLoopTimeInMs = DEFAULT_IO_RECONNETCT_LOOP_TIME_IN_MS;

    protected SerialP2PTransmissionMetrics(Builder aBuilder) {
        super(aBuilder);
        this._hopCountRequestMagicBytes = aBuilder.hopCountRequestMagicBytes;
        this._hopCountResponseMagicBytes = aBuilder.hopCountResponseMagicBytes;
        this._p2pMessageMagicBytes = aBuilder.p2pMessageMagicBytes;
        this._p2pMessageResponseMagicBytes = aBuilder.p2pMessageResponseMagicBytes;
        this._acknowledgeMode = aBuilder.acknowledgeMode;
        this._ioReconnetctLoopTimeInMs = aBuilder.ioReconnetctLoopTimeInMs;
    }

    public SerialP2PTransmissionMetrics() {
    }

    public int getIoReconnetctLoopTimeInMs() {
        return this._ioReconnetctLoopTimeInMs;
    }

    public AcknowledgeMode getAcknowledgeMode() {
        return this._acknowledgeMode;
    }

    public byte[] getHopCountRequestMagicBytes() {
        return this._hopCountRequestMagicBytes;
    }

    public byte[] getHopCountResponseMagicBytes() {
        return this._hopCountResponseMagicBytes;
    }

    public byte[] getP2PMessageMagicBytes() {
        return this._p2pMessageMagicBytes;
    }

    public byte[] getP2PMessageResponseMagicBytes() {
        return this._p2pMessageResponseMagicBytes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends HandshakeTransmissionMetrics.Builder {
        protected byte[] hopCountRequestMagicBytes = DEFAULT_HOP_COUNT_REQUEST_MAGIC_BYTES;
        protected byte[] hopCountResponseMagicBytes = DEFAULT_HOP_COUNT_RESPONSE_MAGIC_BYTES;
        protected byte[] p2pMessageMagicBytes = DEFAULT_P2P_MESSAGE_MAGIC_BYTES;
        protected byte[] p2pMessageResponseMagicBytes = DEFAULT_P2P_MESSAGE_RESPONSE_MAGIC_BYTES;
        protected AcknowledgeMode acknowledgeMode = DEFAULT_ACKNOWLEDGE_MODE;
        protected int ioReconnetctLoopTimeInMs = DEFAULT_IO_RECONNETCT_LOOP_TIME_IN_MS;

        protected Builder() {
        }

        public Builder withIoReconnetctLoopTimeInMs(int aIoReconnetctLoopTimeInMs) {
            this.ioReconnetctLoopTimeInMs = aIoReconnetctLoopTimeInMs;
            return this;
        }

        public Builder withAcknowledgeMode(AcknowledgeMode aAcknowledgeMode) {
            this.acknowledgeMode = aAcknowledgeMode;
            return this;
        }

        @Override
        public Builder withReplyRetryNumber(int aReplyRetryNumber) {
            this.replyRetryNumber = aReplyRetryNumber;
            return this;
        }

        @Override
        public Builder withReplyTimeoutMillis(long aReplyTimeoutInMs) {
            this.replyTimeoutInMs = aReplyTimeoutInMs;
            return this;
        }

        @Override
        public Builder withIoHeuristicsTimeToLiveMillis(long aIoHeuristicsTimeToLiveInMs) {
            this.ioHeuristicsTimeToLiveInMs = aIoHeuristicsTimeToLiveInMs;
            return this;
        }

        @Override
        public Builder withPongMagicBytes(byte[] aPongMagicBytes) {
            this.pongMagicBytes = aPongMagicBytes;
            return this;
        }

        @Override
        public Builder withPingMagicBytes(byte[] aPingMagicBytes) {
            this.pingMagicBytes = aPingMagicBytes;
            return this;
        }

        @Override
        public Builder withPingRetryNumber(int aPingRetryNumber) {
            this.pingRetryNumber = aPingRetryNumber;
            return this;
        }

        @Override
        public Builder withPingTimeoutMillis(long aPingTimeoutInMs) {
            this.pingTimeoutInMs = aPingTimeoutInMs;
            return this;
        }

        public Builder withHopCountRequestMagicBytes(byte[] aHopCountRequestMagicBytes) {
            return this;
        }

        public Builder withHopCountResponseMagicBytes(byte[] aHopCountResponseMagicBytes) {
            return this;
        }

        public Builder withP2PMessageMagicBytes(byte[] aP2PMessageMagicBytes) {
            return this;
        }

        public Builder withP2PMessageResponseMagicBytes(byte[] aP2PMessageResponseMagicBytes) {
            return this;
        }

        @Override
        public Builder withAcknowledgeMagicBytes(byte[] aAcknowledgeMagicBytes) {
            this.acknowledgeMagicBytes = aAcknowledgeMagicBytes;
            return this;
        }

        @Override
        public Builder withClearToSendMagicBytes(byte[] aClearToSendMagicBytes) {
            this.clearToSendMagicBytes = aClearToSendMagicBytes;
            return this;
        }

        @Override
        public Builder withPacketMagicBytes(byte[] aPacketMagicBytes) {
            this.packetMagicBytes = aPacketMagicBytes;
            return this;
        }

        @Override
        public Builder withReadyToReceiveMagicBytes(byte[] aReadyToReceiveMagicBytes) {
            this.readyToReceiveMagicBytes = aReadyToReceiveMagicBytes;
            return this;
        }

        @Override
        public Builder withReadyToSendMagicBytes(byte[] aReadyToSendMagicBytes) {
            this.readyToSendMagicBytes = aReadyToSendMagicBytes;
            return this;
        }

        @Override
        public Builder withAcknowledgeRetryNumber(int aAcknowledgeRetryNumber) {
            this.acknowledgeRetryNumber = aAcknowledgeRetryNumber;
            return this;
        }

        @Override
        public Builder withAcknowledgeSegmentPackager(SegmentPackager aAcknowledgeSegmentPackager) {
            this.acknowledgeSegmentPackager = aAcknowledgeSegmentPackager;
            return this;
        }

        @Override
        public Builder withAcknowledgeTimeoutMillis(long aAcknowledgeTimeoutInMs) {
            this.acknowledgeTimeoutInMs = aAcknowledgeTimeoutInMs;
            return this;
        }

        @Override
        public Builder withBlockSize(int aBlockSize) {
            this.blockSize = aBlockSize;
            return this;
        }

        @Override
        public Builder withChecksumValidationMode(ChecksumValidationMode aChecksumValidationMode) {
            this.checksumValidationMode = aChecksumValidationMode;
            return this;
        }

        @Override
        public Builder withClearToSendSegmentPackager(SegmentPackager aClearToSendSegmentPackager) {
            this.clearToSendSegmentPackager = aClearToSendSegmentPackager;
            return this;
        }

        @Override
        public Builder withClearToSendTimeoutMillis(long aClearToSendTimeoutInMs) {
            this.clearToSendTimeoutInMs = aClearToSendTimeoutInMs;
            return this;
        }

        @Override
        public Builder withCrcAlgorithm(CrcAlgorithm aCrcAlgorithm) {
            this.crcAlgorithm = aCrcAlgorithm;
            return this;
        }

        @Override
        public Builder withCrcChecksumConcatenateMode(ConcatenateMode aChecksumConcatenateMode) {
            this.crcChecksumConcatenateMode = aChecksumConcatenateMode;
            return this;
        }

        @Override
        public Builder withEncoding(Charset aEncoding) {
            this.encoding = aEncoding;
            return this;
        }

        @Override
        public Builder withEndianess(Endianess aEndianess) {
            this.endianess = aEndianess;
            return this;
        }

        @Override
        public Builder withEndOfStringByte(byte aEndOfStringByte) {
            this.endOfStringByte = aEndOfStringByte;
            return this;
        }

        @Override
        public Builder withEnquiryStandbyTimeMillis(long aEnquiryStandbyTimeInMs) {
            this.enquiryStandbyTimeInMs = aEnquiryStandbyTimeInMs;
            return this;
        }

        @Override
        public Builder withLengthWidth(int aLengthWidth) {
            this.lengthWidth = aLengthWidth;
            return this;
        }

        @Override
        public Builder withPacketLengthWidth(int aPacketLengthWidth) {
            this.packetLengthWidth = aPacketLengthWidth;
            return this;
        }

        @Override
        public Builder withMagicBytesLength(int aMagicBytesLength) {
            this.magicBytesLength = aMagicBytesLength;
            return this;
        }

        @Override
        public Builder withPacketSegmentPackager(SegmentPackager aPacketSegmentPackager) {
            this.packetSegmentPackager = aPacketSegmentPackager;
            return this;
        }

        @Override
        public Builder withReadTimeoutMillis(long aReadTimeoutInMs) {
            this.readTimeoutInMs = aReadTimeoutInMs;
            return this;
        }

        @Override
        public Builder withReadyToReceiveRetryNumber(int aReadyToReceiveRetryNumber) {
            this.readyToReceiveRetryNumber = aReadyToReceiveRetryNumber;
            return this;
        }

        @Override
        public Builder withReadyToReceiveSegmentPackager(SegmentPackager aReadyToReceiveSegmentPackager) {
            this.readyToReceiveSegmentPackager = aReadyToReceiveSegmentPackager;
            return this;
        }

        @Override
        public Builder withReadyToReceiveTimeoutMillis(long aReadyToReceiveTimeoutInMs) {
            this.readyToReceiveTimeoutInMs = aReadyToReceiveTimeoutInMs;
            return this;
        }

        @Override
        public Builder withReadyToSendRetryNumber(int aReadyToSendRetryNumber) {
            this.readyToSendRetryNumber = aReadyToSendRetryNumber;
            return this;
        }

        @Override
        public Builder withReadyToSendSegmentPackager(SegmentPackager aReadyToSendSegmentPackager) {
            this.readyToSendSegmentPackager = aReadyToSendSegmentPackager;
            return this;
        }

        @Override
        public Builder withReadyToSendTimeoutMillis(long aReadyToSendTimeoutInMs) {
            this.readyToSendTimeoutInMs = aReadyToSendTimeoutInMs;
            return this;
        }

        @Override
        public Builder withSequenceNumberConcatenateMode(ConcatenateMode aSequenceNumberConcatenateMode) {
            this.sequenceNumberConcatenateMode = aSequenceNumberConcatenateMode;
            return this;
        }

        @Override
        public Builder withSequenceNumberInitValue(int aSequenceNumberInitValue) {
            this.sequenceNumberInitValue = aSequenceNumberInitValue;
            return this;
        }

        @Override
        public Builder withSequenceNumberWidth(int aSequenceNumberWidth) {
            this.sequenceNumberWidth = aSequenceNumberWidth;
            return this;
        }

        @Override
        public Builder withTransmissionRetryNumber(int aTransmissionRetryNumber) {
            this.transmissionRetryNumber = aTransmissionRetryNumber;
            return this;
        }

        @Override
        public Builder withTransmissionTimeoutMillis(long aTransmissionTimeoutInMs) {
            this.transmissionTimeoutInMs = aTransmissionTimeoutInMs;
            return this;
        }

        @Override
        public Builder withWriteTimeoutMillis(long aWriteTimeoutInMs) {
            this.writeTimeoutInMs = aWriteTimeoutInMs;
            return this;
        }

        @Override
        public Builder withAcknowledgeableTransmissionMagicBytes(byte[] aAcknowledgeableTransmissionMagicBytes) {
            this.acknowledgeableTransmissionMagicBytes = aAcknowledgeableTransmissionMagicBytes;
            return this;
        }

        @Override
        public Builder withAcknowledgeableResponseMagicBytes(byte[] aAcknowledgeableResponseMagicBytes) {
            this.acknowledgeableResponseMagicBytes = aAcknowledgeableResponseMagicBytes;
            return this;
        }

        @Override
        public Builder withAcknowledgeableRequestMagicBytes(byte[] aAcknowledgeableRequestMagicBytes) {
            this.acknowledgeableRequestMagicBytes = aAcknowledgeableRequestMagicBytes;
            return this;
        }

        @Override
        public Builder withTransmissionMagicBytes(byte[] aTransmissionMagicBytes) {
            this.transmissionMagicBytes = aTransmissionMagicBytes;
            return this;
        }

        @Override
        public Builder withResponseMagicBytes(byte[] aResponseMagicBytes) {
            this.responseMagicBytes = aResponseMagicBytes;
            return this;
        }

        @Override
        public Builder withRequestMagicBytes(byte[] aRequestMagicBytes) {
            this.requestMagicBytes = aRequestMagicBytes;
            return this;
        }

        @Override
        public Builder withTransmissionDismissedMagicBytes(byte[] aTransmissionDismissedMagicBytes) {
            this.transmissionDismissedMagicBytes = aTransmissionDismissedMagicBytes;
            return this;
        }

        @Override
        public Builder withRequestDismissedMagicBytes(byte[] aRequestDismissedMagicBytes) {
            this.requestDismissedMagicBytes = aRequestDismissedMagicBytes;
            return this;
        }

        @Override
        public SerialP2PTransmissionMetrics build() {
            return new SerialP2PTransmissionMetrics(this);
        }
    }
}

