/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.p2p.alt.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.p2p.AbstractP2PTail;
import org.refcodes.serial.IntArraySection;
import org.refcodes.serial.Section;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.struct.SimpleTypeTable;

public class SerialP2PTail
extends AbstractP2PTail<Integer>
implements Segment,
Segment.SegmentMixin {
    private static final long serialVersionUID = 1L;
    private static final TransmissionMetrics DEFAULT_TRANSMISSION_METRICS = new TransmissionMetrics();
    private Segment _delegatee;
    private IntArraySection _hopsSection;

    SerialP2PTail() {
        this(DEFAULT_TRANSMISSION_METRICS);
    }

    SerialP2PTail(TransmissionMetrics aTransmissionMetrics) {
        aTransmissionMetrics = aTransmissionMetrics != null ? aTransmissionMetrics : DEFAULT_TRANSMISSION_METRICS;
        this._hops = new Integer[0];
        this._hopsSection = SerialSugar.intArraySection(aTransmissionMetrics);
        this._delegatee = SerialSugar.crcSuffixSegment(SerialSugar.allocSegment(this._hopsSection, aTransmissionMetrics), aTransmissionMetrics);
    }

    @Override
    public int getLength() {
        this.updateHopsSection();
        return this._delegatee.getLength();
    }

    @Override
    public Sequence toSequence() {
        this.updateHopsSection();
        return this._delegatee.toSequence();
    }

    @Override
    public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
        this.updateHopsSection();
        this._delegatee.transmitTo(aOutputStream, aReturnStream);
    }

    @Override
    public void reset() {
        this._hops = null;
        this._hopsSection.reset();
    }

    @Override
    public SerialSchema toSchema() {
        this.updateHopsSection();
        return this._delegatee.toSchema();
    }

    @Override
    public SimpleTypeTable toSimpleTypeTable() {
        this.updateHopsSection();
        return this._delegatee.toSimpleTypeTable();
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        int theOffset = this._delegatee.fromTransmission(aSequence, aOffset);
        this.updateHops();
        return theOffset;
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException {
        this._delegatee.receiveFrom(aInputStream, aReturnStream);
        this.updateHops();
    }

    @Override
    public void appendHop(Integer aLocator) {
        super.appendHop(aLocator);
        this.updateHopsSection();
    }

    void updateHops() {
        this.setHops((int[])this._hopsSection.getPayload());
    }

    void updateHopsSection() {
        this._hopsSection.setPayload((Integer[])this.getHops());
    }

    Section getHopsSection() {
        return this._hopsSection;
    }

    void setHops(int[] aHops) {
        this._hops = SerialP2PTail.toBoxedArray(aHops);
    }

    void setHops(Integer[] aHops) {
        this._hops = aHops;
    }

    private static Integer[] toBoxedArray(int[] aValues) {
        Integer[] theValues = new Integer[aValues.length];
        for (int i = 0; i < theValues.length; ++i) {
            theValues[i] = aValues[i];
        }
        return theValues;
    }
}

