/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.p2p.alt.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.p2p.AbstractP2PMessage;
import org.refcodes.p2p.alt.serial.SerialP2PHeader;
import org.refcodes.p2p.alt.serial.SerialP2PTail;
import org.refcodes.p2p.alt.serial.SerialP2PTransmissionMetrics;
import org.refcodes.serial.AllocSectionDecoratorSegment;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.ComplexTypeSegment;
import org.refcodes.serial.CrcSegmentDecorator;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SequenceSection;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.struct.SimpleTypeTable;

public class SerialP2PMessage
extends AbstractP2PMessage<Integer, SerialP2PHeader, Sequence, SerialP2PTail>
implements Segment,
Segment.SegmentMixin {
    private static final long serialVersionUID = 1L;
    private static final SerialP2PTransmissionMetrics DEFAULT_TRANSMISSION_METRICS = new SerialP2PTransmissionMetrics();
    private Segment _delegatee;
    private transient Segment _payloadSegment;
    private SerialP2PTransmissionMetrics _transmissionMetrics;

    public SerialP2PMessage() {
        this(-1, -1, new ByteArraySequence(), DEFAULT_TRANSMISSION_METRICS);
    }

    public SerialP2PMessage(SerialP2PTransmissionMetrics aTransmissionMetrics) {
        this(-1, -1, new ByteArraySequence(), aTransmissionMetrics);
    }

    public <P> SerialP2PMessage(int aDestination, P aPayload) {
        this(-1, aDestination, aPayload, DEFAULT_TRANSMISSION_METRICS);
    }

    public <P> SerialP2PMessage(int aDestination, P aPayload, SerialP2PTransmissionMetrics aTransmissionMetrics) {
        this(-1, aDestination, SerialSugar.complexTypeSegment(aPayload, (TransmissionMetrics)aTransmissionMetrics), aTransmissionMetrics);
    }

    public <P> SerialP2PMessage(int aMagicNumber, int aDestination, P aPayload) {
        this(aMagicNumber, aDestination, SerialSugar.complexTypeSegment(aPayload, (TransmissionMetrics)DEFAULT_TRANSMISSION_METRICS), DEFAULT_TRANSMISSION_METRICS);
    }

    public <P> SerialP2PMessage(int aMagicNumber, int aDestination, P aPayload, SerialP2PTransmissionMetrics aTransmissionMetrics) {
        this(aMagicNumber, aDestination, SerialSugar.complexTypeSegment(aPayload, (TransmissionMetrics)aTransmissionMetrics), aTransmissionMetrics);
    }

    public SerialP2PMessage(int aDestination, Sequence aPayload) {
        this(-1, aDestination, aPayload, DEFAULT_TRANSMISSION_METRICS);
    }

    public SerialP2PMessage(int aMagicNumber, int aDestination, Segment aPayload) {
        this(aMagicNumber, aDestination, aPayload, DEFAULT_TRANSMISSION_METRICS);
    }

    public SerialP2PMessage(int aDestination, Segment aPayload) {
        this(-1, aDestination, aPayload, DEFAULT_TRANSMISSION_METRICS);
    }

    public SerialP2PMessage(int aMagicNumber, int aDestination, Sequence aPayload) {
        this(aMagicNumber, aDestination, aPayload, DEFAULT_TRANSMISSION_METRICS);
    }

    public SerialP2PMessage(int aDestination, Segment aPayload, SerialP2PTransmissionMetrics aTransmissionMetrics) {
        this(-1, aDestination, aPayload, aTransmissionMetrics);
    }

    public SerialP2PMessage(int aMagicNumber, int aDestination, Segment aPayload, SerialP2PTransmissionMetrics aTransmissionMetrics) {
        super(new SerialP2PHeader(aMagicNumber, aDestination, aTransmissionMetrics), aPayload.toSequence(), new SerialP2PTail());
        this._payloadSegment = aPayload;
        this._transmissionMetrics = aTransmissionMetrics != null ? aTransmissionMetrics : DEFAULT_TRANSMISSION_METRICS;
        CrcSegmentDecorator<Segment> theBodySegment = SerialSugar.crcSuffixSegment(this._payloadSegment, this._transmissionMetrics.getCrcAlgorithm());
        this._delegatee = SerialSugar.segmentComposite((Segment[])new Segment[]{(Segment)((Object)this._header), theBodySegment, (Segment)((Object)this._tail)});
    }

    public SerialP2PMessage(int aDestination, Sequence aPayload, SerialP2PTransmissionMetrics aTransmissionMetrics) {
        this(-1, aDestination, aPayload, aTransmissionMetrics);
    }

    public SerialP2PMessage(int aMagicNumber, int aDestination, Sequence aPayload, SerialP2PTransmissionMetrics aTransmissionMetrics) {
        super(new SerialP2PHeader(aMagicNumber, aDestination, aTransmissionMetrics), aPayload, new SerialP2PTail());
        AllocSectionDecoratorSegment<SequenceSection> thePayload;
        SequenceSection theSequenceSection = aPayload != null ? SerialSugar.sequenceSection(aPayload) : SerialSugar.sequenceSection();
        this._payloadSegment = thePayload = SerialSugar.allocSegment(theSequenceSection);
        this._transmissionMetrics = aTransmissionMetrics != null ? aTransmissionMetrics : DEFAULT_TRANSMISSION_METRICS;
        CrcSegmentDecorator<Segment> theBodySegment = SerialSugar.crcSuffixSegment(this._payloadSegment, this._transmissionMetrics.getCrcAlgorithm());
        this._delegatee = SerialSugar.segmentComposite((Segment[])new Segment[]{(Segment)((Object)this._header), theBodySegment, (Segment)((Object)this._tail)});
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        int theOffset = this._delegatee.fromTransmission(aSequence, aOffset);
        this._body = this._payloadSegment.toSequence();
        return theOffset;
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aFeedbackStream) throws IOException {
        this._delegatee.receiveFrom(aInputStream, aFeedbackStream);
        this._body = this._payloadSegment.toSequence();
    }

    @Override
    public Sequence toSequence() {
        return this._delegatee.toSequence();
    }

    @Override
    public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
        this._delegatee.transmitTo(aOutputStream, aReturnStream);
    }

    @Override
    public void reset() {
    }

    @Override
    public SerialSchema toSchema() {
        return this._delegatee.toSchema();
    }

    @Override
    public int getLength() {
        return this._delegatee.getLength();
    }

    @Override
    public SimpleTypeTable toSimpleTypeTable() {
        return this._delegatee.toSimpleTypeTable();
    }

    @Override
    public <P> P getPayload(Class<P> aResponseType) throws UnmarshalException {
        ComplexTypeSegment<Class<P>> thePayloadSegment = SerialSugar.complexTypeSegment(aResponseType, (TransmissionMetrics)this._transmissionMetrics);
        Sequence theSequence = null;
        try {
            theSequence = this._payloadSegment.toSequence();
            thePayloadSegment.fromTransmission(theSequence);
        }
        catch (TransmissionException e) {
            throw new UnmarshalException("Cannot unmarshal the payload " + (String)(theSequence != null ? "<" + theSequence.toHexString() + "> " : "") + "to type <" + aResponseType.getName() + ">!", e);
        }
        return (P)thePayloadSegment.getPayload();
    }
}

