/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.p2p.alt.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.mixin.MagicBytesAccessor;
import org.refcodes.mixin.MagicNumberAccessor;
import org.refcodes.p2p.AbstractP2PHeader;
import org.refcodes.p2p.alt.serial.SerialP2PTransmissionMetrics;
import org.refcodes.serial.AssertMagicBytesSegment;
import org.refcodes.serial.CrcSegmentDecorator;
import org.refcodes.serial.IntSegment;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.struct.SimpleTypeTable;

public class SerialP2PHeader
extends AbstractP2PHeader<Integer>
implements MagicNumberAccessor<Integer>,
MagicBytesAccessor,
Segment,
Segment.SegmentMixin {
    private static final long serialVersionUID = 1L;
    private static final SerialP2PTransmissionMetrics DEFAULT_TRANSMISSION_METRICS = new SerialP2PTransmissionMetrics();
    private Segment _delegatee;
    private AssertMagicBytesSegment _magicBytesSegment;
    private IntSegment _destinationSegment;
    private IntSegment _magicNumberSegment;

    SerialP2PHeader(Integer aDestination) {
        this(-1, aDestination, DEFAULT_TRANSMISSION_METRICS);
    }

    SerialP2PHeader(Integer aMagicNumber, Integer aDestination, SerialP2PTransmissionMetrics aTransmissionMetrics) {
        super(aDestination);
        aTransmissionMetrics = aTransmissionMetrics != null ? aTransmissionMetrics : DEFAULT_TRANSMISSION_METRICS;
        Segment[] segmentArray = new CrcSegmentDecorator[1];
        Segment[] segmentArray2 = new Segment.SegmentMixin[3];
        this._magicBytesSegment = SerialSugar.assertMagicBytesSegment(aTransmissionMetrics.getP2PMessageMagicBytes(), (TransmissionMetrics)aTransmissionMetrics);
        segmentArray2[0] = this._magicBytesSegment;
        this._magicNumberSegment = SerialSugar.intSegment(aMagicNumber, (TransmissionMetrics)aTransmissionMetrics);
        segmentArray2[1] = this._magicNumberSegment;
        this._destinationSegment = SerialSugar.intSegment(aDestination, (TransmissionMetrics)aTransmissionMetrics);
        segmentArray2[2] = this._destinationSegment;
        segmentArray[0] = SerialSugar.crcSegment(SerialSugar.segmentComposite((Segment[])segmentArray2), aTransmissionMetrics);
        this._delegatee = SerialSugar.segmentComposite((Segment[])segmentArray);
    }

    @Override
    public byte[] getMagicBytes() {
        return this._magicBytesSegment.getMagicBytes();
    }

    @Override
    public Integer getMagicNumber() {
        return (Integer)this._magicNumberSegment.getPayload();
    }

    @Override
    public int getLength() {
        return this._delegatee.getLength();
    }

    @Override
    public void reset() {
    }

    @Override
    public Sequence toSequence() {
        this._destinationSegment.setPayload((Integer)this._destination);
        return this._delegatee.toSequence();
    }

    @Override
    public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
        this._destinationSegment.setPayload((Integer)this._destination);
        this._delegatee.transmitTo(aOutputStream, aReturnStream);
    }

    @Override
    public SerialSchema toSchema() {
        return this._delegatee.toSchema();
    }

    @Override
    public SimpleTypeTable toSimpleTypeTable() {
        return this._delegatee.toSimpleTypeTable();
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        int theOffset = this._delegatee.fromTransmission(aSequence, aOffset);
        this._destination = this._destinationSegment.getPayload();
        return theOffset;
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException {
        this._delegatee.receiveFrom(aInputStream, aReturnStream);
        this._destination = this._destinationSegment.getPayload();
    }
}

