/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.p2p;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.refcodes.p2p.NoSuchDestinationException;
import org.refcodes.p2p.P2PHeader;
import org.refcodes.p2p.P2PMessage;
import org.refcodes.p2p.P2PMessageConsumer;
import org.refcodes.p2p.P2PTail;
import org.refcodes.p2p.Peer;
import org.refcodes.p2p.PeerRouter;

public abstract class AbstractPeer<LOCATOR, HEADER extends P2PHeader<LOCATOR>, TAIL extends P2PTail<LOCATOR>, MSG extends P2PMessage<LOCATOR, HEADER, ?, TAIL>, CONSUMER extends P2PMessageConsumer<MSG, PEER>, PEER extends Peer<LOCATOR, HEADER, TAIL, MSG, ROUTER>, ROUTER extends PeerRouter<LOCATOR, HEADER, TAIL, MSG>>
implements Peer<LOCATOR, HEADER, TAIL, MSG, ROUTER> {
    protected LOCATOR _locator;
    protected Set<ROUTER> _peerRouter = new HashSet<ROUTER>();
    protected CONSUMER _messageConsumer = null;

    public AbstractPeer(LOCATOR aLocator, CONSUMER aMessageConsumer) {
        this._locator = aLocator;
        this._messageConsumer = aMessageConsumer;
    }

    @Override
    public LOCATOR getLocator() {
        return this._locator;
    }

    @Override
    public int getHopCount(LOCATOR aDestination, LOCATOR[] aTrail) throws IOException {
        if (this.getLocator().equals(aDestination)) {
            return 0;
        }
        HashSet<LOCATOR> thePeerIdTrail = null;
        if (aTrail != null && aTrail.length != 0) {
            for (LOCATOR anATrail : aTrail) {
                if (!this.getLocator().equals(anATrail)) continue;
                return -1;
            }
            thePeerIdTrail = new HashSet<LOCATOR>();
            thePeerIdTrail.addAll(Arrays.asList(aTrail));
        }
        int theMinHopCount = -1;
        if (thePeerIdTrail == null || !thePeerIdTrail.contains(this.getLocator())) {
            for (PeerRouter eRouter : this._peerRouter) {
                int eHopCount = eRouter.getHopCount(aDestination, this.appendHop(this.getLocator(), aTrail));
                if (theMinHopCount != -1 && (eHopCount == -1 || eHopCount >= theMinHopCount)) continue;
                theMinHopCount = eHopCount;
            }
        }
        return theMinHopCount != -1 ? theMinHopCount + 1 : -1;
    }

    @Override
    public Set<ROUTER> peerRouters() {
        return this._peerRouter;
    }

    @Override
    public boolean addPeerRouter(ROUTER aPeerRouter) {
        return this._peerRouter.add(aPeerRouter);
    }

    @Override
    public boolean removePeerRouter(ROUTER aPeerRouter) {
        return this._peerRouter.remove(aPeerRouter);
    }

    @Override
    public void sendMessage(MSG aMessage) throws NoSuchDestinationException, IOException {
        ((P2PTail)aMessage.getTail()).appendHop(this.getLocator());
        if (((P2PHeader)aMessage.getHeader()).getDestination().equals(this.getLocator())) {
            if (this._messageConsumer != null) {
                this._messageConsumer.onP2PMessage(aMessage, (AbstractPeer)this);
            }
        } else {
            int theMinHopCount = -1;
            ArrayList<PeerRouter> theTargetProxies = new ArrayList<PeerRouter>();
            for (PeerRouter eRouter : this._peerRouter) {
                int eHopCount = eRouter.getHopCount(((P2PHeader)aMessage.getHeader()).getDestination(), ((P2PTail)aMessage.getTail()).getHops());
                if (eHopCount == -1) continue;
                if (theMinHopCount == -1 || eHopCount < theMinHopCount) {
                    theTargetProxies.clear();
                    theTargetProxies.add(eRouter);
                    theMinHopCount = eHopCount;
                    continue;
                }
                if (theMinHopCount != eHopCount) continue;
                theTargetProxies.add(eRouter);
            }
            if (theTargetProxies.size() > 0) {
                Collections.shuffle(theTargetProxies);
                ((PeerRouter)theTargetProxies.get(0)).sendMessage(aMessage);
            } else {
                throw new NoSuchDestinationException("Cannot dispatch the message <" + aMessage.toString() + "> to destination <" + String.valueOf(((P2PHeader)aMessage.getHeader()).getDestination()) + ">!", ((P2PHeader)aMessage.getHeader()).getDestination());
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + String.valueOf(this._locator) + "]";
    }

    private LOCATOR[] appendHop(LOCATOR aLocator, LOCATOR[] aIdTrail) {
        Object[] theIdTrail = (Object[])Array.newInstance(aLocator.getClass(), aIdTrail.length + 1);
        theIdTrail[theIdTrail.length - 1] = aLocator;
        for (int i = 0; i < aIdTrail.length; ++i) {
            theIdTrail[i] = aIdTrail[i];
        }
        return theIdTrail;
    }
}

