/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.matcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.refcodes.data.Delimiter;
import org.refcodes.internal.PathPattern;
import org.refcodes.matcher.AbstractWildcardMatcher;
import org.refcodes.matcher.MatcherSchema;
import org.refcodes.matcher.WildcardMatcher;
import org.refcodes.mixin.DelimiterAccessor;
import org.refcodes.mixin.WildcardSubstitutes;

public class PathMatcher
extends AbstractWildcardMatcher<String>
implements WildcardMatcher,
DelimiterAccessor {
    private static final String DELIMITER = "DELIMITER";
    private static final String PATH_PATTERN = "PATH_PATTERN";
    private final Pattern _matchee;
    private final String _pathPattern;
    private final String[] _wildcardNames;
    private final char _delimiter;

    public PathMatcher(String aPathPattern) {
        this(aPathPattern, Delimiter.PATH.getChar());
    }

    public PathMatcher(String aPathPattern, char aDelimiter) {
        super("Matches a path against an ant path pattern (ANT).");
        this._delimiter = aDelimiter;
        this._pathPattern = aPathPattern;
        PathPattern theWildcardPattern = new PathPattern(aPathPattern, aDelimiter);
        this._matchee = theWildcardPattern.getPattern();
        this._wildcardNames = theWildcardPattern.getWildcardNames();
    }

    @Override
    public String[] getWildcardNames() {
        return this._wildcardNames;
    }

    public String getPathPattern() {
        return this._pathPattern;
    }

    @Override
    public boolean isMatching(String aPath) {
        return this._matchee.matcher(aPath).matches();
    }

    @Override
    public WildcardSubstitutes toWildcardSubstitutes(String aPath) {
        Matcher theMatcher = this._matchee.matcher(aPath);
        if (!theMatcher.matches()) {
            return null;
        }
        ArrayList<String> theWildcardSubstitutes = new ArrayList<String>();
        for (int i = 0; i < theMatcher.groupCount(); ++i) {
            theWildcardSubstitutes.add(theMatcher.group(i + 1));
        }
        String[] theWildcardReplacements = theWildcardSubstitutes.toArray(new String[theWildcardSubstitutes.size()]);
        HashMap<String, String> theNamedWildcardSubstitutes = null;
        if (this._wildcardNames != null) {
            theNamedWildcardSubstitutes = new HashMap<String, String>();
            for (String eName : this._wildcardNames) {
                theNamedWildcardSubstitutes.put(eName, theMatcher.group(eName));
            }
        }
        return new AbstractWildcardMatcher.WildcardMatcherSubstitutes(theWildcardReplacements, theNamedWildcardSubstitutes);
    }

    @Override
    public String[] toWildcardReplacements(String aPath) {
        Matcher theMatcher = this._matchee.matcher(aPath);
        if (!theMatcher.matches()) {
            return null;
        }
        ArrayList<String> theWildcardSubstitutes = new ArrayList<String>();
        for (int i = 0; i < theMatcher.groupCount(); ++i) {
            theWildcardSubstitutes.add(theMatcher.group(i + 1));
        }
        return theWildcardSubstitutes.toArray(new String[theWildcardSubstitutes.size()]);
    }

    @Override
    public String toWildcardReplacementAt(String aPath, int aIndex) {
        Matcher theMatcher = this._matchee.matcher(aPath);
        if (!theMatcher.matches()) {
            return null;
        }
        if (aIndex < theMatcher.groupCount()) {
            return theMatcher.group(aIndex + 1);
        }
        throw new IllegalArgumentException("Your provided index <" + aIndex + "> exceeds the number if wildcards <" + theMatcher.groupCount() + "> defined in your pattern \"" + this.getPathPattern() + "\" for current path \"" + aPath + "\".");
    }

    @Override
    public String[] toWildcardReplacementsAt(String aPath, int ... aIndexes) {
        Matcher theMatcher = this._matchee.matcher(aPath);
        if (!theMatcher.matches()) {
            return null;
        }
        if (aIndexes == null || aIndexes.length == 0) {
            return new String[0];
        }
        ArrayList<String> theWildcardSubstitutes = new ArrayList<String>();
        for (int i : aIndexes) {
            if (i >= theMatcher.groupCount()) {
                throw new IllegalArgumentException("Your provided index <" + i + "> exceeds the number of wildcards <" + theMatcher.groupCount() + "> defined in your pattern \"" + this.getPathPattern() + "\" for current path \"" + aPath + "\".");
            }
            theWildcardSubstitutes.add(theMatcher.group(i + 1));
        }
        return theWildcardSubstitutes.toArray(new String[theWildcardSubstitutes.size()]);
    }

    @Override
    public String toWildcardReplacement(String aPath, String aWildcardName) {
        Matcher theMatcher = this._matchee.matcher(aPath);
        if (!theMatcher.matches()) {
            return null;
        }
        try {
            return theMatcher.group(aWildcardName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Your provided name <" + aWildcardName + "> is not defined in your pattern \"" + this.getPathPattern() + "\" for current path \"" + aPath + "\".", e);
        }
    }

    @Override
    public String[] toWildcardReplacements(String aPath, String ... aWildcardNames) {
        Matcher theMatcher = this._matchee.matcher(aPath);
        if (!theMatcher.matches()) {
            return null;
        }
        if (aWildcardNames == null || aWildcardNames.length == 0) {
            return new String[0];
        }
        ArrayList<String> theWildcardSubstitutes = new ArrayList<String>();
        for (String eWildcardName : aWildcardNames) {
            try {
                theWildcardSubstitutes.add(theMatcher.group(eWildcardName));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Your provided name <" + eWildcardName + "> is not defined in your pattern \"" + this.getPathPattern() + "\" for current path \"" + aPath + "\".", e);
            }
        }
        return theWildcardSubstitutes.toArray(new String[theWildcardSubstitutes.size()]);
    }

    public String toPattern() {
        return this._matchee.pattern();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._matchee == null ? 0 : this._matchee.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathMatcher other = (PathMatcher)obj;
        return !(this._matchee == null ? other._matchee != null : !this._matchee.equals(other._matchee));
    }

    @Override
    public char getDelimiter() {
        return this._delimiter;
    }

    @Override
    public MatcherSchema toSchema() {
        MatcherSchema theSchema = super.toSchema();
        theSchema.put("REGEX_PATTERN", this._matchee);
        theSchema.put(DELIMITER, Character.valueOf(this._delimiter));
        theSchema.put(PATH_PATTERN, this._pathPattern);
        theSchema.put("WILDCARD_NAMES", this._wildcardNames);
        return theSchema;
    }
}

