/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.controlflow;

import java.util.concurrent.atomic.AtomicInteger;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.exception.Exceptional;
import org.refcodes.mixin.Disposable;
import org.refcodes.mixin.Releaseable;

public class ExceptionWatchdog<E extends Exception>
implements Exceptional<E>,
Disposable,
Releaseable {
    AtomicInteger _threadCount = new AtomicInteger(0);
    private E _exception = null;
    private E _lastException = null;
    boolean _isDisposed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void catchException() throws E {
        ControlFlowUtility.throwIllegalStateException(this._isDisposed);
        ExceptionWatchdog exceptionWatchdog = this;
        synchronized (exceptionWatchdog) {
            this.waitForExceptionHandling();
            this._threadCount.incrementAndGet();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        E theException = this._exception;
        this._threadCount.decrementAndGet();
        if (theException == null) {
            return;
        }
        if (this._threadCount.get() == 0) {
            this._exception = null;
        }
        throw theException;
    }

    @Override
    public E lastException() {
        ControlFlowUtility.throwIllegalStateException(this._isDisposed);
        return this._lastException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throwException(E aException) {
        ControlFlowUtility.throwIllegalStateException(this._isDisposed);
        this._exception = aException;
        ExceptionWatchdog exceptionWatchdog = this;
        synchronized (exceptionWatchdog) {
            this.notifyAll();
        }
        this.waitForExceptionHandling();
        this._lastException = aException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseAll() {
        ControlFlowUtility.throwIllegalStateException(this._isDisposed);
        this._exception = null;
        ExceptionWatchdog exceptionWatchdog = this;
        synchronized (exceptionWatchdog) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this._isDisposed = true;
        this._exception = null;
        ExceptionWatchdog exceptionWatchdog = this;
        synchronized (exceptionWatchdog) {
            this.notifyAll();
            try {
                this.wait(SleepLoopTime.MAX.getTimeMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.notifyAll();
        }
    }

    private void waitForExceptionHandling() {
        long theStartTime = System.currentTimeMillis();
        while (this._threadCount.get() > 0 && this._exception != null && System.currentTimeMillis() - theStartTime < (long)SleepLoopTime.NORM.getTimeMillis()) {
            try {
                Thread.sleep(SleepLoopTime.MIN.getTimeMillis());
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

