/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.playload;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.refcodes.archetype.C2Helper;
import org.refcodes.archetype.CliHelper;
import org.refcodes.cli.ArrayOption;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CleanFlag;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.ConfigOption;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Example;
import org.refcodes.cli.Flag;
import org.refcodes.cli.ForceFlag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.InitFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.QuietFlag;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.data.Literal;
import org.refcodes.data.Scheme;
import org.refcodes.exception.BugException;
import org.refcodes.exception.Trap;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.net.PortManagerSingleton;
import org.refcodes.p2p.NoSuchDestinationException;
import org.refcodes.p2p.alt.serial.AcknowledgeMode;
import org.refcodes.p2p.alt.serial.SerialP2PHeader;
import org.refcodes.p2p.alt.serial.SerialP2PMessage;
import org.refcodes.p2p.alt.serial.SerialP2PMessageConsumer;
import org.refcodes.p2p.alt.serial.SerialP2PTail;
import org.refcodes.p2p.alt.serial.SerialP2PTransmissionMetrics;
import org.refcodes.p2p.alt.serial.SerialPeer;
import org.refcodes.properties.ImmutableProperties;
import org.refcodes.properties.MapProperties;
import org.refcodes.properties.ext.application.ApplicationProperties;
import org.refcodes.rest.JdkHttpRestClient;
import org.refcodes.rest.JdkHttpRestServer;
import org.refcodes.rest.RestRequestConsumer;
import org.refcodes.rest.RestRequestEvent;
import org.refcodes.rest.RestResponse;
import org.refcodes.runtime.Execution;
import org.refcodes.serial.alt.tty.Parity;
import org.refcodes.serial.alt.tty.StopBits;
import org.refcodes.serial.alt.tty.TtyPort;
import org.refcodes.serial.alt.tty.TtyPortHubSingleton;
import org.refcodes.serial.alt.tty.TtyPortMetrics;
import org.refcodes.serial.ext.handshake.HandshakeTransmissionMetrics;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.HttpServerResponse;
import org.refcodes.web.HttpStatusCode;
import org.refcodes.web.HttpStatusException;
import org.refcodes.web.InternalServerErrorException;
import org.refcodes.web.MediaType;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.UrlBuilder;

public class Main {
    private static final RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final int DEFAULT_DATA_BITS = 8;
    private static final int DEFAULT_BAUD_RATE = 9600;
    private static final String TITLE = "<PLA\u03a8L0AD>";
    private static final String NAME = "playload";
    private static final String DEFAULT_CONFIG = "playload.ini";
    private static final String DESCRIPTION = "Peer-to-Peer (P2P) command line transport system for exchanging messages between participating parties (peers) over serial TTY (COM) ports.";
    private static final String LICENSE_NOTE = "You may choose between the LGPL v3.0 or later and the Apache License v2.0 when using this software";
    private static final String COPYRIGHT = "Copyright (c) by CLUB.FUNCODES | See [https://www.metacodes.pro/manpages/teletype_manpage]";
    private static final char[] BANNER_PALETTE = AsciiColorPalette.MAX_LEVEL_GRAY.getPalette();
    private static final Font BANNER_FONT = new Font(FontFamily.DIALOG, FontStyle.BOLD);
    private static final String MESSAGE_PROPERTY = "message";
    private static final String ATTACH_PROPERTY = "attach";
    private static final String FORWARD_PROPERTY = "forward";
    private static final String LOCATOR_PROPERTY = "locator";
    private static final String SOURCE_PROPERTY = "source";
    private static final String DESTINATION_PROPERTY = "destination";
    private static final String ACKNOWLEDGE_MODE_PROPERTY = "peers/acknowledge/mode";
    private static final String ACKNOWLEDGE_RETRY_NUMBER_PROPERTY = "peers/acknowledge/retryNumber";
    private static final String ACKNOWLEDGE_TIMEOUTIN_PROPERTY = "peers/acknowledge/timeoutInMs";
    private static final String REPLY_RETRY_NUMBER_PROPERTY = "peers/reply/retryNumber";
    private static final String REPLY_TIMEOUTIN_PROPERTY = "peers/reply/timeoutInMs";
    private static final String STOP_BITS_PROPERTY = "peers/ports/stopBits";
    private static final String PARITY_PROPERTY = "peers/ports/parity";
    private static final String DATA_BITS_PROPERTY = "peers/ports/dataBits";
    private static final String BAUD_PROPERTY = "peers/ports/baud";
    private static final String PORTS_PROPERTY = "peers/ports";
    private static final String PORTS_PATTERN_PROPERTY = "peers/ports/pattern";
    private static final String PORTS_COUNT_PROPERTY = "peers/ports/count";
    private static final String LIST_PROPERTY = "list";
    private static final int MAX_OPEN_FORWARD_DAEMON_RETRY_COUNT = 5;
    private static final String C2_FORWARD_ENDPOINT = "/forward";
    private static final String C2_PORT_PROPERTY = "port";
    private static final String DESTINATION_QUERY_FIELD = "destination";
    private static C2Helper _c2Helper = null;

    public static void main(String[] args) {
        block16: {
            Flag theListPortsFlag = CliSugar.flag(Character.valueOf('l'), LIST_PROPERTY, LIST_PROPERTY, "List all detected TTY (COM) serial ports.");
            ArrayOption<String> theTtyPortsArg = CliSugar.asArray(CliSugar.stringOption(Character.valueOf('p'), C2_PORT_PROPERTY, PORTS_PROPERTY, "The COM (serial) port(s) to attach."));
            IntOption theBaudArg = CliSugar.intOption(Character.valueOf('b'), "baud", BAUD_PROPERTY, "The baud rate to use for the TTY (COM) serial port(s).");
            IntOption theDataBitsArg = CliSugar.intOption("data-bits", DATA_BITS_PROPERTY, "The data bits to use for the TTY (COM) serial port(s) (usually a value of 7 or 8).");
            IntOption thePortsCountArg = CliSugar.intOption("count", PORTS_COUNT_PROPERTY, "The number of ports to bind (if omitted, all according ports are bound).");
            EnumOption<AcknowledgeMode> theAckModeArg = CliSugar.enumOption("ack", AcknowledgeMode.class, ACKNOWLEDGE_MODE_PROPERTY, "The acknowledge mode to use for transmissions: " + VerboseTextBuilder.asString(AcknowledgeMode.values()));
            EnumOption<Parity> theParityArg = CliSugar.enumOption("parity", Parity.class, PARITY_PROPERTY, "The parity to use for the TTY (COM) serial port(s): " + VerboseTextBuilder.asString((Object[])Parity.values()));
            EnumOption<StopBits> theStopBitsArg = CliSugar.enumOption("stop-bits", StopBits.class, STOP_BITS_PROPERTY, "The stop bits to use for the TTY (COM) serial port(s): " + VerboseTextBuilder.asString((Object[])StopBits.values()));
            IntOption theLocatorArg = CliSugar.intOption(Character.valueOf('L'), LOCATOR_PROPERTY, LOCATOR_PROPERTY, "The locator ID of the peer.");
            IntOption theSrcArg = CliSugar.intOption(Character.valueOf('s'), SOURCE_PROPERTY, SOURCE_PROPERTY, "The locator ID of the source peer.");
            IntOption theDestArg = CliSugar.intOption(Character.valueOf('d'), "destination", "destination", "The locator ID of the destination peer.");
            StringOption thePortsPatternArg = CliSugar.stringOption("pattern", PORTS_PATTERN_PROPERTY, "The name pattern for the ports to bind (\"*\"=any characters, \"?\"=one character).");
            StringOption theMessageArg = CliSugar.stringOption(Character.valueOf('m'), MESSAGE_PROPERTY, MESSAGE_PROPERTY, "The message to be sent.");
            ConfigOption theConfigArg = CliSugar.configOption();
            Flag theForwardFlag = CliSugar.flag(Character.valueOf('f'), FORWARD_PROPERTY, FORWARD_PROPERTY, "Forward a request to the P2P network.");
            Flag theAttachFlag = CliSugar.flag(Character.valueOf('a'), ATTACH_PROPERTY, ATTACH_PROPERTY, "Attach peer to P2P network.");
            SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag(false);
            HelpFlag theHelpFlag = CliSugar.helpFlag();
            QuietFlag theQuietFlag = CliSugar.quietFlag();
            DebugFlag theDebugFlag = CliSugar.debugFlag();
            ForceFlag theForceFlag = CliSugar.forceFlag(false);
            InitFlag theInitFlag = CliSugar.initFlag(false);
            CleanFlag theCleanFlag = CliSugar.cleanFlag(false);
            CasesCondition theArgsSyntax = CliSugar.cases(CliSugar.and(theListPortsFlag, CliSugar.any(theQuietFlag, theDebugFlag)), CliSugar.and(theAttachFlag, CliSugar.any(theLocatorArg, theConfigArg, CliSugar.xor(theTtyPortsArg, CliSugar.and(thePortsPatternArg, CliSugar.any(thePortsCountArg))), theBaudArg, theDataBitsArg, theStopBitsArg, theParityArg, theAckModeArg, theQuietFlag, theDebugFlag, theForceFlag)), CliSugar.and(theForwardFlag, theSrcArg, theDestArg, theMessageArg, CliSugar.any(theQuietFlag, theDebugFlag, theForceFlag)), CliSugar.and(theInitFlag, CliSugar.optional(theConfigArg, theQuietFlag)), CliSugar.and(theLocatorArg, theCleanFlag, CliSugar.any(theQuietFlag, theDebugFlag)), CliSugar.xor(theHelpFlag, CliSugar.and(theSysInfoFlag, CliSugar.any(theQuietFlag))));
            Example[] theExamples = CliSugar.examples(CliSugar.example("List all available TTY (COM) ports", theListPortsFlag), CliSugar.example("Attach peer to P2P network on given ports", theAttachFlag, theLocatorArg, theTtyPortsArg), CliSugar.example("Attach peer to P2P network on specified ports", theAttachFlag, theLocatorArg, thePortsPatternArg), CliSugar.example("Attach peer to P2P network using the given config", theAttachFlag, theConfigArg), CliSugar.example("Forward data to P2P network", theSrcArg, theDestArg, theForwardFlag, theMessageArg), CliSugar.example("Initialize default config file", theInitFlag), CliSugar.example("Initialize specific config file", theInitFlag, theConfigArg), CliSugar.example("Clean the peer's lock file", theCleanFlag, theLocatorArg), CliSugar.example("To show the help text", theHelpFlag), CliSugar.example("To print the system info", theSysInfoFlag));
            CliHelper theCliHelper = ((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)CliHelper.builder().withArgs(args)).withArgsSyntax(theArgsSyntax)).withExamples(theExamples)).withFilePath(DEFAULT_CONFIG)).withResourceClass((Class)Main.class)).withName(NAME)).withTitle(TITLE)).withDescription(DESCRIPTION)).withLicense(LICENSE_NOTE)).withCopyright(COPYRIGHT)).withBannerFont(BANNER_FONT)).withBannerFontPalette(BANNER_PALETTE)).withLogger(LOGGER)).build();
            ApplicationProperties theArgsProperties = theCliHelper.getApplicationProperties();
            boolean isDebug = theArgsProperties.getBoolean((Object)theDebugFlag);
            boolean isForce = theArgsProperties.getBoolean((Object)theForceFlag);
            boolean isVerbose = theCliHelper.isVerbose();
            if (!isVerbose) {
                Execution.setJulLoggingStreams(System.out, System.err, Level.WARNING);
            }
            try {
                if (theListPortsFlag.isEnabled()) {
                    Main.listSerialPorts(isVerbose);
                    break block16;
                }
                if (theAttachFlag.isEnabled() || theForwardFlag.isEnabled() || theCleanFlag.isEnabled()) {
                    int theLocator = theArgsProperties.getInt((Object)(theForwardFlag.isEnabled() ? theSrcArg : theLocatorArg));
                    _c2Helper = C2Helper.builder().withInstanceAlias(Integer.toString(theLocator)).withResourceClass(Main.class).withLogger(LOGGER).withVerbose(isVerbose).withForce(isForce).build();
                    if (theAttachFlag.isEnabled()) {
                        int thePort;
                        Integer thePort2;
                        if (isVerbose) {
                            LOGGER.printSeparator();
                            LOGGER.info("Attaching peer <" + theLocator + ">...");
                        }
                        int theBaudRate = theArgsProperties.getIntOr(theBaudArg, (Integer)9600);
                        int theDataBits = theArgsProperties.getIntOr(theDataBitsArg, (Integer)8);
                        Parity theParity = theArgsProperties.getEnumOr(theParityArg, Parity.NONE);
                        StopBits theStopBits = theArgsProperties.getEnumOr(theStopBitsArg, StopBits.AUTO);
                        AcknowledgeMode theAckMode = theArgsProperties.getEnumOr(theAckModeArg, AcknowledgeMode.ON);
                        int theAckRetryNumber = theArgsProperties.getIntOr(ACKNOWLEDGE_RETRY_NUMBER_PROPERTY, (Integer)HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER);
                        long theAckTimeout = theArgsProperties.getLongOr(ACKNOWLEDGE_TIMEOUTIN_PROPERTY, (Long)HandshakeTransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS);
                        int theReplyRetryNumber = theArgsProperties.getIntOr(REPLY_RETRY_NUMBER_PROPERTY, (Integer)HandshakeTransmissionMetrics.DEFAULT_REPLY_RETRY_NUMBER);
                        long theReplyTimeout = theArgsProperties.getLongOr(REPLY_TIMEOUTIN_PROPERTY, (Long)HandshakeTransmissionMetrics.DEFAULT_REPLY_TIMEOUT_IN_MS);
                        String[] thePortNames = (String[])theArgsProperties.getArrayOr(theTtyPortsArg, null);
                        String thePortsPattern = theArgsProperties.getString((Object)thePortsPatternArg);
                        int thePortsCount = theArgsProperties.getIntOr(thePortsCountArg, (Integer)-1);
                        if (thePortsCount != -1 && thePortsCount <= 0) {
                            throw new IllegalArgumentException("The ports count <" + thePortsCount + "> property <peers/ports/count> must be greater than <0>!");
                        }
                        TtyPortMetrics thePortMetrics = TtyPortMetrics.builder().withBaudRate(theBaudRate).withDataBits(theDataBits).withParity(theParity).withStopBits(theStopBits).build();
                        TtyPort[] theTtyPorts = thePortNames != null && thePortNames.length != 0 ? Main.toTtyPorts(thePortNames, thePortMetrics, isVerbose) : Main.toTtyPorts(thePortsPattern, thePortsCount, thePortMetrics, isVerbose);
                        SerialP2PTransmissionMetrics theTransmissionMetrics = SerialP2PTransmissionMetrics.builder().withAcknowledgeMode(theAckMode).withAcknowledgeRetryNumber(theAckRetryNumber).withAcknowledgeTimeoutMillis(theAckTimeout).withReplyRetryNumber(theReplyRetryNumber).withReplyTimeoutMillis(theReplyTimeout).build();
                        if (isVerbose) {
                            LOGGER.printSeparator();
                            LOGGER.info("The transmission acknowledge mode is set to <" + String.valueOf(theTransmissionMetrics.getAcknowledgeMode()) + ">...");
                            LOGGER.info("Applying <" + theTransmissionMetrics.getReplyTimeoutMillis() + "> ms reply timeout each for a total of <" + theTransmissionMetrics.getReplyRetryNumber() + "> retries...");
                            if (theTransmissionMetrics.getAcknowledgeMode() == AcknowledgeMode.ON) {
                                LOGGER.info("Applying <" + theTransmissionMetrics.getAcknowledgeTimeoutMillis() + "> ms acknowledge timeout each for a total of <" + theTransmissionMetrics.getAcknowledgeRetryNumber() + "> retries...");
                            }
                        }
                        SerialPeer thePeer = new SerialPeer((Integer)theLocator, (SerialP2PMessageConsumer)new LoggingMessageConsumer(isVerbose, isDebug), theTransmissionMetrics, theTtyPorts);
                        ImmutableProperties theImmutableProperties = _c2Helper.readLockFile(isVerbose);
                        if (theImmutableProperties != null && (thePort2 = theImmutableProperties.getInt(C2_PORT_PROPERTY)) != null && !PortManagerSingleton.getInstance().isPortAvaialble(thePort2)) {
                            throw new IllegalStateException("Cannot start daemon as the port <" + thePort2 + "> reserved by the lockfile is already in use!");
                        }
                        JdkHttpRestServer theRestServer = null;
                        int count = 1;
                        do {
                            block17: {
                                thePort = PortManagerSingleton.getInstance().bindAnyPort();
                                try {
                                    theRestServer = new JdkHttpRestServer().withOpen(thePort);
                                }
                                catch (IOException e) {
                                    if (count <= 5) break block17;
                                    throw e;
                                }
                            }
                            ++count;
                        } while (theRestServer == null);
                        _c2Helper.writeLockFile((ImmutableProperties)((Object)new MapProperties().withPutInt(C2_PORT_PROPERTY, (Integer)thePort)), isVerbose);
                        theRestServer.onPost(Main.toForwardHttpEndpoint(), (RestRequestConsumer)new MessageRequestConsumer(thePeer, isVerbose, isDebug)).open();
                        break block16;
                    }
                    if (theForwardFlag.isEnabled()) {
                        int theDestination = theArgsProperties.getInt((Object)theDestArg);
                        String theMessage = (String)theArgsProperties.get((Object)theMessageArg);
                        Main.forwardMessage(theLocator, theDestination, theMessage, isVerbose, isDebug);
                        break block16;
                    }
                    if (theCleanFlag.isEnabled()) {
                        _c2Helper.deleteLockFile(isVerbose);
                        break block16;
                    }
                    throw new BugException("We should never end up here, please check your command line args!");
                }
                throw new BugException("We should never end up here, please check your command line args!");
            }
            catch (Throwable e) {
                theCliHelper.exitOnException(e);
            }
        }
    }

    protected static TtyPort[] toTtyPorts(String[] aPortNames, TtyPortMetrics aPortMetrics, boolean isVerbose) throws IOException {
        TtyPort[] theTtyPorts = new TtyPort[aPortNames.length];
        if (isVerbose) {
            LOGGER.printSeparator();
            LOGGER.info("Initializing ports with <" + aPortMetrics.getBaudRate() + "> baud, <" + aPortMetrics.getDataBits() + "> data bits, <" + String.valueOf((Object)aPortMetrics.getStopBits()) + "> stop bits and parity <" + String.valueOf((Object)aPortMetrics.getParity()) + ">...");
        }
        for (int i = 0; i < theTtyPorts.length; ++i) {
            if (isVerbose) {
                LOGGER.printSeparator();
                LOGGER.info("Binding port <" + aPortNames[i] + ">...");
            }
            theTtyPorts[i] = ((TtyPort)TtyPortHubSingleton.getInstance().toPort(aPortNames[i])).withOpen(aPortMetrics);
        }
        return theTtyPorts;
    }

    protected static TtyPort[] toTtyPorts(String aPortsPattern, int aPortsCount, TtyPortMetrics aPortMetrics, boolean isVerbose) throws IOException {
        String thePortsPatternMessage;
        String thePortsPattern;
        ArrayList<TtyPort> theTtyPorts = new ArrayList<TtyPort>();
        String string = thePortsPattern = aPortsPattern != null ? aPortsPattern.replace("*", ".*").replace("?", ".") : null;
        if (isVerbose) {
            LOGGER.printSeparator();
            LOGGER.info("Initializing ports with <" + aPortMetrics.getBaudRate() + "> baud, <" + aPortMetrics.getDataBits() + "> data bits, <" + String.valueOf((Object)aPortMetrics.getStopBits()) + "> stop bits and parity <" + String.valueOf((Object)aPortMetrics.getParity()) + ">...");
        }
        for (TtyPort ePort : TtyPortHubSingleton.getInstance().ports()) {
            String ePortName = ePort.getAlias();
            try {
                if (isVerbose) {
                    LOGGER.printSeparator();
                }
                if (thePortsPattern != null && thePortsPattern.length() != 0) {
                    if (ePortName.matches(thePortsPattern)) {
                        theTtyPorts.add(ePort.withOpen(aPortMetrics));
                    }
                    if (isVerbose) {
                        LOGGER.info("Binding port <" + ePortName + ">...");
                    }
                } else {
                    theTtyPorts.add(ePort.withOpen(aPortMetrics));
                    if (isVerbose) {
                        LOGGER.info("Binding port <" + ePortName + ">...");
                    }
                }
                if (aPortsCount == -1 || theTtyPorts.size() != aPortsCount) continue;
                break;
            }
            catch (IOException e) {
                if (!isVerbose) continue;
                LOGGER.warn("Skipping port <" + ePortName + "> (probably already bound) as of: " + Trap.asMessage(e));
            }
        }
        if (theTtyPorts.isEmpty()) {
            thePortsPatternMessage = aPortsPattern != null && aPortsPattern.length() != 0 ? "ports pattern \"" + aPortsPattern + "\" property <peers/ports/pattern> " : "";
            Object thePortsCountMessage = aPortsCount != -1 ? "ports count <" + aPortsCount + "> property <peers/ports/count> " : "";
            throw new IllegalArgumentException("No ports found for the provided " + thePortsPatternMessage + (thePortsPatternMessage != null && thePortsCountMessage != null ? "and " : "") + (String)thePortsCountMessage + "arguments!");
        }
        if (aPortsCount != -1 && theTtyPorts.size() != aPortsCount) {
            thePortsPatternMessage = aPortsPattern != null && aPortsPattern.length() != 0 ? "ports pattern \"" + aPortsPattern + "\" property <peers/ports/pattern> " : "";
            Object thePortsCountMessage = aPortsCount != -1 ? "ports count <" + aPortsCount + "> property <peers/ports/count> " : "";
            throw new IllegalArgumentException("Only found <" + theTtyPorts.size() + "> ports for the provided " + thePortsPatternMessage + (thePortsPatternMessage != null && thePortsCountMessage != null ? "and " : "") + (String)thePortsCountMessage + "arguments!");
        }
        return theTtyPorts.toArray(new TtyPort[theTtyPorts.size()]);
    }

    private static void listSerialPorts(boolean isVerbose) throws IOException {
        TtyPort[] thePorts = TtyPortHubSingleton.getInstance().ports();
        if (isVerbose) {
            if (thePorts.length != 0) {
                int theMaxWidth = 0;
                for (TtyPort ePort : thePorts) {
                    int eWidth = ePort.getAlias().length();
                    if (theMaxWidth >= eWidth) continue;
                    theMaxWidth = eWidth;
                }
                HorizAlignTextBuilder theBuilder = new HorizAlignTextBuilder().withColumnWidth(theMaxWidth);
                for (TtyPort ePort : thePorts) {
                    LOGGER.info("[" + theBuilder.toString(new String[]{ePort.getAlias()}) + "] " + ePort.getName() + ": \"" + ePort.getDescription() + "\" (" + ePort.getPortMetrics().getBaudRate() + " baud)");
                }
            } else {
                LOGGER.info("No serial (COM) ports found.");
            }
        } else {
            for (TtyPort ePort : thePorts) {
                System.out.println(ePort.getAlias() + "\t" + ePort.getPortMetrics().getBaudRate() + " baud\t" + ePort.getDescription() + "\t" + ePort.getName());
            }
        }
    }

    protected static void forwardMessage(int aSource, int aDestination, String aMessage, boolean isVerbose, boolean isDebug) throws IOException, ParseException, HttpStatusException {
        ImmutableProperties theLockProperties = _c2Helper.readLockFile(isVerbose);
        if (theLockProperties != null) {
            int thePort = theLockProperties.getInt(C2_PORT_PROPERTY);
            if (PortManagerSingleton.getInstance().isPortBound(thePort)) {
                if (isVerbose) {
                    LOGGER.printSeparator();
                    LOGGER.info("Forwarding \"" + aMessage + "\" from peer <" + aSource + "> to peer <" + aDestination + ">...");
                }
                JdkHttpRestClient theClient = new JdkHttpRestClient().withBaseUrl(Scheme.HTTP, Literal.LOCALHOST.getValue(), thePort);
                UrlBuilder theUrl = new UrlBuilder(Main.toForwardHttpEndpoint());
                theUrl.getQueryFields().put("destination", Integer.toString(aDestination));
                RequestHeaderFields theHeadeFields = new RequestHeaderFields();
                theHeadeFields.putContentType(MediaType.TEXT_PLAIN);
                RestResponse theResponse = theClient.doPost(theUrl, theHeadeFields, (Object)aMessage);
                if (theResponse.getHttpStatusCode() == HttpStatusCode.NOT_FOUND) {
                    if (isVerbose) {
                        LOGGER.warn(theResponse.getHttpBody());
                    } else {
                        System.out.println(theResponse.getHttpBody());
                    }
                } else {
                    if (theResponse.getHttpStatusCode().isErrorStatus()) {
                        throw theResponse.getHttpStatusCode().toHttpStatusException("Failed to forward message \"" + aMessage + "\" from peer <" + aSource + "> to peer <" + aDestination + ">: " + theResponse.getHttpBody());
                    }
                    if (isVerbose) {
                        LOGGER.printSeparator();
                        LOGGER.info("Successfully dispatched \"" + aMessage + "\" from peer <" + aSource + "> to peer <" + aDestination + ">!");
                    } else {
                        System.out.println("Successfully dispatched \"" + aMessage + "\" from peer <" + aSource + "> to peer <" + aDestination + ">!");
                    }
                }
            }
        } else {
            throw new IllegalStateException("The peer <" + aSource + "> seems not to be attached to the P2P network on this host!");
        }
    }

    private static String toForwardHttpEndpoint() {
        return C2_FORWARD_ENDPOINT + _c2Helper.getInstanceAlias() != null ? "/" + _c2Helper.getInstanceAlias().toLowerCase() : "";
    }

    private static class LoggingMessageConsumer
    implements SerialP2PMessageConsumer {
        private final boolean _isVerbose;
        private final boolean _isDebug;

        public LoggingMessageConsumer(boolean isVerbose, boolean isDebug) {
            this._isVerbose = isVerbose;
            this._isDebug = isDebug;
        }

        @Override
        public void onP2PMessage(SerialP2PMessage aMessage, SerialPeer aPeer) {
            block7: {
                try {
                    String theMessage = "Peer <" + String.valueOf(aPeer.getLocator()) + "> received \"" + aMessage.getPayload(String.class) + "\" from peer <" + String.valueOf(((SerialP2PTail)aMessage.getTail()).getSource()) + "> to peer <" + String.valueOf(((SerialP2PHeader)aMessage.getHeader()).getDestination()) + "> via " + VerboseTextBuilder.asString((Integer[])((SerialP2PTail)aMessage.getTail()).getHops());
                    if (this._isVerbose) {
                        LOGGER.printSeparator();
                        LOGGER.info(theMessage);
                    } else {
                        System.out.println(theMessage);
                    }
                }
                catch (UnmarshalException e) {
                    String theMessage = "Peer <" + String.valueOf(aPeer.getLocator()) + "> cannot unmarshal dispatch from peer <" + String.valueOf(((SerialP2PTail)aMessage.getTail()).getSource()) + "> to peer <" + String.valueOf(((SerialP2PHeader)aMessage.getHeader()).getDestination()) + "> via " + VerboseTextBuilder.asString((Integer[])((SerialP2PTail)aMessage.getTail()).getHops()) + ": " + e.getMessage();
                    String theWarning = Trap.asMessage(theMessage, e);
                    if (this._isVerbose) {
                        if (this._isDebug) {
                            LOGGER.warn(theWarning, e);
                        } else {
                            LOGGER.warn(theWarning);
                        }
                    }
                    System.out.println(theWarning);
                    if (!this._isDebug) break block7;
                    e.printStackTrace();
                }
            }
        }
    }

    private static class MessageRequestConsumer
    implements RestRequestConsumer {
        private final SerialPeer _peer;
        private final boolean _isVerbose;
        private final boolean _isDebug;

        public MessageRequestConsumer(SerialPeer aPeer, boolean isVerbose, boolean isDebug) {
            this._peer = aPeer;
            this._isVerbose = isVerbose;
            this._isDebug = isDebug;
        }

        @Override
        public void onRequest(RestRequestEvent aRequest, HttpServerResponse aResponse) throws HttpStatusException {
            String thePayload = aRequest.getHttpBody();
            String theDestination = aRequest.getUrl().getQueryFields().getFirst("destination");
            if (this._isVerbose) {
                LOGGER.printSeparator();
                LOGGER.info("Dispatching \"" + thePayload + "\" from peer <" + String.valueOf(this._peer.getLocator()) + "> to peer <" + theDestination + ">...");
            } else {
                System.out.println("Dispatching \"" + thePayload + "\" from peer <" + String.valueOf(this._peer.getLocator()) + "> to peer <" + theDestination + ">...");
            }
            try {
                this._peer.sendMessage(Integer.valueOf(theDestination), thePayload);
            }
            catch (NoSuchDestinationException e) {
                String theMessage = "No such destination <" + theDestination + ">: Unable to dispatch \"" + thePayload + "\" from peer <" + String.valueOf(this._peer.getLocator()) + "> to peer <" + theDestination + ">: " + e.toMessage();
                String theWarning = Trap.asMessage(theMessage, e);
                if (this._isVerbose) {
                    if (this._isDebug) {
                        LOGGER.warn(theWarning, e);
                    } else {
                        LOGGER.warn(theWarning);
                    }
                } else {
                    System.out.println(theWarning);
                    if (this._isDebug) {
                        e.printStackTrace();
                    }
                }
                aResponse.getHeaderFields().putContentType(MediaType.TEXT_PLAIN);
                aResponse.setHttpStatusCode(HttpStatusCode.NOT_FOUND);
                aResponse.setResponse(theMessage);
            }
            catch (IOException | NumberFormatException e) {
                String theMessage = "Unable to dispatch \"" + thePayload + "\" from peer <" + String.valueOf(this._peer.getLocator()) + "> to peer <" + theDestination + ">!";
                String theWarning = Trap.asMessage(theMessage, e);
                if (this._isVerbose) {
                    if (this._isDebug) {
                        LOGGER.warn(theWarning, e);
                    } else {
                        LOGGER.warn(theWarning);
                    }
                } else {
                    System.out.println(theWarning);
                    if (this._isDebug) {
                        e.printStackTrace();
                    }
                }
                throw new InternalServerErrorException(theMessage, (Throwable)e);
            }
        }
    }
}

