/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties.ext.obfuscation;

import java.util.HashSet;
import java.util.Set;
import org.refcodes.data.Prefix;
import org.refcodes.properties.AbstractPropertiesDecorator;
import org.refcodes.properties.Properties;
import org.refcodes.properties.ext.obfuscation.ObfuscationProperties;

public abstract class AbstractObfuscationPropertiesDecorator
extends AbstractPropertiesDecorator<Properties>
implements ObfuscationProperties {
    protected String _decryptPrefix = Prefix.DECRYPT.getPrefix();
    protected String _encryptPrefix = Prefix.ENCRYPT.getPrefix();

    public AbstractObfuscationPropertiesDecorator(Properties aProperties) {
        super(aProperties);
    }

    @Override
    public String getEncryptPrefix() {
        return this._encryptPrefix;
    }

    @Override
    public void setEncryptPrefix(String aEncryptPrefix) {
        this._encryptPrefix = aEncryptPrefix;
    }

    @Override
    public String getDecryptPrefix() {
        return this._decryptPrefix;
    }

    @Override
    public void setDecryptPrefix(String aDecryptPrefix) {
        this._decryptPrefix = aDecryptPrefix;
    }

    @Override
    public String get(Object aKey) {
        String theValue = super.get(aKey);
        if (theValue != null) {
            if (theValue.startsWith(this._encryptPrefix)) {
                theValue = theValue.substring(this._encryptPrefix.length());
            } else if (theValue.startsWith(this._decryptPrefix)) {
                theValue = theValue.substring(this._decryptPrefix.length());
                theValue = this.toDecrypted(theValue);
            }
        }
        return theValue;
    }

    @Override
    public String put(String aKey, String aValue) {
        if (aValue != null && ((String)aValue).startsWith(this._encryptPrefix)) {
            aValue = ((String)aValue).substring(this._encryptPrefix.length());
            aValue = this.toEncrypted((String)aValue);
            aValue = this._decryptPrefix + (String)aValue;
        }
        return super.put(aKey, (String)aValue);
    }

    abstract String toEncrypted(String var1);

    abstract String toDecrypted(String var1);

    protected boolean encryptAll() {
        boolean isDirty = false;
        for (String eKey : this.keySet()) {
            String eValue = super.get((Object)eKey);
            if (eValue == null || !eValue.startsWith(this._encryptPrefix)) continue;
            eValue = eValue.substring(this._encryptPrefix.length());
            eValue = this.toEncrypted(eValue);
            super.put(eKey, this._decryptPrefix + eValue);
            isDirty = true;
        }
        return isDirty;
    }

    protected Set<String> encryptSet() {
        HashSet<String> theResult = new HashSet<String>();
        for (String eKey : this.keySet()) {
            String eValue = this.get((Object)eKey);
            if (eValue == null || !eValue.startsWith(this._encryptPrefix)) continue;
            theResult.add(eKey);
        }
        return theResult;
    }
}

