/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Map;
import org.refcodes.mixin.FilenameSuffixesAccessor;
import org.refcodes.properties.ImmutableProperties;
import org.refcodes.properties.ImmutableResourceProperties;
import org.refcodes.properties.Properties;
import org.refcodes.runtime.ConfigLocator;

public interface ImmutableResourcePropertiesFactory
extends FilenameSuffixesAccessor {
    default public boolean hasFilenameSuffix(File aFile) {
        if (aFile != null) {
            return this.hasFilenameSuffix(aFile.getAbsolutePath());
        }
        return false;
    }

    default public boolean hasFilenameSuffix(String aFilePath) {
        if (this.getFilenameSuffixes() != null && aFilePath != null) {
            String theLowerCase = aFilePath.toLowerCase();
            for (String eSuffix : this.getFilenameSuffixes()) {
                if (eSuffix == null || !theLowerCase.endsWith(eSuffix.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    default public ImmutableResourceProperties toProperties(Class<?> aResourceClass, String aFilePath) throws IOException, ParseException {
        return this.toProperties(aResourceClass, aFilePath, null);
    }

    public ImmutableResourceProperties toProperties(Class<?> var1, String var2, ConfigLocator var3) throws IOException, ParseException;

    default public ImmutableResourceProperties toProperties(File aFile) throws IOException, ParseException {
        return this.toProperties(aFile, null);
    }

    public ImmutableResourceProperties toProperties(File var1, ConfigLocator var2) throws IOException, ParseException;

    public ImmutableResourceProperties toProperties(InputStream var1) throws IOException, ParseException;

    public ImmutableResourceProperties toProperties(Map<?, ?> var1);

    public ImmutableResourceProperties toProperties(Object var1);

    public ImmutableResourceProperties toProperties(ImmutableProperties var1);

    public ImmutableResourceProperties toProperties(Properties var1);

    default public ImmutableResourceProperties toProperties(String aFilePath) throws IOException, ParseException {
        return this.toProperties(null, aFilePath, null);
    }

    default public ImmutableResourceProperties toProperties(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        return this.toProperties(null, aFilePath, aConfigLocator);
    }

    public ImmutableResourceProperties toProperties(URL var1) throws IOException, ParseException;
}

