/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.OutputStream;
import org.refcodes.runtime.SystemProperty;

public class LineBreakOutputStream
extends OutputStream {
    private long _count = 0L;
    private final String _lineBreak;
    private final int _lineWidth;
    private final OutputStream _outputStream;
    private final boolean _isFlushLineBreak;

    public LineBreakOutputStream(OutputStream aOutputStream, int aLineWidth, String aLineBreak) {
        this._lineBreak = aLineBreak;
        this._lineWidth = aLineWidth;
        this._outputStream = aOutputStream;
        this._isFlushLineBreak = false;
    }

    public LineBreakOutputStream(OutputStream aOutputStream, int aLineWidth) {
        this._lineBreak = SystemProperty.LINE_SEPARATOR.getValue();
        this._lineWidth = aLineWidth;
        this._outputStream = aOutputStream;
        this._isFlushLineBreak = false;
    }

    public LineBreakOutputStream(OutputStream aOutputStream, int aLineWidth, String aLineBreak, boolean isFlushLineBreak) {
        this._lineBreak = aLineBreak;
        this._lineWidth = aLineWidth;
        this._outputStream = aOutputStream;
        this._isFlushLineBreak = isFlushLineBreak;
    }

    public LineBreakOutputStream(OutputStream aOutputStream, int aLineWidth, boolean isFlushLineBreak) {
        this._lineBreak = SystemProperty.LINE_SEPARATOR.getValue();
        this._lineWidth = aLineWidth;
        this._outputStream = aOutputStream;
        this._isFlushLineBreak = isFlushLineBreak;
    }

    @Override
    public void write(int aByte) throws IOException {
        ++this._count;
        this._outputStream.write(aByte);
        if (this._lineWidth != -1 && this._count % (long)this._lineWidth == 0L) {
            this._outputStream.write(this._lineBreak.getBytes());
            this._count = 0L;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this._isFlushLineBreak) {
            this._outputStream.write(this._lineBreak.getBytes());
            this._count = 0L;
        }
        super.flush();
    }

    @Override
    public void close() throws IOException {
        if (this._lineWidth != -1) {
            if (this._count % (long)this._lineWidth != 0L) {
                this._outputStream.write(this._lineBreak.getBytes());
                this._count = 0L;
            }
            super.close();
        }
    }
}

