/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class LimitedInputStream
extends InputStream {
    private final InputStream _in;
    private final long _limit;
    private final boolean _isDelegateClose;
    private long _count;
    private long _markCount = -1L;

    public LimitedInputStream(InputStream aInputStream, long aLimit) {
        this(aInputStream, aLimit, false);
    }

    public LimitedInputStream(InputStream aInputStream, long aLimit, boolean isDelegateClose) {
        this._in = Objects.requireNonNull(aInputStream, "aInputStream");
        if (aLimit < 0L) {
            throw new IllegalArgumentException("aLimit must be >= 0");
        }
        this._limit = aLimit;
        this._isDelegateClose = isDelegateClose;
    }

    public long remaining() {
        long r = this._limit - this._count;
        return r < 0L ? 0L : r;
    }

    @Override
    public int read() throws IOException {
        if (this._count >= this._limit) {
            return -1;
        }
        int b = this._in.read();
        if (b >= 0) {
            ++this._count;
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Objects.requireNonNull(b, "b");
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        long remaining = this._limit - this._count;
        if (remaining <= 0L) {
            return -1;
        }
        int toRead = (int)Math.min((long)len, remaining);
        int r = this._in.read(b, off, toRead);
        if (r > 0) {
            this._count += (long)r;
        }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long remaining = this._limit - this._count;
        if (remaining <= 0L) {
            return 0L;
        }
        long toSkip = Math.min(n, remaining);
        long skipped = this._in.skip(toSkip);
        if (skipped > 0L) {
            this._count += skipped;
        }
        return skipped;
    }

    @Override
    public int available() throws IOException {
        long remaining = this._limit - this._count;
        if (remaining <= 0L) {
            return 0;
        }
        return (int)Math.min((long)this._in.available(), remaining);
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this._in.markSupported()) {
            this._in.mark(readlimit);
            this._markCount = this._count;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this._in.reset();
        if (this._markCount >= 0L) {
            this._count = this._markCount;
        }
    }

    @Override
    public boolean markSupported() {
        return this._in.markSupported();
    }

    @Override
    public void close() throws IOException {
        if (this._isDelegateClose) {
            this._in.close();
        }
    }
}

