/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical.ext.javafx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.application.Platform;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import org.refcodes.exception.UnhandledEnumBugException;
import org.refcodes.graphical.Dimension;
import org.refcodes.graphical.DimensionImpl;
import org.refcodes.graphical.PixGridPane;
import org.refcodes.graphical.PixelShape;
import org.refcodes.graphical.Rectangle;
import org.refcodes.graphical.RectangleImpl;
import org.refcodes.graphical.RgbColor;
import org.refcodes.graphical.RgbPixel;
import org.refcodes.graphical.RgbPixelImpl;
import org.refcodes.graphical.RgbPixmap;
import org.refcodes.graphical.RgbPixmapBuilderImpl;

public class FxPixGridMatrixPane
extends Pane
implements PixGridPane {
    protected RgbPixmap.RgbPixmapBuilder _rgbPixmapBuilder = null;
    private int _matrixHeight = 1;
    private int _matrixWidth = 1;
    private Shape[][] _shapes;
    private int _topBorder = 0;
    private int _bottomBorder = 0;
    private int _leftBorder = 0;
    private int _rightBorder = 0;
    private int _horizontalSpace = 0;
    private int _verticalSpace = 0;
    private int _pixelWidth = 1;
    private int _pixelHeight = 1;
    protected Color _inactivePixelColor;
    private int _pixmapOffsetX;
    private int _pixmapOffsetY;
    private boolean _isHorizontalWrap;
    private boolean _isVerticalWrap;
    private PixelShape _pixelShape = PixelShape.RECTANGLE;
    private List<Rectangle> _unconsideredAreaList;
    private Color _pixelBorderColor;
    private float _pixelBorderWidth;
    private static final Map<RgbPixel, Color> _pixelToFxColorCache = new WeakHashMap<RgbPixel, Color>();
    private static final Map<Color, RgbPixel> _fxColorToPixelCache = new WeakHashMap<Color, RgbPixel>();

    public FxPixGridMatrixPane(int aMatrixWidth, int aMatrixHeight, java.awt.Color aBackgroundColor, int aPixelWidth, int aPixelHeight, PixelShape aPixelShape, float aPixelBorderWidth, java.awt.Color aPixelBorderColor, java.awt.Color aInactivePixelColor, int aTopBorder, int aBottomBorder, int aLeftBorder, int aRightBorder, int aHorizontalSpace, float aPixelWidthToHorizontalSpaceRatio, boolean isForceHorizontalSpace, int aVerticalSpace, float aPixelHeightToVerticalSpaceRatio, boolean isForceVerticalSpace) {
        this(aMatrixWidth, aMatrixHeight, aBackgroundColor != null ? FxPixGridMatrixPane.toFxColor(aBackgroundColor) : null, aPixelWidth, aPixelHeight, aPixelShape, aPixelBorderWidth, aPixelBorderColor != null ? FxPixGridMatrixPane.toFxColor(aPixelBorderColor) : null, aInactivePixelColor != null ? FxPixGridMatrixPane.toFxColor(aInactivePixelColor) : null, aTopBorder, aBottomBorder, aLeftBorder, aRightBorder, aHorizontalSpace, aPixelWidthToHorizontalSpaceRatio, isForceHorizontalSpace, aVerticalSpace, aPixelHeightToVerticalSpaceRatio, isForceVerticalSpace);
    }

    public FxPixGridMatrixPane(int aMatrixWidth, int aMatrixHeight, String aBackgroundColor, int aPixelWidth, int aPixelHeight, PixelShape aPixelShape, float aPixelBorderWidth, String aPixelBorderColor, String aInactivePixelColor, int aTopBorder, int aBottomBorder, int aLeftBorder, int aRightBorder, int aHorizontalSpace, float aPixelWidthToHorizontalSpaceRatio, boolean isForceHorizontalSpace, int aVerticalSpace, float aPixelHeightToVerticalSpaceRatio, boolean isForceVerticalSpace) {
        this(aMatrixWidth, aMatrixHeight, aBackgroundColor != null ? FxPixGridMatrixPane.toFxColor(aBackgroundColor) : null, aPixelWidth, aPixelHeight, aPixelShape, aPixelBorderWidth, aPixelBorderColor != null ? FxPixGridMatrixPane.toFxColor(aPixelBorderColor) : null, aInactivePixelColor != null ? FxPixGridMatrixPane.toFxColor(aInactivePixelColor) : null, aTopBorder, aBottomBorder, aLeftBorder, aRightBorder, aHorizontalSpace, aPixelWidthToHorizontalSpaceRatio, isForceHorizontalSpace, aVerticalSpace, aPixelHeightToVerticalSpaceRatio, isForceVerticalSpace);
    }

    public FxPixGridMatrixPane(int aMatrixWidth, int aMatrixHeight, Color aBackgroundColor, int aPixelWidth, int aPixelHeight, PixelShape aPixelShape, float aPixelBorderWidth, Color aPixelBorderColor, Color aInactivePixelColor, int aTopBorder, int aBottomBorder, int aLeftBorder, int aRightBorder, int aHorizontalSpace, float aPixelWidthToHorizontalSpaceRatio, boolean isForceHorizontalSpace, int aVerticalSpace, float aPixelHeightToVerticalSpaceRatio, boolean isForceVerticalSpace) {
        int tmpRemainder;
        int theRightBorder;
        this._inactivePixelColor = aInactivePixelColor != null ? aInactivePixelColor : Color.DARKGRAY;
        this._pixmapOffsetX = 0;
        this._pixmapOffsetY = 0;
        this._isHorizontalWrap = true;
        this._isVerticalWrap = true;
        this._unconsideredAreaList = new ArrayList<Rectangle>();
        if (aPixelHeightToVerticalSpaceRatio == -1.0f) {
            aPixelHeightToVerticalSpaceRatio = 0.2f;
        }
        if (aPixelWidthToHorizontalSpaceRatio == -1.0f) {
            aPixelWidthToHorizontalSpaceRatio = 0.2f;
        }
        int theTopBorder = aTopBorder == -1 ? 0 : aTopBorder;
        int theBottomBorder = aBottomBorder == -1 ? 0 : aBottomBorder;
        int theLeftBorder = aLeftBorder == -1 ? 0 : aLeftBorder;
        int n = theRightBorder = aRightBorder == -1 ? 0 : aRightBorder;
        if (aHorizontalSpace == -1 && aPixelWidth == -1) {
            tmpRemainder = ((int)this.getWidth() - (theLeftBorder + theRightBorder)) / aMatrixWidth;
            aHorizontalSpace = (int)((float)tmpRemainder * aPixelWidthToHorizontalSpaceRatio);
            if (isForceHorizontalSpace && aHorizontalSpace == 0) {
                aHorizontalSpace = 1;
            }
            aPixelWidth = ((int)this.getWidth() - (theLeftBorder + theRightBorder)) / aMatrixWidth - aHorizontalSpace;
        } else if (aHorizontalSpace == -1 && aPixelWidth != -1) {
            tmpRemainder = (int)this.getWidth() - (theLeftBorder + theRightBorder) - aPixelWidth * aMatrixWidth;
            aHorizontalSpace = tmpRemainder / (aMatrixWidth - 1);
        } else if (aHorizontalSpace != -1 && aPixelWidth == -1) {
            tmpRemainder = (int)this.getWidth() - (theLeftBorder + theRightBorder) - aHorizontalSpace * (aMatrixWidth - 1);
            aPixelWidth = tmpRemainder / aMatrixWidth;
        }
        if (aVerticalSpace == -1 && aPixelHeight == -1) {
            tmpRemainder = ((int)this.getHeight() - (theTopBorder + theBottomBorder)) / aMatrixHeight;
            aVerticalSpace = (int)((float)tmpRemainder * aPixelHeightToVerticalSpaceRatio);
            if (isForceVerticalSpace && aVerticalSpace == 0) {
                aVerticalSpace = 1;
            }
            aPixelHeight = ((int)this.getHeight() - (theTopBorder + theBottomBorder)) / aMatrixHeight - aVerticalSpace;
        } else if (aVerticalSpace == -1 && aPixelHeight != -1) {
            tmpRemainder = (int)this.getHeight() - (theTopBorder + theBottomBorder) - aPixelHeight * aMatrixHeight;
            aVerticalSpace = tmpRemainder / (aMatrixHeight - 1);
        } else if (aVerticalSpace != -1 && aPixelHeight == -1) {
            tmpRemainder = (int)this.getHeight() - (theTopBorder + theBottomBorder) - aVerticalSpace * (aMatrixHeight - 1);
            aPixelHeight = tmpRemainder / aMatrixHeight;
        }
        this._matrixWidth = aMatrixWidth;
        this._matrixHeight = aMatrixHeight;
        this._horizontalSpace = aHorizontalSpace;
        this._verticalSpace = aVerticalSpace;
        this._pixelWidth = aPixelWidth;
        this._pixelHeight = aPixelHeight;
        this._pixelShape = aPixelShape;
        this._pixelBorderWidth = aPixelBorderWidth;
        this._pixelBorderColor = aPixelBorderColor;
        if (aLeftBorder == -1 && aRightBorder == -1) {
            aLeftBorder = ((int)this.getWidth() - this.getMatrixDrawingWidth(false, true, true)) / 2;
            if (aLeftBorder < 0) {
                aLeftBorder = 0;
            }
            aRightBorder = aLeftBorder;
        } else if (aLeftBorder == -1 && aRightBorder != -1) {
            aLeftBorder = (int)this.getWidth() - this.getMatrixDrawingWidth(false, true, true) - aRightBorder;
            if (aLeftBorder < 0) {
                aLeftBorder = 0;
            }
        } else if (aLeftBorder != -1 && aRightBorder == -1 && (aRightBorder = (int)this.getWidth() - this.getMatrixDrawingWidth(false, true, true) - aLeftBorder) < 0) {
            aRightBorder = 0;
        }
        this._leftBorder = aLeftBorder;
        this._rightBorder = aRightBorder;
        if (aTopBorder == -1 && aBottomBorder == -1) {
            aTopBorder = ((int)this.getHeight() - this.getMatrixDrawingHeight(false, true, true)) / 2;
            if (aTopBorder < 0) {
                aTopBorder = 0;
            }
            aBottomBorder = aTopBorder;
        } else if (aTopBorder == -1 && aBottomBorder != -1) {
            aTopBorder = (int)this.getHeight() - this.getMatrixDrawingHeight(false, true, true) - aBottomBorder;
            if (aTopBorder < 0) {
                aTopBorder = 0;
            }
        } else if (aTopBorder != -1 && aBottomBorder == -1 && (aBottomBorder = (int)this.getHeight() - this.getMatrixDrawingHeight(false, true, true) - aTopBorder) < 0) {
            aBottomBorder = 0;
        }
        this._topBorder = aTopBorder;
        this._bottomBorder = aBottomBorder;
        int thePixelSpanWidthSum = this.getHorizontalSpace() * (this.getMatrixWidth() - 1);
        int thePixelSpanHeightSum = this.getVerticalSpace() * (this.getMatrixHeight() - 1);
        int thePixelWidthSum = this.getPixelWidth() * this.getMatrixWidth();
        int thePixelHeightSum = this.getPixelHeight() * this.getMatrixHeight();
        int theBorderWidthSum = this.getLeftBorder() + this.getRightBorder();
        int theBorderHeightSum = this.getTopBorder() + this.getBottomBorder();
        int theWidth = thePixelSpanWidthSum + thePixelWidthSum + theBorderWidthSum;
        int theHeight = thePixelSpanHeightSum + thePixelHeightSum + theBorderHeightSum;
        java.awt.Dimension theDimension = new java.awt.Dimension(theWidth, theHeight);
        this.setPrefSize(theDimension.getWidth(), theDimension.getHeight());
        this.setMinSize(theDimension.getWidth(), theDimension.getHeight());
        this.setWidth(theDimension.getWidth());
        this.setHeight(theDimension.getHeight());
        this._rgbPixmapBuilder = new RgbPixmapBuilderImpl(aMatrixWidth, aMatrixHeight);
        if (aBackgroundColor != null) {
            javafx.scene.shape.Rectangle theBackground = new javafx.scene.shape.Rectangle(0.0, 0.0, theDimension.getWidth(), theDimension.getHeight());
            theBackground.setFill(aBackgroundColor);
            this.getChildren().add(theBackground);
        }
        this._shapes = new Shape[aMatrixWidth][aMatrixHeight];
        for (int x = 0; x < aMatrixWidth; ++x) {
            for (int y = 0; y < aMatrixHeight; ++y) {
                int eLeft = this._leftBorder + x * this._horizontalSpace + x * this._pixelWidth;
                int eTop = this._topBorder + y * this._verticalSpace + y * this._pixelHeight;
                switch (this._pixelShape) {
                    case ELLIPSE: {
                        Ellipse theEllipse = new Ellipse(eLeft + this._pixelWidth / 2, eTop + this._pixelHeight / 2, this._pixelWidth / 2, this._pixelHeight / 2);
                        theEllipse.setFill(this._inactivePixelColor);
                        if (this._pixelBorderColor != null && this._pixelBorderWidth > 0.0f) {
                            theEllipse.setStroke(this._pixelBorderColor);
                            theEllipse.setStrokeWidth(this._pixelBorderWidth);
                            theEllipse.setStrokeLineCap(StrokeLineCap.ROUND);
                            theEllipse.setStrokeLineJoin(StrokeLineJoin.MITER);
                        }
                        this._shapes[x][y] = theEllipse;
                        break;
                    }
                    case RECTANGLE: {
                        javafx.scene.shape.Rectangle theRectangle = new javafx.scene.shape.Rectangle(eLeft, eTop, this._pixelWidth, this._pixelHeight);
                        theRectangle.setFill(this._inactivePixelColor);
                        if (this._pixelBorderColor != null && this._pixelBorderWidth > 0.0f) {
                            theRectangle.setStroke(this._pixelBorderColor);
                            theRectangle.setStrokeWidth(this._pixelBorderWidth);
                            theRectangle.setStrokeLineCap(StrokeLineCap.SQUARE);
                            theRectangle.setStrokeLineJoin(StrokeLineJoin.MITER);
                        }
                        this._shapes[x][y] = theRectangle;
                        break;
                    }
                    default: {
                        throw new UnhandledEnumBugException(this._pixelShape);
                    }
                }
                this.getChildren().add(this._shapes[x][y]);
                this._rgbPixmapBuilder.setPixelAt(FxPixGridMatrixPane.toRgbPixel(this._inactivePixelColor), x, y);
            }
        }
    }

    public Color getColorAt(int aXPos, int aYPos) {
        return FxPixGridMatrixPane.toFxColor(this._rgbPixmapBuilder.getColorAt(aXPos, aYPos));
    }

    @Override
    public RgbPixel getPixelAt(int aXPos, int aYPos) {
        return (RgbPixel)this._rgbPixmapBuilder.getPixelAt(aXPos, aYPos);
    }

    @Override
    public int getTopBorder() {
        return this._topBorder;
    }

    @Override
    public int getBottomBorder() {
        return this._bottomBorder;
    }

    @Override
    public int getLeftBorder() {
        return this._leftBorder;
    }

    @Override
    public int getRightBorder() {
        return this._rightBorder;
    }

    @Override
    public int getHorizontalSpace() {
        return this._horizontalSpace;
    }

    @Override
    public int getVerticalSpace() {
        return this._verticalSpace;
    }

    @Override
    public int getPixelWidth() {
        return this._pixelWidth;
    }

    @Override
    public int getPixelHeight() {
        return this._pixelHeight;
    }

    @Override
    public int getMatrixDrawingWidth(boolean isWithBorder, boolean isWithPixelSpace, boolean isWithPixelWidth) {
        int theBorder = isWithBorder ? this.getLeftBorder() + this.getRightBorder() : 0;
        int theSpace = isWithPixelSpace ? this.getHorizontalSpace() : 0;
        int thePixelWidth = isWithPixelWidth ? this.getPixelWidth() : 0;
        return theBorder * 2 + theSpace * (this.getMatrixWidth() - 1) + thePixelWidth * this.getMatrixWidth();
    }

    @Override
    public int getMatrixDrawingHeight(boolean isWithBorder, boolean isWithPixelSpace, boolean isWithPixelHeight) {
        int theBorder = isWithBorder ? this.getTopBorder() + this.getBottomBorder() : 0;
        int theSpace = isWithPixelSpace ? this.getVerticalSpace() : 0;
        int thePixelHeight = isWithPixelHeight ? this.getPixelWidth() : 0;
        return theBorder * 2 + theSpace * (this.getMatrixHeight() - 1) + thePixelHeight * this.getMatrixHeight();
    }

    @Override
    public RgbPixmap.RgbPixmapBuilder getRgbPixmap() {
        return this._rgbPixmapBuilder;
    }

    @Override
    public int getPixmapOffsetX() {
        return this._pixmapOffsetX;
    }

    @Override
    public int getPixmapOffsetY() {
        return this._pixmapOffsetY;
    }

    @Override
    public boolean isHorizontalWrapEnabled() {
        return this._isHorizontalWrap;
    }

    @Override
    public boolean isVerticalWrapEnabled() {
        return this._isVerticalWrap;
    }

    @Override
    public int getMatrixWidth() {
        return this._matrixWidth;
    }

    @Override
    public int getMatrixHeight() {
        return this._matrixHeight;
    }

    @Override
    public Dimension getMatrixSize() {
        return new DimensionImpl(this._matrixWidth, this._matrixHeight);
    }

    @Override
    public RgbColor getInactivePixelColor() {
        return FxPixGridMatrixPane.toRgbPixel(this._inactivePixelColor);
    }

    @Override
    public void clear() {
        for (int x = 0; x < this.getMatrixWidth(); ++x) {
            for (int y = 0; y < this.getMatrixHeight(); ++y) {
                this._rgbPixmapBuilder.setPixelAt(FxPixGridMatrixPane.toRgbPixel(this._inactivePixelColor), x, y);
            }
        }
        this.repaint();
    }

    @Override
    public PixelShape getPixelShape() {
        return this._pixelShape;
    }

    @Override
    public boolean addBlankArea(int aXPosition, int aYPosition, int aWidth, int aHeight) {
        RectangleImpl theRectangle = new RectangleImpl(aXPosition, aYPosition, aWidth, aHeight);
        return this.addBlankArea(theRectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addBlankArea(Rectangle aRectangle) {
        List<Rectangle> list = this._unconsideredAreaList;
        synchronized (list) {
            return !this._unconsideredAreaList.contains(aRectangle) ? this._unconsideredAreaList.add(aRectangle) : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeBlankArea(Rectangle aRectangle) {
        List<Rectangle> list = this._unconsideredAreaList;
        synchronized (list) {
            return this._unconsideredAreaList.remove(aRectangle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBlankAreas() {
        List<Rectangle> list = this._unconsideredAreaList;
        synchronized (list) {
            this._unconsideredAreaList.clear();
        }
    }

    @Override
    public RgbPixmap.RgbPixmapBuilder getPixmapSnapshot() {
        RgbPixmapBuilderImpl theMatrix = new RgbPixmapBuilderImpl(this.getMatrixWidth(), this.getMatrixHeight());
        theMatrix.mergeWith(this._rgbPixmapBuilder, this._pixmapOffsetX, this._pixmapOffsetY, this._isHorizontalWrap, this._isVerticalWrap, 0, 0, this._matrixWidth, this._matrixHeight);
        return theMatrix;
    }

    private boolean isPaintPixelAt(int aXPosition, int aYPosition) {
        Rectangle eRectangle;
        if (this._unconsideredAreaList.isEmpty()) {
            return true;
        }
        Iterator<Rectangle> e = this._unconsideredAreaList.iterator();
        do {
            if (e.hasNext()) continue;
            return true;
        } while (aXPosition < (eRectangle = e.next()).getPositionX() || aXPosition >= eRectangle.getPositionX() + eRectangle.getWidth() || aYPosition < eRectangle.getPositionY() || aYPosition >= eRectangle.getPositionY() + eRectangle.getHeight());
        return false;
    }

    @Override
    public void setPixmapOffset(int aPosX, int aPosY) {
        if (aPosX < 0) {
            throw new IllegalArgumentException("Argument must be greater than or equal to <0>! You provided an x-offset of < " + aPosX + ">");
        }
        if (aPosY < 0) {
            throw new IllegalArgumentException("Argument must be greater than or equal to <0>! You provided an y-offset of < " + aPosY + ">");
        }
        this._pixmapOffsetX = aPosX;
        this._pixmapOffsetY = aPosY;
    }

    public void setColorAt(Color aColor, int aPosX, int aPosY) {
        if (aPosX < this._matrixWidth && aPosY < this._matrixHeight) {
            this._rgbPixmapBuilder.setPixelAt(FxPixGridMatrixPane.toRgbPixel(aColor), aPosX, aPosY);
            if (Platform.isFxApplicationThread()) {
                this._shapes[aPosX][aPosY].setFill(aColor);
            } else {
                Platform.runLater(() -> this._shapes[aPosX][aPosY].setFill(aColor));
            }
        }
    }

    @Override
    public void setPixelAtAt(RgbPixel aPixel, int aPosX, int aPosY) {
        if (aPosX < this._matrixWidth && aPosY < this._matrixHeight) {
            this._rgbPixmapBuilder.setPixelAt(aPixel, aPosX, aPosY);
            if (Platform.isFxApplicationThread()) {
                this._shapes[aPosX][aPosY].setFill(FxPixGridMatrixPane.toFxColor(aPixel));
            } else {
                Platform.runLater(() -> this._shapes[aPosX][aPosY].setFill(FxPixGridMatrixPane.toFxColor(aPixel)));
            }
        }
    }

    @Override
    public void repaint() {
        for (int x = 0; x < this._matrixWidth; ++x) {
            for (int y = 0; y < this._matrixHeight; ++y) {
                boolean isVerticalWrapSet;
                boolean isHorizontalWrapSet;
                if (!this.isPaintPixelAt(x, y)) continue;
                int eX = x + this._pixmapOffsetX;
                int eY = y + this._pixmapOffsetY;
                if (eX >= this._rgbPixmapBuilder.getWidth()) {
                    isHorizontalWrapSet = true;
                    eX -= this._rgbPixmapBuilder.getWidth();
                } else {
                    isHorizontalWrapSet = false;
                }
                if (eY >= this._rgbPixmapBuilder.getHeight()) {
                    isVerticalWrapSet = true;
                    eY -= this._rgbPixmapBuilder.getHeight();
                } else {
                    isVerticalWrapSet = false;
                }
                Color eColor = !(isHorizontalWrapSet && !this.isHorizontalWrapEnabled() || isVerticalWrapSet && !this.isVerticalWrapEnabled()) ? FxPixGridMatrixPane.toFxColor(this._rgbPixmapBuilder.getColorAt(eX, eY)) : this._inactivePixelColor;
                if (Platform.isFxApplicationThread()) {
                    this._shapes[x][y].setFill(eColor);
                    continue;
                }
                int theX = x;
                int theY = y;
                Platform.runLater(() -> this._shapes[theX][theY].setFill(eColor));
            }
        }
    }

    protected static Color toFxColor(RgbPixel aPixel) {
        Color fxColor = _pixelToFxColorCache.get(aPixel);
        if (fxColor == null) {
            int r = aPixel.getRed();
            int g = aPixel.getGreen();
            int b = aPixel.getBlue();
            int a = aPixel.getAlpha();
            double opacity = (double)a / 255.0;
            fxColor = Color.rgb(r, g, b, opacity);
            _pixelToFxColorCache.put(aPixel, fxColor);
        }
        return fxColor;
    }

    protected static Color toFxColor(java.awt.Color aAwtColor) {
        int r = aAwtColor.getRed();
        int g = aAwtColor.getGreen();
        int b = aAwtColor.getBlue();
        int a = aAwtColor.getAlpha();
        double opacity = (double)a / 255.0;
        Color fxColor = Color.rgb(r, g, b, opacity);
        return fxColor;
    }

    protected static Color toFxColor(String aWebColor) {
        return Color.web(aWebColor);
    }

    protected static RgbPixel toRgbPixel(Color aFxColor) {
        RgbPixel pixel = _fxColorToPixelCache.get(aFxColor);
        if (pixel == null) {
            pixel = new RgbPixelImpl(new java.awt.Color((float)aFxColor.getRed(), (float)aFxColor.getGreen(), (float)aFxColor.getBlue(), (float)aFxColor.getOpacity()));
            _fxColorToPixelCache.put(aFxColor, pixel);
        }
        return pixel;
    }
}

