/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical.ext.javafx;

import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.refcodes.graphical.LayoutMode;
import org.refcodes.graphical.ext.javafx.FxGraphicalUtility;
import org.refcodes.mixin.TextAccessor;
import org.refcodes.textual.FontNameAccessor;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.HorizAlignTextModeAccessor;
import org.refcodes.textual.VertAlignTextMode;
import org.refcodes.textual.VertAlignTextModeAccessor;

public class FxLabelDecorator
extends StackPane
implements TextAccessor.TextProperty,
TextAccessor.TextBuilder<FxLabelDecorator>,
HorizAlignTextModeAccessor.HorizAlignTextModeProperty,
HorizAlignTextModeAccessor.HorizAlignTextModeBuilder<FxLabelDecorator>,
VertAlignTextModeAccessor.VertAlignTextModeProperty,
VertAlignTextModeAccessor.VertAlignTextModeBuilder<FxLabelDecorator>,
FontNameAccessor.FontNameProperty,
FontNameAccessor.FontNameBuilder<FxLabelDecorator> {
    private static final Color DEFAULT_TEXT_BACKGROUND_COLOR = Color.BLACK;
    private static final double DEFAULT_TEXT_BORDER_ARC_FACTOR = 0.025;
    private static final Color DEFAULT_TEXT_BORDER_COLOR = Color.GRAY;
    private static final int DEFAULT_TEXT_BORDER_SIZE = 0;
    private static final Color DEFAULT_TEXT_COLOR = Color.WHITE;
    private static final int DEFAULT_TEXT_MARGIN_FACTOR = 0;
    private static final int DEFAULT_TEXT_PADDING_FACTOR = 0;
    private static final int PROBE_FONT_SIZE = 24;
    private double _bottomTextMarginFactor = 0.0;
    private double _bottomTextPaddingFactor = 0.0;
    private Node _content;
    private String _fontName;
    private HorizAlignTextMode _horizAlignTextMode = HorizAlignTextMode.CENTER;
    private double _leftTextMarginFactor = 0.0;
    private double _leftTextPaddingFactor = 0.0;
    private Rectangle _rect;
    private RedrawDaemon _redraw = new RedrawDaemon();
    private double _rightTextMarginFactor = 0.0;
    private double _rightTextPaddingFactor = 0.0;
    private String _text;
    private double _textBorderArcFactor = 0.025;
    private double _textBorderSizeFactor = 0.0;
    private LayoutMode _textLayoutMode = LayoutMode.VERTICAL;
    private Text _textNode;
    private double _textSizeFactor;
    private double _topTextMarginFactor = 0.0;
    private double _topTextPaddingFactor = 0.0;
    private VertAlignTextMode _vertAlignTextMode = VertAlignTextMode.MIDDLE;

    private static ImageView toImageView(Image aImage) {
        ImageView theImageView = new ImageView(aImage);
        theImageView.smoothProperty().set(true);
        return theImageView;
    }

    private static String toString(Object aText) {
        if (aText == null) {
            return null;
        }
        return aText instanceof String ? (String)aText : aText.toString();
    }

    public FxLabelDecorator(Object aText, String aFontName, double aTextSizeFactor, Image aImage) {
        this(FxLabelDecorator.toString(aText), aFontName, aTextSizeFactor, aImage);
    }

    public FxLabelDecorator(String aText, String aFontName, double aTextSizeFactor, Image aImage) {
        this(aText, aFontName, aTextSizeFactor, (Node)FxLabelDecorator.toImageView(aImage));
    }

    public FxLabelDecorator(String aText, String aFontName, double aTextSizeFactor, Node aNode) {
        this._text = aText;
        this._fontName = aFontName;
        this._textSizeFactor = aTextSizeFactor;
        this._content = aNode;
        this._textNode = new Text(aText);
        this._textNode.setFont(new Font(aFontName, 24.0));
        this._textNode.setFill(DEFAULT_TEXT_COLOR);
        this._rect = new Rectangle(this._textNode.getBoundsInLocal().getWidth(), this._textNode.getBoundsInLocal().getHeight(), DEFAULT_TEXT_BACKGROUND_COLOR);
        this._rect.setStroke(DEFAULT_TEXT_BORDER_COLOR);
        this.setBorder(null);
        StackPane.setMargin(this._content, null);
        StackPane.setAlignment(this._content, Pos.CENTER);
        StackPane.setMargin(this._rect, null);
        StackPane.setAlignment(this._rect, FxGraphicalUtility.toPos(this._horizAlignTextMode, this._vertAlignTextMode));
        StackPane.setMargin(this._textNode, null);
        StackPane.setAlignment(this._textNode, FxGraphicalUtility.toPos(this._horizAlignTextMode, this._vertAlignTextMode));
        this.getChildren().addAll((Node[])new Node[]{this._rect, this._content, this._textNode});
        this._redraw.run();
    }

    public double getBottomTextMarginFactor() {
        return this._bottomTextMarginFactor;
    }

    public double getBottomTextPaddingFactor() {
        return this._bottomTextPaddingFactor;
    }

    public Node getContent() {
        return this._content;
    }

    @Override
    public String getFontName() {
        return this._textNode.getFont().getName();
    }

    @Override
    public HorizAlignTextMode getHorizAlignTextMode() {
        return this._horizAlignTextMode;
    }

    public Image getImage() {
        if (this._content instanceof ImageView) {
            return ((ImageView)this._content).getImage();
        }
        if (this._content instanceof FxLabelDecorator) {
            return ((FxLabelDecorator)this._content).getImage();
        }
        return null;
    }

    public double getLeftTextMarginFactor() {
        return this._leftTextMarginFactor;
    }

    public double getLeftTextPaddingFactor() {
        return this._leftTextPaddingFactor;
    }

    public double getRightTextMarginFactor() {
        return this._rightTextMarginFactor;
    }

    public double getRightTextPaddingFactor() {
        return this._rightTextPaddingFactor;
    }

    @Override
    public String getText() {
        return this._text;
    }

    public Paint getTextBackground() {
        return this._rect.getFill();
    }

    public double getTextBorderArcFactor() {
        return this._textBorderArcFactor;
    }

    public Paint getTextBorderColor() {
        return this._rect.getStroke();
    }

    public double getTextBorderSizeFactor() {
        return this._textBorderSizeFactor;
    }

    public Paint getTextColor() {
        return this._textNode.getFill();
    }

    public LayoutMode getTextLayoutMode() {
        return this._textLayoutMode;
    }

    public double getTextSizeFactor() {
        return this._textSizeFactor;
    }

    public double getTopTextMarginFactor() {
        return this._topTextMarginFactor;
    }

    public double getTopTextPaddingFactor() {
        return this._topTextPaddingFactor;
    }

    @Override
    public VertAlignTextMode getVertAlignTextMode() {
        return this._vertAlignTextMode;
    }

    public void setBottomTextMarginFactor(double aBottomTextMarginFactor) {
        this._bottomTextMarginFactor = aBottomTextMarginFactor;
    }

    public void setBottomTextPaddingFactor(double aBottomTextPaddingFactor) {
        this._bottomTextPaddingFactor = aBottomTextPaddingFactor;
    }

    public void setContent(Node aContent) {
        if (aContent instanceof Region) {
            ((Region)aContent).setPrefWidth(this.getWidth());
            ((Region)aContent).setPrefHeight(this.getHeight());
        }
        this._content = aContent;
    }

    @Override
    public void setFontName(String aFontName) {
        this._fontName = aFontName;
        this.redraw();
    }

    @Override
    public void setHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        this._horizAlignTextMode = aHorizAlignTextMode;
        Pos thePos = FxGraphicalUtility.toPos(this._horizAlignTextMode, this._vertAlignTextMode);
        StackPane.setAlignment(this._textNode, thePos);
        StackPane.setAlignment(this._rect, thePos);
    }

    public void setHorizTextMarginFactor(double aTextMarginFactor) {
        this.setLeftTextMarginFactor(aTextMarginFactor);
        this.setRightTextMarginFactor(aTextMarginFactor);
    }

    public void setHorizTextPaddingFactor(double aTextPaddingFactor) {
        this.setLeftTextPaddingFactor(aTextPaddingFactor);
        this.setRightTextPaddingFactor(aTextPaddingFactor);
    }

    public void setImage(Image aImage) {
        if (this._content instanceof ImageView) {
            ((ImageView)this._content).setImage(aImage);
        } else if (this._content instanceof FxLabelDecorator) {
            ((FxLabelDecorator)this._content).setImage(aImage);
        } else {
            this._content = FxLabelDecorator.toImageView(aImage);
            this.redraw();
        }
    }

    public void setLeftTextMarginFactor(double aLeftTextMarginFactor) {
        this._leftTextMarginFactor = aLeftTextMarginFactor;
    }

    public void setLeftTextPaddingFactor(double aLeftTextPaddingFactor) {
        this._leftTextPaddingFactor = aLeftTextPaddingFactor;
    }

    public void setRightTextMarginFactor(double aRightTextMarginFactor) {
        this._rightTextMarginFactor = aRightTextMarginFactor;
    }

    public void setRightTextPaddingFactor(double aRightTextPaddingFactor) {
        this._rightTextPaddingFactor = aRightTextPaddingFactor;
    }

    @Override
    public void setText(String aText) {
        this._text = aText;
        this.redraw();
    }

    public void setTextBackground(Paint aTextBackground) {
        this._rect.setFill(aTextBackground);
    }

    public void setTextBorderArcFactor(double aTextBorderArcFactor) {
        this._textBorderArcFactor = aTextBorderArcFactor;
        this.redraw();
    }

    public void setTextBorderColor(Paint aTextBorderColor) {
        this._rect.setStroke(aTextBorderColor);
    }

    public void setTextBorderSizeFactor(double aTextBorderSizeFactor) {
        this._textBorderSizeFactor = aTextBorderSizeFactor;
        this.redraw();
    }

    public void setTextColor(Paint aColor) {
        this._textNode.setFill(aColor);
    }

    public void setTextLayoutMode(LayoutMode aLayoutMode) {
        this._textLayoutMode = aLayoutMode;
    }

    public void setTextMarginFactor(double aTextMarginFactor) {
        this.setTopTextMarginFactor(aTextMarginFactor);
        this.setLeftTextMarginFactor(aTextMarginFactor);
        this.setBottomTextMarginFactor(aTextMarginFactor);
        this.setRightTextMarginFactor(aTextMarginFactor);
    }

    public void setTextPaddingFactor(double aTextPaddingFactor) {
        this.setTopTextPaddingFactor(aTextPaddingFactor);
        this.setLeftTextPaddingFactor(aTextPaddingFactor);
        this.setBottomTextPaddingFactor(aTextPaddingFactor);
        this.setRightTextPaddingFactor(aTextPaddingFactor);
    }

    public void setTextSizeFactor(double aTextSizeFactor) {
        this._textSizeFactor = aTextSizeFactor;
        this.redraw();
    }

    public void setTopTextMarginFactor(double aTopTextMarginFactor) {
        this._topTextMarginFactor = aTopTextMarginFactor;
    }

    public void setTopTextPaddingFactor(double aTopTextPaddingFactor) {
        this._topTextPaddingFactor = aTopTextPaddingFactor;
    }

    @Override
    public void setVertAlignTextMode(VertAlignTextMode aVertAlignTextMode) {
        this._vertAlignTextMode = aVertAlignTextMode;
        Pos thePos = FxGraphicalUtility.toPos(this._horizAlignTextMode, this._vertAlignTextMode);
        StackPane.setAlignment(this._textNode, thePos);
        StackPane.setAlignment(this._rect, thePos);
    }

    public void setVertTextMarginFactor(double aTextMarginFactor) {
        this.setTopTextMarginFactor(aTextMarginFactor);
        this.setBottomTextMarginFactor(aTextMarginFactor);
    }

    public void setVertTextPaddingFactor(double aTextPaddingFactor) {
        this.setTopTextPaddingFactor(aTextPaddingFactor);
        this.setBottomTextPaddingFactor(aTextPaddingFactor);
    }

    public FxLabelDecorator withBottomTextMarginFactor(double aTextMarginFactor) {
        this.setTextMarginFactor(aTextMarginFactor);
        return this;
    }

    public FxLabelDecorator withBottomTextPaddingFactor(double aTextPaddingFactor) {
        this.setTextPaddingFactor(aTextPaddingFactor);
        return this;
    }

    public FxLabelDecorator withContent(Node aContent) {
        this.setContent(aContent);
        return this;
    }

    @Override
    public FxLabelDecorator withFontName(String aFontName) {
        this.setFontName(aFontName);
        return this;
    }

    @Override
    public FxLabelDecorator withHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        this.setHorizAlignTextMode(aHorizAlignTextMode);
        return this;
    }

    public FxLabelDecorator withHorizTextMarginFactor(double aTextMarginFactor) {
        this.setHorizTextMarginFactor(aTextMarginFactor);
        return this;
    }

    public FxLabelDecorator withHorizTextPaddingFactor(double aTextPaddingFactor) {
        this.setHorizTextPaddingFactor(aTextPaddingFactor);
        return this;
    }

    public FxLabelDecorator withImage(Image aImage) {
        this.setImage(aImage);
        return this;
    }

    public FxLabelDecorator withLeftTextMarginFactor(double aTextMarginFactor) {
        this.setTextMarginFactor(aTextMarginFactor);
        return this;
    }

    public FxLabelDecorator withLeftTextPaddingFactor(double aTextPaddingFactor) {
        this.setTextPaddingFactor(aTextPaddingFactor);
        return this;
    }

    public FxLabelDecorator withRightTextMarginFactor(double aTextMarginFactor) {
        this.setTextMarginFactor(aTextMarginFactor);
        return this;
    }

    public FxLabelDecorator withRightTextPaddingFactor(double aTextPaddingFactor) {
        this.setTextPaddingFactor(aTextPaddingFactor);
        return this;
    }

    @Override
    public FxLabelDecorator withText(String aText) {
        this.setText(aText);
        return this;
    }

    public FxLabelDecorator withTextBackground(Paint aTextBackground) {
        this.setTextBackground(aTextBackground);
        return this;
    }

    public FxLabelDecorator withTextBorderArcFactor(double aTextBorderArcFactor) {
        this.setTextBorderArcFactor(aTextBorderArcFactor);
        return this;
    }

    public FxLabelDecorator withTextBorderColor(Paint aTextBorderColor) {
        this.setTextBorderColor(aTextBorderColor);
        return this;
    }

    public FxLabelDecorator withTextBorderSizeFactor(double aTextBorderSizeFactor) {
        this.setTextBorderSizeFactor(aTextBorderSizeFactor);
        return this;
    }

    public FxLabelDecorator withTextColor(Paint aTextColor) {
        this.setTextColor(aTextColor);
        return this;
    }

    public FxLabelDecorator withTextLayoutMode(LayoutMode aLayoutMode) {
        this.setTextLayoutMode(aLayoutMode);
        return this;
    }

    public FxLabelDecorator withTextMarginFactor(double aTextMarginFactor) {
        this.setTextMarginFactor(aTextMarginFactor);
        return this;
    }

    public FxLabelDecorator withTextPaddingFactor(double aTextPaddingFactor) {
        this.setTextPaddingFactor(aTextPaddingFactor);
        return this;
    }

    public FxLabelDecorator withTextSizeFactor(double aTextSizeFactor) {
        this.setTextSizeFactor(aTextSizeFactor);
        return this;
    }

    public FxLabelDecorator withTopTextMarginFactor(double aTextMarginFactor) {
        this.setTextMarginFactor(aTextMarginFactor);
        return this;
    }

    public FxLabelDecorator withTopTextPaddingFactor(double aTextPaddingFactor) {
        this.setTextPaddingFactor(aTextPaddingFactor);
        return this;
    }

    @Override
    public FxLabelDecorator withVertAlignTextMode(VertAlignTextMode aVertAlignTextMode) {
        this.setVertAlignTextMode(aVertAlignTextMode);
        return this;
    }

    public FxLabelDecorator withVertTextMarginFactor(double aTextMarginFactor) {
        this.setVertTextMarginFactor(aTextMarginFactor);
        return this;
    }

    public FxLabelDecorator withVertTextPaddingFactor(double aTextPaddingFactor) {
        this.setVertTextPaddingFactor(aTextPaddingFactor);
        return this;
    }

    protected void redraw() {
        Platform.runLater(this._redraw);
    }

    private class RedrawDaemon
    implements Runnable {
        private RedrawDaemon() {
        }

        @Override
        public void run() {
            double theWidth = FxLabelDecorator.this.getWidth();
            double theHeight = FxLabelDecorator.this.getHeight();
            if (theWidth == 0.0 || theHeight == 0.0) {
                if (FxLabelDecorator.this._content instanceof ImageView) {
                    theWidth = ((ImageView)FxLabelDecorator.this._content).getImage().getWidth();
                    theHeight = ((ImageView)FxLabelDecorator.this._content).getImage().getHeight();
                } else if (FxLabelDecorator.this._content instanceof FxLabelDecorator) {
                    theWidth = ((FxLabelDecorator)FxLabelDecorator.this._content).getImage().getWidth();
                    theHeight = ((FxLabelDecorator)FxLabelDecorator.this._content).getImage().getHeight();
                } else if (FxLabelDecorator.this._content instanceof Region) {
                    theWidth = ((Region)FxLabelDecorator.this._content).getPrefWidth();
                    theHeight = ((Region)FxLabelDecorator.this._content).getPrefHeight();
                }
            }
            FxLabelDecorator.this.setHeight(theWidth);
            FxLabelDecorator.this.setWidth(theHeight);
            FxLabelDecorator.this.setPrefWidth(theWidth);
            FxLabelDecorator.this.setPrefHeight(theHeight);
            FxLabelDecorator.this.setMinWidth(theWidth);
            FxLabelDecorator.this.setMinHeight(theHeight);
            Font theFont = FxGraphicalUtility.toFont(FxLabelDecorator.this._fontName, FxLabelDecorator.this._text, FxLabelDecorator.this._textLayoutMode == LayoutMode.VERTICAL ? theHeight * FxLabelDecorator.this._textSizeFactor : theWidth * FxLabelDecorator.this._textSizeFactor, FxLabelDecorator.this._textLayoutMode);
            FxLabelDecorator.this._textNode.setText(FxLabelDecorator.this._text);
            FxLabelDecorator.this._textNode.setFont(theFont);
            double theLeftTextMargin = 0.0;
            double theTopTextMargin = 0.0;
            double theRightTextMargin = 0.0;
            double theBottomTextMargin = 0.0;
            if (FxLabelDecorator.this._horizAlignTextMode != HorizAlignTextMode.CENTER && FxLabelDecorator.this._horizAlignTextMode != HorizAlignTextMode.BLOCK) {
                theLeftTextMargin = (FxLabelDecorator.this._textLayoutMode == LayoutMode.VERTICAL ? theHeight : theWidth) * FxLabelDecorator.this._leftTextMarginFactor;
                theRightTextMargin = (FxLabelDecorator.this._textLayoutMode == LayoutMode.VERTICAL ? theHeight : theWidth) * FxLabelDecorator.this._rightTextMarginFactor;
            }
            if (FxLabelDecorator.this._vertAlignTextMode != VertAlignTextMode.MIDDLE) {
                theTopTextMargin = (FxLabelDecorator.this._textLayoutMode == LayoutMode.VERTICAL ? theHeight : theWidth) * FxLabelDecorator.this._topTextMarginFactor;
                theBottomTextMargin = (FxLabelDecorator.this._textLayoutMode == LayoutMode.VERTICAL ? theHeight : theWidth) * FxLabelDecorator.this._bottomTextMarginFactor;
            }
            double theLeftTextPadding = (FxLabelDecorator.this._textLayoutMode == LayoutMode.VERTICAL ? theHeight : theWidth) * FxLabelDecorator.this._leftTextPaddingFactor;
            double theTopTextPadding = (FxLabelDecorator.this._textLayoutMode == LayoutMode.VERTICAL ? theHeight : theWidth) * FxLabelDecorator.this._topTextPaddingFactor;
            double theRightTextPadding = (FxLabelDecorator.this._textLayoutMode == LayoutMode.VERTICAL ? theHeight : theWidth) * FxLabelDecorator.this._rightTextPaddingFactor;
            double theBottomTextPadding = (FxLabelDecorator.this._textLayoutMode == LayoutMode.VERTICAL ? theHeight : theWidth) * FxLabelDecorator.this._bottomTextPaddingFactor;
            double theTextBorderArc = (FxLabelDecorator.this._textLayoutMode == LayoutMode.VERTICAL ? theHeight : theWidth) * FxLabelDecorator.this._textBorderArcFactor;
            double theTextBorderSize = (FxLabelDecorator.this._textLayoutMode == LayoutMode.VERTICAL ? theHeight : theWidth) * FxLabelDecorator.this._textBorderSizeFactor;
            if (FxLabelDecorator.this._horizAlignTextMode == HorizAlignTextMode.LEFT) {
                FxLabelDecorator.this._textNode.setTranslateX(theLeftTextMargin + theLeftTextPadding);
            }
            if (FxLabelDecorator.this._horizAlignTextMode == HorizAlignTextMode.RIGHT) {
                FxLabelDecorator.this._textNode.setTranslateX(-(theRightTextMargin + theRightTextPadding));
            }
            if (FxLabelDecorator.this._vertAlignTextMode == VertAlignTextMode.TOP) {
                FxLabelDecorator.this._textNode.setTranslateY(theTopTextMargin + theTopTextPadding);
            }
            if (FxLabelDecorator.this._vertAlignTextMode == VertAlignTextMode.BOTTOM) {
                FxLabelDecorator.this._textNode.setTranslateY(-(theBottomTextMargin + theBottomTextPadding));
            }
            FxLabelDecorator.this._rect.setArcWidth(theTextBorderArc);
            FxLabelDecorator.this._rect.setArcHeight(theTextBorderArc);
            FxLabelDecorator.this._rect.setStrokeWidth(theTextBorderSize);
            FxLabelDecorator.this._rect.setWidth(FxLabelDecorator.this._textNode.getBoundsInLocal().getWidth() + theLeftTextPadding + theRightTextPadding);
            FxLabelDecorator.this._rect.setHeight(FxLabelDecorator.this._textNode.getBoundsInLocal().getHeight() + theTopTextPadding + theBottomTextPadding);
            if (FxLabelDecorator.this._horizAlignTextMode == HorizAlignTextMode.LEFT) {
                FxLabelDecorator.this._rect.setTranslateX(theLeftTextMargin);
            }
            if (FxLabelDecorator.this._horizAlignTextMode == HorizAlignTextMode.RIGHT) {
                FxLabelDecorator.this._rect.setTranslateX(-theRightTextMargin);
            }
            if (FxLabelDecorator.this._vertAlignTextMode == VertAlignTextMode.TOP) {
                FxLabelDecorator.this._rect.setTranslateY(theTopTextMargin);
            }
            if (FxLabelDecorator.this._vertAlignTextMode == VertAlignTextMode.BOTTOM) {
                FxLabelDecorator.this._rect.setTranslateY(-theBottomTextMargin);
            }
        }
    }
}

