/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical.ext.javafx;

import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.util.Duration;
import org.refcodes.graphical.Dimension;
import org.refcodes.graphical.DragOpacityAccessor;
import org.refcodes.graphical.FieldDimension;
import org.refcodes.graphical.MoveMode;
import org.refcodes.graphical.MoveModeAccessor;
import org.refcodes.graphical.Offset;
import org.refcodes.graphical.Opacity;
import org.refcodes.graphical.Position;
import org.refcodes.graphical.SpriteAccessor;
import org.refcodes.mixin.Disposable;

public class FxGridDragSpriteEventHandler
implements FieldDimension.FieldDimensionProperty,
FieldDimension.FieldDimensionBuilder<FxGridDragSpriteEventHandler>,
DragOpacityAccessor.DragOpacityProperty,
DragOpacityAccessor.DragOpacityBuilder<FxGridDragSpriteEventHandler>,
SpriteAccessor<Node>,
MoveModeAccessor.MoveModeProperty,
MoveModeAccessor.MoveModeBuilder<FxGridDragSpriteEventHandler>,
Offset.OffsetProperty,
Offset.OffsetBuilder<FxGridDragSpriteEventHandler>,
Disposable {
    private static final Logger LOGGER = Logger.getLogger(FxGridDragSpriteEventHandler.class.getName());
    private static final int DEFAULT_MOVE_SPRITE_DURATION_MILLIS = 300;
    private static final int DEFAULT_DRAG_SPRITE_DURATION_MILLIS = 300;
    private double _sceneX;
    private double _sceneY;
    public double _posX;
    private double _posY;
    private Node _node;
    private Pane _pane;
    private int _offsetY;
    private int _offsetX;
    private int _fieldWidth;
    private int _fieldHeight;
    private int _fieldGap;
    private double _prevOpacity = 1.0;
    private double _dragOpacity = Opacity.DRAG.getOpacity();
    private MoveMode _moveMode = MoveMode.SMOOTH;
    private BiConsumer<Integer, Integer> _offsetChangedListener = null;
    private BiConsumer<Integer, Integer> _mouseClickedListener = null;
    private int _moveSpriteDurationMillis = 300;
    private int _dragSpriteDurationMillis = 300;
    private boolean _isDragged;
    private final EventHandler<MouseEvent> _onMousePressedEventHandler = aEvent -> {
        this._isDragged = false;
        Node theSprite = (Node)aEvent.getSource();
        this._prevOpacity = theSprite.getOpacity();
        theSprite.setOpacity(this._dragOpacity);
        this._sceneX = aEvent.getSceneX();
        this._sceneY = aEvent.getSceneY();
        this._posX = theSprite.getTranslateX();
        this._posY = theSprite.getTranslateY();
        LOGGER.log(Level.FINE, "Sprite mouse press X := " + aEvent.getSceneX());
        LOGGER.log(Level.FINE, "Sprite mouse press Y := " + aEvent.getSceneY());
        aEvent.consume();
    };
    private final EventHandler<MouseEvent> _onMouseDraggedEventHandler = new EventHandler<MouseEvent>(){

        @Override
        public void handle(MouseEvent aEvent) {
            Node theSprite = (Node)aEvent.getSource();
            double theSceneOffsetX = aEvent.getSceneX() - FxGridDragSpriteEventHandler.this._sceneX;
            double theSceneOffsetY = aEvent.getSceneY() - FxGridDragSpriteEventHandler.this._sceneY;
            double theTranslateX = FxGridDragSpriteEventHandler.this._posX + theSceneOffsetX;
            double theTranslateY = FxGridDragSpriteEventHandler.this._posY + theSceneOffsetY;
            switch (FxGridDragSpriteEventHandler.this._moveMode) {
                case SMOOTH: {
                    theTranslateX = FxGridDragSpriteEventHandler.this.toBoundsX(theTranslateX, theSprite);
                    theTranslateY = FxGridDragSpriteEventHandler.this.toBoundsY(theTranslateY, theSprite);
                    break;
                }
                case JUMPY: {
                    theTranslateX = FxGridDragSpriteEventHandler.this.toSnapX(theTranslateX, theSprite);
                    theTranslateY = FxGridDragSpriteEventHandler.this.toSnapY(theTranslateY, theSprite);
                }
            }
            theSprite.setTranslateX(theTranslateX);
            theSprite.setTranslateY(theTranslateY);
            int theOffsetX = (int)Math.round(theTranslateX / (double)(FxGridDragSpriteEventHandler.this.getFieldWidth() + FxGridDragSpriteEventHandler.this.getFieldGap()));
            int theOffsetY = (int)Math.round(theTranslateY / (double)(FxGridDragSpriteEventHandler.this.getFieldHeight() + FxGridDragSpriteEventHandler.this.getFieldGap()));
            if (theOffsetX != FxGridDragSpriteEventHandler.this._offsetX || theOffsetY != FxGridDragSpriteEventHandler.this._offsetY) {
                FxGridDragSpriteEventHandler.this._offsetX = theOffsetX;
                FxGridDragSpriteEventHandler.this._offsetY = theOffsetY;
                if (FxGridDragSpriteEventHandler.this._offsetChangedListener != null) {
                    FxGridDragSpriteEventHandler.this._offsetChangedListener.accept(theOffsetX, theOffsetY);
                }
                FxGridDragSpriteEventHandler.this._isDragged = true;
            }
            aEvent.consume();
        }
    };
    private final EventHandler<MouseEvent> _onMouseReleasedEventHandler = new EventHandler<MouseEvent>(){

        @Override
        public void handle(MouseEvent aEvent) {
            final Node theSprite = (Node)aEvent.getSource();
            double theSceneOffsetX = aEvent.getSceneX() - FxGridDragSpriteEventHandler.this._sceneX;
            double theSceneOffsetY = aEvent.getSceneY() - FxGridDragSpriteEventHandler.this._sceneY;
            double theTranslateX = FxGridDragSpriteEventHandler.this._posX + theSceneOffsetX;
            double theTranslateY = FxGridDragSpriteEventHandler.this._posY + theSceneOffsetY;
            final double theToX = FxGridDragSpriteEventHandler.this.toSnapX(theTranslateX, theSprite);
            final double theToY = FxGridDragSpriteEventHandler.this.toSnapY(theTranslateY, theSprite);
            theSprite.setOpacity(FxGridDragSpriteEventHandler.this._prevOpacity);
            switch (FxGridDragSpriteEventHandler.this._moveMode) {
                case SMOOTH: {
                    Runnable theRunner = new Runnable(){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            TranslateTransition theTransition = new TranslateTransition(Duration.millis(this.this$1.FxGridDragSpriteEventHandler.this._dragSpriteDurationMillis), theSprite);
                            theTransition.setToX(theToX);
                            theTransition.setToY(theToY);
                            theTransition.setCycleCount(1);
                            theTransition.setAutoReverse(false);
                            theTransition.play();
                        }
                    };
                    if (Platform.isFxApplicationThread()) {
                        theRunner.run();
                        break;
                    }
                    Platform.runLater(theRunner);
                    break;
                }
                case JUMPY: {
                    theSprite.setTranslateX(theToX);
                    theSprite.setTranslateY(theToY);
                }
            }
            LOGGER.log(Level.FINE, "Sprite mouse release X := " + aEvent.getSceneX());
            LOGGER.log(Level.FINE, "Sprite mouse release Y := " + aEvent.getSceneY());
            LOGGER.log(Level.FINE, "Sprite mouse release offset X := " + theSceneOffsetX);
            LOGGER.log(Level.FINE, "Sprite mouse release offset Y := " + theSceneOffsetY);
            LOGGER.log(Level.FINE, "Sprite translate X := " + theTranslateX);
            LOGGER.log(Level.FINE, "Sprite translate Y := " + theTranslateY);
            aEvent.consume();
            if (!FxGridDragSpriteEventHandler.this._isDragged && FxGridDragSpriteEventHandler.this._mouseClickedListener != null) {
                int theClickPosX = (int)(aEvent.getSceneX() / (double)(FxGridDragSpriteEventHandler.this.getFieldWidth() + FxGridDragSpriteEventHandler.this.getFieldGap())) - FxGridDragSpriteEventHandler.this._offsetX;
                int theClickPosY = (int)(aEvent.getSceneY() / (double)(FxGridDragSpriteEventHandler.this.getFieldHeight() + FxGridDragSpriteEventHandler.this.getFieldGap())) - FxGridDragSpriteEventHandler.this._offsetY;
                FxGridDragSpriteEventHandler.this._mouseClickedListener.accept(theClickPosX, theClickPosY);
            }
        }
    };

    public FxGridDragSpriteEventHandler(Node aSprite, Pane aPane) {
        this(aSprite, aPane, 0, 0, 1, 1, 0, null, null);
    }

    public FxGridDragSpriteEventHandler(Node aSprite, Pane aPane, Offset aOffset, FieldDimension aFieldDimension) {
        this(aSprite, aPane, aOffset.getOffsetX(), aOffset.getOffsetY(), aFieldDimension.getFieldWidth(), aFieldDimension.getFieldHeight(), aFieldDimension.getFieldGap(), null, null);
    }

    public FxGridDragSpriteEventHandler(Node aSprite, Pane aPane, Offset aOffset, FieldDimension aFieldDimension, BiConsumer<Integer, Integer> aOffsetChangedListener, BiConsumer<Integer, Integer> aMouseClickedListener) {
        this(aSprite, aPane, aOffset.getOffsetX(), aOffset.getOffsetY(), aFieldDimension.getFieldWidth(), aFieldDimension.getFieldHeight(), aFieldDimension.getFieldGap(), aOffsetChangedListener, aMouseClickedListener);
    }

    public FxGridDragSpriteEventHandler(Node aSprite, Pane aPane, int aOffsetX, int aOffsetY, int aFieldWidth, int aFieldHeight, int aFieldGap) {
        this(aSprite, aPane, aOffsetX, aOffsetY, aFieldWidth, aFieldHeight, aFieldGap, null, null);
    }

    public FxGridDragSpriteEventHandler(Node aSprite, Pane aPane, int aOffsetX, int aOffsetY, int aFieldWidth, int aFieldHeight, int aFieldGap, BiConsumer<Integer, Integer> aOffsetChangedListener, BiConsumer<Integer, Integer> aMouseClickedListener) {
        aSprite.setOnMousePressed(this._onMousePressedEventHandler);
        aSprite.setOnMouseDragged(this._onMouseDraggedEventHandler);
        aSprite.setOnMouseReleased(this._onMouseReleasedEventHandler);
        this._fieldWidth = aFieldWidth;
        this._fieldHeight = aFieldHeight;
        this._fieldGap = aFieldGap;
        this._offsetX = aOffsetX;
        this._offsetY = aOffsetY;
        this._offsetChangedListener = aOffsetChangedListener;
        this._mouseClickedListener = aMouseClickedListener;
        this._node = aSprite;
        this._pane = aPane;
        if (this._offsetX != 0 || this._offsetY != 0) {
            this._posX = this._offsetX * (this._fieldWidth + this._fieldGap);
            this._posY = this._offsetY * (this._fieldHeight + this._fieldGap);
            aSprite.setTranslateX(this._posX);
            aSprite.setTranslateY(this._posY);
        }
    }

    @Override
    public int getFieldWidth() {
        return this._fieldWidth;
    }

    @Override
    public int getFieldHeight() {
        return this._fieldHeight;
    }

    @Override
    public int getFieldGap() {
        return this._fieldGap;
    }

    @Override
    public void setFieldWidth(int aWidth) {
        this._fieldWidth = aWidth;
    }

    @Override
    public FxGridDragSpriteEventHandler withFieldWidth(int aWidth) {
        this._fieldWidth = aWidth;
        return this;
    }

    @Override
    public void setFieldHeight(int aHeight) {
        this._fieldHeight = aHeight;
    }

    @Override
    public int getOffsetX() {
        return this._offsetX;
    }

    @Override
    public int getOffsetY() {
        return this._offsetY;
    }

    @Override
    public void setOffset(int aOffsetX, int aOffsetY) {
        Node thePlayer = this.getSprite();
        double theToX = (this.getFieldWidth() + this.getFieldGap()) * aOffsetX;
        double theToY = (this.getFieldWidth() + this.getFieldGap()) * aOffsetY;
        thePlayer.setOpacity(1.0);
        Runnable theRunner = () -> {
            TranslateTransition theTransition = new TranslateTransition(Duration.millis(this._moveSpriteDurationMillis), thePlayer);
            theTransition.setToX(theToX);
            theTransition.setToY(theToY);
            theTransition.setCycleCount(1);
            theTransition.setAutoReverse(false);
            theTransition.play();
            theTransition.setOnFinished(actionEvent -> {
                this._offsetX = aOffsetX;
                this._offsetY = aOffsetY;
            });
        };
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater(theRunner);
        }
    }

    @Override
    public void setOffset(Offset aOffset) {
        this._offsetX = aOffset.getOffsetX();
        this._offsetY = aOffset.getOffsetY();
    }

    @Override
    public void setOffset(Position aOffset) {
        this._offsetX = aOffset.getPositionX();
        this._offsetY = aOffset.getPositionY();
    }

    @Override
    public void setOffsetX(int aOffsetX) {
        this._offsetX = aOffsetX;
    }

    @Override
    public void setOffsetY(int aOffsetY) {
        this._offsetY = aOffsetY;
    }

    @Override
    public FxGridDragSpriteEventHandler withOffsetX(int aOffsetX) {
        this.setOffsetX(aOffsetX);
        return this;
    }

    @Override
    public FxGridDragSpriteEventHandler withOffsetY(int aOffsetY) {
        this.setOffsetY(aOffsetY);
        return this;
    }

    @Override
    public FxGridDragSpriteEventHandler withOffset(int aOffsetX, int aOffsetY) {
        this.setOffset(aOffsetX, aOffsetY);
        return this;
    }

    @Override
    public FxGridDragSpriteEventHandler withOffset(Offset aOffset) {
        this.setOffset(aOffset);
        return this;
    }

    @Override
    public FxGridDragSpriteEventHandler withOffset(Position aOffset) {
        this.setOffset(aOffset);
        return this;
    }

    @Override
    public FxGridDragSpriteEventHandler withFieldHeight(int aHeight) {
        this._fieldHeight = aHeight;
        return this;
    }

    @Override
    public FxGridDragSpriteEventHandler withFieldDimension(int aWidth, int aHeight) {
        this.setFieldDimension(aWidth, aHeight);
        return this;
    }

    @Override
    public FxGridDragSpriteEventHandler withFieldDimension(int aWidth, int aHeight, int aGap) {
        this.setFieldDimension(aWidth, aHeight, aGap);
        return this;
    }

    @Override
    public FxGridDragSpriteEventHandler withFieldDimension(FieldDimension aDimension) {
        this.setFieldDimension(aDimension);
        return this;
    }

    @Override
    public void setFieldDimension(int aWidth, int aHeight) {
        this._fieldWidth = aWidth;
        this._fieldHeight = aHeight;
    }

    @Override
    public void setFieldDimension(int aWidth, int aHeight, int aGap) {
        this._fieldWidth = aWidth;
        this._fieldHeight = aHeight;
        this._fieldGap = aGap;
    }

    @Override
    public void setFieldDimension(FieldDimension aDimension) {
        this._fieldWidth = aDimension.getFieldWidth();
        this._fieldHeight = aDimension.getFieldHeight();
        this._fieldGap = aDimension.getFieldGap();
    }

    @Override
    public FxGridDragSpriteEventHandler withFieldDimension(Dimension aDimension) {
        this.setFieldDimension(aDimension.getWidth(), aDimension.getHeight());
        return this;
    }

    @Override
    public void setFieldDimension(Dimension aDimension) {
        this._fieldWidth = aDimension.getWidth();
        this._fieldHeight = aDimension.getHeight();
    }

    @Override
    public void setFieldGap(int aFieldGap) {
        this._fieldGap = aFieldGap;
    }

    @Override
    public FxGridDragSpriteEventHandler withFieldGap(int aFieldGap) {
        this.setFieldGap(aFieldGap);
        return this;
    }

    @Override
    public double getDragOpacity() {
        return this._dragOpacity;
    }

    @Override
    public void setDragOpacity(double aOpacity) {
        this._dragOpacity = aOpacity;
    }

    @Override
    public FxGridDragSpriteEventHandler withDragOpacity(double aOpacity) {
        this.setDragOpacity(aOpacity);
        return this;
    }

    @Override
    public Node getSprite() {
        return this._node;
    }

    @Override
    public MoveMode getMoveMode() {
        return this._moveMode;
    }

    @Override
    public void setMoveMode(MoveMode aMoveMode) {
        this._moveMode = aMoveMode;
    }

    @Override
    public FxGridDragSpriteEventHandler withMoveMode(MoveMode aMoveMode) {
        this.setMoveMode(aMoveMode);
        return this;
    }

    public int getDragSpriteDurationMillis() {
        return this._dragSpriteDurationMillis;
    }

    public void setDragSpriteDurationMillis(int aDragSpriteDurationMillis) {
        this._dragSpriteDurationMillis = aDragSpriteDurationMillis;
    }

    public FxGridDragSpriteEventHandler withDragSpriteDurationMillis(int aDragSpriteDurationMillis) {
        this.setDragSpriteDurationMillis(aDragSpriteDurationMillis);
        return this;
    }

    public int getMoveSpriteDurationMillis() {
        return this._moveSpriteDurationMillis;
    }

    public void setMoveSpriteDurationMillis(int aMoveSpriteDurationMillis) {
        this._moveSpriteDurationMillis = aMoveSpriteDurationMillis;
    }

    public FxGridDragSpriteEventHandler withMoveSpriteDurationMillis(int aMoveSpriteDurationMillis) {
        this.setMoveSpriteDurationMillis(aMoveSpriteDurationMillis);
        return this;
    }

    public void onOffsetChanged(BiConsumer<Integer, Integer> aOffsetChangedListener) {
        this._offsetChangedListener = aOffsetChangedListener;
    }

    public void onMouseClicked(BiConsumer<Integer, Integer> aMouseClickedListener) {
        this._mouseClickedListener = aMouseClickedListener;
    }

    @Override
    public void dispose() {
        this._node.setOnMousePressed(null);
        this._node.setOnMouseDragged(null);
        this._node.setOnMouseReleased(null);
        this._node = null;
    }

    private double toBoundsX(double aTranslateX, Node aSprite) {
        return this.toBounds(aTranslateX, aSprite.getBoundsInParent().getWidth(), this._pane.getWidth());
    }

    private double toBoundsY(double aTranslateY, Node aSprite) {
        return this.toBounds(aTranslateY, aSprite.getBoundsInParent().getHeight(), this._pane.getHeight());
    }

    private double toBounds(double aTranslateSize, double aSpriteSize, double aBackgroundSize) {
        if (aSpriteSize < aBackgroundSize) {
            if (aSpriteSize + aTranslateSize > aBackgroundSize) {
                aTranslateSize = aBackgroundSize - aSpriteSize;
            }
            if (aTranslateSize < 0.0) {
                aTranslateSize = 0.0;
            }
        } else {
            if (aSpriteSize + aTranslateSize < aBackgroundSize) {
                aTranslateSize = aBackgroundSize - aSpriteSize;
            }
            if (aTranslateSize > 0.0) {
                aTranslateSize = 0.0;
            }
        }
        return aTranslateSize;
    }

    private double toSnapX(double aTranslateX, Node aSprite) {
        return this.toSnap(aTranslateX, aSprite.getBoundsInParent().getWidth(), this.getFieldWidth(), this._pane.getWidth());
    }

    private double toSnapY(double aTranslateY, Node aSprite) {
        return this.toSnap(aTranslateY, aSprite.getBoundsInParent().getHeight(), this.getFieldHeight(), this._pane.getHeight());
    }

    private double toSnap(double aTranslateSize, double aSpriteSize, int aFieldSize, double aBackgroundSize) {
        if (aSpriteSize > aBackgroundSize && aSpriteSize + aTranslateSize == aBackgroundSize) {
            return aTranslateSize;
        }
        return this.toBounds(Math.round(aTranslateSize / (double)(aFieldSize + this.getFieldGap())) * (long)(aFieldSize + this.getFieldGap()), aSpriteSize, aBackgroundSize);
    }
}

