/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.refcodes.codec.BaseMetrics;
import org.refcodes.codec.BaseMetricsAccessor;
import org.refcodes.codec.BaseMetricsConfig;
import org.refcodes.codec.Decoder;
import org.refcodes.component.AbstractConnectableAutomaton;
import org.refcodes.component.ConnectionComponent;
import org.refcodes.component.Openable;
import org.refcodes.io.BytesDestination;
import org.refcodes.io.BytesReceiver;
import org.refcodes.io.BytesReceiverDecorator;
import org.refcodes.io.InputStreamByteReceiver;

public class BaseDecoder
extends AbstractConnectableAutomaton
implements BaseMetricsAccessor.BaseMetricsProperty,
BaseMetricsAccessor.BaseMetricsBuilder<BaseDecoder>,
Decoder {
    private static final int BYTE_MASK = 255;
    private static final int BITS_PER_BYTE = 8;
    private BytesReceiver _byteReceiver;
    private BaseMetrics _baseMetrics = BaseMetricsConfig.BASE64;
    private int _trailingBytes = 0;
    int _word = 0;
    private byte[] _decodedBytes = new byte[this._baseMetrics.getBytesPerInt()];
    private int _readIndex = 0;

    public BaseDecoder(InputStream aInputStream) throws IOException {
        this(new InputStreamByteReceiver(aInputStream));
    }

    public BaseDecoder(InputStream aInputStream, BaseMetrics aBaseMetrics) throws IOException {
        this(new InputStreamByteReceiver(aInputStream), aBaseMetrics);
    }

    public BaseDecoder(BytesDestination aByteProvider) {
        try {
            this.open(new BytesReceiverDecorator(aByteProvider));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public BaseDecoder(BytesReceiver aByteReceiver) throws IOException {
        this.open(aByteReceiver);
    }

    public BaseDecoder(InputStreamByteReceiver aInputStreamByteReceiver, BaseMetrics aBaseMetrics) throws IOException {
        this(aInputStreamByteReceiver);
        this.setBaseMetrics(aBaseMetrics);
    }

    protected BaseDecoder() {
    }

    @Override
    public BaseMetrics getBaseMetrics() {
        return this._baseMetrics;
    }

    @Override
    public void setBaseMetrics(BaseMetrics aBaseMetrics) {
        this._baseMetrics = aBaseMetrics;
        this._decodedBytes = new byte[this._baseMetrics.getBytesPerInt()];
    }

    @Override
    public BaseDecoder withBaseMetrics(BaseMetrics aBaseMetrics) {
        this.setBaseMetrics(aBaseMetrics);
        return this;
    }

    @Override
    public int available() throws IOException {
        return this._byteReceiver.available();
    }

    @Override
    public byte[] receiveAllBytes() throws IOException {
        if (this._readIndex > 0) {
            byte[] theDecodedBytes = new byte[this._decodedBytes.length - this._readIndex];
            int l = 0;
            for (int i = this._readIndex; i < this._decodedBytes.length; ++i) {
                theDecodedBytes[l++] = this._decodedBytes[i];
            }
            this._readIndex = 0;
            return theDecodedBytes;
        }
        if (!this._byteReceiver.hasAvailable()) {
            throw new EOFException("Reached end of file (stream), no more data avaialble!");
        }
        try {
            for (int l = 0; l < this._baseMetrics.getDigitsPerInt(); ++l) {
                char eRead = (char)this._byteReceiver.receiveByte();
                while (eRead == '\n' || eRead == '\r') {
                    eRead = (char)this._byteReceiver.receiveByte();
                }
                this._word <<= this._baseMetrics.getBitsPerDigit();
                if (eRead != this._baseMetrics.getPaddingChar()) {
                    this._word |= this._baseMetrics.toValue(eRead) & 0xFF;
                    continue;
                }
                ++this._trailingBytes;
            }
            for (int i = 0; i < this._baseMetrics.getBytesPerInt(); ++i) {
                int theIndex = this._baseMetrics.getBytesPerInt() - i - 1;
                this._decodedBytes[theIndex] = (byte)this._word;
                this._word >>= 8;
            }
            this._word = 0;
        }
        catch (IOException e) {
            throw new IOException("Unable to read from the provided receiver <" + String.valueOf(this._byteReceiver) + ">!", e);
        }
        if (this._trailingBytes != 0) {
            int theLastBlockSize = this._baseMetrics.getBytesPerInt() - this._trailingBytes;
            byte[] theDecodedBytes = new byte[theLastBlockSize];
            for (int i = 0; i < theLastBlockSize; ++i) {
                theDecodedBytes[i] = this._decodedBytes[i];
            }
            return theDecodedBytes;
        }
        return this._decodedBytes;
    }

    @Override
    public byte receiveByte() throws IOException {
        if (this._readIndex >= this._baseMetrics.getBytesPerInt() - this._trailingBytes) {
            if (!this._byteReceiver.hasAvailable()) {
                throw new EOFException("Reached end of file (stream), no more data avaialble!");
            }
            this._trailingBytes = 0;
            this._readIndex = 0;
        }
        if (this._readIndex == 0) {
            this.receiveAllBytes();
        }
        byte theDecodedByte = this._decodedBytes[this._readIndex++];
        if (this._readIndex >= this._decodedBytes.length) {
            this._readIndex = 0;
        }
        return theDecodedByte;
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            this._byteReceiver.close();
        }
        catch (IOException e) {
            throw new IOException("Unable to close the receiver <" + String.valueOf(this._byteReceiver) + ">", e);
        }
        super.close();
    }

    protected void open(BytesDestination aConnection) throws IOException {
        this._byteReceiver = aConnection instanceof BytesReceiver ? (BytesReceiver)aConnection : new BytesReceiverDecorator(aConnection);
        if (!this._byteReceiver.isOpened()) {
            if (this._byteReceiver instanceof Openable) {
                ((Openable)((Object)this._byteReceiver)).open();
            } else {
                throw new IOException("The provided connection is in status <" + String.valueOf((Object)this._byteReceiver.getConnectionStatus()) + "> but does not provide the <" + Openable.class.getName() + "> interface.");
            }
        }
        this.open();
    }

    public static class BaseDecoderConnection
    extends BaseDecoder
    implements ConnectionComponent<BytesDestination> {
        @Override
        public void open(BytesDestination aConnection) throws IOException {
            super.open(aConnection);
        }
    }
}

